/*
 * Copyright (c) 2016 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef INTEL_IPU5_BUTTRESS_REGS_H
#define INTEL_IPU5_BUTTRESS_REGS_H

#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_SHIFT	20
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_MASK		\
	(0x1f << IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_SHIFT)

#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_IDLE			0x0
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_PLL_CMP		0x1
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_CLKACK		0x2
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_PG_ACK		0x3
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_RST_ASSRT_CYCLES		0x4
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_STOP_CLK_CYCLES1		0x5
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_STOP_CLK_CYCLES2		0x6
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_RST_DEASSRT_CYCLES	0x7
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_FUSE_WR_CMP	0x8
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_BRK_POINT			0x9
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_IS_RDY			0xa
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_HALT_HALTED		0xb
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_RST_DURATION_CNT3		0xc
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_CLKACK_PD		0xd
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_PD_BRK_POINT		0xe
#define IPU5_BUTTRESS_PWR_STATE_IS_PWR_FSM_WAIT_4_PD_PG_ACK0		0xf

#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_SHIFT	25
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_MASK		\
	(0x1f << IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_SHIFT)

#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_IDLE			0x0
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_PLL_IP_RDY	0x1
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_RO_PRE_CNT_EXH	0x2
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_VGI_PWRGOOD	0x3
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_RO_POST_CNT_EXH	0x4
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WR_PLL_RATIO		0x5
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_PLL_CMP		0x6
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PU_CLKACK		0x7
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_RST_ASSRT_CYCLES		0x8
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_STOP_CLK_CYCLES1		0x9
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_STOP_CLK_CYCLES2		0xa
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_RST_DEASSRT_CYCLES	0xb
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_PU_BRK_PNT		0xc
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_FUSE_ACCPT		0xd
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_PS_PWR_UP			0xf
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_4_HALTED		0x10
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_RESET_CNT3		0x11
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PD_CLKACK		0x12
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_PD_OFF_IND		0x13
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_DVFS_PH4		0x14
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_DVFS_PLL_CMP		0x15
#define IPU5_BUTTRESS_PWR_STATE_PS_PWR_FSM_WAIT_DVFS_CLKACK		0x16

#endif /* INTEL_IPU5_BUTTRESS_REGS_H */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/graphics/branches/denso-jp-hv-ivi/hardware/capture/intel-ipu4/driver/intel-ipu4-drv/intel-ipu5-buttress-regs.h $ $Rev: 836043 $")
#endif
