/* -*- pse-c -*-
 *-----------------------------------------------------------------------------
 * Filename: ovl_coeff.c
 * $Revision: 1.7 $
 *-----------------------------------------------------------------------------
 * Copyright (c) 2002-2010, Intel Corporation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *-----------------------------------------------------------------------------
 * Description:
 *  This file calculates the coefficient values used by the various
 *  platform families.
 *-----------------------------------------------------------------------------
 */

#include <general.h>
#include <memory.h>

#include "ovl_coeff.h"

/*****************************************************************
 *                                                               *
 *        HARDCODED QUARTER SINE WAVE TABLES                     *
 *        4096 unsigned shorts MSB is integer                    *
 *        and 15 LSB's are after the radix                       *
 *                                                               *
 *****************************************************************/
static unsigned short wave_table[4096] = {
	/* 16 bit value - all 16 bits are fp only */
	0x0,  0x19,  0x32,  0x4b,  0x65,  0x7e,  0x97,  0xb0,  0xc9,  0xe2,
	0xfb,  0x114,  0x12e,  0x147,  0x160,  0x179,  0x192,  0x1ab,  0x1c4,  0x1de,
	0x1f7,  0x210,  0x229,  0x242,  0x25b,  0x274,  0x28d,  0x2a7,  0x2c0,  0x2d9,
	0x2f2,  0x30b,  0x324,  0x33d,  0x356,  0x370,  0x389,  0x3a2,  0x3bb,  0x3d4,
	0x3ed,  0x406,  0x420,  0x439,  0x452,  0x46b,  0x484,  0x49d,  0x4b6,  0x4cf,
	0x4e9,  0x502,  0x51b,  0x534,  0x54d,  0x566,  0x57f,  0x598,  0x5b2,  0x5cb,
	0x5e4,  0x5fd,  0x616,  0x62f,  0x648,  0x661,  0x67b,  0x694,  0x6ad,  0x6c6,
	0x6df,  0x6f8,  0x711,  0x72a,  0x744,  0x75d,  0x776,  0x78f,  0x7a8,  0x7c1,
	0x7da,  0x7f3,  0x80d,  0x826,  0x83f,  0x858,  0x871,  0x88a,  0x8a3,  0x8bc,
	0x8d5,  0x8ef,  0x908,  0x921,  0x93a,  0x953,  0x96c,  0x985,  0x99e,  0x9b8,
	0x9d1,  0x9ea,  0xa03,  0xa1c,  0xa35,  0xa4e,  0xa67,  0xa80,  0xa9a,  0xab3,
	0xacc,  0xae5,  0xafe,  0xb17,  0xb30,  0xb49,  0xb62,  0xb7c,  0xb95,  0xbae,
	0xbc7,  0xbe0,  0xbf9,  0xc12,  0xc2b,  0xc44,  0xc5d,  0xc77,  0xc90,  0xca9,
	0xcc2,  0xcdb,  0xcf4,  0xd0d,  0xd26,  0xd3f,  0xd59,  0xd72,  0xd8b,  0xda4,
	0xdbd,  0xdd6,  0xdef,  0xe08,  0xe21,  0xe3a,  0xe53,  0xe6d,  0xe86,  0xe9f,
	0xeb8,  0xed1,  0xeea,  0xf03,  0xf1c,  0xf35,  0xf4e,  0xf67,  0xf81,  0xf9a,
	0xfb3,  0xfcc,  0xfe5,  0xffe,  0x1017,  0x1030,  0x1049,  0x1062,  0x107b,  0x1094,
	0x10ae,  0x10c7,  0x10e0,  0x10f9,  0x1112,  0x112b,  0x1144,  0x115d,  0x1176,  0x118f,
	0x11a8,  0x11c1,  0x11da,  0x11f4,  0x120d,  0x1226,  0x123f,  0x1258,  0x1271,  0x128a,
	0x12a3,  0x12bc,  0x12d5,  0x12ee,  0x1307,  0x1320,  0x1339,  0x1352,  0x136c,  0x1385,
	0x139e,  0x13b7,  0x13d0,  0x13e9,  0x1402,  0x141b,  0x1434,  0x144d,  0x1466,  0x147f,
	0x1498,  0x14b1,  0x14ca,  0x14e3,  0x14fc,  0x1515,  0x152e,  0x1548,  0x1561,  0x157a,
	0x1593,  0x15ac,  0x15c5,  0x15de,  0x15f7,  0x1610,  0x1629,  0x1642,  0x165b,  0x1674,
	0x168d,  0x16a6,  0x16bf,  0x16d8,  0x16f1,  0x170a,  0x1723,  0x173c,  0x1755,  0x176e,
	0x1787,  0x17a0,  0x17b9,  0x17d2,  0x17eb,  0x1804,  0x181d,  0x1837,  0x1850,  0x1869,
	0x1882,  0x189b,  0x18b4,  0x18cd,  0x18e6,  0x18ff,  0x1918,  0x1931,  0x194a,  0x1963,
	0x197c,  0x1995,  0x19ae,  0x19c7,  0x19e0,  0x19f9,  0x1a12,  0x1a2b,  0x1a44,  0x1a5d,
	0x1a76,  0x1a8f,  0x1aa8,  0x1ac1,  0x1ada,  0x1af3,  0x1b0c,  0x1b25,  0x1b3e,  0x1b57,
	0x1b70,  0x1b89,  0x1ba2,  0x1bbb,  0x1bd4,  0x1bed,  0x1c06,  0x1c1f,  0x1c38,  0x1c51,
	0x1c69,  0x1c82,  0x1c9b,  0x1cb4,  0x1ccd,  0x1ce6,  0x1cff,  0x1d18,  0x1d31,  0x1d4a,
	0x1d63,  0x1d7c,  0x1d95,  0x1dae,  0x1dc7,  0x1de0,  0x1df9,  0x1e12,  0x1e2b,  0x1e44,
	0x1e5d,  0x1e76,  0x1e8f,  0x1ea8,  0x1ec1,  0x1eda,  0x1ef3,  0x1f0b,  0x1f24,  0x1f3d,
	0x1f56,  0x1f6f,  0x1f88,  0x1fa1,  0x1fba,  0x1fd3,  0x1fec,  0x2005,  0x201e,  0x2037,
	0x2050,  0x2069,  0x2082,  0x209a,  0x20b3,  0x20cc,  0x20e5,  0x20fe,  0x2117,  0x2130,
	0x2149,  0x2162,  0x217b,  0x2194,  0x21ad,  0x21c6,  0x21de,  0x21f7,  0x2210,  0x2229,
	0x2242,  0x225b,  0x2274,  0x228d,  0x22a6,  0x22bf,  0x22d7,  0x22f0,  0x2309,  0x2322,
	0x233b,  0x2354,  0x236d,  0x2386,  0x239f,  0x23b8,  0x23d0,  0x23e9,  0x2402,  0x241b,
	0x2434,  0x244d,  0x2466,  0x247f,  0x2497,  0x24b0,  0x24c9,  0x24e2,  0x24fb,  0x2514,
	0x252d,  0x2546,  0x255e,  0x2577,  0x2590,  0x25a9,  0x25c2,  0x25db,  0x25f4,  0x260c,
	0x2625,  0x263e,  0x2657,  0x2670,  0x2689,  0x26a2,  0x26ba,  0x26d3,  0x26ec,  0x2705,
	0x271e,  0x2737,  0x274f,  0x2768,  0x2781,  0x279a,  0x27b3,  0x27cc,  0x27e4,  0x27fd,
	0x2816,  0x282f,  0x2848,  0x2860,  0x2879,  0x2892,  0x28ab,  0x28c4,  0x28dd,  0x28f5,
	0x290e,  0x2927,  0x2940,  0x2959,  0x2971,  0x298a,  0x29a3,  0x29bc,  0x29d5,  0x29ed,
	0x2a06,  0x2a1f,  0x2a38,  0x2a51,  0x2a69,  0x2a82,  0x2a9b,  0x2ab4,  0x2acc,  0x2ae5,
	0x2afe,  0x2b17,  0x2b30,  0x2b48,  0x2b61,  0x2b7a,  0x2b93,  0x2bab,  0x2bc4,  0x2bdd,
	0x2bf6,  0x2c0e,  0x2c27,  0x2c40,  0x2c59,  0x2c71,  0x2c8a,  0x2ca3,  0x2cbc,  0x2cd4,
	0x2ced,  0x2d06,  0x2d1f,  0x2d37,  0x2d50,  0x2d69,  0x2d82,  0x2d9a,  0x2db3,  0x2dcc,
	0x2de5,  0x2dfd,  0x2e16,  0x2e2f,  0x2e47,  0x2e60,  0x2e79,  0x2e92,  0x2eaa,  0x2ec3,
	0x2edc,  0x2ef4,  0x2f0d,  0x2f26,  0x2f3f,  0x2f57,  0x2f70,  0x2f89,  0x2fa1,  0x2fba,
	0x2fd3,  0x2feb,  0x3004,  0x301d,  0x3035,  0x304e,  0x3067,  0x307f,  0x3098,  0x30b1,
	0x30ca,  0x30e2,  0x30fb,  0x3114,  0x312c,  0x3145,  0x315e,  0x3176,  0x318f,  0x31a7,
	0x31c0,  0x31d9,  0x31f1,  0x320a,  0x3223,  0x323b,  0x3254,  0x326d,  0x3285,  0x329e,
	0x32b7,  0x32cf,  0x32e8,  0x3300,  0x3319,  0x3332,  0x334a,  0x3363,  0x337c,  0x3394,
	0x33ad,  0x33c5,  0x33de,  0x33f7,  0x340f,  0x3428,  0x3440,  0x3459,  0x3472,  0x348a,
	0x34a3,  0x34bb,  0x34d4,  0x34ed,  0x3505,  0x351e,  0x3536,  0x354f,  0x3568,  0x3580,
	0x3599,  0x35b1,  0x35ca,  0x35e2,  0x35fb,  0x3614,  0x362c,  0x3645,  0x365d,  0x3676,
	0x368e,  0x36a7,  0x36c0,  0x36d8,  0x36f1,  0x3709,  0x3722,  0x373a,  0x3753,  0x376b,
	0x3784,  0x379c,  0x37b5,  0x37cd,  0x37e6,  0x37fe,  0x3817,  0x3830,  0x3848,  0x3861,
	0x3879,  0x3892,  0x38aa,  0x38c3,  0x38db,  0x38f4,  0x390c,  0x3925,  0x393d,  0x3956,
	0x396e,  0x3987,  0x399f,  0x39b8,  0x39d0,  0x39e9,  0x3a01,  0x3a1a,  0x3a32,  0x3a4a,
	0x3a63,  0x3a7b,  0x3a94,  0x3aac,  0x3ac5,  0x3add,  0x3af6,  0x3b0e,  0x3b27,  0x3b3f,
	0x3b58,  0x3b70,  0x3b88,  0x3ba1,  0x3bb9,  0x3bd2,  0x3bea,  0x3c03,  0x3c1b,  0x3c33,
	0x3c4c,  0x3c64,  0x3c7d,  0x3c95,  0x3cae,  0x3cc6,  0x3cde,  0x3cf7,  0x3d0f,  0x3d28,
	0x3d40,  0x3d58,  0x3d71,  0x3d89,  0x3da2,  0x3dba,  0x3dd2,  0x3deb,  0x3e03,  0x3e1c,
	0x3e34,  0x3e4c,  0x3e65,  0x3e7d,  0x3e95,  0x3eae,  0x3ec6,  0x3edf,  0x3ef7,  0x3f0f,
	0x3f28,  0x3f40,  0x3f58,  0x3f71,  0x3f89,  0x3fa1,  0x3fba,  0x3fd2,  0x3fea,  0x4003,
	0x401b,  0x4033,  0x404c,  0x4064,  0x407c,  0x4095,  0x40ad,  0x40c5,  0x40de,  0x40f6,
	0x410e,  0x4127,  0x413f,  0x4157,  0x416f,  0x4188,  0x41a0,  0x41b8,  0x41d1,  0x41e9,
	0x4201,  0x421a,  0x4232,  0x424a,  0x4262,  0x427b,  0x4293,  0x42ab,  0x42c3,  0x42dc,
	0x42f4,  0x430c,  0x4324,  0x433d,  0x4355,  0x436d,  0x4385,  0x439e,  0x43b6,  0x43ce,
	0x43e6,  0x43ff,  0x4417,  0x442f,  0x4447,  0x4460,  0x4478,  0x4490,  0x44a8,  0x44c0,
	0x44d9,  0x44f1,  0x4509,  0x4521,  0x4539,  0x4552,  0x456a,  0x4582,  0x459a,  0x45b2,
	0x45cb,  0x45e3,  0x45fb,  0x4613,  0x462b,  0x4643,  0x465c,  0x4674,  0x468c,  0x46a4,
	0x46bc,  0x46d4,  0x46ec,  0x4705,  0x471d,  0x4735,  0x474d,  0x4765,  0x477d,  0x4795,
	0x47ae,  0x47c6,  0x47de,  0x47f6,  0x480e,  0x4826,  0x483e,  0x4856,  0x486f,  0x4887,
	0x489f,  0x48b7,  0x48cf,  0x48e7,  0x48ff,  0x4917,  0x492f,  0x4947,  0x495f,  0x4978,
	0x4990,  0x49a8,  0x49c0,  0x49d8,  0x49f0,  0x4a08,  0x4a20,  0x4a38,  0x4a50,  0x4a68,
	0x4a80,  0x4a98,  0x4ab0,  0x4ac8,  0x4ae0,  0x4af8,  0x4b10,  0x4b28,  0x4b40,  0x4b58,
	0x4b71,  0x4b89,  0x4ba1,  0x4bb9,  0x4bd1,  0x4be9,  0x4c01,  0x4c19,  0x4c31,  0x4c49,
	0x4c61,  0x4c79,  0x4c90,  0x4ca8,  0x4cc0,  0x4cd8,  0x4cf0,  0x4d08,  0x4d20,  0x4d38,
	0x4d50,  0x4d68,  0x4d80,  0x4d98,  0x4db0,  0x4dc8,  0x4de0,  0x4df8,  0x4e10,  0x4e28,
	0x4e40,  0x4e58,  0x4e70,  0x4e87,  0x4e9f,  0x4eb7,  0x4ecf,  0x4ee7,  0x4eff,  0x4f17,
	0x4f2f,  0x4f47,  0x4f5f,  0x4f77,  0x4f8e,  0x4fa6,  0x4fbe,  0x4fd6,  0x4fee,  0x5006,
	0x501e,  0x5036,  0x504d,  0x5065,  0x507d,  0x5095,  0x50ad,  0x50c5,  0x50dd,  0x50f4,
	0x510c,  0x5124,  0x513c,  0x5154,  0x516c,  0x5183,  0x519b,  0x51b3,  0x51cb,  0x51e3,
	0x51fb,  0x5212,  0x522a,  0x5242,  0x525a,  0x5272,  0x5289,  0x52a1,  0x52b9,  0x52d1,
	0x52e8,  0x5300,  0x5318,  0x5330,  0x5348,  0x535f,  0x5377,  0x538f,  0x53a7,  0x53be,
	0x53d6,  0x53ee,  0x5406,  0x541d,  0x5435,  0x544d,  0x5464,  0x547c,  0x5494,  0x54ac,
	0x54c3,  0x54db,  0x54f3,  0x550b,  0x5522,  0x553a,  0x5552,  0x5569,  0x5581,  0x5599,
	0x55b0,  0x55c8,  0x55e0,  0x55f7,  0x560f,  0x5627,  0x563e,  0x5656,  0x566e,  0x5685,
	0x569d,  0x56b5,  0x56cc,  0x56e4,  0x56fc,  0x5713,  0x572b,  0x5743,  0x575a,  0x5772,
	0x5789,  0x57a1,  0x57b9,  0x57d0,  0x57e8,  0x57ff,  0x5817,  0x582f,  0x5846,  0x585e,
	0x5875,  0x588d,  0x58a5,  0x58bc,  0x58d4,  0x58eb,  0x5903,  0x591a,  0x5932,  0x594a,
	0x5961,  0x5979,  0x5990,  0x59a8,  0x59bf,  0x59d7,  0x59ee,  0x5a06,  0x5a1d,  0x5a35,
	0x5a4c,  0x5a64,  0x5a7b,  0x5a93,  0x5aaa,  0x5ac2,  0x5ad9,  0x5af1,  0x5b08,  0x5b20,
	0x5b37,  0x5b4f,  0x5b66,  0x5b7e,  0x5b95,  0x5bad,  0x5bc4,  0x5bdc,  0x5bf3,  0x5c0b,
	0x5c22,  0x5c3a,  0x5c51,  0x5c68,  0x5c80,  0x5c97,  0x5caf,  0x5cc6,  0x5cde,  0x5cf5,
	0x5d0c,  0x5d24,  0x5d3b,  0x5d53,  0x5d6a,  0x5d81,  0x5d99,  0x5db0,  0x5dc8,  0x5ddf,
	0x5df6,  0x5e0e,  0x5e25,  0x5e3c,  0x5e54,  0x5e6b,  0x5e83,  0x5e9a,  0x5eb1,  0x5ec9,
	0x5ee0,  0x5ef7,  0x5f0f,  0x5f26,  0x5f3d,  0x5f55,  0x5f6c,  0x5f83,  0x5f9b,  0x5fb2,
	0x5fc9,  0x5fe1,  0x5ff8,  0x600f,  0x6026,  0x603e,  0x6055,  0x606c,  0x6084,  0x609b,
	0x60b2,  0x60c9,  0x60e1,  0x60f8,  0x610f,  0x6126,  0x613e,  0x6155,  0x616c,  0x6183,
	0x619b,  0x61b2,  0x61c9,  0x61e0,  0x61f8,  0x620f,  0x6226,  0x623d,  0x6254,  0x626c,
	0x6283,  0x629a,  0x62b1,  0x62c8,  0x62e0,  0x62f7,  0x630e,  0x6325,  0x633c,  0x6353,
	0x636b,  0x6382,  0x6399,  0x63b0,  0x63c7,  0x63de,  0x63f5,  0x640d,  0x6424,  0x643b,
	0x6452,  0x6469,  0x6480,  0x6497,  0x64ae,  0x64c6,  0x64dd,  0x64f4,  0x650b,  0x6522,
	0x6539,  0x6550,  0x6567,  0x657e,  0x6595,  0x65ac,  0x65c3,  0x65db,  0x65f2,  0x6609,
	0x6620,  0x6637,  0x664e,  0x6665,  0x667c,  0x6693,  0x66aa,  0x66c1,  0x66d8,  0x66ef,
	0x6706,  0x671d,  0x6734,  0x674b,  0x6762,  0x6779,  0x6790,  0x67a7,  0x67be,  0x67d5,
	0x67ec,  0x6803,  0x681a,  0x6831,  0x6848,  0x685f,  0x6876,  0x688d,  0x68a3,  0x68ba,
	0x68d1,  0x68e8,  0x68ff,  0x6916,  0x692d,  0x6944,  0x695b,  0x6972,  0x6989,  0x69a0,
	0x69b6,  0x69cd,  0x69e4,  0x69fb,  0x6a12,  0x6a29,  0x6a40,  0x6a57,  0x6a6d,  0x6a84,
	0x6a9b,  0x6ab2,  0x6ac9,  0x6ae0,  0x6af6,  0x6b0d,  0x6b24,  0x6b3b,  0x6b52,  0x6b69,
	0x6b7f,  0x6b96,  0x6bad,  0x6bc4,  0x6bdb,  0x6bf1,  0x6c08,  0x6c1f,  0x6c36,  0x6c4d,
	0x6c63,  0x6c7a,  0x6c91,  0x6ca8,  0x6cbe,  0x6cd5,  0x6cec,  0x6d03,  0x6d19,  0x6d30,
	0x6d47,  0x6d5e,  0x6d74,  0x6d8b,  0x6da2,  0x6db8,  0x6dcf,  0x6de6,  0x6dfc,  0x6e13,
	0x6e2a,  0x6e41,  0x6e57,  0x6e6e,  0x6e85,  0x6e9b,  0x6eb2,  0x6ec9,  0x6edf,  0x6ef6,
	0x6f0d,  0x6f23,  0x6f3a,  0x6f50,  0x6f67,  0x6f7e,  0x6f94,  0x6fab,  0x6fc2,  0x6fd8,
	0x6fef,  0x7005,  0x701c,  0x7033,  0x7049,  0x7060,  0x7076,  0x708d,  0x70a3,  0x70ba,
	0x70d1,  0x70e7,  0x70fe,  0x7114,  0x712b,  0x7141,  0x7158,  0x716e,  0x7185,  0x719b,
	0x71b2,  0x71c9,  0x71df,  0x71f6,  0x720c,  0x7223,  0x7239,  0x7250,  0x7266,  0x727c,
	0x7293,  0x72a9,  0x72c0,  0x72d6,  0x72ed,  0x7303,  0x731a,  0x7330,  0x7347,  0x735d,
	0x7373,  0x738a,  0x73a0,  0x73b7,  0x73cd,  0x73e4,  0x73fa,  0x7410,  0x7427,  0x743d,
	0x7454,  0x746a,  0x7480,  0x7497,  0x74ad,  0x74c3,  0x74da,  0x74f0,  0x7507,  0x751d,
	0x7533,  0x754a,  0x7560,  0x7576,  0x758d,  0x75a3,  0x75b9,  0x75d0,  0x75e6,  0x75fc,
	0x7612,  0x7629,  0x763f,  0x7655,  0x766c,  0x7682,  0x7698,  0x76ae,  0x76c5,  0x76db,
	0x76f1,  0x7708,  0x771e,  0x7734,  0x774a,  0x7760,  0x7777,  0x778d,  0x77a3,  0x77b9,
	0x77d0,  0x77e6,  0x77fc,  0x7812,  0x7828,  0x783f,  0x7855,  0x786b,  0x7881,  0x7897,
	0x78ad,  0x78c4,  0x78da,  0x78f0,  0x7906,  0x791c,  0x7932,  0x7949,  0x795f,  0x7975,
	0x798b,  0x79a1,  0x79b7,  0x79cd,  0x79e3,  0x79f9,  0x7a10,  0x7a26,  0x7a3c,  0x7a52,
	0x7a68,  0x7a7e,  0x7a94,  0x7aaa,  0x7ac0,  0x7ad6,  0x7aec,  0x7b02,  0x7b18,  0x7b2e,
	0x7b44,  0x7b5a,  0x7b70,  0x7b86,  0x7b9c,  0x7bb2,  0x7bc8,  0x7bde,  0x7bf4,  0x7c0a,
	0x7c20,  0x7c36,  0x7c4c,  0x7c62,  0x7c78,  0x7c8e,  0x7ca4,  0x7cba,  0x7cd0,  0x7ce6,
	0x7cfc,  0x7d12,  0x7d28,  0x7d3e,  0x7d54,  0x7d6a,  0x7d7f,  0x7d95,  0x7dab,  0x7dc1,
	0x7dd7,  0x7ded,  0x7e03,  0x7e19,  0x7e2f,  0x7e44,  0x7e5a,  0x7e70,  0x7e86,  0x7e9c,
	0x7eb2,  0x7ec8,  0x7edd,  0x7ef3,  0x7f09,  0x7f1f,  0x7f35,  0x7f4a,  0x7f60,  0x7f76,
	0x7f8c,  0x7fa2,  0x7fb7,  0x7fcd,  0x7fe3,  0x7ff9,  0x800f,  0x8024,  0x803a,  0x8050,
	0x8066,  0x807b,  0x8091,  0x80a7,  0x80bc,  0x80d2,  0x80e8,  0x80fe,  0x8113,  0x8129,
	0x813f,  0x8154,  0x816a,  0x8180,  0x8195,  0x81ab,  0x81c1,  0x81d6,  0x81ec,  0x8202,
	0x8217,  0x822d,  0x8243,  0x8258,  0x826e,  0x8284,  0x8299,  0x82af,  0x82c4,  0x82da,
	0x82f0,  0x8305,  0x831b,  0x8330,  0x8346,  0x835c,  0x8371,  0x8387,  0x839c,  0x83b2,
	0x83c7,  0x83dd,  0x83f2,  0x8408,  0x841d,  0x8433,  0x8449,  0x845e,  0x8474,  0x8489,
	0x849f,  0x84b4,  0x84ca,  0x84df,  0x84f5,  0x850a,  0x851f,  0x8535,  0x854a,  0x8560,
	0x8575,  0x858b,  0x85a0,  0x85b6,  0x85cb,  0x85e0,  0x85f6,  0x860b,  0x8621,  0x8636,
	0x864c,  0x8661,  0x8676,  0x868c,  0x86a1,  0x86b6,  0x86cc,  0x86e1,  0x86f7,  0x870c,
	0x8721,  0x8737,  0x874c,  0x8761,  0x8777,  0x878c,  0x87a1,  0x87b7,  0x87cc,  0x87e1,
	0x87f6,  0x880c,  0x8821,  0x8836,  0x884c,  0x8861,  0x8876,  0x888b,  0x88a1,  0x88b6,
	0x88cb,  0x88e0,  0x88f6,  0x890b,  0x8920,  0x8935,  0x894a,  0x8960,  0x8975,  0x898a,
	0x899f,  0x89b4,  0x89ca,  0x89df,  0x89f4,  0x8a09,  0x8a1e,  0x8a34,  0x8a49,  0x8a5e,
	0x8a73,  0x8a88,  0x8a9d,  0x8ab2,  0x8ac7,  0x8add,  0x8af2,  0x8b07,  0x8b1c,  0x8b31,
	0x8b46,  0x8b5b,  0x8b70,  0x8b85,  0x8b9a,  0x8baf,  0x8bc5,  0x8bda,  0x8bef,  0x8c04,
	0x8c19,  0x8c2e,  0x8c43,  0x8c58,  0x8c6d,  0x8c82,  0x8c97,  0x8cac,  0x8cc1,  0x8cd6,
	0x8ceb,  0x8d00,  0x8d15,  0x8d2a,  0x8d3f,  0x8d54,  0x8d69,  0x8d7e,  0x8d93,  0x8da7,
	0x8dbc,  0x8dd1,  0x8de6,  0x8dfb,  0x8e10,  0x8e25,  0x8e3a,  0x8e4f,  0x8e64,  0x8e79,
	0x8e8d,  0x8ea2,  0x8eb7,  0x8ecc,  0x8ee1,  0x8ef6,  0x8f0b,  0x8f1f,  0x8f34,  0x8f49,
	0x8f5e,  0x8f73,  0x8f88,  0x8f9c,  0x8fb1,  0x8fc6,  0x8fdb,  0x8ff0,  0x9004,  0x9019,
	0x902e,  0x9043,  0x9057,  0x906c,  0x9081,  0x9096,  0x90aa,  0x90bf,  0x90d4,  0x90e9,
	0x90fd,  0x9112,  0x9127,  0x913b,  0x9150,  0x9165,  0x9179,  0x918e,  0x91a3,  0x91b7,
	0x91cc,  0x91e1,  0x91f5,  0x920a,  0x921f,  0x9233,  0x9248,  0x925d,  0x9271,  0x9286,
	0x929a,  0x92af,  0x92c4,  0x92d8,  0x92ed,  0x9301,  0x9316,  0x932a,  0x933f,  0x9354,
	0x9368,  0x937d,  0x9391,  0x93a6,  0x93ba,  0x93cf,  0x93e3,  0x93f8,  0x940c,  0x9421,
	0x9435,  0x944a,  0x945e,  0x9473,  0x9487,  0x949c,  0x94b0,  0x94c5,  0x94d9,  0x94ee,
	0x9502,  0x9516,  0x952b,  0x953f,  0x9554,  0x9568,  0x957d,  0x9591,  0x95a5,  0x95ba,
	0x95ce,  0x95e2,  0x95f7,  0x960b,  0x9620,  0x9634,  0x9648,  0x965d,  0x9671,  0x9685,
	0x969a,  0x96ae,  0x96c2,  0x96d7,  0x96eb,  0x96ff,  0x9713,  0x9728,  0x973c,  0x9750,
	0x9765,  0x9779,  0x978d,  0x97a1,  0x97b6,  0x97ca,  0x97de,  0x97f2,  0x9807,  0x981b,
	0x982f,  0x9843,  0x9857,  0x986c,  0x9880,  0x9894,  0x98a8,  0x98bc,  0x98d0,  0x98e5,
	0x98f9,  0x990d,  0x9921,  0x9935,  0x9949,  0x995d,  0x9972,  0x9986,  0x999a,  0x99ae,
	0x99c2,  0x99d6,  0x99ea,  0x99fe,  0x9a12,  0x9a26,  0x9a3a,  0x9a4f,  0x9a63,  0x9a77,
	0x9a8b,  0x9a9f,  0x9ab3,  0x9ac7,  0x9adb,  0x9aef,  0x9b03,  0x9b17,  0x9b2b,  0x9b3f,
	0x9b53,  0x9b67,  0x9b7b,  0x9b8f,  0x9ba3,  0x9bb7,  0x9bca,  0x9bde,  0x9bf2,  0x9c06,
	0x9c1a,  0x9c2e,  0x9c42,  0x9c56,  0x9c6a,  0x9c7e,  0x9c92,  0x9ca6,  0x9cb9,  0x9ccd,
	0x9ce1,  0x9cf5,  0x9d09,  0x9d1d,  0x9d31,  0x9d44,  0x9d58,  0x9d6c,  0x9d80,  0x9d94,
	0x9da7,  0x9dbb,  0x9dcf,  0x9de3,  0x9df7,  0x9e0a,  0x9e1e,  0x9e32,  0x9e46,  0x9e59,
	0x9e6d,  0x9e81,  0x9e95,  0x9ea8,  0x9ebc,  0x9ed0,  0x9ee3,  0x9ef7,  0x9f0b,  0x9f1f,
	0x9f32,  0x9f46,  0x9f5a,  0x9f6d,  0x9f81,  0x9f95,  0x9fa8,  0x9fbc,  0x9fd0,  0x9fe3,
	0x9ff7,  0xa00a,  0xa01e,  0xa032,  0xa045,  0xa059,  0xa06c,  0xa080,  0xa094,  0xa0a7,
	0xa0bb,  0xa0ce,  0xa0e2,  0xa0f5,  0xa109,  0xa11c,  0xa130,  0xa143,  0xa157,  0xa16b,
	0xa17e,  0xa192,  0xa1a5,  0xa1b9,  0xa1cc,  0xa1df,  0xa1f3,  0xa206,  0xa21a,  0xa22d,
	0xa241,  0xa254,  0xa268,  0xa27b,  0xa28e,  0xa2a2,  0xa2b5,  0xa2c9,  0xa2dc,  0xa2ef,
	0xa303,  0xa316,  0xa32a,  0xa33d,  0xa350,  0xa364,  0xa377,  0xa38a,  0xa39e,  0xa3b1,
	0xa3c4,  0xa3d8,  0xa3eb,  0xa3fe,  0xa412,  0xa425,  0xa438,  0xa44b,  0xa45f,  0xa472,
	0xa485,  0xa498,  0xa4ac,  0xa4bf,  0xa4d2,  0xa4e5,  0xa4f9,  0xa50c,  0xa51f,  0xa532,
	0xa545,  0xa559,  0xa56c,  0xa57f,  0xa592,  0xa5a5,  0xa5b8,  0xa5cc,  0xa5df,  0xa5f2,
	0xa605,  0xa618,  0xa62b,  0xa63e,  0xa652,  0xa665,  0xa678,  0xa68b,  0xa69e,  0xa6b1,
	0xa6c4,  0xa6d7,  0xa6ea,  0xa6fd,  0xa710,  0xa723,  0xa736,  0xa749,  0xa75c,  0xa76f,
	0xa782,  0xa795,  0xa7a8,  0xa7bb,  0xa7ce,  0xa7e1,  0xa7f4,  0xa807,  0xa81a,  0xa82d,
	0xa840,  0xa853,  0xa866,  0xa879,  0xa88c,  0xa89f,  0xa8b2,  0xa8c5,  0xa8d7,  0xa8ea,
	0xa8fd,  0xa910,  0xa923,  0xa936,  0xa949,  0xa95c,  0xa96e,  0xa981,  0xa994,  0xa9a7,
	0xa9ba,  0xa9cd,  0xa9df,  0xa9f2,  0xaa05,  0xaa18,  0xaa2a,  0xaa3d,  0xaa50,  0xaa63,
	0xaa76,  0xaa88,  0xaa9b,  0xaaae,  0xaac1,  0xaad3,  0xaae6,  0xaaf9,  0xab0b,  0xab1e,
	0xab31,  0xab43,  0xab56,  0xab69,  0xab7b,  0xab8e,  0xaba1,  0xabb3,  0xabc6,  0xabd9,
	0xabeb,  0xabfe,  0xac11,  0xac23,  0xac36,  0xac48,  0xac5b,  0xac6d,  0xac80,  0xac93,
	0xaca5,  0xacb8,  0xacca,  0xacdd,  0xacef,  0xad02,  0xad14,  0xad27,  0xad39,  0xad4c,
	0xad5e,  0xad71,  0xad83,  0xad96,  0xada8,  0xadbb,  0xadcd,  0xade0,  0xadf2,  0xae05,
	0xae17,  0xae29,  0xae3c,  0xae4e,  0xae61,  0xae73,  0xae85,  0xae98,  0xaeaa,  0xaebd,
	0xaecf,  0xaee1,  0xaef4,  0xaf06,  0xaf18,  0xaf2b,  0xaf3d,  0xaf4f,  0xaf62,  0xaf74,
	0xaf86,  0xaf99,  0xafab,  0xafbd,  0xafcf,  0xafe2,  0xaff4,  0xb006,  0xb018,  0xb02b,
	0xb03d,  0xb04f,  0xb061,  0xb074,  0xb086,  0xb098,  0xb0aa,  0xb0bc,  0xb0ce,  0xb0e1,
	0xb0f3,  0xb105,  0xb117,  0xb129,  0xb13b,  0xb14e,  0xb160,  0xb172,  0xb184,  0xb196,
	0xb1a8,  0xb1ba,  0xb1cc,  0xb1de,  0xb1f0,  0xb203,  0xb215,  0xb227,  0xb239,  0xb24b,
	0xb25d,  0xb26f,  0xb281,  0xb293,  0xb2a5,  0xb2b7,  0xb2c9,  0xb2db,  0xb2ed,  0xb2ff,
	0xb311,  0xb323,  0xb335,  0xb347,  0xb358,  0xb36a,  0xb37c,  0xb38e,  0xb3a0,  0xb3b2,
	0xb3c4,  0xb3d6,  0xb3e8,  0xb3fa,  0xb40b,  0xb41d,  0xb42f,  0xb441,  0xb453,  0xb465,
	0xb477,  0xb488,  0xb49a,  0xb4ac,  0xb4be,  0xb4d0,  0xb4e1,  0xb4f3,  0xb505,  0xb517,
	0xb528,  0xb53a,  0xb54c,  0xb55e,  0xb56f,  0xb581,  0xb593,  0xb5a5,  0xb5b6,  0xb5c8,
	0xb5da,  0xb5eb,  0xb5fd,  0xb60f,  0xb620,  0xb632,  0xb644,  0xb655,  0xb667,  0xb679,
	0xb68a,  0xb69c,  0xb6ad,  0xb6bf,  0xb6d1,  0xb6e2,  0xb6f4,  0xb705,  0xb717,  0xb729,
	0xb73a,  0xb74c,  0xb75d,  0xb76f,  0xb780,  0xb792,  0xb7a3,  0xb7b5,  0xb7c6,  0xb7d8,
	0xb7e9,  0xb7fb,  0xb80c,  0xb81e,  0xb82f,  0xb841,  0xb852,  0xb864,  0xb875,  0xb886,
	0xb898,  0xb8a9,  0xb8bb,  0xb8cc,  0xb8dd,  0xb8ef,  0xb900,  0xb912,  0xb923,  0xb934,
	0xb946,  0xb957,  0xb968,  0xb97a,  0xb98b,  0xb99c,  0xb9ae,  0xb9bf,  0xb9d0,  0xb9e1,
	0xb9f3,  0xba04,  0xba15,  0xba26,  0xba38,  0xba49,  0xba5a,  0xba6b,  0xba7d,  0xba8e,
	0xba9f,  0xbab0,  0xbac1,  0xbad3,  0xbae4,  0xbaf5,  0xbb06,  0xbb17,  0xbb28,  0xbb3a,
	0xbb4b,  0xbb5c,  0xbb6d,  0xbb7e,  0xbb8f,  0xbba0,  0xbbb1,  0xbbc3,  0xbbd4,  0xbbe5,
	0xbbf6,  0xbc07,  0xbc18,  0xbc29,  0xbc3a,  0xbc4b,  0xbc5c,  0xbc6d,  0xbc7e,  0xbc8f,
	0xbca0,  0xbcb1,  0xbcc2,  0xbcd3,  0xbce4,  0xbcf5,  0xbd06,  0xbd17,  0xbd28,  0xbd39,
	0xbd4a,  0xbd5a,  0xbd6b,  0xbd7c,  0xbd8d,  0xbd9e,  0xbdaf,  0xbdc0,  0xbdd1,  0xbde2,
	0xbdf2,  0xbe03,  0xbe14,  0xbe25,  0xbe36,  0xbe47,  0xbe57,  0xbe68,  0xbe79,  0xbe8a,
	0xbe9b,  0xbeab,  0xbebc,  0xbecd,  0xbede,  0xbeee,  0xbeff,  0xbf10,  0xbf21,  0xbf31,
	0xbf42,  0xbf53,  0xbf63,  0xbf74,  0xbf85,  0xbf95,  0xbfa6,  0xbfb7,  0xbfc7,  0xbfd8,
	0xbfe9,  0xbff9,  0xc00a,  0xc01b,  0xc02b,  0xc03c,  0xc04c,  0xc05d,  0xc06e,  0xc07e,
	0xc08f,  0xc09f,  0xc0b0,  0xc0c0,  0xc0d1,  0xc0e1,  0xc0f2,  0xc102,  0xc113,  0xc123,
	0xc134,  0xc144,  0xc155,  0xc165,  0xc176,  0xc186,  0xc197,  0xc1a7,  0xc1b8,  0xc1c8,
	0xc1d8,  0xc1e9,  0xc1f9,  0xc20a,  0xc21a,  0xc22a,  0xc23b,  0xc24b,  0xc25c,  0xc26c,
	0xc27c,  0xc28d,  0xc29d,  0xc2ad,  0xc2be,  0xc2ce,  0xc2de,  0xc2ee,  0xc2ff,  0xc30f,
	0xc31f,  0xc330,  0xc340,  0xc350,  0xc360,  0xc371,  0xc381,  0xc391,  0xc3a1,  0xc3b1,
	0xc3c2,  0xc3d2,  0xc3e2,  0xc3f2,  0xc402,  0xc413,  0xc423,  0xc433,  0xc443,  0xc453,
	0xc463,  0xc473,  0xc483,  0xc494,  0xc4a4,  0xc4b4,  0xc4c4,  0xc4d4,  0xc4e4,  0xc4f4,
	0xc504,  0xc514,  0xc524,  0xc534,  0xc544,  0xc554,  0xc564,  0xc574,  0xc584,  0xc594,
	0xc5a4,  0xc5b4,  0xc5c4,  0xc5d4,  0xc5e4,  0xc5f4,  0xc604,  0xc614,  0xc624,  0xc634,
	0xc644,  0xc653,  0xc663,  0xc673,  0xc683,  0xc693,  0xc6a3,  0xc6b3,  0xc6c2,  0xc6d2,
	0xc6e2,  0xc6f2,  0xc702,  0xc712,  0xc721,  0xc731,  0xc741,  0xc751,  0xc761,  0xc770,
	0xc780,  0xc790,  0xc7a0,  0xc7af,  0xc7bf,  0xc7cf,  0xc7de,  0xc7ee,  0xc7fe,  0xc80d,
	0xc81d,  0xc82d,  0xc83c,  0xc84c,  0xc85c,  0xc86b,  0xc87b,  0xc88b,  0xc89a,  0xc8aa,
	0xc8ba,  0xc8c9,  0xc8d9,  0xc8e8,  0xc8f8,  0xc907,  0xc917,  0xc927,  0xc936,  0xc946,
	0xc955,  0xc965,  0xc974,  0xc984,  0xc993,  0xc9a3,  0xc9b2,  0xc9c2,  0xc9d1,  0xc9e1,
	0xc9f0,  0xc9ff,  0xca0f,  0xca1e,  0xca2e,  0xca3d,  0xca4d,  0xca5c,  0xca6b,  0xca7b,
	0xca8a,  0xca99,  0xcaa9,  0xcab8,  0xcac7,  0xcad7,  0xcae6,  0xcaf5,  0xcb05,  0xcb14,
	0xcb23,  0xcb33,  0xcb42,  0xcb51,  0xcb61,  0xcb70,  0xcb7f,  0xcb8e,  0xcb9e,  0xcbad,
	0xcbbc,  0xcbcb,  0xcbda,  0xcbea,  0xcbf9,  0xcc08,  0xcc17,  0xcc26,  0xcc35,  0xcc45,
	0xcc54,  0xcc63,  0xcc72,  0xcc81,  0xcc90,  0xcc9f,  0xccae,  0xccbe,  0xcccd,  0xccdc,
	0xcceb,  0xccfa,  0xcd09,  0xcd18,  0xcd27,  0xcd36,  0xcd45,  0xcd54,  0xcd63,  0xcd72,
	0xcd81,  0xcd90,  0xcd9f,  0xcdae,  0xcdbd,  0xcdcc,  0xcddb,  0xcdea,  0xcdf9,  0xce08,
	0xce17,  0xce25,  0xce34,  0xce43,  0xce52,  0xce61,  0xce70,  0xce7f,  0xce8e,  0xce9c,
	0xceab,  0xceba,  0xcec9,  0xced8,  0xcee7,  0xcef5,  0xcf04,  0xcf13,  0xcf22,  0xcf30,
	0xcf3f,  0xcf4e,  0xcf5d,  0xcf6b,  0xcf7a,  0xcf89,  0xcf98,  0xcfa6,  0xcfb5,  0xcfc4,
	0xcfd2,  0xcfe1,  0xcff0,  0xcffe,  0xd00d,  0xd01c,  0xd02a,  0xd039,  0xd047,  0xd056,
	0xd065,  0xd073,  0xd082,  0xd090,  0xd09f,  0xd0ae,  0xd0bc,  0xd0cb,  0xd0d9,  0xd0e8,
	0xd0f6,  0xd105,  0xd113,  0xd122,  0xd130,  0xd13f,  0xd14d,  0xd15c,  0xd16a,  0xd179,
	0xd187,  0xd195,  0xd1a4,  0xd1b2,  0xd1c1,  0xd1cf,  0xd1de,  0xd1ec,  0xd1fa,  0xd209,
	0xd217,  0xd225,  0xd234,  0xd242,  0xd250,  0xd25f,  0xd26d,  0xd27b,  0xd28a,  0xd298,
	0xd2a6,  0xd2b5,  0xd2c3,  0xd2d1,  0xd2df,  0xd2ee,  0xd2fc,  0xd30a,  0xd318,  0xd326,
	0xd335,  0xd343,  0xd351,  0xd35f,  0xd36d,  0xd37c,  0xd38a,  0xd398,  0xd3a6,  0xd3b4,
	0xd3c2,  0xd3d0,  0xd3df,  0xd3ed,  0xd3fb,  0xd409,  0xd417,  0xd425,  0xd433,  0xd441,
	0xd44f,  0xd45d,  0xd46b,  0xd479,  0xd487,  0xd495,  0xd4a3,  0xd4b1,  0xd4bf,  0xd4cd,
	0xd4db,  0xd4e9,  0xd4f7,  0xd505,  0xd513,  0xd521,  0xd52f,  0xd53d,  0xd54b,  0xd559,
	0xd566,  0xd574,  0xd582,  0xd590,  0xd59e,  0xd5ac,  0xd5ba,  0xd5c7,  0xd5d5,  0xd5e3,
	0xd5f1,  0xd5ff,  0xd60c,  0xd61a,  0xd628,  0xd636,  0xd644,  0xd651,  0xd65f,  0xd66d,
	0xd67a,  0xd688,  0xd696,  0xd6a4,  0xd6b1,  0xd6bf,  0xd6cd,  0xd6da,  0xd6e8,  0xd6f6,
	0xd703,  0xd711,  0xd71f,  0xd72c,  0xd73a,  0xd747,  0xd755,  0xd763,  0xd770,  0xd77e,
	0xd78b,  0xd799,  0xd7a6,  0xd7b4,  0xd7c1,  0xd7cf,  0xd7dc,  0xd7ea,  0xd7f8,  0xd805,
	0xd812,  0xd820,  0xd82d,  0xd83b,  0xd848,  0xd856,  0xd863,  0xd871,  0xd87e,  0xd88b,
	0xd899,  0xd8a6,  0xd8b4,  0xd8c1,  0xd8ce,  0xd8dc,  0xd8e9,  0xd8f6,  0xd904,  0xd911,
	0xd91e,  0xd92c,  0xd939,  0xd946,  0xd954,  0xd961,  0xd96e,  0xd97b,  0xd989,  0xd996,
	0xd9a3,  0xd9b0,  0xd9be,  0xd9cb,  0xd9d8,  0xd9e5,  0xd9f2,  0xda00,  0xda0d,  0xda1a,
	0xda27,  0xda34,  0xda41,  0xda4f,  0xda5c,  0xda69,  0xda76,  0xda83,  0xda90,  0xda9d,
	0xdaaa,  0xdab7,  0xdac4,  0xdad1,  0xdade,  0xdaeb,  0xdaf8,  0xdb05,  0xdb12,  0xdb1f,
	0xdb2c,  0xdb39,  0xdb46,  0xdb53,  0xdb60,  0xdb6d,  0xdb7a,  0xdb87,  0xdb94,  0xdba1,
	0xdbae,  0xdbbb,  0xdbc8,  0xdbd5,  0xdbe1,  0xdbee,  0xdbfb,  0xdc08,  0xdc15,  0xdc22,
	0xdc2f,  0xdc3b,  0xdc48,  0xdc55,  0xdc62,  0xdc6f,  0xdc7b,  0xdc88,  0xdc95,  0xdca2,
	0xdcae,  0xdcbb,  0xdcc8,  0xdcd5,  0xdce1,  0xdcee,  0xdcfb,  0xdd07,  0xdd14,  0xdd21,
	0xdd2d,  0xdd3a,  0xdd47,  0xdd53,  0xdd60,  0xdd6c,  0xdd79,  0xdd86,  0xdd92,  0xdd9f,
	0xddab,  0xddb8,  0xddc5,  0xddd1,  0xddde,  0xddea,  0xddf7,  0xde03,  0xde10,  0xde1c,
	0xde29,  0xde35,  0xde42,  0xde4e,  0xde5b,  0xde67,  0xde74,  0xde80,  0xde8c,  0xde99,
	0xdea5,  0xdeb2,  0xdebe,  0xdeca,  0xded7,  0xdee3,  0xdef0,  0xdefc,  0xdf08,  0xdf15,
	0xdf21,  0xdf2d,  0xdf39,  0xdf46,  0xdf52,  0xdf5e,  0xdf6b,  0xdf77,  0xdf83,  0xdf8f,
	0xdf9c,  0xdfa8,  0xdfb4,  0xdfc0,  0xdfcd,  0xdfd9,  0xdfe5,  0xdff1,  0xdffd,  0xe009,
	0xe016,  0xe022,  0xe02e,  0xe03a,  0xe046,  0xe052,  0xe05e,  0xe06a,  0xe077,  0xe083,
	0xe08f,  0xe09b,  0xe0a7,  0xe0b3,  0xe0bf,  0xe0cb,  0xe0d7,  0xe0e3,  0xe0ef,  0xe0fb,
	0xe107,  0xe113,  0xe11f,  0xe12b,  0xe137,  0xe143,  0xe14f,  0xe15b,  0xe167,  0xe172,
	0xe17e,  0xe18a,  0xe196,  0xe1a2,  0xe1ae,  0xe1ba,  0xe1c6,  0xe1d1,  0xe1dd,  0xe1e9,
	0xe1f5,  0xe201,  0xe20d,  0xe218,  0xe224,  0xe230,  0xe23c,  0xe247,  0xe253,  0xe25f,
	0xe26b,  0xe276,  0xe282,  0xe28e,  0xe299,  0xe2a5,  0xe2b1,  0xe2bd,  0xe2c8,  0xe2d4,
	0xe2df,  0xe2eb,  0xe2f7,  0xe302,  0xe30e,  0xe31a,  0xe325,  0xe331,  0xe33c,  0xe348,
	0xe353,  0xe35f,  0xe36b,  0xe376,  0xe382,  0xe38d,  0xe399,  0xe3a4,  0xe3b0,  0xe3bb,
	0xe3c7,  0xe3d2,  0xe3de,  0xe3e9,  0xe3f4,  0xe400,  0xe40b,  0xe417,  0xe422,  0xe42e,
	0xe439,  0xe444,  0xe450,  0xe45b,  0xe466,  0xe472,  0xe47d,  0xe488,  0xe494,  0xe49f,
	0xe4aa,  0xe4b6,  0xe4c1,  0xe4cc,  0xe4d7,  0xe4e3,  0xe4ee,  0xe4f9,  0xe504,  0xe510,
	0xe51b,  0xe526,  0xe531,  0xe53d,  0xe548,  0xe553,  0xe55e,  0xe569,  0xe574,  0xe57f,
	0xe58b,  0xe596,  0xe5a1,  0xe5ac,  0xe5b7,  0xe5c2,  0xe5cd,  0xe5d8,  0xe5e3,  0xe5ee,
	0xe5f9,  0xe605,  0xe610,  0xe61b,  0xe626,  0xe631,  0xe63c,  0xe647,  0xe652,  0xe65c,
	0xe667,  0xe672,  0xe67d,  0xe688,  0xe693,  0xe69e,  0xe6a9,  0xe6b4,  0xe6bf,  0xe6ca,
	0xe6d5,  0xe6df,  0xe6ea,  0xe6f5,  0xe700,  0xe70b,  0xe716,  0xe720,  0xe72b,  0xe736,
	0xe741,  0xe74c,  0xe756,  0xe761,  0xe76c,  0xe777,  0xe781,  0xe78c,  0xe797,  0xe7a1,
	0xe7ac,  0xe7b7,  0xe7c2,  0xe7cc,  0xe7d7,  0xe7e2,  0xe7ec,  0xe7f7,  0xe801,  0xe80c,
	0xe817,  0xe821,  0xe82c,  0xe836,  0xe841,  0xe84c,  0xe856,  0xe861,  0xe86b,  0xe876,
	0xe880,  0xe88b,  0xe895,  0xe8a0,  0xe8aa,  0xe8b5,  0xe8bf,  0xe8ca,  0xe8d4,  0xe8df,
	0xe8e9,  0xe8f3,  0xe8fe,  0xe908,  0xe913,  0xe91d,  0xe927,  0xe932,  0xe93c,  0xe947,
	0xe951,  0xe95b,  0xe966,  0xe970,  0xe97a,  0xe985,  0xe98f,  0xe999,  0xe9a3,  0xe9ae,
	0xe9b8,  0xe9c2,  0xe9cc,  0xe9d7,  0xe9e1,  0xe9eb,  0xe9f5,  0xe9ff,  0xea0a,  0xea14,
	0xea1e,  0xea28,  0xea32,  0xea3c,  0xea47,  0xea51,  0xea5b,  0xea65,  0xea6f,  0xea79,
	0xea83,  0xea8d,  0xea97,  0xeaa1,  0xeaab,  0xeab6,  0xeac0,  0xeaca,  0xead4,  0xeade,
	0xeae8,  0xeaf2,  0xeafc,  0xeb06,  0xeb0f,  0xeb19,  0xeb23,  0xeb2d,  0xeb37,  0xeb41,
	0xeb4b,  0xeb55,  0xeb5f,  0xeb69,  0xeb73,  0xeb7c,  0xeb86,  0xeb90,  0xeb9a,  0xeba4,
	0xebae,  0xebb7,  0xebc1,  0xebcb,  0xebd5,  0xebdf,  0xebe8,  0xebf2,  0xebfc,  0xec06,
	0xec0f,  0xec19,  0xec23,  0xec2c,  0xec36,  0xec40,  0xec4a,  0xec53,  0xec5d,  0xec66,
	0xec70,  0xec7a,  0xec83,  0xec8d,  0xec97,  0xeca0,  0xecaa,  0xecb3,  0xecbd,  0xecc6,
	0xecd0,  0xecda,  0xece3,  0xeced,  0xecf6,  0xed00,  0xed09,  0xed13,  0xed1c,  0xed26,
	0xed2f,  0xed38,  0xed42,  0xed4b,  0xed55,  0xed5e,  0xed68,  0xed71,  0xed7a,  0xed84,
	0xed8d,  0xed97,  0xeda0,  0xeda9,  0xedb3,  0xedbc,  0xedc5,  0xedcf,  0xedd8,  0xede1,
	0xedea,  0xedf4,  0xedfd,  0xee06,  0xee0f,  0xee19,  0xee22,  0xee2b,  0xee34,  0xee3e,
	0xee47,  0xee50,  0xee59,  0xee62,  0xee6b,  0xee75,  0xee7e,  0xee87,  0xee90,  0xee99,
	0xeea2,  0xeeab,  0xeeb4,  0xeebd,  0xeec7,  0xeed0,  0xeed9,  0xeee2,  0xeeeb,  0xeef4,
	0xeefd,  0xef06,  0xef0f,  0xef18,  0xef21,  0xef2a,  0xef33,  0xef3c,  0xef45,  0xef4d,
	0xef56,  0xef5f,  0xef68,  0xef71,  0xef7a,  0xef83,  0xef8c,  0xef95,  0xef9d,  0xefa6,
	0xefaf,  0xefb8,  0xefc1,  0xefca,  0xefd2,  0xefdb,  0xefe4,  0xefed,  0xeff5,  0xeffe,
	0xf007,  0xf010,  0xf018,  0xf021,  0xf02a,  0xf033,  0xf03b,  0xf044,  0xf04d,  0xf055,
	0xf05e,  0xf067,  0xf06f,  0xf078,  0xf080,  0xf089,  0xf092,  0xf09a,  0xf0a3,  0xf0ab,
	0xf0b4,  0xf0bc,  0xf0c5,  0xf0ce,  0xf0d6,  0xf0df,  0xf0e7,  0xf0f0,  0xf0f8,  0xf101,
	0xf109,  0xf111,  0xf11a,  0xf122,  0xf12b,  0xf133,  0xf13c,  0xf144,  0xf14c,  0xf155,
	0xf15d,  0xf166,  0xf16e,  0xf176,  0xf17f,  0xf187,  0xf18f,  0xf198,  0xf1a0,  0xf1a8,
	0xf1b1,  0xf1b9,  0xf1c1,  0xf1c9,  0xf1d2,  0xf1da,  0xf1e2,  0xf1ea,  0xf1f3,  0xf1fb,
	0xf203,  0xf20b,  0xf213,  0xf21b,  0xf224,  0xf22c,  0xf234,  0xf23c,  0xf244,  0xf24c,
	0xf254,  0xf25d,  0xf265,  0xf26d,  0xf275,  0xf27d,  0xf285,  0xf28d,  0xf295,  0xf29d,
	0xf2a5,  0xf2ad,  0xf2b5,  0xf2bd,  0xf2c5,  0xf2cd,  0xf2d5,  0xf2dd,  0xf2e5,  0xf2ed,
	0xf2f5,  0xf2fd,  0xf304,  0xf30c,  0xf314,  0xf31c,  0xf324,  0xf32c,  0xf334,  0xf33c,
	0xf343,  0xf34b,  0xf353,  0xf35b,  0xf363,  0xf36a,  0xf372,  0xf37a,  0xf382,  0xf38a,
	0xf391,  0xf399,  0xf3a1,  0xf3a8,  0xf3b0,  0xf3b8,  0xf3c0,  0xf3c7,  0xf3cf,  0xf3d7,
	0xf3de,  0xf3e6,  0xf3ed,  0xf3f5,  0xf3fd,  0xf404,  0xf40c,  0xf413,  0xf41b,  0xf423,
	0xf42a,  0xf432,  0xf439,  0xf441,  0xf448,  0xf450,  0xf457,  0xf45f,  0xf466,  0xf46e,
	0xf475,  0xf47d,  0xf484,  0xf48c,  0xf493,  0xf49a,  0xf4a2,  0xf4a9,  0xf4b1,  0xf4b8,
	0xf4bf,  0xf4c7,  0xf4ce,  0xf4d5,  0xf4dd,  0xf4e4,  0xf4eb,  0xf4f3,  0xf4fa,  0xf501,
	0xf509,  0xf510,  0xf517,  0xf51e,  0xf526,  0xf52d,  0xf534,  0xf53b,  0xf543,  0xf54a,
	0xf551,  0xf558,  0xf55f,  0xf566,  0xf56e,  0xf575,  0xf57c,  0xf583,  0xf58a,  0xf591,
	0xf598,  0xf59f,  0xf5a6,  0xf5ae,  0xf5b5,  0xf5bc,  0xf5c3,  0xf5ca,  0xf5d1,  0xf5d8,
	0xf5df,  0xf5e6,  0xf5ed,  0xf5f4,  0xf5fb,  0xf602,  0xf609,  0xf610,  0xf616,  0xf61d,
	0xf624,  0xf62b,  0xf632,  0xf639,  0xf640,  0xf647,  0xf64e,  0xf654,  0xf65b,  0xf662,
	0xf669,  0xf670,  0xf677,  0xf67d,  0xf684,  0xf68b,  0xf692,  0xf698,  0xf69f,  0xf6a6,
	0xf6ad,  0xf6b3,  0xf6ba,  0xf6c1,  0xf6c7,  0xf6ce,  0xf6d5,  0xf6db,  0xf6e2,  0xf6e9,
	0xf6ef,  0xf6f6,  0xf6fd,  0xf703,  0xf70a,  0xf710,  0xf717,  0xf71e,  0xf724,  0xf72b,
	0xf731,  0xf738,  0xf73e,  0xf745,  0xf74b,  0xf752,  0xf758,  0xf75f,  0xf765,  0xf76c,
	0xf772,  0xf779,  0xf77f,  0xf785,  0xf78c,  0xf792,  0xf799,  0xf79f,  0xf7a5,  0xf7ac,
	0xf7b2,  0xf7b8,  0xf7bf,  0xf7c5,  0xf7cb,  0xf7d2,  0xf7d8,  0xf7de,  0xf7e5,  0xf7eb,
	0xf7f1,  0xf7f7,  0xf7fe,  0xf804,  0xf80a,  0xf810,  0xf816,  0xf81d,  0xf823,  0xf829,
	0xf82f,  0xf835,  0xf83b,  0xf842,  0xf848,  0xf84e,  0xf854,  0xf85a,  0xf860,  0xf866,
	0xf86c,  0xf872,  0xf878,  0xf87e,  0xf885,  0xf88b,  0xf891,  0xf897,  0xf89d,  0xf8a3,
	0xf8a9,  0xf8af,  0xf8b4,  0xf8ba,  0xf8c0,  0xf8c6,  0xf8cc,  0xf8d2,  0xf8d8,  0xf8de,
	0xf8e4,  0xf8ea,  0xf8f0,  0xf8f5,  0xf8fb,  0xf901,  0xf907,  0xf90d,  0xf913,  0xf918,
	0xf91e,  0xf924,  0xf92a,  0xf930,  0xf935,  0xf93b,  0xf941,  0xf946,  0xf94c,  0xf952,
	0xf958,  0xf95d,  0xf963,  0xf969,  0xf96e,  0xf974,  0xf97a,  0xf97f,  0xf985,  0xf98a,
	0xf990,  0xf996,  0xf99b,  0xf9a1,  0xf9a6,  0xf9ac,  0xf9b2,  0xf9b7,  0xf9bd,  0xf9c2,
	0xf9c8,  0xf9cd,  0xf9d3,  0xf9d8,  0xf9de,  0xf9e3,  0xf9e8,  0xf9ee,  0xf9f3,  0xf9f9,
	0xf9fe,  0xfa04,  0xfa09,  0xfa0e,  0xfa14,  0xfa19,  0xfa1f,  0xfa24,  0xfa29,  0xfa2f,
	0xfa34,  0xfa39,  0xfa3e,  0xfa44,  0xfa49,  0xfa4e,  0xfa54,  0xfa59,  0xfa5e,  0xfa63,
	0xfa69,  0xfa6e,  0xfa73,  0xfa78,  0xfa7d,  0xfa83,  0xfa88,  0xfa8d,  0xfa92,  0xfa97,
	0xfa9c,  0xfaa1,  0xfaa7,  0xfaac,  0xfab1,  0xfab6,  0xfabb,  0xfac0,  0xfac5,  0xfaca,
	0xfacf,  0xfad4,  0xfad9,  0xfade,  0xfae3,  0xfae8,  0xfaed,  0xfaf2,  0xfaf7,  0xfafc,
	0xfb01,  0xfb06,  0xfb0b,  0xfb10,  0xfb15,  0xfb1a,  0xfb1f,  0xfb23,  0xfb28,  0xfb2d,
	0xfb32,  0xfb37,  0xfb3c,  0xfb40,  0xfb45,  0xfb4a,  0xfb4f,  0xfb54,  0xfb58,  0xfb5d,
	0xfb62,  0xfb67,  0xfb6b,  0xfb70,  0xfb75,  0xfb7a,  0xfb7e,  0xfb83,  0xfb88,  0xfb8c,
	0xfb91,  0xfb96,  0xfb9a,  0xfb9f,  0xfba4,  0xfba8,  0xfbad,  0xfbb1,  0xfbb6,  0xfbbb,
	0xfbbf,  0xfbc4,  0xfbc8,  0xfbcd,  0xfbd1,  0xfbd6,  0xfbda,  0xfbdf,  0xfbe3,  0xfbe8,
	0xfbec,  0xfbf1,  0xfbf5,  0xfbfa,  0xfbfe,  0xfc02,  0xfc07,  0xfc0b,  0xfc10,  0xfc14,
	0xfc18,  0xfc1d,  0xfc21,  0xfc26,  0xfc2a,  0xfc2e,  0xfc33,  0xfc37,  0xfc3b,  0xfc3f,
	0xfc44,  0xfc48,  0xfc4c,  0xfc51,  0xfc55,  0xfc59,  0xfc5d,  0xfc61,  0xfc66,  0xfc6a,
	0xfc6e,  0xfc72,  0xfc76,  0xfc7b,  0xfc7f,  0xfc83,  0xfc87,  0xfc8b,  0xfc8f,  0xfc93,
	0xfc97,  0xfc9b,  0xfca0,  0xfca4,  0xfca8,  0xfcac,  0xfcb0,  0xfcb4,  0xfcb8,  0xfcbc,
	0xfcc0,  0xfcc4,  0xfcc8,  0xfccc,  0xfcd0,  0xfcd4,  0xfcd8,  0xfcdc,  0xfcdf,  0xfce3,
	0xfce7,  0xfceb,  0xfcef,  0xfcf3,  0xfcf7,  0xfcfb,  0xfcfe,  0xfd02,  0xfd06,  0xfd0a,
	0xfd0e,  0xfd12,  0xfd15,  0xfd19,  0xfd1d,  0xfd21,  0xfd24,  0xfd28,  0xfd2c,  0xfd30,
	0xfd33,  0xfd37,  0xfd3b,  0xfd3e,  0xfd42,  0xfd46,  0xfd49,  0xfd4d,  0xfd51,  0xfd54,
	0xfd58,  0xfd5b,  0xfd5f,  0xfd63,  0xfd66,  0xfd6a,  0xfd6d,  0xfd71,  0xfd74,  0xfd78,
	0xfd7c,  0xfd7f,  0xfd83,  0xfd86,  0xfd89,  0xfd8d,  0xfd90,  0xfd94,  0xfd97,  0xfd9b,
	0xfd9e,  0xfda2,  0xfda5,  0xfda8,  0xfdac,  0xfdaf,  0xfdb3,  0xfdb6,  0xfdb9,  0xfdbd,
	0xfdc0,  0xfdc3,  0xfdc7,  0xfdca,  0xfdcd,  0xfdd0,  0xfdd4,  0xfdd7,  0xfdda,  0xfddd,
	0xfde1,  0xfde4,  0xfde7,  0xfdea,  0xfdee,  0xfdf1,  0xfdf4,  0xfdf7,  0xfdfa,  0xfdfd,
	0xfe01,  0xfe04,  0xfe07,  0xfe0a,  0xfe0d,  0xfe10,  0xfe13,  0xfe16,  0xfe19,  0xfe1c,
	0xfe1f,  0xfe22,  0xfe25,  0xfe28,  0xfe2b,  0xfe2e,  0xfe31,  0xfe34,  0xfe37,  0xfe3a,
	0xfe3d,  0xfe40,  0xfe43,  0xfe46,  0xfe49,  0xfe4c,  0xfe4f,  0xfe52,  0xfe55,  0xfe57,
	0xfe5a,  0xfe5d,  0xfe60,  0xfe63,  0xfe66,  0xfe68,  0xfe6b,  0xfe6e,  0xfe71,  0xfe73,
	0xfe76,  0xfe79,  0xfe7c,  0xfe7e,  0xfe81,  0xfe84,  0xfe87,  0xfe89,  0xfe8c,  0xfe8f,
	0xfe91,  0xfe94,  0xfe97,  0xfe99,  0xfe9c,  0xfe9e,  0xfea1,  0xfea4,  0xfea6,  0xfea9,
	0xfeab,  0xfeae,  0xfeb0,  0xfeb3,  0xfeb5,  0xfeb8,  0xfeba,  0xfebd,  0xfebf,  0xfec2,
	0xfec4,  0xfec7,  0xfec9,  0xfecc,  0xfece,  0xfed1,  0xfed3,  0xfed5,  0xfed8,  0xfeda,
	0xfedd,  0xfedf,  0xfee1,  0xfee4,  0xfee6,  0xfee8,  0xfeeb,  0xfeed,  0xfeef,  0xfef1,
	0xfef4,  0xfef6,  0xfef8,  0xfefb,  0xfefd,  0xfeff,  0xff01,  0xff03,  0xff06,  0xff08,
	0xff0a,  0xff0c,  0xff0e,  0xff10,  0xff13,  0xff15,  0xff17,  0xff19,  0xff1b,  0xff1d,
	0xff1f,  0xff21,  0xff23,  0xff25,  0xff28,  0xff2a,  0xff2c,  0xff2e,  0xff30,  0xff32,
	0xff34,  0xff36,  0xff38,  0xff3a,  0xff3b,  0xff3d,  0xff3f,  0xff41,  0xff43,  0xff45,
	0xff47,  0xff49,  0xff4b,  0xff4d,  0xff4e,  0xff50,  0xff52,  0xff54,  0xff56,  0xff58,
	0xff59,  0xff5b,  0xff5d,  0xff5f,  0xff60,  0xff62,  0xff64,  0xff66,  0xff67,  0xff69,
	0xff6b,  0xff6c,  0xff6e,  0xff70,  0xff71,  0xff73,  0xff75,  0xff76,  0xff78,  0xff7a,
	0xff7b,  0xff7d,  0xff7e,  0xff80,  0xff82,  0xff83,  0xff85,  0xff86,  0xff88,  0xff89,
	0xff8b,  0xff8c,  0xff8e,  0xff8f,  0xff91,  0xff92,  0xff94,  0xff95,  0xff96,  0xff98,
	0xff99,  0xff9b,  0xff9c,  0xff9d,  0xff9f,  0xffa0,  0xffa2,  0xffa3,  0xffa4,  0xffa6,
	0xffa7,  0xffa8,  0xffa9,  0xffab,  0xffac,  0xffad,  0xffaf,  0xffb0,  0xffb1,  0xffb2,
	0xffb4,  0xffb5,  0xffb6,  0xffb7,  0xffb8,  0xffb9,  0xffbb,  0xffbc,  0xffbd,  0xffbe,
	0xffbf,  0xffc0,  0xffc1,  0xffc2,  0xffc4,  0xffc5,  0xffc6,  0xffc7,  0xffc8,  0xffc9,
	0xffca,  0xffcb,  0xffcc,  0xffcd,  0xffce,  0xffcf,  0xffd0,  0xffd1,  0xffd2,  0xffd3,
	0xffd4,  0xffd5,  0xffd5,  0xffd6,  0xffd7,  0xffd8,  0xffd9,  0xffda,  0xffdb,  0xffdc,
	0xffdc,  0xffdd,  0xffde,  0xffdf,  0xffe0,  0xffe0,  0xffe1,  0xffe2,  0xffe3,  0xffe3,
	0xffe4,  0xffe5,  0xffe6,  0xffe6,  0xffe7,  0xffe8,  0xffe8,  0xffe9,  0xffea,  0xffea,
	0xffeb,  0xffec,  0xffec,  0xffed,  0xffed,  0xffee,  0xffef,  0xffef,  0xfff0,  0xfff0,
	0xfff1,  0xfff1,  0xfff2,  0xfff2,  0xfff3,  0xfff3,  0xfff4,  0xfff4,  0xfff5,  0xfff5,
	0xfff6,  0xfff6,  0xfff7,  0xfff7,  0xfff7,  0xfff8,  0xfff8,  0xfff9,  0xfff9,  0xfff9,
	0xfffa,  0xfffa,  0xfffa,  0xfffb,  0xfffb,  0xfffb,  0xfffc,  0xfffc,  0xfffc,  0xfffc,
	0xfffd,  0xfffd,  0xfffd,  0xfffd,  0xfffe,  0xfffe,  0xfffe,  0xfffe,  0xfffe,  0xffff,
	0xffff,  0xffff,  0xffff,  0xffff,  0xffff,  0xffff,  0xffff,  0xffff,  0xffff,  0xffff,
	0xffff,  0x0000,  0x0000,  0x0000,  0x0000,  0x0000};
/* in actual sine / cosine functions, the last 5
 * values will be added with a int '1' */

/* FIXME: The coefficients could use a bit of cleanup */
/*----------------------------------------------------------------------
 * Function: ovl_util_sine()
 * Description: Helper function for filter coefficient programming
 *
 * Notes in Usage:
 *
 *----------------------------------------------------------------------*/
static int ovl_util_sine(int radiant_input)
{

	/*
	 * the radiant input parameter is a 32 signed number where the LSB
	 * 16 bits are the FP portion
	 */

	short sign = 0; /* 0 positive for and 1 for negative */
	int pi_half_count = 0;
	int pi_half = 0;
	int balance = 0;
	int answer = 0;

	/* lets rule that the input is a signed integer in which:
	 * the first 16 bits represent the integer
	 * the last 16 bits represent the floating point portion */

	/* first we have to normalize it to a positive number.*/
	if(radiant_input<0)
	{
		sign = 1;
		radiant_input = -radiant_input;
	}

	/* let's get pi/2 variable with 16 LSB FP just like this input data.*/
	pi_half = 0x3243f; /* = 3.141586 */
	pi_half += 0x1; /* for rounding off */
	pi_half = pi_half >> 1; /* divided by 2 */


	/* now we have to count how many pi/2 there are in this value
	 * (since pi/2 = 90' = one quarter sine wave from 0 to 1) */
	balance = radiant_input;
	while(balance >= pi_half)
	{
		balance = balance - pi_half;
		++pi_half_count;
	}

	/* using the pi_half_count, we can figure out how many 90 degrees.
	 * thru the sine wave we are looking at */
	pi_half_count = pi_half_count%4;

	/*
	 * balance is something between '0' and 'pi/2' - exactly what we need
	 * to use in the table however, this is 16 bits shifted and our table
	 * is a max of 12 bits - lets not forget to adjust but first we have to
	 * use the balance according to which 90' of the sine wave we are in
	 */

	/* now we get the actual sine value of excess that's less than a
	 * quarter pi if quart_count = 0, then answer is direct from table; */
	if(pi_half_count == 0){

		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */
		balance = balance << 13;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */
		balance = balance / pi_half;
		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}
		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}
	}

	/* if quart_count = 1, then formula is =
	 * answer = sin[(pi/2) - balance)] */
	else if(pi_half_count == 1){
		balance = pi_half - balance;

		balance = balance << 13;
		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */

		balance = balance / pi_half;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */

		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}

		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}
	}

	/*
	 * if quart_count = 2, then formula is = answer = the negative of the
	 * case it being 0;
	 */
	else if(pi_half_count == 2){

		balance = balance << 13;
		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */

		balance = balance / pi_half;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */

		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}

		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}
		answer = 0 - answer;
	}

	/*
	 * if quart_count = 3, then formula is = answer = the negative of the
	 * case it being 1;
	 */
	else if(pi_half_count == 3){
		balance = pi_half - balance;

		balance = balance << 13;
		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */

		balance = balance / pi_half;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */

		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}

		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}
		answer = 0 - answer;
	}

	if(sign==1) {
		answer = 0-answer;
	}

	return answer;
	/*
	 * so return value is a signed short where 16 MSBits are integer and
	 * 16 LSBits are FP
	 */
}

/*----------------------------------------------------------------------
 * Function: ovl_util_cosine()
 * Description: Helper function for filter coefficient programming
 *
 * Notes in Usage:
 *
 *----------------------------------------------------------------------*/
static int ovl_util_cosine(int radiant_input)
{
	/*
	 * the radiant input parameter is a 32 signed number where the LSB
	 * 16 bits are the FP portion
	 */

	short sign = 0; /* 0 positive for and 1 for negative */
	int pi_half_count = 0;
	int pi_half = 0;
	int balance = 0;
	int answer = 0;

	/* lets rule that the input is a signed integer in which:
	 * the first 16 bits represent the integer
	 * the last 16 bits represent the floating point portion */

	/* first we have to normalize it to a positive number.*/
	if(radiant_input<0) {
		sign = 1;
		radiant_input = -radiant_input;
	}

	/* let's get pi/2 variable with 16 LSB FP just like this input data.*/
	pi_half = 0x3243f; /* = 3.141586 */
	pi_half += 0x1; /* for rounding off */
	pi_half = pi_half >> 1; /* divided by 2 */


	/* now we have to count how many pi/2 there are in this value
	 * (since pi/2 = 90' = one quarter sine wave from 0 to 1) */
	balance = radiant_input;
	while(balance >= pi_half) {
		balance = balance - pi_half;
		++pi_half_count;
	}

	/* using the pi_half_count, we can figure out how many 90 degrees.
	 * thru the sine wave we are looking at */
	pi_half_count = pi_half_count%4;

	/*
	 * balance is something between '0' and 'pi/2' - exactly what we need
	 * to use in the table however, this is 16 bits shifted and our table
	 * is a max of 12 bits - lets not forget to adjust but first we have
	 * to use the balance according to which 90' of the sine wave we are in
	 */

	/* now we get the actual sine value of excess
	 * that's less than a quarter pi
	 * if quart_count = 0, then formula is = sine quarter # 1
	 * then formula is = answer = sin[(pi/2) - balance)] */
	if(pi_half_count == 0) {
		balance = pi_half - balance;

		balance = balance << 13;
		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */

		balance = balance / pi_half;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */

		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}

		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}
	}

	/* if quart_count = 1, then formula is = sine quarter # 2
	 * then formula is = answer = the negative of the case it being 0; */
	else if(pi_half_count == 1){

		balance = balance << 13;
		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */

		balance = balance / pi_half;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */

		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}

		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}

		answer = 0 - answer;
	}

	/*if quart_count = 2, then formula is = sine quarter # 3
	 * then formula is = answer = the negative of the case it being 1; */
	else if(pi_half_count == 2){
		balance = pi_half - balance;

		balance = balance << 13;
		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */

		balance = balance / pi_half;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */

		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}

		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}
		answer = 0 - answer;
	}

	/*if quart_count = 3, then formula is = sine quarter # 0
	 * now we get the actual sine value of excess that's
	 * less than a quarter pi then answer is direct from table;*/
	else if(pi_half_count == 3){

		balance = balance << 13;
		/* balance is now 16+13 = 29 fp portion BUT 20 bit numb */

		balance = balance / pi_half;
		/* balance is now 29 - 16 = 13 bit fp area BUT 14 bit numb */

		balance = balance + 1; /* for round up */
		balance = balance >> 1;
		/* now balance should be a 13 bit number but */
		/* bit 13 will never be '1' since balance was less than pi_half */

		if(balance>4095) {
			balance = 4095;
		}

		answer = wave_table[balance];
		if(balance>4090) {
			answer |= BIT16;
		}
	}

	if(sign==1) {
		answer = 0-answer;
	}

	return answer;
	/*
	 * so return value is a signed short where bit_16 = integer and 16
	 * LSBits are FP
	 */
}

/*----------------------------------------------------------------------
 * Function: ovl_set_coeff_reg()
 * Description: Helper function for filter coefficient programming
 *
 * Notes in Usage:
 *
 *----------------------------------------------------------------------*/
static unsigned int ovl_set_coeff_reg(
	int * fpint_Coeff,
	unsigned short wMantSize,
	unsigned short * pCoeff,
	unsigned short wPosition)
{

	/*
	 * fpint_Coeff is a pointer to signed int that follows
	 * MS 16 bits =integer, LS 16 bits =floating point for f.p. portion of
	 * scaling
	 */

	unsigned short wRes;
	unsigned short sign;
	int coeff;
	int maxVal;
	int wCoeff_exp3;
	int wCoeff_exp2;
	int wCoeff_exp1;
	int wCoeff_exp0;

	sign = 0;
	maxVal = 1 << wMantSize;
	coeff = *fpint_Coeff;
	if (coeff < 0) {
		sign = 1;
		coeff = - coeff;
	}

	wRes = 12 - wMantSize;

	wCoeff_exp3 = coeff * 4;
	wCoeff_exp2 = coeff * 2;
	wCoeff_exp1 = coeff;
	wCoeff_exp0 = coeff;
	wCoeff_exp0 += BIT0;
	wCoeff_exp0 = wCoeff_exp0 >> 1;

	wCoeff_exp3 = wCoeff_exp3 + (1 << (16 - wMantSize -1));
	/* round coeff to the nearest bit X */
	/* where X is the last MS bit that will
	 * be left out of the mantissa*/
	wCoeff_exp3 = wCoeff_exp3 >> (16 - wMantSize);
	/* now wCoeff is a unsigned short where */
	/* FP portion matched maxVal */

	wCoeff_exp2 = wCoeff_exp2 + (1 << (16 - wMantSize -1));
	/* round coeff to the nearest bit X */
	/* where X is the last MS bit that will
	 * be left out of the mantissa */

	wCoeff_exp2 = wCoeff_exp2 >> (16 - wMantSize);
	/* now wCoeff is a unsigned short where */
	/* FP portion matched maxVal */

	wCoeff_exp1 = wCoeff_exp1 + (1 << (16 - wMantSize -1));
	/* round coeff to the nearest bit X */
	/* where X is the last MS bit that will
	 * be left out of the mantissa */

	wCoeff_exp1 = wCoeff_exp1 >> (16 - wMantSize);
	/* now wCoeff is a unsigned short where */
	/* FP portion matched maxVal */

	wCoeff_exp0 = wCoeff_exp0 + (1 << (16 - wMantSize -1));
	/* round coeff to the nearest bit X */
	/* where X is the last MS bit that will
	 * be left out of the mantissa */

	wCoeff_exp0 = wCoeff_exp0 >> (16 - wMantSize);
	/* now wCoeff is a unsigned short where */
	/* FP portion matched maxVal */

	pCoeff[wPosition] = 0;

	if ( wCoeff_exp3 < maxVal ) {
		pCoeff[wPosition] |= (3 << 12);/*exponent */
		pCoeff[wPosition] |= (wCoeff_exp3 << wRes);/*mantissa*/

		*fpint_Coeff = wCoeff_exp3 << (16 - wMantSize);
		*fpint_Coeff += BIT1;
		*fpint_Coeff = *fpint_Coeff >> 2;
	} else if ( wCoeff_exp2 < maxVal ) {
		pCoeff[wPosition] |= (2 << 12);/*.exponent */
		pCoeff[wPosition] |= (wCoeff_exp2 << wRes);/*mantissa*/

		*fpint_Coeff = wCoeff_exp2 << (16 - wMantSize);
		*fpint_Coeff += BIT0;
		*fpint_Coeff = *fpint_Coeff >> 1;
	} else if ( wCoeff_exp1 < maxVal ) {
		pCoeff[wPosition] |= (1 << 12);/*.exponent */
		pCoeff[wPosition] |= (wCoeff_exp1 << wRes);/*mantissa*/

		*fpint_Coeff = wCoeff_exp1 << (16 - wMantSize);
	} else if ( wCoeff_exp0 < maxVal ) {
		pCoeff[wPosition] |= (wCoeff_exp0 << wRes);/*mantissa*/

		*fpint_Coeff = wCoeff_exp0 << (16 - wMantSize);
		*fpint_Coeff = *fpint_Coeff * 2;
	} else {
		return 0; /*Coeff out of range*/
	}

	if(sign) {
		pCoeff[wPosition] |= BIT15;/*sign */
	}

	if (sign) {
		*fpint_Coeff = -(*fpint_Coeff);
	}

	return 1;

}


/*----------------------------------------------------------------------
 * Function: ovl_update_coeff_regs()
 * Description: Helper function for filter coefficient programming
 *
 * Notes in Usage:
 *
 *----------------------------------------------------------------------*/
int ddCoeff[17][5];
unsigned short wTapAdjust[5];
void ovl_update_coeff_regs(
	unsigned short wTaps,
	int fpint_cutoff,
	unsigned short bHor,
	unsigned short bY,
	unsigned short * pCoeff)
{

	unsigned short i, j, j1, num, pos, wMantSize;
	unsigned short bVandC;

	int val, sinc, window, sum, x, y;
	int dCoeff[5*32];
	int dDiff;
   	unsigned short wTap2Fix;

	const int pi = 0x3243f; /* = 3.141586 << 16 */
				  /*+- 3.1415926535; */

	/* H Scale */
	if (bHor==1)
		wMantSize = 7;
	else
		wMantSize = 6;

	/*vertal & Chroma */
	if(bHor==0 && bY==0)
		bVandC = 1;
	else
		bVandC = 0;

	/*
	 * 1 - let's make this fixed point number smaller by 4 bits,
	 * since it will be a denominator later
	 */
	/* 2 - dont forget to round it at the 3rd bit */
	fpint_cutoff += BIT3;
	fpint_cutoff = fpint_cutoff >> 4; /* 16 bits of FP (reduced from 20) */

	num = wTaps * 16;
	for (i = 0; i < num*2; i++) {
		/* fpint cutoff is 16 bits */
		val = ((1 << 30)/fpint_cutoff);
		/*14 bits of FP (after dividing the fpint_cutoff */
		val += BIT3;
		val = val >> 4; /* val is now 10 bits of FP */
		val = val * wTaps * pi;
		/*now 26 bits of FP (increase from 10 after multiply pi)*/
		val += BIT5;
		val = val >> 6; /*20 bits of FP (reduced from 26 bits)*/
		val = val * (((i - num) << 8)/(2*num)); /*28 bits of FP now*/
		if(val<0) {
			val -= BIT11;
		} else {
			val += BIT11;
		}
		val = val >> 12; /* 16 bits of FP (reduced from 22 bits)*/

		if (val == 0) {
			sinc = (1 << 16); /*sinc = 1.0;*/
		} else {
			sinc = ovl_util_sine(val);
			/* dont forget val has 14 bits of FP to it */
			sinc = sinc << 12; /* sinc now has 28 bit FP */
			if(val<0) {
				val -= BIT3;
			} else {
				val += BIT3;
			}
			val = val >> 4; /* val now has 12 bit FP */
			sinc = sinc / val; /* the new sinc is back to 16 bit FP */
		}

		/* hanning window */
		window = (pi << 12)/num; /* 16 bits increased to 28 bits FP */
		window += BIT11;
		window = window >> 12;
		window = i * window;
		window = ovl_util_cosine(window);
		/* note cosine param is 16 bits FP to it */
		window += 1;
		window = window >> 1; /* divided by 2 */
		window = ((1 << 15) /*0.5*/ - window);

		if(window<0) {
			window -= BIT3;
		} else {
			window += BIT3;
		}
		window = window >> 4; /* now window is with 12 bit FP*/
		if(sinc<0) {
			sinc -= BIT3;
		} else {
			sinc += BIT3;
		}
		sinc = sinc >> 4; /* now sinc is with 12 bit FP */

		dCoeff[i] = sinc * window;
		/* dCoeff item is with 24 bit FP  --> lets reduce to 16*/
		if(dCoeff[i]<0) {
			dCoeff[i] -= BIT7;
		} else {
			dCoeff[i] += BIT7;
		}
		dCoeff[i] = dCoeff[i] >> 8;

	}

	for (i = 0; i < 17; i++) {
		/* normalize the coefficient */
		sum = 0;
		for (j = 0; j < wTaps; j++) {
			pos = i + j * 32;
			sum += dCoeff[pos];
			/* sum takes from dCeoff so it also has 16bit FP to it */
		}
		for (j = 0; j < wTaps; j++) {
			pos = i + j * 32;
			x = dCoeff[pos] << 11; /* x now has (16+11)=27 fp to it */
			y = sum;
			if(y<0)
				y -= BIT7;
			else
				y += BIT7;
			y = y >> 8; /* y now has (16-8)=8 fp to it */
			ddCoeff[i][j] = x/y; /* ddCoeff has 27-8 = 19 fp to it */
			if(ddCoeff[i][j] < 0)
				ddCoeff[i][j] -= BIT2;
			else
				ddCoeff[i][j] += BIT2;
			ddCoeff[i][j] = ddCoeff[i][j] >> 3;
			/*ddCoeff is back to 16 bit fp (19-3) */
		}

		/*
		 * set the coefficient registers and get the data in floating
		 * point format
		 */
        for (j = 0; j < wTaps; j++) {
			pos = j + i * wTaps;
			if ( (j == (wTaps - 1)/2) && (!bVandC) ) {
				ovl_set_coeff_reg(&ddCoeff[i][j],
					(unsigned short)(wMantSize + 2),pCoeff,pos);
			} else {
				ovl_set_coeff_reg(&ddCoeff[i][j],
					(unsigned short)wMantSize,pCoeff,pos);
			}
		}

		wTapAdjust[0] = (wTaps - 1)/2;
		for (j = 1, j1 = 1; j <= wTapAdjust[0]; j++, j1++) {
			wTapAdjust[j1] = wTapAdjust[0] - j;
			wTapAdjust[++j1] = wTapAdjust[0] + j;
		}

		/* adjust the coefficient */
		sum = 0;
		for (j = 0; j < wTaps; j++) {
			sum += ddCoeff[i][j]; /*sum is now 16 bit fp to it*/
		}

		if (sum != (1 << 16)) {
			/* if sum != 1.0 */
			for (j1 = 0; j1 < wTaps; j1++) {
				wTap2Fix = wTapAdjust[j1];
				dDiff = (1 << 16) - sum; /*dDiff is also 16 bit FP to it*/
				ddCoeff[i][wTap2Fix] += dDiff;
				pos = wTap2Fix + i * wTaps;
				if ( (wTap2Fix == (wTaps - 1)/2) && (!bVandC) ) {
					ovl_set_coeff_reg(&ddCoeff[i][wTap2Fix],
						(unsigned short)(wMantSize + 2),pCoeff,pos);
				} else {
					ovl_set_coeff_reg(&ddCoeff[i][wTap2Fix],
						(unsigned short)wMantSize,pCoeff,pos);
				}
				sum = 0;
				for (j = 0; j < wTaps; j++) {
					sum += ddCoeff[i][j]; /*sum is now 16 bit FP to it*/
				}
				if (sum == (1 << 16 )) {
					break;
				}
			}
		}
	}
}
