/**********************************************************************
 * Copyright (c) 2011, Intel Corporation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 ******************************************************************************/

#ifndef _EMGDHMI_2FB_H
#define _EMGDHMI_2FB_H

#include "drm_emgd_private.h"
#include "img_defs.h"
#include "servicesext.h"
#include "kerneldisplay.h"
#include "emgd_dc.h"

int emgdhmi_set_ovl_planes(igd_display_context_t *ctx, int screen,
			   igd_buffer_config_t buf_cfg[3]);

void emgdhmi_vsync(int screen);

void emgdhmi_set_framebuffer(int owner, emgddc_buffer_t *buf, int sync,
                             PVRSRV_DC_DISP2SRV_KMJTABLE *funcs,
                             IMG_HANDLE cmd_cookie_h);

int emgdhmi_wait_flips(void);

void emgdhmi_set_buf_cfg(igd_display_context_t *pri, igd_display_context_t *sec,
			 igd_buffer_config_t bc[2][3]);

int emgdhmi_secondary_vblank(void* pdevinfo);

int emgdhmi_mode(void);

void emgdhmi_enable(void);

void emgdhmi_set_active(void);

void emgdhmi_enable_secondary(void);

#endif /* _EMGDHMI_2FB_H */
