Summary: Tools needed to create Texinfo format documentation files
Name: texinfo
Version: 4.8
Release: 15.1
License: GPL
Group: Applications/Publishing
Url: http://www.gnu.org/software/texinfo/
Source0: ftp://ftp.gnu.org/gnu/texinfo/texinfo-%{version}.tar.bz2
Source1: info-dir
Source2: texi2pdf.man
Patch0: texinfo-4.8-zlib.patch
Patch1: texinfo-4.8-texindex.patch
Patch2: texinfo-4.8-0xA0.patch
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Buildroot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: zlib-devel, ncurses-devel

# Redefine this so "dir" in the info directory isn't compressed

%define __spec_install_post %{?__debug_package:%{__debug_install_post}} /usr/lib/rpm/brp-strip \; /usr/lib/rpm/brp-strip-comment-note \; rm -f

%description
Texinfo is a documentation system that can produce both online
information and printed output from a single source file. The GNU
Project uses the Texinfo file format for most of its documentation.

Install texinfo if you want a documentation system for producing both
online and print documentation from the same source file and/or if you
are going to write documentation for the GNU Project.

%package -n info
Summary: A stand-alone TTY-based reader for GNU texinfo documentation
Group: System Environment/Base
# By making info prereq bash, other packages which have triggers based on
# info don't run those triggers until bash is in place as well. This is an
# ugly method of doing it (triggers which fire on set intersection would
# be better), but it's the best we can do for now. Talk to Erik before
# removing this.
Prereq: bash

%description -n info
The GNU project uses the texinfo file format for much of its
documentation. The info package provides a standalone TTY-based
browser program for viewing texinfo files.

%package tex
Summary: Tools for fromating Texinfo documentation files using TeX
Group: Applications/Publishing
Requires: texinfo = %{version}-%{release}
Requires: tetex

%description tex
Texinfo is a documentation system that can produce both online
information and printed output from a single source file. The GNU
Project uses the Texinfo file format for most of its documentation.

The texinfo-tex package provides tools to format Texinfo documents
for printing using TeX.

%prep
%setup -q
%patch0 -p1 -b .zlib
%patch1 -p1 -b .texindex
%patch2 -p1 -b .0xA0

%build

%configure
make %{?_smp_mflags}

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/sbin

make install DESTDIR=$RPM_BUILD_ROOT

pushd ${RPM_BUILD_ROOT}
  install -m644 %{SOURCE2} .%{_mandir}/man1/texi2pdf.1
  gzip -n -9f .%{_infodir}/*info*
  gzip -n -9f .%{_mandir}/*/*
  install -m644 %{SOURCE1} .%{_infodir}/dir
  mv -f .%{_bindir}/install-info ./sbin
popd

rm -f $RPM_BUILD_ROOT%{_datadir}/texinfo/texinfo.{xsl,dtd}

%find_lang %name

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
/sbin/install-info %{_infodir}/texinfo.gz %{_infodir}/dir || :

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/texinfo.gz %{_infodir}/dir || :
fi

%post -n info
/sbin/install-info %{_infodir}/info-stnd.info.gz %{_infodir}/dir || :

%preun -n info
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/info-stnd.info.gz %{_infodir}/dir \
	|| :
fi

%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS ChangeLog INTRODUCTION NEWS README TODO
%{_bindir}/makeinfo
%{_datadir}/texinfo
%{_infodir}/texinfo*
%{_mandir}/man1/makeinfo.1*
%{_mandir}/man5/texinfo.5*

%files -n info
%defattr(-,root,root)
%config(noreplace) %verify(not md5 size mtime) %{_infodir}/dir
%doc COPYING
%{_bindir}/info
%{_bindir}/infokey
%{_infodir}/info.info*
%{_infodir}/info-stnd.info*
/sbin/install-info
%{_mandir}/man1/info.1*
%{_mandir}/man1/infokey.1*
%{_mandir}/man1/install-info.1*
%{_mandir}/man5/info.5*

%files tex
%defattr(-,root,root)
%{_bindir}/texindex
%{_bindir}/texi2dvi
%{_bindir}/texi2pdf
%{_mandir}/man1/texindex.1*
%{_mandir}/man1/texi2dvi.1*
%{_mandir}/man1/texi2pdf.1*

%changelog
* Mon Dec  4 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-15
- Don't replace 0xA0 by a space in makeinfo
  Related: #208511
- Fix some rpmlint warnings

* Sun Nov  5 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-14
- Remove off-line sorting from texindex (fixes CVE 2006-4810)

* Mon Oct  9 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-13
- Don't use mode 0666 for the texindex temporary files

* Mon Oct  9 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-12
- Don't leave around temporary files used by texindex
- Add missing error handling to texinfo-CAN-2005-3011.patch

* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 4.8-11.1
- rebuild

* Sat Mar 25 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-11
- Split texinfo-tex from the texinfo package (#178406)
- Ship COPYING, don't ship INSTALL

* Sun Mar 19 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-10
- Remove incorrect Prefix:
- Drop info/README
- Convert change log to UTF-8

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 4.8-9.2
- bump again for double-long bug on ppc(64)

* Tue Feb 07 2006 Jesse Keating <jkeating@redhat.com> - 4.8-9.1
- rebuilt for new gcc4.1 snapshot and glibc changes

* Mon Jan 16 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-9
- Fix handling of bzip2'ed files (#128637)

* Mon Jan 16 2006 Miloslav Trmac <mitr@redhat.com> - 4.8-8
- Ignore scriptlet failures with --excludedocs (#166958)
- Don't link texindex to zlib, don't pretend to link to zlib statically

* Fri Dec 09 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt

* Fri Oct 14 2005 Tim Waugh <twaugh@redhat.com> 4.8-7
- Apply patch to fix CAN-2005-3011 (bug #169585).

* Thu Jun  9 2005 Tim Waugh <twaugh@redhat.com> 4.8-6
- Ship texi2pdf man page, taken from tetex-2.0.2 RPM.

* Tue Jun  7 2005 Tim Waugh <twaugh@redhat.com> 4.8-5
- Ship texi2pdf (bug #147271).

* Mon Mar 14 2005 Tim Waugh <twaugh@redhat.com> 4.8-4
- Requires tetex (bug #151075).

* Wed Mar  2 2005 Tim Waugh <twaugh@redhat.com> 4.8-3
- Rebuild for new GCC.

* Mon Feb  7 2005 Tim Waugh <twaugh@redhat.com> 4.8-2
- Don't ship texi2pdf (bug #147271).

* Thu Feb  3 2005 Tim Waugh <twaugh@redhat.com> 4.8-1
- 4.8.

* Thu Dec 30 2004 Tim Waugh <twaugh@redhat.com> 4.7-6
- Fixed URL (bug #143729).

* Thu Aug 12 2004 Tim Waugh <twaugh@redhat.com> 4.7-5
- Rebuilt.

* Wed Jul  7 2004 Tim Waugh <twaugh@redhat.com> 4.7-4
- Build for FC2.

* Tue Jun 29 2004 Tim Waugh <twaugh@redhat.com> 4.7-3
- Fix grouping in user-defined macros.

* Mon Jun 28 2004 Tim Waugh <twaugh@redhat.com> 4.7-2
- Build requires ncurses-devel (bug #126600).

* Fri Jun 25 2004 Tim Waugh <twaugh@redhat.com> 4.7-1
- 4.7.

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar  2 2004 Tim Waugh <twaugh@redhat.com>
- Fixed compiler warning (bug #117097).

* Sat Feb 21 2004 Tim Waugh <twaugh@redhat.com> 4.6-3
- Build requires zlib-devel (bug #116436).

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Dec  2 2003 Tim Waugh <twaugh@redhat.com> 4.6-1
- Fixed compiler warning (bug #111279).
- 4.6.

* Tue Jun 17 2003 Tim Waugh <twaugh@redhat.com> 4.5-3
- Rebuilt.

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue May  6 2003 Tim Waugh <twaugh@redhat.com>
- No longer need 3.12h-fix patch.

* Tue Apr 29 2003 Tim Waugh <twaugh@redhat.com> 4.5-1
- 4.5 (bug #88428).  Update zlib patch.
- Add URL tag (bug #54613).

* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 4.3-5
- rebuilt

* Tue Jan  7 2003 Tim Waugh <twaugh@redhat.com> 4.3-4
- Fix up spec_install_post to strip debug info out to separate package
  (bug #81226).

* Thu Dec 26 2002 Florian La Roche <Florian.LaRoche@redhat.de> 4.3-3
- Make /usr/share/info/dir a real file and remove /etc/info-dir, that
  file should be unused for a long time.

* Thu Nov 21 2002 Elliot Lee <sopwith@redhat.com> 4.3-2
- Don't strip files here (rpm takes care of it)
- Use pushd/popd instead of enclosing things in (), to make
  error detection easier
- Use _smp_mflags

* Tue Nov 19 2002 Tim Waugh <twaugh@redhat.com> 4.3-1
- 4.3.
- No longer need fileextension or malloccheck patches.
- Update zlib patch.

* Wed Oct 23 2002 Tim Waugh <twaugh@redhat.com> 4.2-6
- Don't install files not packaged.
- Fix file list (bug #55816).

* Mon Sep  2 2002 Bernhard Rosenkraenzer <bero@redhat.com> 4.2-5
- Fix crash w/ MALLOC_CHECK_ == 2 (#72831)

* Tue Jul  2 2002 Bernhard Rosenkraenzer <bero@redhat.com> 4.2-4
- Add infokey (#67728)

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Apr 23 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- 4.2

* Tue Mar  5 2002 Bernhard Rosenkraenzer <bero@redhat.com> 4.1-1
- 4.1 (#60714)

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Aug  7 2001 Bernhard Rosenkraenzer <bero@redhat.com> 4.0b-3
- Don't create the desktop file - we don't install it anyway.

* Sat Jul 21 2001 Tim Powers <timp@redhat.com>
- remove the info viewer from the menus, it's cluttering things

* Wed May 09 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- 4.0b

* Tue Apr 24 2001 Bernhard Rosenkraenzer <bero@redhat.com> 4.0a-1
- Update to 4.0a, the patch looks sane

* Fri Feb 23 2001 Trond Eivind Glomsrød <teg@redhat.com>
- langify
- don't create desktop file in spec file

* Tue Jan 23 2001 Preston Brown <pbrown@redhat.com>
- danish translation added

* Tue Dec 12 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Rebuild to get rid of 0777 dirs

* Wed Nov  8 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix recognition of .?o extensions in texi2dvi, Bug #20498

* Thu Sep  7 2000 Jeff Johnson <jbj@redhat.com>
- FHS packaging (64bit systems need to use %%_libdir not /usr/lib).

* Sat Aug 19 2000 Trond Eivind Glomsrød <teg@redhat.com>
- really do it - #16120

* Mon Aug 14 2000 Helge Deller <hdeller@redhat.com>
- gzip man-pages, #16120

* Mon Aug  7 2000 Tim Waugh <twaugh@redhat.com>
- List man-pages in %%files.

* Fri Aug  4 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Add Swedish and German translations to desktop file, Bug #15366

* Thu Aug  3 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- mark /etc/info-dir %%verify(not md5 size mime), Bug #14826

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Wed Jun 28 2000 Bill Nottingham <notting@redhat.com>
- fix build wackiness with info page compressing

* Fri Jun 16 2000 Bill Nottingham <notting@redhat.com>
- fix info-dir symlink

* Thu May 18 2000 Preston Brown <pbrown@redhat.com>
- use FHS paths for info.

* Fri Mar 24 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- rebuild with current ncurses

* Wed Feb 09 2000 Preston Brown <pbrown@redhat.com>
- wmconfig -> desktop

* Wed Feb 02 2000 Cristian Gafton <gafton@redhat.com>
- fix descriptions

* Wed Jan 26 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- move info-stnd.info* to the info package, /sbin/install-info it
  in %%post (Bug #6632)

* Thu Jan 13 2000 Jeff Johnson <jbj@redhat.com>
- recompile to eliminate ncurses foul-up.

* Tue Nov  9 1999 Bernhard Rosenkränzer <bero@redhat.com>
- 4.0
- handle RPM_OPT_FLAGS

* Tue Sep 07 1999 Cristian Gafton <gafton@redhat.com>
- import version 3.12h into 6.1 tree from HJLu

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 4)

* Wed Mar 17 1999 Erik Troan <ewt@redhat.com>
- hacked to use zlib to get rid of the requirement on gzip

* Wed Mar 17 1999 Matt Wilson <msw@redhat.com>
- install-info prerequires gzip

* Thu Mar 11 1999 Cristian Gafton <gafton@redhat.com>
- version 3.12f
- make /usr/info/dir to be a %%config(noreplace)
* Wed Nov 25 1998 Jeff Johnson <jbj@redhat.com>
- rebuild to fix docdir perms.

* Thu Sep 24 1998 Cristian Gafton <gafton@redhat.com>
- fix allocation problems in install-info

* Wed Sep 23 1998 Jeff Johnson <jbj@redhat.com>
- /sbin/install-info should not depend on /usr/lib/libz.so.1 -- statically
  link with /usr/lib/libz.a.

* Fri Aug 07 1998 Erik Troan <ewt@redhat.com>
- added a prereq of bash to the info package -- see the comment for a
  description of why that was done

* Tue Jun 09 1998 Prospector System <bugs@redhat.com>
- translations modified for de

* Tue Jun  9 1998 Jeff Johnson <jbj@redhat.com>
- add %%attr to permit non-root build.

* Thu May 07 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Sun Apr 12 1998 Cristian Gafton <gafton@redhat.com>
- added %%clean
- manhattan build

* Wed Mar 04 1998 Cristian Gafton <gafton@redhat.com>
- upgraded to version 3.12
- added buildroot

* Sun Nov 09 1997 Donnie Barnes <djb@redhat.com>
- moved /usr/info/dir to /etc/info-dir and made /usr/info/dir a
  symlink to /etc/info-dir.

* Wed Oct 29 1997 Donnie Barnes <djb@redhat.com>
- added wmconfig entry for info

* Wed Oct 01 1997 Donnie Barnes <djb@redhat.com>
- stripped /sbin/install-info

* Mon Sep 22 1997 Erik Troan <ewt@redhat.com>
- added info-dir to filelist

* Sun Sep 14 1997 Erik Troan <ewt@redhat.com>
- added patch from sopwith to let install-info understand gzip'ed info files
- use skeletal dir file from texinfo tarball (w/ bash entry to reduce
  dependency chain) instead (and install-info command everywhere else)
- patches install-info to handle .gz names correctly

* Tue Jun 03 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Tue Feb 25 1997 Erik Troan <ewt@redhat.com>
- patched install-info.c for glibc.
- added /usr/bin/install-info to the filelist

* Tue Feb 18 1997 Michael Fulbright <msf@redhat.com>
- upgraded to version 3.9.
