# run internal testsuite?
%bcond_without check

%define rpmhome /usr/lib/rpm

Summary: The RPM package management system
Name: rpm
Version: 4.8.1
Release: 6.2
Source0: http://rpm.org/releases/rpm-4.8.x/rpm-%{version}.tar.bz2
Group: System/Base
Url: http://www.rpm.org/

Patch0: 0001-Eliminate-leftover-checks-for-Berkeley-DB-4.3-compat.patch
Patch1: 0002-Enable-dbenv-failchk-functionality-on-BDB-5.0-too.patch
Patch2: rpm-4.7.90-devel-autodep.patch
Patch3: rpm-4.5.90-pkgconfig-path.patch
Patch4: rpm-4.5.90-gstreamer-provides.patch
Patch5: rpm-4.8.0-tilde.patch
Patch6: rpm-macros.patch
Patch7: rpm-4.8.1-meego-arm.patch
Patch8: fix-perl-epoch.patch

# Partially GPL/LGPL dual-licensed and some bits with BSD
# SourceLicense: (GPLv2+ and LGPLv2+ with exceptions) and BSD 
License: GPLv2+
##PYTHON##

Requires: curl
Requires: coreutils
Requires: db4-utils
BuildRequires: db4-devel

# XXX generally assumed to be installed but make it explicit as rpm
# is a bit special...
BuildRequires: meego-rpm-config
BuildRequires: gawk
BuildRequires: elfutils-devel >= 0.112
BuildRequires: elfutils-libelf-devel
BuildRequires: readline-devel zlib-devel
BuildRequires: nss-devel
# The popt version here just documents an older known-good version
BuildRequires: popt-devel >= 1.10.2
BuildRequires: file-devel
BuildRequires: gettext-devel
BuildRequires: cvs
BuildRequires: ncurses-devel
BuildRequires: bzip2-devel >= 0.9.0c-2
BuildRequires: lua-devel >= 5.1
BuildRequires: libcap-devel
BuildRequires: xz-devel >= 4.999.8

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
The RPM Package Manager (RPM) is a powerful command line driven
package management system capable of installing, uninstalling,
verifying, querying, and updating software packages. Each software
package consists of an archive of files along with information about
the package like its version, a description, etc.

%package libs
Summary:  Libraries for manipulating RPM packages
Group: Development/Libraries
License: GPLv2+ and LGPLv2+ with exceptions
Requires: rpm = %{version}-%{release}

%description libs
This package contains the RPM shared libraries.

%package devel
Summary:  Development files for manipulating RPM packages
Group: Development/Libraries
License: GPLv2+ and LGPLv2+ with exceptions
Requires: rpm = %{version}-%{release}
Requires: file-devel

%description devel
This package contains the RPM C library and header files. These
development files will simplify the process of writing programs that
manipulate RPM packages and databases. These files are intended to
simplify the process of creating graphical package managers or any
other tools that need an intimate knowledge of RPM packages in order
to function.

This package should be installed if you want to develop programs that
will manipulate RPM packages and databases.

%package build
Summary: Scripts and executable programs used to build packages
Group: Development/Tools
Requires: rpm = %{version}-%{release}
Requires: elfutils >= 0.128 binutils
Requires: findutils sed grep gawk diffutils file patch >= 2.5
Requires: unzip gzip bzip2 cpio lzma xz
Requires: pkgconfig

%description build
The rpm-build package contains the scripts and executable programs
that are used to build packages using the RPM Package Manager.


%package apidocs
Summary: API documentation for RPM libraries
Group: Documentation
BuildArch: noarch

%description apidocs
This package contains API documentation for developing applications
that will manipulate RPM packages and databases.

%prep
%setup -q  -n rpm-%{version}
%patch0 -p1 
%patch1 -p1
%patch2 -p1 -b .devel-autodep
%patch3 -p1 -b .pkgconfig-path
%patch4 -p1 -b .gstreamer-prov
%patch5 -p1 -b .tilde
%patch6 -p1 -b .vendor
%patch7 -p1 -b .arm
%patch8 -p1 -b .epoch

%build
CPPFLAGS="$CPPFLAGS `pkg-config --cflags nss`"
CFLAGS="$RPM_OPT_FLAGS"
export CPPFLAGS CFLAGS LDFLAGS

# Using configure macro has some unwanted side-effects on rpm platform
# setup, use the old-fashioned way for now only defining minimal paths.
autoreconf -i -f

./configure \
    --prefix=%{_usr} \
    --sysconfdir=%{_sysconfdir} \
    --localstatedir=%{_var} \
    --sharedstatedir=%{_var}/lib \
    --libdir=%{_libdir} \
    --with-external-db \
%if %{with python}
    --enable-python \
%endif
    --with-lua \
    --with-cap  

make %{?jobs:-j%jobs}

%install
rm -rf $RPM_BUILD_ROOT

%make_install

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/rpm
mkdir -p $RPM_BUILD_ROOT/var/lib/rpm
for dbi in \
    Basenames Conflictname Dirnames Group Installtid Name Packages \
    Providename Provideversion Requirename Requireversion Triggername \
    Filedigests Pubkeys Sha1header Sigmd5 Obsoletename \
    __db.001 __db.002 __db.003 __db.004 __db.005 __db.006 __db.007 \
    __db.008 __db.009
do
    touch $RPM_BUILD_ROOT/var/lib/rpm/$dbi
done


%find_lang %{name}
# avoid dragging in tonne of perl libs for an unused script
chmod 0644 $RPM_BUILD_ROOT/%{rpmhome}/perldeps.pl

# compress our ChangeLog, it's fairly big...
bzip2 -9 ChangeLog

%clean
rm -rf $RPM_BUILD_ROOT

%if %{with check}
%check
make check
%endif

%post libs -p /sbin/ldconfig
%postun libs -p /sbin/ldconfig

%posttrans
# XXX this is klunky and ugly, rpm itself should handle this
dbstat=/usr/lib/rpm/rpmdb_stat
if [ -x "$dbstat" ]; then
    if "$dbstat" -e -h /var/lib/rpm 2>&1 | grep -q "doesn't match environment version \| Invalid argument"; then
        rm -f /var/lib/rpm/__db.* 
    fi
fi
exit 0

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc GROUPS COPYING CREDITS 

%dir %{_sysconfdir}/rpm

%attr(0755, root, root)   %dir /var/lib/rpm
%attr(0644, root, root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/lib/rpm/*
%attr(0755, root, root) %dir %{rpmhome}

/bin/rpm
%{_bindir}/rpm2cpio
%{_bindir}/rpmdb
%{_bindir}/rpmsign
%{_bindir}/rpmquery
%{_bindir}/rpmverify

%doc %{_mandir}/man8/rpm.8*
%doc %{_mandir}/man8/rpm2cpio.8*

# XXX this places translated manuals to wrong package wrt eg rpmbuild
%lang(fr) %{_mandir}/fr/man[18]/*.[18]*
%lang(ko) %{_mandir}/ko/man[18]/*.[18]*
%lang(ja) %{_mandir}/ja/man[18]/*.[18]*
%lang(pl) %{_mandir}/pl/man[18]/*.[18]*
%lang(ru) %{_mandir}/ru/man[18]/*.[18]*
%lang(sk) %{_mandir}/sk/man[18]/*.[18]*

%{rpmhome}/macros
%{rpmhome}/rpmpopt*
%{rpmhome}/rpmrc

%{rpmhome}/rpmdb_*
%{rpmhome}/rpm.daily
%{rpmhome}/rpm.log
%{rpmhome}/rpm.xinetd
%{rpmhome}/rpm2cpio.sh
%{rpmhome}/tgpg

%{rpmhome}/platform

%files libs
%defattr(-,root,root)
%{_libdir}/librpm*.so.*

%files build
%defattr(-,root,root)
%{_bindir}/rpmbuild
%{_bindir}/gendiff

%{_mandir}/man1/gendiff.1*

%{rpmhome}/brp-*
%{rpmhome}/check-buildroot
%{rpmhome}/check-files
%{rpmhome}/check-prereqs
%{rpmhome}/check-rpaths*
%{rpmhome}/debugedit
%{rpmhome}/find-debuginfo.sh
%{rpmhome}/find-lang.sh
%{rpmhome}/find-provides
%{rpmhome}/find-requires
%{rpmhome}/javadeps
%{rpmhome}/mono-find-provides
%{rpmhome}/mono-find-requires
%{rpmhome}/ocaml-find-provides.sh
%{rpmhome}/ocaml-find-requires.sh
%{rpmhome}/osgideps.pl
%{rpmhome}/perldeps.pl
%{rpmhome}/libtooldeps.sh
%{rpmhome}/pkgconfigdeps.sh
%{rpmhome}/perl.prov
%{rpmhome}/perl.req
%{rpmhome}/tcl.req
%{rpmhome}/pythondeps.sh
%{rpmhome}/rpmdeps
%{rpmhome}/config.guess
%{rpmhome}/config.sub
%{rpmhome}/mkinstalldirs
%{rpmhome}/rpmdiff*
%{rpmhome}/desktop-file.prov
%{rpmhome}/fontconfig.prov

%{rpmhome}/macros.perl
%{rpmhome}/macros.python
%{rpmhome}/macros.php

%{_mandir}/man8/rpmbuild.8*
%{_mandir}/man8/rpmdeps.8*


%files devel
%defattr(-,root,root)
%{_includedir}/rpm
%{_libdir}/librp*[a-z].so
%{_mandir}/man8/rpmgraph.8*
%{_bindir}/rpmgraph
%{_libdir}/pkgconfig/rpm.pc

%files apidocs
%defattr(-,root,root)
%doc doc/librpm/html/*

%changelog
* Thu Mar 10 2011 Anas Nashif <anas.nashif@intel.com> - 4.8.1
- Remove MSSF patches for now
* Fri Feb 25 2011 Ilhan Gurel <ilhan.gurel@nokia.com> - 4.8.1
- Apply MSSF patches
- Fixes for Coverity defects
* Fri Feb  4 2011 Anas Nashif <anas.nashif@intel.com> - 4.8.1
- Apply to upstream patches on top of 4.8.1:
  - Enable dbenv->failchk() functionality on BDB >= 5.0 too
  - Eliminate leftover checks for Berkeley DB < 4.3 compatibility
* Mon Jan 24 2011 Carsten Munk <carsten@maemo.org>
- Merge arch.patch and armv7nhl-armv7hl patch.
- Add thumb subarch support, BMC#12622
* Thu Jan 20 2011 Anas Nashif <anas.nashif@intel.com> - 4.8.1
- [FEA] RPM plug-in support (FEA #9095)
- Partly implements FEA #9097: Package labeling
- Add and enable MSSF support
* Tue Jan 11 2011 Carsten Munk <carsten@maemo.org> - 4.8.1
- armv7hl patch didn't contain %%arm addition in macros
  and installplatform.in changes for some reason. BMC#11429
* Mon Jan 10 2011 Anas Nashif <anas.nashif@intel.com> - 4.8.1
- Fixed bmc #5546: include rpm.spec in rpm-python
* Fri Dec 17 2010 Carsten Munk <carsten@maemo.org> - 4.8.1
- Added armv7hl and armv7nhl architectures, fixing BMC#11428
- Remove project.diff
* Fri Jul  2 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.1
- Removed unused BuildRequires and macros
- removed old requirement on moblin-rpm-config in python spec file
* Sun Jun 20 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.1
- Update to 4.8.1
  Security:
  * Remove SUID/SGID bits from hardlinked executables on upgrade too
    (CVE-2010-2059, RhBug:598775) [1]
  * Remove POSIX capabilities from hardlinked executables on upgrade and
    erase (CVE-2010-2059?, RhBug:598775)
  General bugfixes and enhancements:
  * Fix "empty reply from server" curl-syndrome with URL retrieval,
    regression introduced in 4.6.0 (RhBug:598988)
  * Fix transaction hanging on unrelated filesystems (RhBug:547548)
  * Fix crash on URL retrieve to read-only location on install (RhBug:557118)
  * Fix verification error code not to depend on verbosity
    level (RhBug:557101)
  * Fix return from chroot() on verify (RhBug:590588)
  * Permit DOS-style line-endings in PGP ASCII armors (RhBug:532992)
  * Fix :pgpsig header format extension sometimes showing numbers for
    known hash types (RhBug:587755)
  * Fix :deptype header format extension failing to show some flag
    combinations
  * Fix error message on package conflicts against installed packages
  * Fix erased packages causing misleading disk-space checking
    messages (RhBug:561160)
  * Document --conflicts option in manpage (ticket #126)
  Package building:
  * Fix %%defattr(-) syntax, regression introduced in  (SuseBug:594310)
  * Fix spec parser eating empty lines in %%prep section, regression
    introduced in 4.6.0 (RhBug:573339)
  * Fix NOSOURCE/NOPATCH tag generation of nosrc packages, regression
    introduced in 4.6.0
  * Fix crash in the spec parser (RhBug:597835, SuseBug:582599)
  * Fix copying of translated tags into source rpms (RhBug:578299)
  * Only extract dependencies from .desktop files with Type=Application
    and Exec= entries (ticket #150)
  * Work around GNU tar debug output breaking rpmbuild -t (SuseBug:558475)
* Tue Apr  6 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.0
- Do not use %%configure which replaces all variables in the platform
  macros (BMC#507)
* Fri Mar 26 2010 Arjan van de Ven <arjan@linux.intel.com> - 4.8.0
- fix the perl dep script to deal with an epoch-less perl
* Thu Mar  4 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.0
- Detect MeeGo release, set MeeGo as vendor
* Fri Feb  5 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.0
- Fixed python module build
* Fri Feb  5 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.0
- Fixed python module build
* Thu Jan 28 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.0
- Update to 4.8.0 final
- Remove obsolete patches
* Thu Jan  7 2010 Anas Nashif <anas.nashif@intel.com> - 4.8.0~beta1
- Update to 4.8.0
- Use ~ for negative versioning of snpashots and pre-releases
* Sat Nov 14 2009 Anas Nashif <anas.nashif@intel.com> - 4.7.1
- Applied fixed from FC12
* Wed Sep 23 2009 Anas Nashif <anas.nashif@intel.com> - 4.7.1
- Update to 4.7.1
- Applied upstream patches
* Sun Apr 19 2009 Anas Nashif <anas.nashif@intel.com> 4.6.0
- rpm-build now requires moblin-rpm-config
* Sat Feb 21 2009 Anas Nashif <anas.nashif@intel.com> 4.6.0
- Remove topdir patch, use default
* Fri Feb 13 2009 Anas Nashif <anas.nashif@intel.com> 4.6.0
- Update to final 4.6.0
* Sat Dec 20 2008 Arjan van de Ven <arjan@linux.intel.com> 4.6.0
- Re-fix the pkgconfig bug
* Thu Dec 18 2008 Anas Nashif <anas.nashif@intel.com> 4.6.0
- Update to 4.6 rc3
* Thu Dec 11 2008 Arjan van de Ven <arjan@linux.intel.com> 4.6.0
- Fix the pkgconfig Requires: issue as exposed by cairo
* Thu Dec  4 2008 Anas Nashif <anas.nashif@intel.com> 4.6.0
- Update to 4.6rc2
* Sun Nov 30 2008 Anas Nashif <anas.nashif@intel.com> 4.6.0
- fix packageconfig auto dependencies
* Mon Nov 24 2008 Anas Nashif <anas.nashif@intel.com> 4.6.0
- split package to avoid long build time
* Fri Nov 21 2008 Anas Nashif <anas.nashif@intel.com> 4.6.0
- use external db 4.7
* Tue Oct 28 2008 Panu Matilainen <pmatilai@redhat.com>
- Florian's improved fingerprinting hash algorithm from upstream
* Sat Oct 25 2008 Panu Matilainen <pmatilai@redhat.com>
- Make noarch sub-packages actually work
- Fix defaultdocdir logic in installplatform to avoid hardwiring mandir
* Fri Oct 24 2008 Jindrich Novy <jnovy@redhat.com>
- update compat-db dependencies (#459710)
* Wed Oct 22 2008 Panu Matilainen <pmatilai@redhat.com>
- never add identical NEVRA to transaction more than once (#467822)
* Sun Oct 19 2008 Panu Matilainen <pmatilai@redhat.com>
- permit tab as macro argument separator (#467567)
* Thu Oct 16 2008 Panu Matilainen <pmatilai@redhat.com>
- update to 4.6.0-rc1
- fixes #465586, #466597, #465409, #216221, #466503, #466009, #463447...
- avoid using %%%%configure macro for now, it has unwanted side-effects on rpm
* Wed Oct  1 2008 Panu Matilainen <pmatilai@redhat.com>
- update to official 4.5.90 alpha tarball
- a big pile of misc bugfixes + translation updates
- isa-macro generation fix for ppc (#464754)
- avoid pulling in pile of perl dependencies for an unused script
- handle both "invalid argument" and clear env version mismatch on posttrans
* Thu Sep 25 2008 Jindrich Novy <jnovy@redhat.com>
- don't treat %%patch numberless if -P parameter is present (#463942)
* Thu Sep 11 2008 Panu Matilainen <pmatilai@redhat.com>
- add hack to support extracting gstreamer plugin provides (#438225)
- fix another macro argument handling regression (#461180)
* Thu Sep 11 2008 Jindrich Novy <jnovy@redhat.com>
- create directory structure for rpmbuild prior to build if it doesn't exist (#455387)
- create _topdir if it doesn't exist when installing SRPM
- don't generate broken cpio in case of hardlink pointing on softlink,
  thanks to pixel@mandriva.com
* Sat Sep  6 2008 Jindrich Novy <jnovy@redhat.com>
- fail hard if patch isn't found (#461347)
* Mon Sep  1 2008 Jindrich Novy <jnovy@redhat.com>
- fix parsing of boolean expressions in spec (#456103)
  (unbreaks pam, jpilot and maybe other builds)
* Tue Aug 26 2008 Jindrich Novy <jnovy@redhat.com>
- add support for noarch subpackages
- fix segfault in case of insufficient disk space detected (#460146)
* Wed Aug 13 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8461.2
- fix archivesize tag generation on ppc (#458817)
* Fri Aug  8 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8461.1
- new snapshot from upstream
- fixes #68290, #455972, #446202, #453364, #456708, #456103, #456321, #456913,
  [#458260], #458261
- partial fix for #457360
* Thu Jul 31 2008 Florian Festi <ffesti@redhat.com>
- 4.5.90-0.git8427.1
- new snapshot from upstream
* Thu Jul 31 2008 Florian Festi <ffesti@redhat.com>
- 4.5.90-0.git8426.10
- rpm-4.5.90-posttrans.patch
- use header from rpmdb in posttrans to make anaconda happy
* Sat Jul 19 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8426.9
- fix regression in patch number handling (#455872)
* Tue Jul 15 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8426.8
- fix regression in macro argument handling (#455333)
* Mon Jul 14 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8426.7
- fix mono dependency extraction (adjust for libmagic string change)
* Sat Jul 12 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8426.6
- fix type mismatch causing funky breakage on ppc64
* Fri Jul 11 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8426.5
- flip back to external bdb
- fix tab vs spaces complaints from rpmlint
- add dep for lzma and require unzip instead of zip in build (#310694)
- add pkgconfig dependency to rpm-devel
- drop ISA-dependencies for initial introduction
- new snapshot from upstream for documentation fixes
* Thu Jul 10 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8424.4
- handle int vs external db in posttrans too
* Tue Jul  8 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8424.3
- require curl as external url helper
* Tue Jul  8 2008 Panu Matilainen <pmatilai@redhat.com>
- 4.5.90-0.git8424.2
- add support for building with or without internal db
* Tue Jul  8 2008 Panu Matilainen <pmatilai@redhat.com>
- rpm 4.5.90-0.git8424.1 (alpha snapshot)
- adjust to build against Berkeley DB 4.5.20 from compat-db for now
- add posttrans to clean up db environment mismatch after upgrade
- forward-port devel autodeps patch
* Tue Jul  8 2008 Panu Matilainen <pmatilai@redhat.com>
- adjust for rpmdb index name change
- drop unnecessary vendor-macro patch for real
- add ISA-dependencies among rpm subpackages
- make lzma and sqlite deps conditional and disabled by default for now
* Fri Feb  1 2008 Panu Matilainen <pmatilai@redhat.com>
- spec largely rewritten, truncating changelog
