Name:		pacrunner
Version:	0.2
Release:	4.3
Summary:	Proxy configuration dæmon

Group:		System/Networking
License:	GPLv2
URL:		http://connman.net/
Source0:	http://www.kernel.org/pub/linux/network/connman/pacrunner-%{version}.tar.bz2
Source1:	libproxy.py
BuildRequires:	python v8-devel
BuildRequires:	pkgconfig(glib-2.0) pkgconfig(dbus-1)
BuildRequires:	pkgconfig(gthread-2.0) pkgconfig(libcurl)
Obsoletes:	libproxy < 0.5
Provides:	libproxy

%description
PacRunner provides a dæmon for processing proxy configuration
and providing information to clients over D-Bus.

%package devel
Summary:    Development files for PacRunner
Group:      Development/Libraries
Requires:   %{name} = %{version}-%{release}
Obsoletes:  libproxy-devel < 0.5
Provides:   libproxy-devel
%description devel
This provides the development files for building against
pacrunner's implementation of libproxy

%package python
Summary:    Python lib for PacRunner
Group:      Development/Libraries
Requires:   %{name} = %{version}-%{release}
Requires:   pacrunner
Obsoletes:  libproxy-python < 0.5
Provides:   libproxy-python
%description python
A python library for proxy configuration and autodetection

%prep
%setup -q

%build
autoreconf
%configure --enable-libproxy --enable-curl --disable-capng --enable-datafiles --enable-v8
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
mv $RPM_BUILD_ROOT/%{_datadir}/dbus-1/system-services/{,org.}pacrunner.service
mkdir -p ${RPM_BUILD_ROOT}/%{python_sitelib}
install -m0644 %{SOURCE1} $RPM_BUILD_ROOT/%{python_sitelib}/libproxy.py
rm -f $RPM_BUILD_ROOT/%{_libdir}/libproxy.la

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING README COPYING.LIB AUTHORS ChangeLog
%{_sbindir}/pacrunner
%{_libdir}/libproxy.so.0.0.0
%{_libdir}/libproxy.so.0
%{_bindir}/proxy
%{_datadir}/dbus-1/system-services/org.pacrunner.service
%config %{_sysconfdir}/dbus-1/system.d/pacrunner.conf

%files devel
%{_libdir}/libproxy.so
/usr/include/proxy.h
%{_libdir}/pkgconfig/libproxy-1.0.pc

%files python
%{python_sitelib}/libproxy.py*
%changelog
* Thu Mar 10 2011 Yu <yu.a.wang@intel.com> - 0.2
- Make a new sub package python for pacrunner, fixe pacrunner requires python BMC#13676
* Thu Jan 13 2011 Martin Xu <martin.xu@intel.com> - 0.2
- upgrade to 0.2 for FEA #11007
* Tue Dec  7 2010 David Woodhouse <David.Woodhouse@intel.com>
- Fix cURL issues, use v8 instead of mozjs
* Sat Nov 13 2010 David Woodhouse <David.Woodhouse@intel.com>
- Avoid parallel invocation of mozjs (BMC#10014)
* Sat Nov 13 2010 David Woodhouse <David.Woodhouse@intel.com>
- Fix libproxy result for https:// URLs
* Wed Nov 10 2010 David Woodhouse <David.Woodhouse@intel.com>
- ldconfig in %%post
* Fri Nov  5 2010 David Woodhouse <David.Woodhouse@intel.com>
- Initial package
