#specfile originally created for Fedora, modified for Moblin Linux
%define debug true
%define udev_libdir /lib/udev
%define firmwaredir /lib/firmware
  
Summary: A userspace implementation of devfs
Name: udev
Version: 172
Release: 16.1
License: GPLv2
Group: System/Base
Source0: http://www.us.kernel.org/pub/linux/utils/kernel/hotplug/%{name}-%{version}.tar.bz2

Source1: start_udev
Source2: udev.nodes
Source4: fw_unit_symlinks.sh
Source5: udev.sysconfig
Source9: 80-clock.rules
Source11: 60-filesystem-info.rules
Source12: 99-runtime-pm.rules
Source13: oaktrail-ins

Source100: Logan-custom-udev-rules.tar.bz2

Patch101: udev-116-nettype.patch
Patch102: udev-118-sysconf.patch

Patch106: udev-136-audio-video.patch
Patch109: udev-input-needs-group.patch
Patch110: udev-136-tty-group.patch
Patch111: udev-145-reconf.patch
Patch112: udev-pkgconfigdir.patch
Patch114: udev-161-oaktrail-ins.patch

ExclusiveOS: Linux
URL: http://www.kernel.org/pub/linux/utils/kernel/hotplug/udev.html
Requires(pre): /bin/sh fileutils
Requires(pre): /usr/bin/stat 
Requires(pre): MAKEDEV >= 0:3.11
Requires: hwdata
Requires: MAKEDEV 
Requires: sed 
Requires: pam 
Requires: ConsoleKit >= 0.4.1
Requires: mkdevnodes
Requires(post):   /bin/systemctl
Requires(preun):  /bin/systemctl
Requires(postun): /bin/systemctl
BuildRequires: sed flex 
BuildRequires: hwdata 
BuildRequires: pam-devel
BuildRequires: libacl-devel libusb-devel
BuildRequires: glib2-devel bison findutils
BuildRequires: gperf usbutils libtool

Obsoletes: udev-extra

%description
The udev package contains an implementation of devfs in 
userspace using sysfs and netlink.

%package rules-nondefault
Summary: Udev rules not used in normal installs
Group: System/base
Requires: udev = %{version}-%{release}

%description rules-nondefault
This package contains a set of udev rules not used in normal installs

%package custom-rules
Summary: Udev custom rules used in the Logan project
Group: System/base
Requires: udev = %{version}-%{release}
Requires: udev-rules-nondefault
Requires: bluez
Requires: ofono
Requires: systemd

%description custom-rules
This package contains a set of custom udev rules used in the Logan project

%package -n libudev
Summary: Library for accessing udev functionality
Group: Development/Libraries
Requires: udev = %{version}-%{release}

%description -n libudev
This package contains a shared library for accesing libudev functionality.

%package -n libudev-devel
Summary: Headers for libudev
Group: Development/Libraries
Requires: udev = %{version}-%{release}
Requires: libudev = %{version}-%{release}

%description -n libudev-devel
This package contains libraries and include files, 
which needed to link against libudev.

%package -n libgudev1
Summary: Libraries for adding libudev support to applications that use glib
Group: Development/Libraries
Requires: libudev >= 142
# remove the following lines for libgudev so major 1
Provides: libgudev = 20090517
Obsoletes: libgudev <= 20090516
 
%description -n libgudev1
This package contains the libraries that make it easier to use libudev
functionality from applications that use glib.
 
%package -n libgudev1-devel
Summary: Header files for adding libudev support to applications that use glib
Group: Development/Libraries
Requires: libudev-devel >= 142
Provides: libgudev-devel = 20090517
Obsoletes: libgudev-devel <= 20090516
 
Requires: libgudev1 = %{version}-%{release}
 
%description -n libgudev1-devel
This package contains the header and pkg-config files for developing
glib-based applications using libudev functionality.
 
%prep
%setup -q

%patch101 -p1 -b .nettyp
%patch102 -p1 -b .sysconf
%patch106 -p1 -b .video
%patch109 -p1 -b .groups
%patch110 -p1 -b .tty
%patch111 -p1 -b .ref
%patch112 -p1 -b .datadir
%patch114 -p1 -b .okt


%build
libtoolize -f -c
%configure --prefix=%{_prefix} --exec-prefix="" \
           --sysconfdir=%{_sysconfdir} --with-libdir-name=%{_lib} \
           --sbindir="/sbin" --libexecdir=%{udev_libdir} \
           --with-rootlibdir=/%{_lib} --disable-introspection \
           --with-systemdsystemunitdir="/%{_lib}/systemd/system"

make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=$RPM_BUILD_ROOT install
mkdir -p \
    $RPM_BUILD_ROOT%{_sysconfdir}/udev/{makedev.d,scripts,devices} \
    $RPM_BUILD_ROOT%{_sysconfdir}/dev.d \
    $RPM_BUILD_ROOT%{firmwaredir} \
    $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig \
    $RPM_BUILD_ROOT/var/lib/udev/makedev.d \
    $RPM_BUILD_ROOT%{_bindir} \
    $RPM_BUILD_ROOT%{_sbindir} \
    $RPM_BUILD_ROOT/usr/lib/pkgconfig \
    $RPM_BUILD_ROOT/%{_libdir}/ConsoleKit/run-session.d \
    $RPM_BUILD_ROOT%{udev_libdir}/{,devices}

rm -f $RPM_BUILD_ROOT/%{_libdir}/*.la

#mv $RPM_BUILD_ROOT/usr/share/pkgconfig/* $RPM_BUILD_ROOT/usr/lib/pkgconfig 
#mv $RPM_BUILD_ROOT/lib/pkgconfig/* $RPM_BUILD_ROOT/usr/lib/pkgconfig 
# force relative symlinks
ln -sf ..%{udev_libdir}/scsi_id $RPM_BUILD_ROOT/sbin/scsi_id

ln -sf ../../sbin/udevadm $RPM_BUILD_ROOT%{_bindir}/udevinfo
ln -sf ../../sbin/udevadm $RPM_BUILD_ROOT%{_bindir}/udevtest
ln -sf ../../sbin/udevadm $RPM_BUILD_ROOT%{_sbindir}/udevmonitor

ln -sf ../../sbin/udevadm $RPM_BUILD_ROOT/sbin/udevtrigger
ln -sf ../../sbin/udevadm $RPM_BUILD_ROOT/sbin/udevsettle
ln -sf ../../sbin/udevadm $RPM_BUILD_ROOT/sbin/udevcontrol


install -m 0644 %{SOURCE2} $RPM_BUILD_ROOT%{_sysconfdir}/udev/makedev.d/50-udev.nodes
install -m 0644 %{SOURCE5} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/udev
install -m 0755 %{SOURCE1} $RPM_BUILD_ROOT/sbin/start_udev
install -m 0755 %{SOURCE4} $RPM_BUILD_ROOT%{udev_libdir}/fw_unit_symlinks.sh
install -m 0644 %{SOURCE9} $RPM_BUILD_ROOT%{udev_libdir}/rules.d
install -m 0644 %{SOURCE11} $RPM_BUILD_ROOT%{udev_libdir}/rules.d
install -m 0644 %{SOURCE12} $RPM_BUILD_ROOT%{udev_libdir}/rules.d
install -m 0644 %{SOURCE13} $RPM_BUILD_ROOT%{udev_libdir}/keymaps

install -m 0755 -d $RPM_BUILD_ROOT%{udev_libdir}/custom.rules.d
tar xjf %{SOURCE100} -C $RPM_BUILD_ROOT%{udev_libdir}/custom.rules.d/

# disable systemd files All of them are now part of systemd package
rm -rf %{buildroot}/lib/systemd

%pre
getent group video >/dev/null || /usr/sbin/groupadd -g 39 video || :
getent group audio >/dev/null || /usr/sbin/groupadd -g 63 audio || :
# to be kept
getent group cdrom >/dev/null || /usr/sbin/groupadd -g 11 cdrom || :
getent group tape >/dev/null || /usr/sbin/groupadd -g 33 tape || :
getent group dialout >/dev/null || /usr/sbin/groupadd -g 18 dialout || :

%post
[ -x /bin/systemctl ] && {
systemctl daemon-reload
systemctl reload-or-try-restart udev.service
systemctl reload-or-try-restart udev-retry.service
systemctl reload-or-try-restart udev-settle.service
} || :
 
%preun
[ -x /bin/systemctl ] && {
systemctl stop udev.service
systemctl stop udev-retry.service
systemctl stop udev-settle.service
} || :
 
%postun
[ -x /bin/systemctl ] && {
systemctl stop udev.service
systemctl daemon-reload
} || :

%post -n libudev -p /sbin/ldconfig
%postun -n libudev -p /sbin/ldconfig

%post -n libgudev1 -p /sbin/ldconfig
%postun -n libgudev1 -p /sbin/ldconfig


%triggerpostun -- dev <= 0:3.12-1
if [ $2 = 0 ]; then
        if [ -x /sbin/MAKEDEV ]; then 
                /sbin/MAKEDEV null
        else
                /bin/mknod /dev/null c 1 3
        fi
        /sbin/start_udev >/dev/null 2>&1
        if [ -e /dev/mapper/control -a -x /sbin/lvm ]; then
                /sbin/lvm vgmknodes >/dev/null 2>&1
        fi
fi
exit 0


%triggerin -- MAKEDEV
rm -f /var/lib/udev/makenode.d/*  >/dev/null 2>&1 || :

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(0644, root, root, 0755)
%doc COPYING README 
%attr(0755,root,root) /sbin/udevadm
%attr(0755,root,root) /sbin/udevsettle
%attr(0755,root,root) /sbin/udevtrigger
%attr(0755,root,root) /sbin/udevcontrol
%attr(0755,root,root) /sbin/udevd
%attr(0755,root,root) /sbin/start_udev
%attr(0755,root,root) /sbin/scsi_id
%attr(0755,root,root) %{_bindir}/udevtest
%attr(0755,root,root) %{_bindir}/udevinfo
%attr(0755,root,root) %{_sbindir}/udevmonitor
%attr(0755,root,root) %dir %{udev_libdir}/rules.d/
%attr(0755,root,root) %dir %{_sysconfdir}/udev/
%attr(0755,root,root) %dir %{_sysconfdir}/udev/rules.d/
%attr(0755,root,root) %dir %{udev_libdir}/
%attr(0755,root,root) %dir %{udev_libdir}/devices/
%attr(0755,root,root) %dir %{_sysconfdir}/udev/makedev.d/

%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/sysconfig/udev

%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/udev/udev.conf

#%config(missingok) %{_sysconfdir}/hotplug.d/default/10-udev.hotplug
#%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/scsi_id.config

%dir %attr(0755,root,root) %{firmwaredir}

%dir %attr(0755,root,root) /var/lib/udev
%dir %attr(0755,root,root) /var/lib/udev/makedev.d

# Deprecated, but keep the ownership
%ghost %dir %{_sysconfdir}/udev/scripts/
%ghost %dir %{_sysconfdir}/udev/devices/
%ghost %dir %{_sysconfdir}/dev.d/

%attr(0644,root,root) %{_prefix}/lib/ConsoleKit/run-seat.d/udev-acl.ck


/etc/udev/makedev.d/50-udev.nodes
%attr(0755,root,root) %{udev_libdir}/ata_id
%attr(0755,root,root) %{udev_libdir}/accelerometer
%attr(0755,root,root) %{udev_libdir}/input_id
%attr(0755,root,root) %{udev_libdir}/cdrom_id
%attr(0755,root,root) %{udev_libdir}/collect
%attr(0755,root,root) %{udev_libdir}/findkeyboards
%attr(0755,root,root) %{udev_libdir}/keyboard-force-release.sh
%attr(0755,root,root) %{udev_libdir}/firmware
%attr(0755,root,root) %{udev_libdir}/fw_unit_symlinks.sh
%attr(0755,root,root) %{udev_libdir}/keymap
%attr(0755,root,root) %{udev_libdir}/keymaps/*
%attr(0755,root,root) %{udev_libdir}/path_id
%attr(0755,root,root) %{udev_libdir}/pci-db
%attr(0644,root,root) %{udev_libdir}/rule_generator.functions
%attr(0755,root,root) %{udev_libdir}/scsi_id
%attr(0755,root,root) %{udev_libdir}/udev-acl
%attr(0755,root,root) %{udev_libdir}/usb-db
%attr(0755,root,root) %{udev_libdir}/usb_id
%attr(0755,root,root) %{udev_libdir}/v4l_id
%attr(0755,root,root) %{udev_libdir}/write_cd_rules
%attr(0755,root,root) %{udev_libdir}/write_net_rules
%attr(0755,root,root) %{udev_libdir}/mtd_probe
%doc /%{_datadir}/doc/udev/README.keymap.txt
#%doc /%{_datadir}/doc/udev/writing_udev_rules/index.html

%attr(0755,root,root) %{udev_libdir}/rules.d/42-qemu-usb.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/50-firmware.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/50-udev-default.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/60-cdrom_id.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/60-persistent-alsa.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/60-persistent-v4l.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/60-persistent-input.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/60-persistent-storage.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/60-filesystem-info.rules
#%attr(0755,root,root) %{udev_libdir}/rules.d/61-option-modem-modeswitch.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/61-accelerometer.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/70-acl.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/75-cd-aliases-generator.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/75-net-description.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/75-tty-description.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/75-probe_mtd.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/78-sound-card.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/80-clock.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/80-drivers.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/95-keyboard-force-release.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/95-keymap.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/95-udev-late.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/99-runtime-pm.rules

# disable systemd files All of them are now part of systemd package
#/%{_lib}/systemd/system/basic.target.wants/udev.service
#/%{_lib}/systemd/system/udev.service
#/%{_lib}/systemd/system/graphical.target.wants/udev-trigger.service
#/%{_lib}/systemd/system/sockets.target.wants/udev-control.socket
#/%{_lib}/systemd/system/sockets.target.wants/udev-kernel.socket
#/%{_lib}/systemd/system/udev-control.socket
#/%{_lib}/systemd/system/udev-kernel.socket
#/%{_lib}/systemd/system/udev-settle.service
#/%{_lib}/systemd/system/udev-trigger.service

%files rules-nondefault
%attr(0755,root,root) %{udev_libdir}/rules.d/60-persistent-storage-tape.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/75-persistent-net-generator.rules
%attr(0755,root,root) %{udev_libdir}/rules.d/60-persistent-serial.rules

%files custom-rules
%defattr(0755, root, root, -)
%{udev_libdir}/custom.rules.d/*

%files -n libudev
%defattr(0644, root, root, 0755)
%doc COPYING
%attr(0755,root,root) /%{_lib}/libudev.so.*
#%attr(0755,root,root) /%{_lib}/libudev.la

%files -n libudev-devel
%defattr(0644, root, root, 0755)
%doc COPYING
%doc TODO ChangeLog extras/keymap/README.keymap.txt
%attr(0644,root,root) %{_mandir}/man8/udev*.8*
%attr(0644,root,root) %{_mandir}/man7/udev*.7*
%attr(0644,root,root) %{_mandir}/man8/scsi_id*.8*
%{_includedir}/libudev.h
%{_libdir}/libudev.so
%{_libdir}/pkgconfig/libudev.pc
%{_libdir}/pkgconfig/udev.pc
%{_datadir}/gtk-doc/html/libudev/*


%files -n libgudev1
%defattr(0644, root, root, 0755)
%doc COPYING
%attr(0755,root,root) /%{_lib}/libgudev-1.0.so.*

%files -n libgudev1-devel
%defattr(0644, root, root, 0755)
%doc COPYING
%attr(0755,root,root) %{_libdir}/libgudev-1.0.so
%attr(0644,root,root) %{_includedir}/gudev-1.0/gudev/*.h
%dir %{_datadir}/gtk-doc/html/gudev
%attr(0644,root,root) %{_datadir}/gtk-doc/html/gudev/*
%attr(0644,root,root) %{_libdir}/pkgconfig/gudev-1.0*

%post custom-rules
/bin/mv /lib/udev/rules.d /lib/udev/orig.rules.d
/bin/mv /lib/udev/custom.rules.d /lib/udev/rules.d

%preun custom-rules
/bin/mv /lib/udev/rules.d /lib/udev/custom.rules.d

%postun custom-rules
/bin/mv /lib/udev/orig.rules.d /lib/udev/rules.d

%changelog
* Fri Nov 2 2012 Andrei Zlate <andrei.zlate@windriver.com> - 172
- To avoid needing to update a lot of packages, use a custom rules archive
* Mon Jan 16 2012 Dragos Stoica <dragos.stoica@windriver.com> - 172
- disabled systemd services. they're now part of systemd package
* Fri Oct 21 2011 Dragos Stoica <dragos.stoica@windriver.com> - 172
- removed udev-trigger.service symlink
* Tue Sep 20 2011 Dragos Stoica <dragos.stoica@windriver.com> - 172
- moved udev-trigger.service to late-services
* Thu Jul 14 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 172
- updated udev from v171 to v172 needed for features required
  by v30 of systemd.
* Sun Jun 26 2011 Anas Nashif <anas.nashif@intel.com> - 171
- gtk-doc files for gudev were packaged twice
* Sun Jun 12 2011 Anas Nashif <anas.nashif@intel.com> - 171
- handle errors in %%post
* Sat Jun 11 2011 Anas Nashif <anas.nashif@intel.com> - 171
- Check for /bin/systemctl before we attempt to run it
* Sun Jun  5 2011 Anas Nashif <anas.nashif@intel.com> - 171
- Remove circular dependency on systemd
- Remove gtk-doc requirement
* Fri May 27 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 171
- Updated the version of udev from v166 to v171. Along with fixes
  and changes to systemd, 171 has refined systemd additions and fixes needed.
* Wed May 25 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 166
- Updated spec file to change systemctl as a requires to the package systemd
- for each scriplet section. Also added a Requires systemd as systemd is configured
- as a build option for this package exposing systemd features.
* Wed May 18 2011 Anas Nashif <anas.nashif@intel.com> - 166
- Move useless documentation from runtime package
* Mon May 16 2011 Auke Kok <auke-jan.h.kok@intel.com> - 166
- Add post dependency on systemctl for script.
* Wed May 11 2011 Austin Zhang <austin.zhang@intel.com> - 161
- Enable one type oaktrail platform hard buttons. BMC#17410.
* Wed May 11 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 166
- FEA#16109 - [FEA] Implement SystemD as MeeGo init provide
- removed the requirment for pidof as it is not used and sysvinit package
  provided it and is not deleted.
* Tue May  3 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 166
- FEA#16109 - [FEA] Implement SystemD as MeeGo init provide
- with the 166 package update which supports systemd by configuration,
  ajusted spec and packaging accordingly to enable systemd.
- Update to 166
- Drop merged lenovo patch (BMC#14198)
* Tue May  3 2011 Neo Fang <neo.fang@intel.com> - 161
- Enable and preinstall 60-persistent-storage.rules to fix BMC#13108
* Thu Apr 21 2011 Kristen Carlson Accardi <kristen@linux.intel.com> - 161
- Add rule to enable runtime power management for the ehci driver
  at boot time for Moorestown tablet.
* Tue Mar 15 2011 Neo Fang <neo.fang@intel.com> - 161
- Modify Lenovo-S10-3t keymap definition to fix BMC#14198
* Thu Mar  3 2011 Neo Fang <neo.fang@intel.com> - 161
- Trigger add rtc in start_udev to fix BMC#13902
* Wed Oct 27 2010 Anas Nashif <anas.nashif@intel.com> - 161
- Remove dependency on gobject-introspection
* Thu Oct 21 2010 Auke Kok <auke-jan.h.kok@intel.com> - 161
- Splitting the mkdevnodes package into a separate package
* Mon Aug 16 2010 Yin Kangkai <kangkai.yin@intel.com> - 161
- Upgrade to 161
- Drop fix-5820-fail-to-install.patch
- Integrate udev-162-keymap-for-lenovo-ideapad.patch, fix BMC #5226
* Tue Jul 13 2010 Marko Saukko <marko.saukko@cybercom.com> - 158
- Removed dependency to udev-rules package.
* Mon Jul  5 2010 Jian-feng Ding <jian-feng.ding@intel.com> 158
- Upgrade to 158 and updated the following patches:
    udev-118-sysconf.patch
    udev-136-audio-video.patch
    udev-136-tty-group.patch
* Fri Apr 23 2010 Michael Demeter <michael.demeter@intel.com> - 150
- Add rule to touch only block devices. This is a fix for BUG 95
* Fri Mar 26 2010 Arjan van de Ven <arjan@linux.intel.com> - 150
- add a filesystem identification rule, fixes meego bz #160
* Thu Mar 25 2010 Arjan van de Ven <arjan@linux.intel.com> - 150
- make sure /dev/shm exists rather than crashing start_udev
* Wed Mar 24 2010 Arjan van de Ven <arjan@linux.intel.com> - 150
- make sure /dev/pts exists rather than crashing start_udev
* Wed Mar 24 2010 Arjan van de Ven <arjan@linux.intel.com> - 150
- fix naming convention of the unused rules subpackage to be consistent
* Wed Mar 24 2010 Anas Nashif <anas.nashif@intel.com> - 150
- Now require virtual udev-rules provides by veritical specific packages
  such as udev-rules-netbook
* Tue Mar 23 2010 Arjan van de Ven <arjan@linux.intel.com> - 150
- split off a subpackage for udev rules that we don't use
* Tue Mar 23 2010 Auke Kok <auke-jan.h.kok@intel.com> - 150
- replace mknods with mkdevnodes - simplifies device node
  creation at boot. /dev is now filled in using sysfs information
  and without hardcoded tables.
* Sat Jan  9 2010 Peter Zhu <peter.j.zhu@intel.com> - 150
- Update to 150
* Tue Dec  8 2009 Peter Zhu <peter.j.zhu@intel.com> - 145
- Get it build
* Thu Sep 24 2009 Anas Nashif <anas.nashif@intel.com> - 145
- Add groups used in udev rules
* Thu Sep  3 2009 Vivian Zhang <vivian.zhang@intel.com> 145
- Quick fix for 5820: fail to install the image, which is caused by the udevd crash
* Wed Aug 26 2009 Arjan van de Ven <arjan@linux.intel.com> 145
- make sure the .pc files are in /usr/lib/pkgconfig
* Tue Aug 25 2009 Arjan van de Ven <arjan@linux.intel.com> 145
- don't play symlinking tricks in %%%%post for the pkgconfig files
* Mon Aug 24 2009 Peter Zhu <peter.j.zhu@intel.com> 145
- wrong link to stdin/stdout fixing 5496
* Thu Jul 30 2009 Austin Zhang <austin.zhang@linux.intel.com> 145
- Split moblin specific rules to individual pkg as less modifications
  should not ask the whole udev update.
* Tue Jul 28 2009 Austin Zhang <austin.zhang@linux.intel.com> 145
- Fixed wrong symbolic link on scsi_id
* Wed Jul 22 2009 Arjan van de Ven <arjan@linux.intel.com> 145
- fix tty permissions again
* Mon Jul 20 2009 Peter Zhu <peter.j.zhu@intel.com> 143
- Obsoletes udev-extra
* Wed Jul 15 2009 Austin Zhang <austin.zhang@intel.com> 143
- Updated to 145 with some related pkgs update and bug fix.
  (145 resolved that udev-worker segfault issue compared with 143)
* Mon Jul 13 2009 Arjan van de Ven <arjan@linux.intel.com> 136
- make sure /dev/tty2 has the video permissions so that X can talk to it
* Wed Jul  1 2009 Arjan van de Ven <arjan@linux.intel.com> 136
- use a group for new input devices to make non-root-X work
* Fri Jun 19 2009 Xu Li <xu.li@intel.com> 136
- Sync clock after detecting the rtc device; fix bug#3025
* Wed May  6 2009 Austin Zhang <austin.zhang@intel.com> 136
- Fix #2027: unbound variable MAKEDEV
* Tue Apr 21 2009 Passion Zhao <passion.zhao@intel.com> 136
- CVE-2009-1185, CVE-2009-1186
* Tue Apr  7 2009 Anas Nashif <anas.nashif@intel.com> 136
- Add /dev/lpe for moorestown
* Wed Apr  1 2009 Vivian Zhang <vivian.zhang@intel.com> 136
- Add more device nodes: sda9, sda10 (bug #1414)
* Thu Mar 26 2009 Austin Zhang <austin.zhang@intel.com> 136
- Fixed error handling when creating nodes (bug #1213)
* Wed Mar 25 2009 Vivian Zhang <vivian.zhang@intel.com> 136
- Fixed the minor number of sda5-7 to fix #1353
* Wed Mar 18 2009 Arjan van de Ven <arjan@linux.intel.com> 136
- add more device nodes for sda
* Tue Feb 17 2009 Anas Nashif <anas.nashif@intel.com> 136
- Replace obsolete option -s with -e
* Sun Feb 15 2009 Anas Nashif <anas.nashif@intel.com> 136
- use correct mknods options, -e instead of -s
* Thu Feb 12 2009 Arjan van de Ven <arjan@linux.intel.com> 136
- start udev faster
* Mon Feb  9 2009 Inaky Perez-Gonzalez <inaky.perez-gonzalez@intel.com> 136
- Fix typo in help
* Mon Feb  9 2009 Inaky Perez-Gonzalez <inaky.perez-gonzalez@intel.com> 136
- Make mknods error-tolerant, fix symlink argument order
* Mon Feb  9 2009 Yin Kangkai <kangkai.yin@intel.com> 136
- Fix Source0 in spec
* Tue Jan 27 2009 Arjan van de Ven <arjan@linux.intel.com> 136
- add more USB device IDs
* Tue Jan 20 2009 Yong Wang <yong.y.wang@intel.com> 136
- Fix bug #153 again as QA reported another device that should be autosuspended
* Thu Jan 15 2009 Anas Nashif <anas.nashif@intel.com> 136
- Added video devices to video group
* Thu Jan 15 2009 Inaky Perez-Gonzalez <inaky.perez-gonzalez@intel.com> 136
- Add static nodes for /dev/sdb to solve issues found installing to a second drive
* Wed Jan 14 2009 Inaky Perez-Gonzalez <inaky.perez-gonzalez@intel.com> 136
- Fix last call to udevadm control --env who was not using --env
* Wed Jan 14 2009 Yong Wang <yong.y.wang@intel.com> 136
- Rework the usb autosuspend patch (bug 153) so that it works with udev-136
* Tue Jan 13 2009 Inaky Perez-Gonzalez <inaky.perez-gonzalez@intel.com> 136
- Add /dev/snd directory and remove old /etc/udev/rules.d
* Fri Jan  9 2009 Anas Nashif <anas.nashif@intel.com> 136
- Fixed command arguments
- Fixed package names
* Thu Jan  8 2009 Inaky Perez-Gonzalez <inaky.perez-gonzalez@intel.com> 136
- updated to udev-136, big cleanup in patches and directory layout changes
* Tue Jan  6 2009 Yong Wang <yong.y.wang@intel.com> 120
- Add moblin specific rules to fix usb autosuspend issue (bug 153)
* Fri Dec 19 2008 Arjan van de Ven <arjan@linux.intel.com> 120
- Make the DRM devices accessible to the moblin users group
* Fri Dec 19 2008 Arjan van de Ven <arjan@linux.intel.com> 120
- omit verbose text messages
* Fri Dec 19 2008 Arjan van de Ven <arjan@linux.intel.com> 120
- Make sure /dev/console always exists
* Thu Dec 18 2008 Arjan van de Ven <arjan@linux.intel.com> 120
- Drop persistent storage, we don't need it and it costs boot time
* Fri Dec 12 2008 Inaky Perez-Gonzalez <inaky.perez-gonzalez@intel.com> 120
- General speed up of udev startup
  * Replace MAKEDEV usage by a simple C program that creates files based
    on a table read on stdin (mknods). This cuts the overhead of
    invoking the same program many times.
  * Cleanup start_udev, introduce boot-time assumptions
  * move uneeded rules to -extra
* Thu Dec 11 2008 Anas Nashif <anas.nashif@intel.com> 120
- fastinit replaces initscripts
* Thu Aug  7 2008 Anas Nashif <anas.nashif@intel.com>
- Remove dependency on libsepol
* Wed Jul 23 2008 Martin Xu <martin.xu@intel.com>
- add %%doc to man file
