#
# Spec file originally created for Fedora, modified for Moblin Linux
#

Summary: The Linux kernel (the core of the Linux operating system)

# Build a kernel with Debug options activated or not
# A value of 0 means fastboot, any other value means debug
%define kernel_type_debug	0


# For a stable, released kernel, released_kernel should be 1. For rawhide
# and/or a kernel built from an rc snapshot, released_kernel should
# be 0.
%define released_kernel 1

# Versions of various parts

# base_sublevel is the kernel version we're starting with and patching
# on top of -- for example, 2.6.22-rc7 starts with a 2.6.21 base,
# which yields a base_sublevel of 21.

%define base_sublevel 37


## If this is a released kernel ##
%if 0%{?released_kernel}
# Do we have a 2.6.21.y update to apply?
%define stable_update 6
# Set rpm version accordingly
%if 0%{?stable_update}
%define stablerev .%{stable_update}
%endif
%define rpmversion 2.6.%{base_sublevel}%{?stablerev}

## The not-released-kernel case ##
%else
# The next upstream release sublevel (base_sublevel+1)
%define upstream_sublevel %(expr %{base_sublevel} + 1)
# The rc snapshot level

%define rcrev 5


%if 0%{?rcrev}
%define rctag ~rc%rcrev
%endif

%if !0%{?rcrev}
%define rctag ~rc0
%endif

# Set rpm version accordingly
%define rpmversion 2.6.%{upstream_sublevel}%{?rctag}
%endif

# The kernel tarball/base version
%define kversion 2.6.%{base_sublevel}

%define make_target bzImage

%define KVERREL %{version}-%{release}
%define hdrarch %_target_cpu

%define all_x86 i386 i586 i686 %{ix86}

%define all_arm %{arm}

%define _default_patch_fuzz 0

# Per-arch tweaks

%ifarch %{all_x86}
%define image_install_path boot
%define hdrarch i386
%define kernel_image arch/x86/boot/bzImage
%endif

%ifarch x86_64
%define image_install_path boot
%define kernel_image arch/x86/boot/bzImage
%endif

%ifarch %{all_arm}
%define image_install_path boot
%define kernel_image arch/arm/boot/zImage
%define make_target zImage
%endif

ExclusiveArch: %{all_x86}

#
# Packages that need to be installed before the kernel is, because the %post
# scripts use them.
#
%define kernel_prereq  fileutils, module-init-tools, fastinit, mkinitrd >= 6.0.39-1

#
# This macro does requires, provides, conflicts, obsoletes for a kernel package.
#	%%kernel_reqprovconf <subpackage>
# It uses any kernel_<subpackage>_conflicts and kernel_<subpackage>_obsoletes
# macros defined above.
#
%define kernel_reqprovconf \
Provides: kernel = %{rpmversion}-%{release}\
Provides: kernel-uname-r = %{KVERREL}%{?1:-%{1}}\
Provides: emgd-drm = 3320 \
Requires(pre): %{kernel_prereq}\
%{?1:%{expand:%%{?kernel_%{1}_conflicts:Conflicts: %%{kernel_%{1}_conflicts}}}}\
%{?1:%{expand:%%{?kernel_%{1}_provides:Provides: %%{kernel_%{1}_provides}}}}\
# We can't let RPM do the dependencies automatic because it'll then pick up\
# a correct but undesirable perl dependency from the module headers which\
# isn't required for the kernel proper to function\
AutoReq: no\
AutoProv: yes\
%{nil}

Name: kernel-android-intel-crossville_lapis-fastboot

Group: System/Kernel
License: GPLv2
URL: http://www.kernel.org/
Version: %{rpmversion}
Release: 34.1

%kernel_reqprovconf

#
# List the packages used during the kernel build
#
BuildRequires: module-init-tools, bash >= 2.03, sh-utils
BuildRequires:  findutils,  make >= 3.78
BuildRequires: linux-firmware
BuildRequires: elfutils-devel elfutils-libelf-devel binutils-devel newt-devel
BuildRequires: lzo lzop

Source0: android-%{kversion}.tar.bz2

Source100: kernel-android-intel-crossville_lapis-debug.config
Source101: kernel-android-intel-crossville_lapis-fastboot.config

Source200: ROHM-docs-v130-20120329.tar.bz2

Patch00: 0001-Update-to-2.6.37.6.patch
# Reminder of the patch filename format:
# linux-<version it is supposed to be upstream>-<description-separated-with-dashes>.patch
#

#
# Stable patches - critical bugfixes
Patch1: 0002-CrossvilleLapis-BSP-linux-2.6.38-btrfs-page-count.patch
Patch2: 0003-CrossvilleLapis-BSP-linux-2.6.38-btrfs-handle-no-mem.patch
Patch3: 0004-CrossvilleLapis-BSP-linux-2.6.38-btrfs-copy-from-user.patch

Patch4: 0005-CrossvilleLapis-BSP-linux-2.6.37-fatal-signals.patch

Patch5: 0006-CrossvilleLapis-BSP-linux-2.6.37-tsc2007.patch
# End of the stable patches
#

#
# EG20T(Topcliff) and ML7213 IOH Patches
Patch8: 0007-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0001-phub.patch
Patch9: 0008-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0002-spi.patch
Patch10: 0009-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0003-gpio.patch
Patch11: 0010-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0004-i2s.patch
Patch12: 0011-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0005-mlb.patch
Patch13: 0012-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0006-snd.patch
Patch14: 0013-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0007-video_in.patch
Patch15: 0014-CrossvilleLapis-BSP-linux-2.6.37-ml7213-0008-ioh_video_in-20110629-delete-invalid-redefinition-PCI_DEVICE_ID.patch
Patch16: 0015-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0001-i2c.patch
Patch17: 0016-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0002-usbdev.patch
Patch18: 0017-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0003-uart.patch
Patch19: 0018-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0004-dma.patch
Patch20: 0019-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0005-gbe.patch
Patch21: 0020-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0006-uart.patch
Patch22: 0021-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0007-fix-dma-issue-for-ch8-11.patch
Patch23: 0022-CrossvilleLapis-BSP-linux-2.6.37-ml7213-eg20t-0008-i2c-eg20t-20110629-Fix-the-issue-combined-access.patch
# End of EG20T and ML7213 Patches
#

#
# EMGD patches
Patch24: 0042-CrossvilleLapis-BSP-linux-2.6.37-emgd-add-makefile.patch
Patch25: 0043-CrossvilleLapis-BSP-linux-2.6.37-emgd-3320.patch
Patch26: 0044-CrossvilleLapis-BSP-linux-2.6.37-emgd-3320_v2g_bridge.patch
# End of EMGD Patches
#

#
# Russellville patches
# Patch27: linux-2.6.37-adjust-adv7180-timblogiw-to-be-NTSC.patch
Patch28: 0023-CrossvilleLapis-BSP-linux-2.6.37-rv-add-timbi2s.patch
Patch29: 0024-CrossvilleLapis-BSP-linux-2.6.37-rv-add-timblogiw.patch
Patch30: 0025-CrossvilleLapis-BSP-linux-2.6.37-rv-fix-tx-cache-issue-ks8842.patch
Patch31: 0026-CrossvilleLapis-BSP-linux-2.6.37-timberdale-enable-devices.patch
Patch32: 0027-CrossvilleLapis-BSP-linux-2.6.37-timb-radio-pickup-dsp.patch
# End of Russellville Patches
#

#
# Kernel CVE patches
Patch33: 0028-CrossvilleLapis-BSP-linux-2.6.37-cve-0001-Treat-writes-as-new-when-holes-span-accross-page-boun.patch
# End of Kernel CVE patches
#

#
# Lapis (OKI) patches
Patch34: 0029-CrossvilleLapis-BSP-linux-2.6.37-ml7213-i2c-eg20t-20110701-Fix-unnecessary-error-message-issue.patch
Patch35: 0030-CrossvilleLapis-BSP-linux-2.6.37-ml7213-ioh_i2s-20110701-Fix-register-setting-issue.patch
Patch36: 0031-CrossvilleLapis-BSP-linux-2.6.37-ml7213-pch_dma-20110701-1of3-Fix-video-channel-issue.patch
Patch37: 0032-CrossvilleLapis-BSP-linux-2.6.37-ml7213-pch_dma-20110701-3of3-Fix-spin_lock-usage-issue.patch
Patch38: 0033-CrossvilleLapis-BSP-linux-2.6.37-ml7213-snd-ml7213-20110701-1of2-Add-Wind-River-for-copyright.patch
Patch39: 0034-CrossvilleLapis-BSP-linux-2.6.37-ml7213-snd-ml7213-20110701-2of2-Add-I2C-Control.patch
Patch40: 0035-CrossvilleLapis-BSP-linux-2.6.37-ml7213-spi_topcliff_pch-20110701-Replaced-upstreamed-version.patch
Patch41: 0036-CrossvilleLapis-BSP-linux-2.6.37-video-input-driver-cv-oki.patch
Patch42: 0037-CrossvilleLapis-BSP-linux-2.6.37-mapper.patch
Patch43: 0038-CrossvilleLapis-BSP-linux-2.6.37-pch-uart-serial-console.patch
Patch44: 0039-CrossvilleLapis-BSP-linux-2.6.37-pch-uart-clock-modification.patch
# End of Lapis (OKI) patches
#

#
# MMC password support
Patch45: 0040-CrossvilleLapis-BSP-linux-2.6.37-add-mmc-password-protection-lock-unlock-support-for-linux.patch
# End of MMC password support
#

#
#Video-bridge related patches
Patch46: 0041-CrossvilleLapis-BSP-linux-2.6.37-dma-video-bridge.patch
Patch47: 0045-CrossvilleLapis-BSP-linux-2.6.37-emgd-video-in-compat.patch
#End of video-brige related patches
#

#
# Persistent Memory for DENSO
Patch48: 0046-CrossvilleLapis-BSP-linux-2.6.37-persistent_memory.patch

#
# MTD driver update for Bootloader Update support
Patch49: 0047-CrossvilleLapis-BSP-linux-2.6.37-mtd-m25p80-add-MX25L1606E-support.patch

#
# USB OverCurrent and VBUS power control
Patch50: 0048-CrossvilleLapis-BSP-linux-2.6.37-usb-oc-power.patch

#
# Add GPIO support for Intel Tunnel Creek
Patch51: 0049-CrossvilleLapis-BSP-linux-2.6.37-add-intel-tunnel-creek-gpio-support.patch

#
# Upgrade I2C driver to ROHM release from 20120329
Patch52: 0050-CrossvilleLapis-BSP-linux-2.6.37-ROHM-I2C-20120329-v1.3.0.patch

#
# Upgrade GPIO driver to ROHM release from 20120329
Patch53: 0051-CrossvilleLapis-BSP-linux-2.6.37-ROHM-GPIO-20120329-v1.2.0.patch

#
# Backport GPIO fixes for Crossville from upstream kernel
Patch54: 0052-CrossvilleLapis-BSP-linux-2.6.37-GPIO-upgrade-for-touch-screen-support.patch

#
# Touch screen fixes: update TSC driver to latest version
Patch55: 0053-CrossvilleLapis-BSP-linux-2.6.37-touch-screen-driver-updates.patch

#
# Fix the mapper driver to load TSC2007 on Crossvillle
Patch56: 0054-CrossvilleLapis-BSP-linux-2.6.37-mapper-updates.patch

#
# Upgrade DMA driver to ROHM relese from 20120329
Patch57: 0055-CrossvilleLapis-BSP-linux-2.6.37-ROHM-DMA-20120329-v1.4.0.patch

#
# Fix IOH Video In and Video 4 Linux dependency issues
Patch58: 0056-CrossvilleLapis-BSP-linux-2.6.37-ioh_video_in_dependecy_fix.patch

#
# Upgrade I2S and SND drivers to ROHM relese from 20120329
Patch59: 0057-CrossvilleLapis-BSP-linux-2.6.37-ROHM-I2S_SND-20120329-v1.3.0.patch

#
# Upgrade PHUB driver to ROHM relese from 20120329
Patch60: 0058-CrossvilleLapis-BSP-linux-2.6.37-ROHM-PHUB-20120329-v1.2.0.patch

#
# Upgrade USBDEV driver to ROHM relese from 20120329
Patch61: 0059-CrossvilleLapis-BSP-linux-2.6.37-ROHM-USBDEV-20120329-v1.1.0.patch

#
# Upgrade SPI driver to ROHM relese from 20120329
Patch62: 0060-CrossvilleLapis-BSP-linux-2.6.37-ROHM-SPI-20120329-v1.3.0.patch

#
# Upgrade UART driver to ROHM relese from 20120329
Patch63: 0061-CrossvilleLapis-BSP-linux-2.6.37-ROHM-UART-20120329-v1.2.0.patch

#
# UART driver updates
Patch64: 0062-CrossvilleLapis-BSP-linux-2.6.37-UART-modifications.patch

#
# Update I2C driver to support setting speed of each bus individualy
Patch65: 0063-CrossvilleLapis-BSP-linux-2.6.37-I2C-set-custom-bus-speed.patch

#
# Add patch to always select HID interface for Apple devices
Patch66: 0064-CrossvilleLapis-BSP-linux-2.6.37-Select-HID-USB-Class-for-Apple-devices.patch

#
# Add audio codecs support for the Denso 3S board
Patch67: 0065-CrossvilleLapis-BSP-linux-2.6.37-ml7213-ioh-d3s_config.patch
Patch68: 0066-CrossvilleLapis-BSP-linux-2.6.37-ml7213-ioh-d3s_driver.patch

#
# Persistent Memeory driver fixes & updates
Patch69: 0067-CrossvilleLapis-BSP-linux-2.6.37-persistent_memory_fixes.patch
Patch70: 0068-CrossvilleLapis-BSP-linux-2.6.37-persistent-memory-add-debug-option.patch
Patch71: 0069-CrossvilleLapis-BSP-linux-2.6.37-persistent-memory-add-LOADTORAM-ioctl.patch


#
# Modify I2S buffer threshold value to fix audio issue with pulseaudio
Patch72: 0070-CrossvilleLapis-BSP-linux-2.6.37-ml7213-ioh-d3s_buffer-threshold-fix.patch

#
# Fix 'Invalid iomem size' error message condition
Patch73: 0071-CrossvilleLapis-BSP-linux-2.6.37-fix-invalid-iomem-size-error-message-condition.patch

#
# Fix I2S overrun/underrun issues at audio playback
Patch74: 0072-CrossvilleLapis-BSP-linux-2.6.37-ioh-i2s_underrun-and-overrun-fix.patch

#
# Fastboot related patches
Patch100: 0100-CrossvilleLapis-BSP-linux-2.6.37-fastboot-aufs2-kbuild.patch
Patch101: 0101-CrossvilleLapis-BSP-linux-2.6.37-fastboot-aufs2-base.patch
Patch102: 0102-CrossvilleLapis-BSP-linux-2.6.37-fastboot-proc_map.patch
Patch103: 0103-CrossvilleLapis-BSP-linux-2.6.37-fastboot-aufs2-standalone.patch
Patch104: 0104-CrossvilleLapis-BSP-linux-2.6.37-fastboot-aufs2-core-files.patch
Patch105: 0105-CrossvilleLapis-BSP-linux-2.6.37-fastboot-early-mmc.patch
# End of Fastboot related patches
#

# EFI init memory mapping
Patch106: 0106-CrossvilleLapis-BSP-linux-2.6.37-efi-init_memory_mapping.patch
Patch107: 0107-CrossvilleLapis-BSP-linux-2.6.37-efi-bad_kernel_paging_request_fix_2GB.patch

BuildRoot: %{_tmppath}/kernel-%{KVERREL}-root

#
# This macro creates a kernel-<subpackage>-devel package.
#	%%kernel_devel_package <subpackage> <pretty-name>
#
%define kernel_devel_package() \
%package -n kernel-%{?1:%{1}-}devel\
Summary: Development package for building kernel modules to match the %{?2:%{2} }kernel\
Group: System/Kernel\
Provides: kernel%{?1:-%{1}}-devel = %{version}-%{release}\
Provides: kernel-devel = %{version}-%{release}%{?1:-%{1}}\
Provides: kernel-devel = %{version}-%{release}%{?1:-%{1}}\
Provides: kernel-devel-uname-r = %{KVERREL}%{?1:-%{1}}\
Requires: kernel%{?1:-%{1}} = %{version}-%{release}\
Requires: hardlink \
AutoReqProv: no\
Requires(pre): /usr/bin/find\
%description -n kernel%{?1:-%{1}}-devel\
This package provides kernel headers and makefiles sufficient to build modules\
against the %{?2:%{2} }kernel package.\
%{nil}

#
# This macro creates a kernel-<subpackage> and its -devel too.
#	%%define variant_summary The Linux kernel compiled for <configuration>
#	%%kernel_variant_package [-n <pretty-name>] <subpackage>
#
%define kernel_variant_package(n:) \
%package -n kernel-%1\
Summary: %{variant_summary}\
Group: System/Kernel\
%kernel_reqprovconf\
%{nil}


# First the auxiliary packages of the main kernel package.
%kernel_devel_package



# Now, each variant package.

%ifarch %all_x86


%define variant_summary Kernel for Mooresetown and Medfield
%kernel_devel_package android-intel-crossville_lapis-fastboot
%description -n kernel-android-intel-crossville_lapis-fastboot
This package contains the kernel optimized for the Moorsetown platform

%endif

%package -n perf
Summary: The 'perf' performance counter tool
Group: System/Performance

%description -n perf
This package provides the "perf" tool that can be used to monitor performance counter events
as well as various kernel internal events.
Obsoletes: oprofile <= 0.9.5

%prep

# First we unpack the kernel tarball.
# If this isn't the first make prep, we use links to the existing clean tarball
# which speeds things up quite a bit.

# Update to latest upstream.
%if 0%{?released_kernel}
%define vanillaversion 2.6.%{base_sublevel}
# released_kernel with stable_update available case
%if 0%{?stable_update}
%define vanillaversion 2.6.%{base_sublevel}.%{stable_update}
%endif
# non-released_kernel case
%else
%if 0%{?rcrev}
%define vanillaversion 2.6.%{upstream_sublevel}-rc%{rcrev}
%endif
%else
# pre-{base_sublevel+1}-rc1 case
%endif


#
# Unpack the kernel tarbal
#
%setup -q -c
cd android-%{kversion}

%patch00 -p1

#
# Then apply all the patches
#
# Reminder of the patch filename format:
# linux-<version it is supposed to be upstream>-<description-separated-with-dashes>.patch
#

#
# Stable patches - critical bugfixes
#
# linux-2.6.38-btrfs-page-count.patch
%patch1 -p1
# linux-2.6.38-btrfs-handle-no-mem.patch
%patch2 -p1
# linux-2.6.38-btrfs-copy-from-user.patch
%patch3 -p1

# linux-2.6.37-fatal-signals.patch
%patch4 -p1

# linux-2.6.37-tsc2007.patch
%patch5 -p1
# End of the stable patches
#


#
# EG20T(Topcliff) and ML7213 IOH Patches
#
# linux-2.6.37-ml7213-0001-phub.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch8 -p1
# linux-2.6.37-ml7213-0002-spi.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch9 -p1
# linux-2.6.37-ml7213-0003-gpio.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch10 -p1
# linux-2.6.37-ml7213-0004-i2s.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch11 -p1
# linux-2.6.37-ml7213-0005-mlb.patch
%patch12 -p1
# linux-2.6.37-ml7213-0006-snd.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch13 -p1
# linux-2.6.37-ml7213-0007-video_in.patch
%patch14 -p1
# linux-2.6.37-ml7213-0008-ioh_video_in-20110629-delete-invalid-definition-PCI_DEVICE_ID.patch
%patch15 -p1
# linux-2.6.37-ml7213-eg20t-0001-i2c.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch16 -p1
# linux-2.6.37-ml7213-eg20t-0002-usbdev.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch17 -p1
# linux-2.6.37-ml7213-eg20t-0003-uart.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch18 -p1
# linux-2.6.37-ml7213-eg20t-0004-dma.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch19 -p1
# linux-2.6.37-ml7213-eg20t-0005-gbe.patch
%patch20 -p1
# linux-2.6.37-ml7213-eg20t-0006-uart.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch21 -p1
# linux-2.6.37-ml7213-eg20t-0007-fix-dma-issue-for-ch8-11.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch22 -p1
# linux-2.6.37-ml7213-eg20t-0008-i2c-eg20t-20110629-Fix-the-issue-combined-access.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch23 -p1
# End of EG20T and ML7213 Patches
#

#
# EMGD patches
#
# 0042-CrossvilleLapis-BSP-linux-2.6.37-emgd-add-makefile.patch 
%patch24 -p1
# 0043-CrossvilleLapis-BSP-linux-2.6.37-emgd-3243.patch
%patch25 -p1
#
# End of EMGD Patches
#

#
# Russellville patches
#
# linux-2.6.37-adjust-adv7180-timblogiw-to-be-NTSC.patch
# %patch27 -p1
# linux-2.6.37-rv-add-timblogiw.patch
%patch29 -p1
# linux-2.6.37-rv-fix-tx-cache-issue-ks8842.patch
%patch30 -p1
# linux-2.6.37-timberdale-enable-devices.patch
%patch31 -p1
# linux-2.6.37-timb-radio-pickup-dsp.patch
%patch32 -p1

#
# Kernel CVE patches
# linux-2.6.37-cve-0001-Treat-writes-as-new-when-holes-span-across-page-boun.patch
%patch33 -p1
#
# End of Kernel CVE patches

#
# Lapis (OKI) patches
# linux-2.6.37-ml7213-i2c-eg20t-20110701-Fix-unnecessary-error-message-issue.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch34 -p1
# linux-2.6.37-ml7213-ioh_i2s-20110701-Fix-register-setting-issue.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch35 -p1
# linux-2.6.37-ml7213-pch_dma-20110701-1of3-Fix-video-channel-issue.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch36 -p1
# linux-2.6.37-ml7213-pch_dma-20110701-3of3-Fix-spin_lock-usage-issue.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch37 -p1
# linux-2.6.37-ml7213-snd-ml7213-20110701-1of2-Add-Wind-River-for-copyright.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch38 -p1
# linux-2.6.37-ml7213-snd-ml7213-20110701-2of2-Add-I2C-Control.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch39 -p1
# linux-2.6.37-ml7213-spi_topcliff_pch-20110701-Replaced-upstreamed-version.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch40 -p1
# linux-2.6.37-video-input-driver-cv-oki.patch
%patch41 -p1
# linux-2.6.37-mapper.patch
%patch42 -p1
# linux-2.6.37-pch-uart-serial-console.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch43 -p1
# linux-2.6.37-pch-uart-clock-modification.patch
### Disabled by upgrade to ROHM 20120329 release ### %patch44 -p1
# add-mmc-password-protection-lock-unlock-support-for-linux.patch
%patch45 -p1

#
# Emgd video bridge patches
#
# 0044-CrossvilleLapis-BSP-linux-2.6.37-emgd-3243_v2g_bridge.patch
%patch26 -p1


#
# End of EMGD Patches
#

#
# Persistent Memory for DENSO
%patch48 -p1

#
# MTD driver update for Bootloader Update support
%patch49 -p1

#
# USB OverCurrent and VBUS power control
%patch50 -p1

#
# Add GPIO support for Intel Tunnel Creek
%patch51 -p1

#
# Upgrade I2C driver to ROHM release from 20120329
%patch52 -p1

#
# Upgrade GPIO driver to ROHM release from 20120329
%patch53 -p1

#
# Backport GPIO fixes for Crossville from upstream kernel
%patch54 -p1

#
# Touch screen fixes: update TSC driver to latest version
%patch55 -p1

#
# Fix the mapper driver to load TSC2007 on Crossvillle
%patch56 -p1

#
# Upgrade DMA driver to ROHM relese from 20120329
%patch57 -p1

#
# 0041-CrossvilleLapis-BSP-linux-2.6.37-dma-video-bridge.patch
%patch46 -p1

#
# 0045-CrossvilleLapis-BSP-lin~-emgd-video-in-compat.patch
%patch47 -p1

#
# Fix IOH Video In and Video 4 Linux dependency issues
%patch58 -p1

#
# Upgrade I2S and SND drivers to ROHM relese from 20120329
%patch59 -p1

# linux-2.6.37-rv-add-timbi2s.patch
%patch28 -p1

#
# Upgrade PHUB driver to ROHM relese from 20120329
%patch60 -p1

#
# Upgrade USBDEV driver to ROHM relese from 20120329
%patch61 -p1

#
# Upgrade SPI driver to ROHM relese from 20120329
%patch62 -p1

#
# Upgrade UART driver to ROHM relese from 20120329
%patch63 -p1

#
# Add Wind River UART modifications
%patch64 -p1

#
# Update I2C driver to support setting speed of each bus individualy
%patch65 -p1

#
# Add patch to always select HID interface for Apple devices
%patch66 -p1

#
# Add audio codecs support for the Denso 3S board
%patch67 -p1
%patch68 -p1

#
# Persistent Memory driver fixes
%patch69 -p1

#
# Enable Persistent Memory driver debug information
%patch70 -p1

#
# Add the LOADTORAM ioctl support to Persistent Memory
%patch71 -p1

#
# Modify I2S buffer threshold value to fix audio issue with pulseaudio
%patch72 -p1

#
# Fix 'Invalid iomem size' error message condition
%patch73 -p1

#
# Fix I2S overrun/underrun issues at audio playback
%patch74 -p1

# End of Lapis (OKI) patches
#

#
# Fastboot related patches
# Aufs-2.2-37
%patch100 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
# early_mmc patch
%patch105 -p1
# End of Fastboot related patches
#

# EFI init memory mapping
%patch106 -p1
%patch107 -p1

mkdir configs
%if 0%{?kernel_type_debug}
cp %{SOURCE100} .
%define kernel_type	debug
%else
cp %{SOURCE101} .
%define kernel_type	fastboot
%endif

#
# We want to run the config checks of all configurations for all architectures always.
# That way, developers immediately found out if they forget to enable not-their-native
# architecture. It's cheap to run anyway.
#

# now run oldconfig over all the config files
for i in kernel-*.config
do
  mv $i .config
  Arch="x86"

  #get ARCH from .config file for other platforms
  if [ `cat .config | grep -c CONFIG_ARM=y` -eq 1 ]; then
    Arch="arm"
  fi

  # make oldconfig > /dev/null
  echo Doing $i

  make ARCH=$Arch listnewconfig &> /tmp/configs
  export conf=`cat /tmp/configs | grep CONFIG | wc -l`
  echo CONF is $conf
  if [ $conf -gt 0 ]; then
	  make ARCH=$Arch listnewconfig  
	  exit 1
  fi
  make ARCH=$Arch oldconfig > /dev/null
  echo "# $Arch" > configs/$i
  cat .config >> configs/$i
done

#
# get rid of unwanted files resulting from patch fuzz
# (not that we can have any)
#
find . \( -name "*.orig" -o -name "*~" \) -exec rm -f {} \; >/dev/null

cd ..


###
### build
###
%build


cp_vmlinux()
{
  eu-strip --remove-comment -o "$2" "$1"
}

BuildKernel() {
    MakeTarget=$1
    KernelImage=$2
    TargetArch=$3
    ConfigFlavour=$4
    Flavour=${ConfigFlavour}-fastboot
    InstallName=${5:-vmlinuz}

    # Pick the right config file for the kernel we're building
    Config=kernel${ConfigFlavour:+-${ConfigFlavour}}-%{kernel_type}.config
    DevelDir=/usr/src/kernels/%{KVERREL}${Flavour:+-${Flavour}}

    # When the bootable image is just the ELF kernel, strip it.
    # We already copy the unstripped file into the debuginfo package.
    if [ "$KernelImage" = vmlinux ]; then
      CopyKernel=cp_vmlinux
    else
      CopyKernel=cp
    fi

    KernelVer=%{version}-%{release}${Flavour:+-${Flavour}}
    ExtraVer=%{?stablerev}%{?rctag}-%{release}${Flavour:+-${Flavour}}
    Arch="x86"
%ifarch %{all_arm}
    Arch="arm"
%endif


    if [ "$Arch" = "$TargetArch" ]; then
        echo BUILDING A KERNEL FOR ${Flavour} %{_target_cpu}... ${KernelVer}
        echo USING ARCH=$Arch

        # make sure EXTRAVERSION says what we want it to say
        perl -p -i -e "s/^EXTRAVERSION.*/EXTRAVERSION = ${ExtraVer}/" Makefile

        # and now to start the build process

        make -s mrproper
        cp configs/$Config .config

        make -s ARCH=$Arch oldconfig > /dev/null
        make -s CONFIG_DEBUG_SECTION_MISMATCH=y ARCH=$Arch %{?_smp_mflags} $MakeTarget %{?sparse_mflags}
        make -s CONFIG_DEBUG_SECTION_MISMATCH=y ARCH=$Arch %{?_smp_mflags} modules %{?sparse_mflags} || exit 1

        # Start installing the results
        mkdir -p $RPM_BUILD_ROOT/%{image_install_path}
        install -m 644 .config $RPM_BUILD_ROOT/boot/config-$KernelVer
        install -m 644 System.map $RPM_BUILD_ROOT/boot/System.map-$KernelVer
        touch $RPM_BUILD_ROOT/boot/initrd-$KernelVer.img
        if [ -f arch/$Arch/boot/zImage.stub ]; then
          cp arch/$Arch/boot/zImage.stub $RPM_BUILD_ROOT/%{image_install_path}/zImage.stub-$KernelVer || :
        fi
        $CopyKernel $KernelImage \
        		$RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer
        chmod 755 $RPM_BUILD_ROOT/%{image_install_path}/$InstallName-$KernelVer

        mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer
        make -s ARCH=$Arch INSTALL_MOD_PATH=$RPM_BUILD_ROOT modules_install KERNELRELEASE=$KernelVer
%ifnarch %{all_arm}
        make -s ARCH=$Arch INSTALL_MOD_PATH=$RPM_BUILD_ROOT vdso_install KERNELRELEASE=$KernelVer
%endif

        # And save the headers/makefiles etc for building modules against
        #
        # This all looks scary, but the end result is supposed to be:
        # * all arch relevant include/ files
        # * all Makefile/Kconfig files
        # * all script/ files

        rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/source
        mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        (cd $RPM_BUILD_ROOT/lib/modules/$KernelVer ; ln -s build source)
        # dirs for additional modules per module-init-tools, kbuild/modules.txt
        # first copy everything
        cp --parents `find  -type f -name "Makefile*" -o -name "Kconfig*"` $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        cp Module.symvers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        cp System.map $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        if [ -s Module.markers ]; then
          cp Module.markers $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        fi
        # then drop all but the needed Makefiles/Kconfig files
        rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Documentation
        rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts
        rm -rf $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
        cp .config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        cp -a scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
        if [ -d arch/%{_arch}/scripts ]; then
          cp -a arch/%{_arch}/scripts $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch} || :
        fi
        if [ -f arch/%{_arch}/*lds ]; then
          cp -a arch/%{_arch}/*lds $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/arch/%{_arch}/ || :
        fi
        rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*.o
        rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/scripts/*/*.o
        cp -a --parents arch/$Arch/include $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
%ifarch %{all_arm}
       cp -a --parents arch/arm/mach-*/include $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
       cp -a --parents arch/arm/plat-*/include $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
%endif
        mkdir -p $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include
        cd include
        cp -a acpi asm-generic config crypto drm generated keys linux math-emu media mtd net pcmcia rdma rxrpc scsi sound video trace xen $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include

        # Make sure the Makefile and version.h have a matching timestamp so that
        # external modules can be built
        touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/Makefile $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/version.h
        touch -r $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/linux/autoconf.h
        # Copy .config to include/config/auto.conf so "make prepare" is unnecessary.
        cp $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/.config $RPM_BUILD_ROOT/lib/modules/$KernelVer/build/include/config/auto.conf
        cd ..

        #
        # save the vmlinux file for kernel debugging into the kernel-*-devel rpm
        #

        cp vmlinux $RPM_BUILD_ROOT/lib/modules/$KernelVer

        find $RPM_BUILD_ROOT/lib/modules/$KernelVer -name "*.ko" -type f >modnames

        # mark modules executable so that strip-to-file can strip them
        xargs --no-run-if-empty chmod u+x < modnames

        # Generate a list of modules for block and networking.

        fgrep /drivers/ modnames | xargs --no-run-if-empty nm -upA |
        sed -n 's,^.*/\([^/]*\.ko\):  *U \(.*\)$,\1 \2,p' > drivers.undef

        collect_modules_list()
        {
          sed -r -n -e "s/^([^ ]+) \\.?($2)\$/\\1/p" drivers.undef |
          LC_ALL=C sort -u > $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.$1
        }

        collect_modules_list networking \
        			 'register_netdev|ieee80211_register_hw|usbnet_probe'
        collect_modules_list block \
        			 'ata_scsi_ioctl|scsi_add_host|blk_init_queue|register_mtd_blktrans'

        # remove files that will be auto generated by depmod at rpm -i time
        for i in alias ccwmap dep ieee1394map inputmap isapnpmap ofmap pcimap seriomap symbols usbmap
        do
          rm -f $RPM_BUILD_ROOT/lib/modules/$KernelVer/modules.$i
        done

        # Move the devel headers out of the root file system
        mkdir -p $RPM_BUILD_ROOT/usr/src/kernels
        mv $RPM_BUILD_ROOT/lib/modules/$KernelVer/build $RPM_BUILD_ROOT/$DevelDir
        ln -sf ../../..$DevelDir $RPM_BUILD_ROOT/lib/modules/$KernelVer/build
    fi
}

###
# DO it...
###

# prepare directories
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/boot

cd android-%{kversion}

BuildKernel %make_target %kernel_image x86 android-intel-crossville_lapis

#
# Build the perf utility
#
pushd tools/perf >/dev/null
    unset LD_AS_NEEDED
    chmod a+x util/generate-cmdlist.sh
    make %{?_smp_mflags}
popd >/dev/null

###
### install
###

%define install  %{?_enable_debug_packages:%{?buildsubdir:%{debug_package}}}\
%%install


%install

cd android-%{kversion}

rm -rf $RPM_BUILD_ROOT/lib/firmware

#
# Install the perf utility
#
pushd tools/perf >/dev/null
    make DESTDIR=$RPM_BUILD_ROOT	install
    mkdir -p				$RPM_BUILD_ROOT/usr/bin/
    mkdir -p				$RPM_BUILD_ROOT/usr/libexec/
    mv $RPM_BUILD_ROOT/bin/*		$RPM_BUILD_ROOT/usr/bin/
    mv $RPM_BUILD_ROOT/libexec/*	$RPM_BUILD_ROOT/usr/libexec/
popd >/dev/null

#
# Install the ROHM readme files
#
mkdir -p				$RPM_BUILD_ROOT/usr/share/doc/
tar xjf %{SOURCE200} -C			$RPM_BUILD_ROOT/usr/share/doc/


###
### clean
###

%clean
rm -rf $RPM_BUILD_ROOT

###
### scripts
###

#
# This macro defines a %%post script for a kernel*-devel package.
#	%%kernel_devel_post <subpackage>
#
%define kernel_devel_post() \
%{expand:%%post -n kernel-%{?1:%{1}-}devel}\
if [ -x /usr/sbin/hardlink ]\
then\
    (cd /usr/src/kernels/%{KVERREL}%{?1:-%{1}} &&\
     /usr/bin/find . -type f | while read f; do\
       hardlink -c /usr/src/kernels/*/$f $f\
     done)\
fi
%{nil}

# This macro defines a %%posttrans script for a kernel package.
#	%%kernel_variant_posttrans [-v <subpackage>] [-s <s> -r <r>] <mkinitrd-args>
# More text can follow to go at the end of this variant's %%post.
#
%define kernel_variant_posttrans(s:r:v:) \
%{expand:%%posttrans -n kernel-%{?-v*}}\
 /sbin/new-kernel-pkg --package kernel%{?-v:-%{-v*}} --rpmposttrans %{KVERREL}%{?-v:-%{-v*}} || exit $?\
%{nil}

#
# This macro defines a %%post script for a kernel package and its devel package.
#	%%kernel_variant_post [-v <subpackage>] [-s <s> -r <r>] <mkinitrd-args>
# More text can follow to go at the end of this variant's %%post.
#
%define kernel_variant_post(s:r:v:) \
%{expand:%%kernel_devel_post %{?-v*}}\
%{expand:%%kernel_variant_posttrans %{?-v*}}\
%{expand:%%post -n kernel-%{?-v*}}\
/sbin/depmod -ae -F /boot/System.map-%{KVERREL}%{?-v:-%{-v*}} %{KVERREL}%{?-v:-%{-v*}}\
%{nil}
# /sbin/new-kernel-pkg --package kernel%{?-v:-%{-v*}} --depmod %{*} %{KVERREL}%{?-v:-%{-v*}} || exit $?\

#
# This macro defines a %%preun script for a kernel package.
#	%%kernel_variant_preun <subpackage>
#
%define kernel_variant_preun() \
%{expand:%%preun -n kernel-%{?1}}\
rm -rf /lib/modules/%{KVERREL}%{?1:-%{1}}/modules.*\
%{nil}
# /sbin/new-kernel-pkg --rmmoddep %{KVERREL}%{?1:-%{1}} || exit $?\

%ifarch %all_x86

%kernel_variant_preun android-intel-crossville_lapis-fastboot
%kernel_variant_post -v android-intel-crossville_lapis-fastboot

%endif


###
### file lists
###



#
# This macro defines the %%files sections for a kernel package
# and its devel packages.
#	%%kernel_variant_files [-k vmlinux] [-a <extra-files-glob>] [-e <extra-nonbinary>] <condition> <subpackage>
#
%define kernel_variant_files(a:e:k:) \
%ifarch %{1}\
%{expand:%%files -n kernel%{?2:-%{2}}}\
%defattr(-,root,root)\
/%{image_install_path}/%{?-k:%{-k*}}%{!?-k:vmlinuz}-%{KVERREL}%{?2:-%{2}}\
/boot/System.map-%{KVERREL}%{?2:-%{2}}\
#/boot/symvers-%{KVERREL}%{?2:-%{2}}.gz\
/boot/config-%{KVERREL}%{?2:-%{2}}\
%{?-a:%{-a*}}\
%dir /lib/modules/%{KVERREL}%{?2:-%{2}}\
/lib/modules/%{KVERREL}%{?2:-%{2}}/kernel\
/lib/modules/%{KVERREL}%{?2:-%{2}}/build\
/lib/modules/%{KVERREL}%{?2:-%{2}}/source\
%ifnarch %{all_arm}\
/lib/modules/%{KVERREL}%{?2:-%{2}}/vdso\
%endif\
/lib/modules/%{KVERREL}%{?2:-%{2}}/modules.block\
/lib/modules/%{KVERREL}%{?2:-%{2}}/modules.dep.bin\
/lib/modules/%{KVERREL}%{?2:-%{2}}/modules.alias.bin\
/lib/modules/%{KVERREL}%{?2:-%{2}}/modules.symbols.bin\
/lib/modules/%{KVERREL}%{?2:-%{2}}/modules.networking\
/lib/modules/%{KVERREL}%{?2:-%{2}}/modules.order\
/lib/modules/%{KVERREL}%{?2:-%{2}}/modules.builtin*\
%ghost /boot/initrd-%{KVERREL}%{?2:-%{2}}.img\
%{?-e:%{-e*}}\
%{expand:%%files -n kernel-%{?2:%{2}-}devel}\
%defattr(-,root,root)\
%verify(not mtime) /usr/src/kernels/%{KVERREL}%{?2:-%{2}}\
/lib/modules/%{KVERREL}%{?2:-%{2}}/vmlinux \
%endif\
/usr/share/doc/*\
%{nil}

%files -n perf
/usr/bin/perf
/usr/libexec/perf-core/

%kernel_variant_files %all_x86 android-intel-crossville_lapis-fastboot

%changelog
* Tue Feb 5 2013 George Cristea <george.cristea@windriver.com>
- Update EMGD to 3320 version
* Fri Jan 11 2013 Andrei Zlate <andrei.zlate@windriver.com>
- Fix I2S underrun/overrun at audio playback
* Tue Dec 19 2012 Dragos Stoica <dragos.stoica@windriver.com>
- Update EMGD to version 3280
* Wed Dec 12 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Fix 'Invalid iomem size' error message condition
* Tue Nov 13 2012 Geroge Cristea <george.cristea@windriver.com
- Updating EMGD to version 3243
* Fri Nov 2 2012 George Cristea <george.cristea@windriver.com>
- Adding 2GB efi memory map fix
* Mon Oct 08 2012 George Cristea <george.cristea@windriver.com>
- Updating EMGD to version 3210
* Wed Sep 19 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Persistent Memory - add the LOADTORAM ioctl
* Mon Sep 3 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Persistent Memory - use 48 bio pages when built as module
- Persistent Memory - add debugging support when built for rootfs
* Mon Aug 6 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Add Persistent Memory fixes patch
* Wed Jun 27 2012 Dragos Stoica <george.cristea@windriver.com>
- Updating EMGD to version 3010
* Fri May 25 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Add audio codecs support for the Denso 3S board
* Thu May 22 2012 George Cristea <george.cristea@windriver.com>
- Updating EMGD to version 2524
* Fri Apr 27 2012 Thomas Bandelier <thomas.bandelier@windriver.com>
- Select HID interface by default for Apple devices
* Fri Apr 13 2012 George Cristea <george.cristea@windriver.com>
- Update EMGD to version 2448
* Tue Apr 10 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Enabled the post rules - run depmod for the new kernel
* Thu Apr 5 2012 George Cristea <george.cristea@windriver.com>
- Update EMGD to version 2437 and adding fix for AXE badPage error
* Tue Apr 04 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Upgraded ROHM drivers to release 20120329
- Updated video bridge, timberdale i2s and mapper drivers
- Added the ROHM readme files in the kernel RPM
* Mon Mar 26 2012 George Cristea <george.cristea@windriver.com>
- Update EMGD to version 2412
* Tue Mar 15 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Update EMGD to version 2393
* Tue Mar 15 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Adding ROHM update patches for I2C, DMA and UART
- Adding GPIO update based on upstream code
- Adding TSC2007 driver update based on upstream code
- Adding Mapper driver update for TSC support
* Fri Mar 09 2012 George Cristea <george.cristea@windriver.com>
- Adding fix for ioh_video_in v4l2 module dependecy 
* Tue Mar 06 2012 Andrei Zlate <andrei.zlate@windriver.com>
- Disable post/preun scripts to enable compatibility with elilo
* Fri Feb 24 2012 George Cristea <george.cristea@windriver.com>
- Adding emgd 2345 release
* Fri Feb 17 2012 George Cristea <george.cristea@windriver.com>
- Adding emgd 2329 release
* Tue Jan 17 2012 George Cristea <george.cristea@windriver.com>
- Adding emgd 2283 release
* Sun Jan 15 2012 Dragos Stoica<dragos.stoica@windriver.com>
- Integrating AUFS2 & adding early_mmc patch
* Fri Jan 13 2012 George Cristea <george.cristea@windriver.com>
- Adding emgd 2278 release
* Tue Dec 16 2011 Andrei Zlate <andrei.zlate@windriver.com>
- Fix kernel config selection (standard/debug)
* Tue Dec 13 2011 George Cristea <george.cristea@windriver.com>
- Add emgd 2248 and video bridge driver (emgd EC7+)
* Mon Dec 12 2011 Andrei Zlate <andrei.zlate@windriver.com>
- Add option to build standard/debug kernels
* Tue Nov 29 2011 Andrei Zlate <andrei.zlate@windriver.com>
- Build and create the perf package
- Initial integration of the Android 2.6.37 kernel
* Thu Oct 20 2011 George Cristea <george.cristea@windriver.com>
- Adding EMGD EC5 - 2156 and video_bridge driver
* Wed Oct 12 2011 Andrei Zlate <andrei.zlate@windriver.com>
- Replace Oki with Lapis as the company name changed
* Fri Aug 19 2011 Andrei Zlate <andrei.zlate@windriver.com>
- Upgrade EMGD kernel module from build 2061 to build 2080
- Add provides for the EMGD DRM kernel module version
* Tue Aug 16 2011 Andrei Zlate <andrei.zlate@windriver.com>
- Update kernel and config file for the fastboot kernel
- Add lzo and lzop dependencies
* Wed Aug 10 2011 Andrei Zlate <andrei.zlate@windriver.com>
- Update kernel and config file names to differentiate from MeeGo's standard automotive kernel
* Wed Jul 27 2011 George Cristea <george.cristea@windriver.com>
- Stability patches & updates
* Wed Jul 20 2011 George Cristea <george.cristea@windriver.com>
- Initial integration for Logan
* Fri May  6 2011 Qi Wang <qi.wang@intel.com> - 2.6.37.6
- BMC #16655.
- Add linux-2.6.37-ml7213-eg20t-0005-gbe.patch to fix MAC address issue.
* Tue May  3 2011 Qi Wang <qi.wang@intel.com> - 2.6.37.6
- FEA 16194
- Update the following patches
  - linux-2.6.37-ml7213-0001-phub.patch
  - linux-2.6.37-ml7213-0002-spi.patch
  - linux-2.6.37-ml7213-0003-gpio.patch
  - linux-2.6.37-ml7213-0006-snd.patch
  - linux-2.6.37-ml7213-eg20t-0001-i2c.patch
  - linux-2.6.37-ml7213-eg20t-0002-usbdev.patch
  - linux-2.6.37-ml7213-eg20t-0003-uart.patch
  - linux-2.6.37-ml7213-eg20t-0004-dma.patch
  from http://sourceforge.net/projects/ml7213/files/Kernel%%202.6.37/Release/Ver%%201.0.0/
* Thu Apr 21 2011 Richard Röjfors <richard.rojfors@pelagicore.com> - 2.6.37.6
- Added Russellville support
* Thu Apr 21 2011 Qi Wang <qi.wang@intel.com> - 2.6.37.6
- FEA 16194
- Update the following patches
  - linux-2.6.37-ml7213-0004-i2s.patch
  - linux-2.6.37-ml7213-0005-mlb.patch
  - from http://sourceforge.net/projects/ml7213/files/Kernel%%202.6.37/Release/Ver%%201.0.0/
  - linux-2.6.37-ml7213-0006-snd.patch
  - linux-2.6.37-ml7213-0007-video_in.patch
  - from http://sourceforge.net/projects/ml7213/files/Kernel%%202.6.37/Release/Ver%%201.0.0/
* Tue Apr 19 2011 Qi Wang <qi.wang@intel.com> - 2.6.37.6
- FEA 16194.
- Update the patches from kernel-adaptation-intel-automotive 2.6.25.10 to 2.6.37.6
  - linux-2.6.38-btrfs-page-count.patch
  - linux-2.6.38-btrfs-handle-no-mem.patch
  - linux-2.6.38-btrfs-copy-from-user.patch
  - linux-2.6.37-fatal-signals.patch
  - linux-2.6.37-tsc2007.patch
  - linux-2.6.37-mapper.patch
* Mon Apr 18 2011 Qi Wang <qi.wang@intel.com> - 2.6.37.6
- FEA 16194.
- Update kernel-adaptation-intel-automotive to 2.6.37.6
- Update EMGD drivers to 2.6.37.6
- Without RV platform support.
- linux-2.6.37-ml7213-0001-phub.patch.
  - http://sourceforge.net/projects/ml7213/files/MeeGo1.1/Drivers/Packet HUB
  - Upgrage to 2.6.37.6.
  - Kernel 2.6.37.6 supports EG20T phub driver.
- linux-2.6.37-ml7213-0002-spi.patch.
  - Source from kernel-adaptation-intel-automotive 2.6.35.10
  - Upgrade to 2.6.37.6
  - Kernel 2.6.37.6 partially supports EG20T SPI driver.
- linux-2.6.37-ml7213-0003-gpio.patch.
  - Source from kernel-adaptation-intel-automotive 2.6.35.10
  - Upgrade to 2.6.37.6
  - Kernel 2.6.37.6 supports EG20T gpio driver.
- linux-2.6.37-ml7213-eg20t-0001-i2c.patch.
  - Source from kernel-adaptation-intel-automotive 2.6.35.10
  - Upgrade to 2.6.37.6
  - Including EG20T i2c patch.
- linux-2.6.37-ml7213-eg20t-0002-usbdev.patch.
  - git log -p f646cf94520e22cb11eb5d2e9a35b33bfe4bea1b
  - Backport to 2.6.37.6
  - Including EG20T usvdev driver.
- linux-2.6.37-ml7213-eg20t-0003-uart.patch.
  - Source from kernel-adaptation-intel-automotive 2.6.35.10
  - Upgrade to 2.6.37.6
  - Including EG20T uart driver.
- linux-2.6.37-ml7213-eg20t-0004-dma.patch.
  - http://sourceforge.net/projects/ml7213/files/MeeGo1.1/Drivers/DMA/
  - Upgrade to 2.6.37.6
  - Including EG20T dma driver.
- linux-2.6.37-emgd-0001-add-makefile.patch
  - Source from kernel-adaptation-intel-automotive 2.6.35.10
  - Upgrade to 2.6.37.6
- linux-2.6.37-emgd-0002-1893-build.patch
  - Source from kernel-adaptation-intel-automotive 2.6.35.10
  - Upgrade to 2.6.37.6
- linux-2.6.37-emgd-0003-1922-build.patch
  - Source from kernel-adaptation-intel-automotive 2.6.35.10
  - Upgrade to 2.6.37.6
* Fri Apr 15 2011 Liu,Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- Fixed BMC #15904. Updated EMGD to ECG 1922 build
* Fri Apr  8 2011 Richard Röjfors <richard.rojfors@pelagicore.com> - 2.6.35.10
- Added timb-radio patch to fix tuner and DSP detection issues.
* Thu Mar 31 2011 Austin Zhang <austin.zhang@intel.com> - 2.6.35.10
- Removed that workaround for touch event to make it work by new evdev
  ATOM enable patch. (see BMC#15028)
* Mon Mar 21 2011 Austin Zhang <austin.zhang@intel.com> - 2.6.35.10
- Send of BTN_LEFT together with BTN_TOUCH to make tsc2007 work with new
  xinput2.0 in MeeGO. Part of fixing of BMC#12777.
* Fri Mar 18 2011 Liu Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- BMC #14512. Update to EMGD 1.6 EC3 (build 1893).
- Revised patch series to one patch
* Thu Mar 17 2011 Liu Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- BMC #14512. Update to EMGD 1.6 EC3 (build 1893).
- Added STM SDVO support.
* Tue Mar 15 2011 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- BMC #13796 14156 14085 13787 14068 13855
- Fixed CVE bugs.
* Thu Mar  3 2011 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- FEA #12050. Integrates ML7213 drivers to Stephenville.
- Integrates PHUB, DMA, I2C, USBDEV, UART, SPI drivers.
- Integrates IOH_GPIO drivers.
* Sat Feb 26 2011 Liu,Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- BMC #12086. Update EMGD kernel driver to support 2.6.37.
* Sat Feb 26 2011 Liu,Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- BMC #12086. Fixed wrong patch name. It's for ECG 1859 build.
* Tue Feb 22 2011 Liu Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- BMC #12086. Update EMGD kernel driver for 1659 build.
* Mon Feb 14 2011 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Fixexd BMC #13027
* Thu Jan 27 2011 Liu Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- Moved i915/EMGD from generic config to platform config
* Tue Jan 25 2011 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Fixed BMC #12736 12739
- CVE bugs.
* Mon Jan 17 2011 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Fixed BMC #11982 11984 11979
* Fri Jan  7 2011 Liu Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- Fixed BMC #12086. Integrate EMGD kernel driver, 1812 build.
* Fri Jan  7 2011 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Fixed BMC #9241 11912 11955 11964 11965 11966 11967 11968
- Russellville regression
* Thu Jan  6 2011 Liu Xinyun <xinyun.liu@intel.com> - 2.6.35.10
- Fixed BMC #11985. Add intel KMS driver.
* Tue Dec 28 2010 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Remove compat-wireless-2010-10-19.tar.bz2
- Modify kernel.spec.in to remove 'patch-2.6.35.10.bz2' from series file.
* Tue Dec 28 2010 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Add EG20T(Topcliff) patches. Master feature is BCM6862.
- linux-2.6.35-EG20T-phub.patch
- linux-2.6.35-EG20T-gbe.patch
- linux-2.6.35-EG20T-i2c.patch
- linux-2.6.35-EG20T-gpio.patch
- linux-2.6.35-EG20T-spi.patch
- linux-2.6.35-EG20T-usbdev.patch
- linux-2.6.35-EG20T-can.patch
- linux-2.6.35-EG20T-dma.patch
- linux-2.6.35-EG20T-uart.patch
* Thu Dec 23 2010 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Remove config-notebook, config-mid, config-n900, config-arm-n900
- Modify kernel.spec.in to rename kernel-ivi with kernel-adpatation-intel-automotive
* Thu Dec 23 2010 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Add Russellville Patches, fix BCM9210, BCM9241 and BCM9242.
- linux-2.6.35-rv-update-timeb-radio.patch
- linux-2.6.35-rv-update-ks8842.patch
- linux-2.6.35-rv-add-timbi2s.patch
- linux-2.6.35-rv-add-timblogiw.patch
- linux-2.6.35-rv-define-timblogiw-timbi2c-ks8842.patch
- linux-2.6.35-rv-fix-tx-cache-issue-ks8842.patch
* Tue Dec 21 2010 Qi Wang <qi.wang@intel.com> - 2.6.35.10
- Update the kernel ro 2.6.35.10
- Clean up all the unncessary patches.
  * Keep linux-2.6-build-nonintconfig.patch
  * Remove Direct Backport section
  * Remove Moorstown and Medfield architecture patches
  * Remove Kangkai and Yong's patches.
  * Keep all the boot time and power patches, update them to 2.6.35.10
  - Remove linux-2.6.36-powertop-timer-tracing.patch. 2.6.35.10 integrates this patch.
  * Remove multi-touch-input-driver-for-event-devices.patch. Need Ming He's confirmation.
  * Remove enable-hid-dg-contact-count-stantum-and-cando-touch-drivers.patch. Need Priya's confirmation.
