# 
# Do not Edit! Generated by:
# spectacle version 0.17
# 
# >> macros
# << macros

Name:       alsa-lib
Summary:    The Advanced Linux Sound Architecture (ALSA) library
Version:    1.0.23
Release:    1.13
Group:      System/Libraries
License:    LGPLv2+
URL:        http://www.alsa-project.org/
Source0:    ftp://ftp.alsa-project.org/pub/lib/alsa-lib-%{version}.tar.bz2
Source1:    asound.conf
Source100:  alsa-lib.yaml
Requires(post): coreutils
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig


%description
The Advanced Linux Sound Architecture (ALSA) provides audio and MIDI
functionality to the Linux operating system.

This package includes the ALSA runtime libraries to simplify application
programming and provide higher level functionality as well as support for
the older OSS API, providing binary compatibility for most OSS programs.



%package devel
Summary:    Development files from the ALSA library
Group:      Development/Libraries
Requires:   %{name} = %{version}-%{release}

%description devel
The Advanced Linux Sound Architecture (ALSA) provides audio and MIDI
functionality to the Linux operating system.

This package includes the ALSA development libraries for developing
against the ALSA libraries and interfaces.



%prep
%setup -q -n %{name}-%{version}

# >> setup
# << setup

%build
# >> build pre
# << build pre

%configure --disable-static \
    --disable-aload

make %{?jobs:-j%jobs}

# >> build post


# << build post
%install
rm -rf %{buildroot}
# >> install pre
# << install pre
%make_install 

# >> install post
# We need the library to be available even before /usr might be mounted
mkdir -p %{buildroot}/%{_lib}
mv %{buildroot}%{_libdir}/libasound.so.* %{buildroot}/%{_lib}
ln -snf ../../%{_lib}/libasound.so.2 %{buildroot}%{_libdir}/libasound.so

# Install global configuration files
mkdir -p -m 755 %{buildroot}/etc
install -p -m 644 %{SOURCE1} %{buildroot}/etc
# << install post



%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig





%files
%defattr(-,root,root,-)
# >> files
%doc COPYING ChangeLog TODO doc/asoundrc.txt
%config %{_sysconfdir}/asound.conf
/%{_lib}/libasound.so.*
%{_bindir}/aserver
%{_libdir}/alsa-lib/
%{_datadir}/alsa/
# << files


%files devel
%defattr(-,root,root,-)
# >> files devel
%{_includedir}/alsa/
%{_includedir}/sys/asoundlib.h
%{_libdir}/libasound.so
%{_libdir}/pkgconfig/alsa.pc
%{_datadir}/aclocal/alsa.m4
# << files devel

%changelog
* Wed Jun  2 2010 Bin Gao <bin.gao@intel.com> 1.0.23
- Update to 1.0.23
- Remove "Require: alsa-plugins-pulseaudio" which is wrong
* Tue Apr 27 2010 Yan Li <yan.i.li@intel.com> - 1.0.22
- Enable ALSA to use PulseAudio by default so that sounds from
  applications using ALSA can be mixed with sounds from applications
  using PulseAudio (BMC#1108)
* Fri Mar 26 2010 Anas Nashif <anas.nashif@intel.com> - 1.0.22
- Really clean spec files
* Wed Mar 24 2010 Bin Gao <bin.gao@intel.com> 1.0.22
- Dropped unuseful patches and fixed spectacle files
* Fri Dec 25 2009 Bin Gao <bin.gao@intel.com> 1.0.22
- Update to 1.0.22
- Dropped 3 patches
* Mon Sep 21 2009 Vivian Zhang <vivian.zhang@intel.com> 1.0.21
- Update to 1.0.21
- Merged 3 upstream patches
* Wed May 20 2009 Vivian Zhang <vivian.zhang@intel.com> 1.0.20
- Update to 1.0.20
* Fri Feb 13 2009 Anas Nashif <anas.nashif@intel.com> 1.0.19
- Update to 1.0.19
* Thu Nov 20 2008 Vivian zhang <vivian.zhang@intel.com> 1.0.18
- Update to 1.0.18 and new configuration stype
- Remove upstreamed patches
* Fri Sep  5 2008 Anas Nashif <anas.nashif@intel.com> 1.0.17
- Initial import into moblin
