Name:           sreadahead
Version:        0.14
Release:        1.1
Summary:        Readahead implementation optimized for netbooks

Group:          System
License:        GPLv2
Source0:        sreadahead-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root

Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig

%description
A readahead implementation optimized for netbooks

%prep
%setup -q

%build
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
install -d -m 755 $RPM_BUILD_ROOT%{_initrddir}/
install -p -m 755 sreadahead.init $RPM_BUILD_ROOT%{_initrddir}/sreadahead-pack


%clean
rm -rf $RPM_BUILD_ROOT


%post
[ -x /sbin/chkconfig ] && /sbin/chkconfig --add sreadahead-pack


%preun
if [ $1 = 0 ]; then
	[ -x /sbin/chkconfig ] && /sbin/chkconfig --del sreadahead-pack
fi


%files
%defattr(-,root,root,-)
/sbin/sreadahead-pack
/sbin/sreadahead-dump
/sbin/sreadahead
%{_initrddir}/sreadahead-pack


%changelog
* Wed Feb  2 2011 Auke Kok <auke-jan.h.kok@intel.com> - 0.14
- (BMC#13221) Sreadahead pack file generation is too heavy at
  first boot.
  * Wed 26 Jan 2011 Auke Kok <auke-jan.h.kok@intel.com> - 0.13
- (BMC#11748) add /home files to the list of files preloaded by sreadahead
* Fri Dec  3 2010 Auke Kok <auke-jan.h.kok@intel.com> - 0.12
- add syslog debugging output to confirm sreadahead ran OK
  * display size read, files read
  * display estimated throughput IO
  (BMC#12181)
* Mon Oct 18 2010 Auke Kok <auke-jan.h.kok@intel.com> - 0.11
- Bugfix: tune readahead sizes to reasonable size
- Minor cleanups: fix text messages for ioprio errors.
- Error handling: account for errors processing the pack file at start up.
- Increasing the number of readahead files to 2048.
- Merge __NR_ioprio_set for ARM and PowerPC like in uxlaunch.
* Mon Aug 23 2010 Carsten Valdemar Munk <carsten@maemo.org> 0.10
- Fix ARM build problem in similar fashion to how uxlaunch was fixed.
* Wed Apr 28 2010 Arjan van de Ven <arjan@linux.intel.com> 0.10
- Optimization from Shuohua to use btrfs ssd mode for the reordering phase
* Thu Apr 22 2010 Arjan van de Ven <arjan@linux.intel.com> 0.09
- upgrade to 0.09 -- adds basic support for sorting on sector number
  to at least not do damage on rotating disks.
* Fri Jan  8 2010 Arjan van de Ven <arjan@linux.intel.com> 0.06
- upgrade to 0.06
* Mon Jan  4 2010 Anas Nashif <anas.nashif@intel.com> - 0.04.1
- Update to 0.04.1
- fixes the string overrun issue
- limits max filename length to 204 characters (ensures cacheline alignment)
- merges all patches from moblin repo
* Thu Dec 10 2009 Arjan van de Ven <arjan@linux.intel.com> 0.04
- fix bug 8568
* Thu Jul 30 2009 Yi Yang <yi.y.yang@intel.com> 0.04
- Add a description for it
* Fri Jul 17 2009 Arjan van de Ven <arjan@linux.intel.com> 0.04
- set nice level
* Thu May  7 2009 Arjan van de Ven <arjan@linux.intel.com> 0.04
- fix build with LD_AS_NEEDED
* Fri Jan 16 2009 Auke Kok <auke-jan.h.kok@intel.com> 0.04
- bugfix release. reduces verbosity of packing.
- make pack generation less verbose, only scan rootfs.
* Thu Dec 11 2008 Auke Kok <auke-jan.h.kok@intel.com>
- Fix init.d script to generate pack file.
* Wed Dec  3 2008 Auke Kok <auke-jan.h.kok@intel.com> 0.03
- dropped obsolete patches
- imported new version
- added sreadahead-pack init.d file for automatic regeneration of pack file,
  which greatly simplifies the implementation of sreadahead.
* Thu Nov 27 2008 Anas Nashif <anas.nashif@intel.com> 0.02
- renamed package
* Tue Nov 25 2008 Austin Zhang <austin.zhang@intel.com>
- Upgraded versin to 0.02.
- Applied patches: sreadahead-0.02-make.patch, readahead_c.patch
  from Poky to 0.02.
- Applied patch: set_to_idle.patch to set the sreadahead into low
  IO priority status.
