Summary: A process-transparent configuration system
Name: GConf-dbus
Version: 2.29.1
Release: 1.10
License: LGPLv2+
Group: System/Base
Source: ftp://ftp.gnome.org/pub/GNOME/mobile/2.23/2.23.92/sources/GConf-dbus-%{version}.tar.bz2
Patch0: no-system.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
URL: http://www.gnome.org

Obsoletes: GConf2
Provides: GConf2
BuildRequires: libxml2-devel, glib2-devel > 2.8.0, dbus-devel, dbus-glib-devel >= 0.60
BuildRequires: pkgconfig >= 0.14
BuildRequires: gettext
BuildRequires: perl(XML::Parser)
BuildRequires: libtool, autoconf, automake
BuildRequires: intltool
Requires: dbus
Requires(post): grep, sed

%description
GConf-dbus is a process-transparent configuration database API used to 
store user preferences. It has pluggable backends and features to 
support workgroup administration.

%package devel
Summary: Headers and libraries for GConf development
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: libxml2-devel
Requires: glib2-devel > 2.8.0
# we install a pc file
Requires: pkgconfig
# we install an automake macro
Requires: automake
Requires: dbus-devel, dbus-glib-devel
Obsoletes: GConf2-devel
Provides: GConf2-devel

%description devel
GConf-dbus development package. Contains files needed for doing
development using GConf.

%prep
%setup -q
%patch0 -p1

%build
#rm -f libtool
#libtoolize --force --copy
#autoreconf
%configure --disable-static --disable-gtk-doc --disable-defaults-service --disable-gtk
make

%install
rm -fr $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/GConf-dbus/2/*.la

%find_lang GConf2

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig

# Disable the system source 
if fgrep -q gconf.xml.system %{_sysconfdir}/gconf/2/path; then
    sed -i -e 's@xml:readonly:/etc/gconf/gconf.xml.system@#&@' %{_sysconfdir}/gconf/2/path
fi

if ! fgrep -q gconf.xml.meego %{_sysconfdir}/gconf/2/path; then
    sed -i -e 's@xml:readwrite:$(HOME)/.gconf@&\n\n# MeeGo settings.\nxml:readonly:/etc/gconf/gconf.xml.meego@' %{_sysconfdir}/gconf/2/path
fi

%postun -p /sbin/ldconfig

%files -f GConf2.lang
%defattr(-, root, root)
%doc COPYING NEWS README backends/README.evoldap
%doc %{_datadir}/gtk-doc/html/gconf/*
%doc %{_datadir}/man/man1/*
%doc %{_datadir}/sgml/gconf/*
%config(noreplace) %{_sysconfdir}/gconf/2/path
%dir %{_sysconfdir}/gconf
%dir %{_sysconfdir}/gconf/2
%dir %{_sysconfdir}/gconf/gconf.xml.defaults
%dir %{_sysconfdir}/gconf/gconf.xml.mandatory
#%{_sysconfdir}/gconf/2/evoldap.conf
%{_bindir}/*
%{_libexecdir}/*
%{_libdir}/*.so.*
%dir %{_libdir}/GConf-dbus
%dir %{_libdir}/GConf-dbus/2
%{_libdir}/GConf-dbus/2/*.so
%{_datadir}/dbus-1/services/gconf.service
#%{_datadir}/GConf-dbus/schema/evoldap.schema

%files devel
%defattr(-, root, root)
%{_libdir}/*.so
%{_includedir}/gconf
%{_datadir}/aclocal/*.m4
%{_libdir}/pkgconfig/*

%changelog
* Mon Feb  7 2011 Patrick McCarty <patrick.mccarty@linux.intel.com> - 2.29.1
- (BMC#7184) Update package to latest version (2.29.1)
* Wed Jun 23 2010 Rob Bradford <rob@linux.intel.com> - 2.29.0
- Switch to using MeeGo source rather than Moblin
* Wed Apr 21 2010 Ross Burton <ross@linux.intel.com> - 2.29.0
- Patch out the system source, we don't enable the defaults service (MBC#276)
- Also disable it in postinst for upgrades
* Tue Mar 23 2010 Anas Nashif <anas.nashif@intel.com> - 2.29.0
- Dont depend on gtk
* Sun Feb  7 2010 Anas Nashif <anas.nashif@intel.com> - 2.29.0
- Require grep and sed for %%post section (MB#9519)
* Thu Jan  7 2010 Ross Burton <ross@linux.intel.com> - 2.29.0
- Merge gettext_domain support in the schemas
* Mon Oct  5 2009 Anas Nashif <anas.nashif@intel.com> - 2.26.2ross2
- Do not build with openldap
* Tue Sep  1 2009 Rob Bradford <rob@linux.intel.com> 2.26.2ross3
- Add Moblin schema directory to search path
* Fri Aug 28 2009 Ross Burton <ross@linux.intel.com> 2.26.2ross2
- More integration with upstream
- Add recursive preloading, thanks Zhenqiang Chen
* Wed Jun 24 2009 Ross Burton <ross@linux.intel.com> 2.26.2ross1
- New upstream "release"
- Merged all of the trivial upstream changes, and integrated all of the patches
* Mon Jun  8 2009 Ross Burton <ross@linux.intel.com> 2.16.0
- Add negative caching patch from upstream (thanks Zhenqiang Chen <zhenqiang.chen@intel.com>)
* Tue Mar 10 2009 Xu Li <xu.li@intel.com> 2.16.0
- Reimplment gconf_ping_daemon() to fix bug#1156; patch added
* Thu Feb 12 2009 Ross Burton <ross@linux.intel.com> 2.16.0-2
- Add optimisation patches from upstream.
* Mon Dec  8 2008 Xu Li <xu.li@intel.com> 2.16.0
- Remove "Conflicts: GConf2-devel"
* Tue Nov 25 2008 Xu Li <xu.li@intel.com> 2.16.0
- Add missing requires: dbus & dbus-devel
* Mon Nov  3 2008 Anas Nashif <anas.nashif@intel.com> 2.16.0
- obsoletes GConf2
* Mon Nov  3 2008 Anas Nashif <anas.nashif@intel.com> 2.16.0
- obsoletes GConf2
* Fri Sep 26 2008 Xu Li <xu.li@intel.com> 2.16.0
- Add conflicts: GConf2 & GConf2-devel
* Thu Sep 25 2008 Xu Li <xu.li@intel.com> 2.16.0
- Add %%doc to man/doc files
* Thu Sep 25 2008 Xu Li <xu.li@intel.com> 2.16.0
- Fix the lang issue
* Thu Sep 25 2008 Xu Li <xu.li@intel.com> 2.16.0
- Add missing buildrequires & requires
* Thu Sep 25 2008 Xu Li <xu.li@intel.com> 2.16.0
- Initial import
