Name: connman
Version: 1.5
Release: 3.6
Summary: An alternative daemon for managing internet connections on Linux

Group: System Environment/Base
License: GPLv2
URL: http://connman.net/
Source0: http://www.kernel.org/pub/linux/network/%{name}/%{name}-%{version}.tar.xz

BuildRequires: systemd
BuildRequires: glib2-devel >= 2.28
BuildRequires: dbus-devel >= 1.4
BuildRequires: iptables-devel
BuildRequires: gnutls-devel
Requires: wpa_supplicant
### Requires: wpa_supplicant >= 1.0
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd

%description
The ConnMan project provides a daemon for managing internet connections within
embedded devices running the Linux operating system. The Connection Manager is
designed to be slim and to use as few resources as possible, so it can be
easily integrated.

%package devel
Summary: Libraries and headers for connman
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}

%description devel
This package contains development files for connman.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}

%post
/bin/systemctl daemon-reload --system
/bin/systemctl start connmand.service

%preun
/bin/systemctl stop connmand.service

%postun
/bin/systemctl daemon-reload --system

%files
%doc README COPYING
# %{_unitdir}/connman.service
%{_sbindir}/connmand
%config(noreplace) /etc/dbus-1/system.d/connman.conf

%files devel
%{_includedir}/connman
%{_includedir}/connman/device.h
%{_includedir}/connman/inet.h
%{_includedir}/connman/ipconfig.h
%{_includedir}/connman/log.h
%{_includedir}/connman/network.h
%{_includedir}/connman/notifier.h
%{_includedir}/connman/plugin.h
%{_includedir}/connman/provision.h
%{_includedir}/connman/resolver.h
%{_includedir}/connman/service.h
%{_includedir}/connman/storage.h
%{_includedir}/connman/types.h
%{_includedir}/connman/version.h
%{_libdir}/pkgconfig/connman.pc

%changelog
* Wed Sep 26 2012 Andrei Zlate <andrei.zlate@windriver.com> - 1.5-3
- Update the post/pre rules

* Wed Sep 19 2012 Andrei Zlate <andrei.zlate@windriver.com> - 1.5-3
- Require systemd instead of systemd-units
- Do not package the systemd service - provided by the custom systemd

* Sat Aug 18 2012 Pavel Šimerda <psimerda@redhat.com> - 1.5-3
- include COPYING
- make -devel depend on main package

* Sat Aug 18 2012 Pavel Šimerda <psimerda@redhat.com> - 1.5-2
- fix scriptlets
- own /usr/include/connman

* Thu Aug 16 2012 Pavel Šimerda <psimerda@redhat.com> - 1.5-1
- initial build
