# 
# Do NOT Edit the Auto-generated Part!
# Generated by: spectacle version 0.22
# 
# >> macros
%define pulseversion  1.1
%define with_x11 0
# << macros

Name:       pulseaudio
Summary:    Improved Linux sound server
Version:    1.1
Release:    13.2
Group:      Multimedia/PulseAudio
License:    LGPLv2+
URL:        http://pulseaudio.org
Source0:    http://0pointer.de/lennart/projects/pulseaudio/pulseaudio-%{version}.tar.bz2
Source1:    default.pa
Source2:    daemon.conf
Source3:    90-pulse.conf
Source4:    start-pulseaudio
Source5:    ia32_oemtablet.pa
Source100:  pulseaudio.yaml
Source200:  pulseaudio.conf
Patch0:     0233-build-add-pulsecore.pc-MeeGo-specific.patch
Patch1:     0234-Update-pulsecore.pc.in-for-pulseaudio-dev-1.0.patch
Patch2:     0235-build-add-pulsecore-installhook-Nokia-specific.patch
Patch3:     0236-module-stream-restore-crash-when-upgrading.patch
Patch900:   0900-change-default-cookie-file-location.patch
Requires:   udev >= 145-3
Requires:   xcb-util
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig
BuildRequires:  pkgconfig(speexdsp)
BuildRequires:  pkgconfig(xextproto)
BuildRequires:  pkgconfig(inputproto)
BuildRequires:  pkgconfig(libasyncns)
BuildRequires:  pkgconfig(x11)
BuildRequires:  pkgconfig(ice)
BuildRequires:  pkgconfig(sm)
BuildRequires:  pkgconfig(xtst)
BuildRequires:  pkgconfig(sndfile)
BuildRequires:  pkgconfig(orc-0.4)
BuildRequires:  pkgconfig(alsa)
BuildRequires:  pkgconfig(glib-2.0)
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(bluez)
BuildRequires:  pkgconfig(xi)
BuildRequires:  pkgconfig(libudev)
BuildRequires:  pkgconfig(xcb-event)
BuildRequires:  pkgconfig(dbus-1)
BuildRequires:  pkgconfig(json)
BuildRequires:  m4
BuildRequires:  libtool-ltdl-devel
BuildRequires:  libtool
BuildRequires:  intltool
BuildRequires:  libatomic_ops-devel
BuildRequires:  fdupes


%description
PulseAudio is a sound server for Linux and other Unix like operating
systems. It is intended to be an improved drop-in replacement for the
Enlightened Sound Daemon (ESOUND).


%if 0%{?with_x11}
%package module-x11
Summary:    PulseAudio components needed for starting x11 User session
Group:      Multimedia/PulseAudio
Requires:   %{name} = %{version}-%{release}
Requires:   /bin/sed

%description module-x11
Description: %{summary}
%endif

%package devel
Summary:    PulseAudio Development headers and libraries
Group:      Development/Libraries
Requires:   %{name} = %{version}-%{release}

%description devel
Description: %{summary}


%prep
%setup -q -n %{name}-%{version}

# 0233-build-add-pulsecore.pc-MeeGo-specific.patch
%patch0 -p1
# 0234-Update-pulsecore.pc.in-for-pulseaudio-dev-1.0.patch
%patch1 -p1
# 0235-build-add-pulsecore-installhook-Nokia-specific.patch
%patch2 -p1
# 0236-module-stream-restore-crash-when-upgrading.patch
%patch3 -p1
# 0900-change-default-cookie-file-location.patch
%patch900 -p1

# >> setup
# << setup

%build
unset LD_AS_NEEDED
# >> build pre
# << build pre

%autogen --disable-static
%configure --disable-static \
%if 0%{?with_x11}
    --enable-x11
%else
    --disable-x11
%endif

make %{?jobs:-j%jobs}

# >> build post
# << build post
%install
rm -rf %{buildroot}
# >> install pre
# << install pre
%make_install

# >> install post
install -d %{buildroot}/etc/pulse/
cp -a %{SOURCE1} %{buildroot}/etc/pulse/default.pa
cp -a %{SOURCE2} %{buildroot}/etc/pulse/daemon.conf
cp -a %{SOURCE5} %{buildroot}/etc/pulse/ia32_oemtablet.pa

install -d  %{buildroot}/etc/security/limits.d
cp -a %{SOURCE3} %{buildroot}/etc/security/limits.d
install -m 755 %{SOURCE4}         %{buildroot}/usr/bin/start-pulseaudio

install -d                        %{buildroot}/usr/include/pulse-modules-headers/pulsecore/
install -m 644 src/pulsecore/*.h  %{buildroot}/usr/include/pulse-modules-headers/pulsecore/

install -d %{buildroot}/etc/dbus-1/system.d/
install -m 644 %{SOURCE200} %{buildroot}/etc/dbus-1/system.d/

%if ! %{?with_x11}
rm -f %{buildroot}/%{_mandir}/man1/pax11publish.1
rm -f %{buildroot}/%{_mandir}/man1/start-pulseaudio-kde.1
rm -f %{buildroot}/%{_mandir}/man1/start-pulseaudio-x11.1
%endif

# these files have been moved in the board-specific packages
rm -f %{buildroot}/etc/pulse/daemon.conf
rm -f %{buildroot}/etc/pulse/system.pa
rm -f %{buildroot}/etc/security/limits.d/90-pulse.conf


# << install post
%find_lang pulseaudio
%fdupes  %{buildroot}/%{_datadir}
%fdupes  %{buildroot}/%{_includedir}



%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig








%files -f pulseaudio.lang
%defattr(-,root,root,-)
# >> files
%doc README LICENSE GPL LGPL
%doc %{_mandir}/man1/pulseaudio.1.gz
%doc %{_mandir}/man5/default.pa.5.gz
%doc %{_mandir}/man5/pulse-client.conf.5.gz
%doc %{_mandir}/man5/pulse-daemon.conf.5.gz
%doc %{_mandir}/man1/pacat.1.gz
%doc %{_mandir}/man1/pacmd.1.gz
%doc %{_mandir}/man1/pactl.1.gz
%doc %{_mandir}/man1/paplay.1.gz
%doc %{_mandir}/man1/pasuspender.1.gz
%doc %{_mandir}/man1/esdcompat.1.gz
%doc %{_mandir}/man1/padsp.1.gz
### %exclude %doc %{_mandir}/man1/start-pulseaudio-kde.1.gz
%dir %{_sysconfdir}/pulse/
### %config(noreplace) %{_sysconfdir}/pulse/daemon.conf
%config(noreplace) %{_sysconfdir}/pulse/default.pa
### %config(noreplace) %{_sysconfdir}/pulse/system.pa
%config(noreplace) %{_sysconfdir}/pulse/client.conf
%config(noreplace) %{_sysconfdir}/pulse/ia32_oemtablet.pa
### %exclude %config(noreplace) %{_sysconfdir}/xdg/autostart/pulseaudio-kde.desktop
### %exclude %{_bindir}/start-pulseaudio-kde
%exclude %config(noreplace) %{_sysconfdir}/dbus-1/system.d/pulseaudio-system.conf
%config(noreplace) %{_sysconfdir}/dbus-1/system.d/pulseaudio.conf
### %{_sysconfdir}/security/limits.d/90-pulse.conf
%{_bindir}/pacat
%{_bindir}/pacmd
%{_bindir}/pactl
%{_bindir}/padsp
%{_bindir}/paplay
%{_bindir}/parec
%{_bindir}/pasuspender
%{_bindir}/esdcompat
%{_bindir}/pulseaudio
%dir %{_libexecdir}/pulse
%{_libexecdir}/pulse/proximity-helper
%{_libexecdir}/pulse/gconf-helper
%{_libdir}/libpulsecommon-%{pulseversion}.so
%{_libdir}/libpulsecore-%{pulseversion}.so
%{_libdir}/libpulsedsp.so
%{_libdir}/libpulse.so.*
%{_libdir}/libpulse-simple.so.*
%{_libdir}/libpulse-mainloop-glib.so.*
%{_libdir}/pulse-%{pulseversion}/modules/libalsa-util.so
%{_libdir}/pulse-%{pulseversion}/modules/libbluetooth-ipc.so
%{_libdir}/pulse-%{pulseversion}/modules/libbluetooth-sbc.so
%{_libdir}/pulse-%{pulseversion}/modules/libbluetooth-util.so
%{_libdir}/pulse-%{pulseversion}/modules/libcli.so
%{_libdir}/pulse-%{pulseversion}/modules/liboss-util.so
%{_libdir}/pulse-%{pulseversion}/modules/libprotocol-cli.so
%{_libdir}/pulse-%{pulseversion}/modules/libprotocol-esound.so
%{_libdir}/pulse-%{pulseversion}/modules/libprotocol-http.so
%{_libdir}/pulse-%{pulseversion}/modules/libprotocol-native.so
%{_libdir}/pulse-%{pulseversion}/modules/libprotocol-simple.so
%{_libdir}/pulse-%{pulseversion}/modules/librtp.so
%{_libdir}/pulse-%{pulseversion}/modules/module-alsa-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-alsa-source.so
%{_libdir}/pulse-%{pulseversion}/modules/module-alsa-card.so
%{_libdir}/pulse-%{pulseversion}/modules/module-always-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-augment-properties.so
%{_libdir}/pulse-%{pulseversion}/modules/module-bluetooth-device.so
%{_libdir}/pulse-%{pulseversion}/modules/module-bluetooth-discover.so
%{_libdir}/pulse-%{pulseversion}/modules/module-bluetooth-proximity.so
%{_libdir}/pulse-%{pulseversion}/modules/module-card-restore.so
%{_libdir}/pulse-%{pulseversion}/modules/module-cli-protocol-tcp.so
%{_libdir}/pulse-%{pulseversion}/modules/module-cli-protocol-unix.so
%{_libdir}/pulse-%{pulseversion}/modules/module-cli.so
%{_libdir}/pulse-%{pulseversion}/modules/module-combine.so
# Warning: following lib should be removed...
%exclude %{_libdir}/pulse-%{pulseversion}/modules/module-device-manager.so
%{_libdir}/pulse-%{pulseversion}/modules/module-loopback.so
%{_libdir}/pulse-%{pulseversion}/modules/module-console-kit.so
%{_libdir}/pulse-%{pulseversion}/modules/module-cork-music-on-phone.so
%{_libdir}/pulse-%{pulseversion}/modules/module-default-device-restore.so
%{_libdir}/pulse-%{pulseversion}/modules/module-detect.so
%{_libdir}/pulse-%{pulseversion}/modules/module-device-restore.so
%{_libdir}/pulse-%{pulseversion}/modules/module-esound-compat-spawnfd.so
%{_libdir}/pulse-%{pulseversion}/modules/module-esound-compat-spawnpid.so
%{_libdir}/pulse-%{pulseversion}/modules/module-esound-protocol-tcp.so
%{_libdir}/pulse-%{pulseversion}/modules/module-esound-protocol-unix.so
%{_libdir}/pulse-%{pulseversion}/modules/module-esound-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-gconf.so
%{_libdir}/pulse-%{pulseversion}/modules/module-hal-detect.so
%{_libdir}/pulse-%{pulseversion}/modules/module-http-protocol-tcp.so
%{_libdir}/pulse-%{pulseversion}/modules/module-http-protocol-unix.so
%{_libdir}/pulse-%{pulseversion}/modules/module-ladspa-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-match.so
%{_libdir}/pulse-%{pulseversion}/modules/module-mmkbd-evdev.so
%{_libdir}/pulse-%{pulseversion}/modules/module-native-protocol-fd.so
%{_libdir}/pulse-%{pulseversion}/modules/module-native-protocol-tcp.so
%{_libdir}/pulse-%{pulseversion}/modules/module-native-protocol-unix.so
%{_libdir}/pulse-%{pulseversion}/modules/module-null-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-oss.so
%{_libdir}/pulse-%{pulseversion}/modules/module-pipe-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-pipe-source.so
%{_libdir}/pulse-%{pulseversion}/modules/module-position-event-sounds.so
%{_libdir}/pulse-%{pulseversion}/modules/module-remap-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-rescue-streams.so
%{_libdir}/pulse-%{pulseversion}/modules/module-rtp-recv.so
%{_libdir}/pulse-%{pulseversion}/modules/module-rtp-send.so
%{_libdir}/pulse-%{pulseversion}/modules/module-simple-protocol-tcp.so
%{_libdir}/pulse-%{pulseversion}/modules/module-simple-protocol-unix.so
%{_libdir}/pulse-%{pulseversion}/modules/module-sine.so
%{_libdir}/pulse-%{pulseversion}/modules/module-sine-source.so
%{_libdir}/pulse-%{pulseversion}/modules/module-stream-restore.so
%{_libdir}/pulse-%{pulseversion}/modules/module-suspend-on-idle.so
%{_libdir}/pulse-%{pulseversion}/modules/module-tunnel-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-tunnel-source.so
%{_libdir}/pulse-%{pulseversion}/modules/module-volume-restore.so
%{_libdir}/pulse-%{pulseversion}/modules/module-udev-detect.so
%{_libdir}/pulse-%{pulseversion}/modules/module-dbus-protocol.so
%{_libdir}/pulse-%{pulseversion}/modules/module-echo-cancel.so
%{_libdir}/pulse-%{pulseversion}/modules/module-virtual-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-virtual-source.so
%{_libdir}/pulse-%{pulseversion}/modules/module-combine-sink.so
%{_libdir}/pulse-%{pulseversion}/modules/module-null-source.so
%{_libdir}/pulse-%{pulseversion}/modules/module-switch-on-connect.so
/lib/udev/rules.d/90-pulseaudio.rules
%{_datadir}/pulseaudio/alsa-mixer/paths/*
%{_datadir}/pulseaudio/alsa-mixer/profile-sets/*
%{_bindir}/pamon
%{_bindir}/parecord
%{_libdir}/pulse-%{pulseversion}/modules/module-intended-roles.so
%{_libdir}/pulse-%{pulseversion}/modules/module-rygel-media-server.so
%{_libdir}/pulse-%{pulseversion}/modules/module-filter-apply.so
%{_libdir}/pulse-%{pulseversion}/modules/module-filter-heuristics.so
/usr/share/vala/vapi/libpulse-mainloop-glib.deps
/usr/share/vala/vapi/libpulse-mainloop-glib.vapi
/usr/share/vala/vapi/libpulse.deps
# %config %{_sysconfdir}/xdg/autostart/pulseaudio.desktop
%{_bindir}/start-pulseaudio
# << files

%if 0%{?with_x11}
%files module-x11
%defattr(-,root,root,-)
# >> files module-x11
%doc %{_mandir}/man1/pax11publish.1.gz
%doc %{_mandir}/man1/start-pulseaudio-x11.1.gz
%{_bindir}/start-pulseaudio-x11
%{_bindir}/pax11publish
%{_libdir}/pulse-%{pulseversion}/modules/module-x11-bell.so
%{_libdir}/pulse-%{pulseversion}/modules/module-x11-publish.so
%{_libdir}/pulse-%{pulseversion}/modules/module-x11-xsmp.so
%{_libdir}/pulse-%{pulseversion}/modules/module-x11-cork-request.so
# << files module-x11
%endif

%files devel
%defattr(-,root,root,-)
# >> files devel
%{_includedir}/pulse/
%{_includedir}/pulse-modules-headers/pulsecore/
%{_libdir}/libpulse.so
%{_libdir}/libpulse-mainloop-glib.so
%{_libdir}/libpulse-simple.so
%{_libdir}/pkgconfig/libpulse-mainloop-glib.pc
%{_libdir}/pkgconfig/libpulse-simple.pc
%{_libdir}/pkgconfig/libpulse.pc
%{_datadir}/vala/vapi/libpulse.vapi
/usr/include/pulsecore/*
/usr/lib/pkgconfig/pulsecore.pc
%{_libdir}/cmake/PulseAudio/PulseAudioConfig.cmake
%{_libdir}/cmake/PulseAudio/PulseAudioConfigVersion.cmake
# << files devel

%changelog
* Thu Aug 23 2012 Andrei Zlate <andrei.zlate@windriver.com> - 1.1
- Update system.pa: define virtual sink for USB audio device
- Update system.pa: define virtual sinks for BT / MPP / Ipod / Voice
- Comment out desktop files - not generated for our env
- Comment out daemon.conf, system.pa and 90-pulse.conf. The files are moved to the board specific package
- Added the pulseaudio.conf D-Bus policy file
- Disable X11 support
- Changed default cookie-file location
* Mon Feb 27 2012 Yang Jie <yang.jie@intel.com> - 1.1
- Added patch 0236-module-stream-restore-crash-when-upgrading.patch to fix BMC#24944
* Thu Feb 23 2012 DengYingAn <ying.an.deng@intel.com> - 1.1
- Set load module-switch-on-connect by default for BMC24777
* Mon Feb  6 2012 DengYingAn <ying.an.deng@intel.com> - 1.1
- Upgrade to 1.1 for BMC24708
* Sat Jul  2 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Add BuildRequires: pkgconfig(dbus-1) to resolve the build failure (BMC#20517)
* Tue Jun 28 2011 William Douglas <william.douglas@intel.com> - 0.9.22
- (BMC#20216) Update device file permissions so that pulseaudio can use them.
* Tue Jun 14 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Add module-filter-* modules in pulseaudio (BMC #17634)
* Sat Jun 11 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Add libspeex based preprocessing to echo cancellation module (BMC #18087)
- Recover the load of module-stream-restore in default.pa for fixing alert volume in sound setting unable to adjust manully issue (BMC #18477)
* Wed May 18 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Merged patches for adrian echo canceller, also use orc as the build dependency (BMC #17701)
* Thu Apr 28 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Remove pulseaudio-startup subpackage and merge startup script and desktop file to pulseaudio
* Tue Apr 19 2011 Sami Sirkia <sami.sirkia@cybercom.com> - 0.9.22
- Fix for BMC#15950 - No audio or audio routing on N900 with Pulseaudio 0.9.22
  A strict checking of audio driver properties caused a failure to load alsamixer paths.
  The patch is temporary but old, so this has to be handled in driver soon.
- Another fix for the same BMC#15950 corrects a input/output typo. We have had this fix before in .19.
* Mon Apr 18 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Use alsa mixer paths and profile sets on 0.9.22 stable tree to resolve the REG issues (BMC #16188, BMC#16192)
* Thu Apr 14 2011 Sami Sirkia <sami.sirkia@cybercom.com> - 0.9.22
- Added alsa-sink-old and alsa-source-old by patch. Fixes: BMC#16057.
* Thu Apr 14 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Do not split the alsa mixer paths and profiles between mfld and non-mfld build(BMC #16009)
* Fri Apr  8 2011 Fabien Barthes <fabienx.barthes@intel.com> - 0.9.22
- sync with latest development done in pulseaudio.org up to 0.9.22 (BMC #15688)
- adaption to necessary mfld patches
* Wed Mar 30 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.22
- Upgrade to 0.9.22 version
* Tue Mar 29 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.19
- Add hfgw profile support in bluetooth module (BMC #12649)
* Thu Mar 24 2011 Sami Sirkia <sami.sirkia@cybercom.com> - 0.9.19
- Updated the platform detection (BMC #6728).
  Same method in start-pulseaudio without patching PulseAudio sources.
* Tue Mar 22 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.19
- Add patch to use a2dp as the default profile for non-mfld platform (BMC #14783)
* Thu Mar 17 2011 Sami Sirkia <sami.sirkia@cybercom.com> - 0.9.19
- Script approach for choosing config file based on the detected platform (BMC #6728).
- Updated yaml to make it pass specify-0.22 without errors or warnings.
* Fri Mar 11 2011 vivian zhang <vivian.zhang@intel.com> - 0.9.19
- Add patch for enabling auto route audio to bluetooth sink (BMC #12916)
* Thu Feb 24 2011 Fabien Barthes <fabienx.barthes@intel.com> - 0.9.19
- Removed usage of daemon_mfld.conf and default_mfld.pa file since now existing new pulseaudio-settings-mfld package
- New module to log PCM samples out of memory chunks
- PCM samples logged either in a file or any remote device (BMC#13555)
  pa-0.9.19-mfld-Add-a-log-target-to-a-file-remote-or-local-for-Pulse.patch
  pa-0.9.19-mfld-Module-to-log-PCM-samples-from-sinks-and-sources-HSD.patch
  pa-0.9.19-mfld-Correct-wav-file-creation-for-24-32-and-24-bits-samp.patch
  pa-0.9.19-mfld-Fix-various-bugs-Support-new-option-trace_ports.patch
* Tue Feb 22 2011 Vivian Zhang <vivian.zhang@intel.com> - 0.9.19
- Updated pa-0.9.19-alsamixer-profile-path.patch to make sure it choose the correct audio path/profile-sets config files (BMC 13436)
* Fri Feb 11 2011 Fabien Barthes <fabienx.barthes@intel.com> - 0.9.19
- Bluetooth AD2P : use case MP3 direct streaming
- MP3 decoding is not done on IA side but by the chip bluetooth itself
- Data going through pulseaudio is MP3 instead of PCM (BMC#13424)
* Thu Feb  3 2011 Fabien Barthes <fabienx.barthes@intel.com> - 0.9.19
- UDEV alsa card detect instead of static configuration in default.pa (BMC#13179)
- Create Alsa card profiles & ports for MFLD platform
- Add change sample spec functionalities for sink and source
- Timer scheduling: adjust tsched_buffer_size according to max Hw buffer size
- Resampler factory
- Integrates Nokia SRC 8khz<->16kHz
- Parameter module support.
  pa-0.9.19-mfld-Pulsecore-Add-change-sample-spec-functionalities-for.patch
  pa-0.9.19-mfld-alsa-module-adjust-tsched_buffer_size-according-to-m.patch
  pa-0.9.19-mfld-pactl-add-alsa-audio-card-support.patch
* Mon Jan 24 2011 Vivian Zhang <vivian.zhang@intel.com> - 0.9.19
- Do not set waker_sink_input if sink.hs doesn't exist, fix pa crash issue for BT headset connecting (BMC #12366)
* Thu Jan 20 2011 Vivian Zhang <vivian.zhang@intel.com> - 0.9.19
- Remove requires: rtkit (BMC #12658)
* Mon Dec 20 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.19
- Downgrade pulseaduio to 0.9.19 and clean the patches
- Added patches from Fabien Barthes for building specific mfld packages of pulseaudio (BMC#11252)
- Added the handset specific alsa-mixer paths & profile-sets files to pulseaudio-mfld-settings package
- Merged core-new-function-pa-module-update-proplist.patch which is required by pulseaudio-policy-enforcement(FEA #6701)
- Merged alsa-source-old-give-correct-direction-to-pa_alsa_pa.patch which fixes typo in port feature of alsa-old-source, this is needed for resource policy audio input to work(FEA #6701)
* Tue Nov  9 2010 Maël Pouessel <mael.pouesse@intel.com> - 0.9.21
  Set the BURST_MODE configuration by default for voice module (BMC9885)
* Mon Nov  1 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Split desktop and startup script out to pulseaudio-startup package, which handles the pa launch on system startup (BMC #9604)
- Merged the patch from Pouessel, Mael which contains the new voice module for enabling the Circuit Switch Voice call on MFLD EB hardware
  0001-audio-voice-call-enabled-HSD-3669129.patch
  0002-HSD3576159-Don-t-cork-the-cs-voice-sink-input-and-cs.patch
  0003-HSD3667148-Add-POLLOUT-event-support-from-modem-even.patch
  0004-HSD3669166-Pulseaudio-Add-Burst-mode-support.patch
  0005-HSD-3576250-Pulseaudio-uplink-delayed.patch
  0006-Pulseaudio-CS-Voice-Call-Add-WB-AMR-support.-Add-SRC.patch
  0007-Pulseaudio-Voice-module-Fix-sink-memblockq-corruptio.patch
  0008-Remove-UMG-contributions-to-config-files.patch
  0009-Align-cs-protocol.h-with-cmt_speech-driver.patch
  0010-Add-Pulseaudio-configuration-files-for-Medfield-EB-h.patch
- Add new package pulseaudio-settings-mfld which includes the pulseaudio config files for MFLD EB hardware (BMC #9607)
* Tue Oct 12 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Disable optional Avahi support to remove the requires for avahi
* Wed Sep 22 2010 Carsten V. Munk <carsten@maemo.org> - 0.9.21
- Add patches that makes pulseaudio support call audio functionality on Nokia N900:
  old-sink.patch: Several patches related to adding alsa-old sink and build dependancies
  flat-sink.patch: Patches to include flat sink functionality
  call-state-tracker.patch: Singleton for central administration if a call is ongoing.
  0027-build-add-pulsecore.pc-Nokia-specific.patch: Add pulsecore.pc pkgconfig and headers
- Fix up packaging to match.
- These changes have been verified with Jyri Sarha and by automatic test cases on netbook.
- The changes serve as part of the implementation of FEA#4134 FEA#4135 FEA#4136 on ARM
  (Dialer - Make a Call, Receive a Call, End Call)
* Fri Sep 17 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Move pulseaudio.desktop to pulseaudio-x11-module package to avoid pulseaudio launch failure if pulseaudio-x11-module is not installed
* Mon Aug 23 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Remove the module load for audiomanager, mrst-specific in default.pa, partially fix BMC #150
* Mon Apr 12 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Updated set profile to a2dp patch to fix ofono call issue (BMC #576)
* Sat Apr 10 2010 Anas Nashif <anas.nashif@intel.com> - 0.9.21
- Fixed rpmlint errors
* Wed Apr  7 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Fix insecure temporary file creation issue (BMC#122, CVE-2009-1200)
* Tue Mar 23 2010 Alexander Kanevskiy <alexander.kanevskiy@nokia.com> - 0.9.21
- Enable ARM optimized code only if it's built for ARMv6+
* Sat Mar 20 2010 Alexander Kanevskiy <alexander.kanevskiy@nokia.com> - 0.9.21
- force armv6 for svolume_arm.c in armv5 targets
* Mon Mar 15 2010 Anas Nashif <anas.nashif@intel.com> - 0.9.21
- Do not require tdb, we do not enable it.
* Thu Mar  4 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Add HFP Gateway support patch from upstream and add the patch to fix MB #6960
* Mon Feb  8 2010 Vivian Zhang <vivian.zhang@intel.com> - 0.9.21
- Set exit-idle-time=-1 in daemon.conf to fix MB #9255: PA not auto-launched after system boot up
* Thu Jan  7 2010 Vivian Zhang <vivian.zhang@intel.com> 0.9.21
- Removed pulseaudio-system.conf since PA is not launched as a system-wide instance to clean unknown username warning, partially fixed MB #8946
* Wed Dec  2 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.21
- Update to 0.9.21
- Add configoption "--with-database=simple" to build with simple db backend
* Fri Oct 30 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.19
- Update to 0.9.19
* Wed Oct 21 2009 Bin Gao <bin.gao@intel.com> 0.9.18
- Changed default resample method to ffmpeg in daemon.conf. This will help to
  drop CPU usage (see bug #6896).
* Sun Sep 27 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.18
- Update to 0.9.18
- Refine volume-ramping and export-headfile-for-modules patches for 0.9.18
- Update default.pa to use module-udev-detect replacing module-alsa-detect and add module-rescue-streams
* Tue Aug 25 2009 Huan Zheng <huan.zheng@intel.com> 0.9.15-2
- Refine volume ramping patch to the code which is accepted by PA community
* Wed Aug 19 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.15-2
- Correct modlibexeclib define to fix install failure
* Mon Aug 10 2009 Rusty Lynch <rusty.lynch@intel.com> - 0.9.15-2
- Adding patch to fix bug #5251 where pulseaudio will abort if started before hal
* Mon Aug  3 2009 Rusty Lynch <rusty.lynch@intel.com> = 0.9.15-2
- Adding support for running pulseaudio with the realtime scheduler
* Wed Jul 29 2009 Vincent Huang <chenglan.huang@intel.com> - 0.9.15-2
- Add volume-ramping patch to enable this new feature.
* Tue Jul 28 2009 Austin Zhang <austin.zhang@intel.com> - 0.9.15-2
- Removed extra-udev dependency with udev update again.
* Mon Jul 27 2009 Arjan van de Ven <arjan@linux.intel.com> - 0.9.15
- don't use tcp wrappers
* Fri Jul 17 2009 Austin Zhang <austin.zhang@intel.com> - 0.9.15-2
- Removed extra-udev dependency with udev update.
* Thu Jul  9 2009 Passion Zhao <passion.zhao@intel.com> - 0.9.15-2
- Add pulseaudio-0.9.15-Remove-exploitable-LD_BIND_NOW-hack.patch from vendor sec, embargo date is Jul-16-2009
* Wed Jul  1 2009 Todd Brandt <todd.e.brandt@intel.com> 0.9.15
- Added Huan Zheng's fiz for HFP. Enables interaction with bluez to
  autoload module-bluetooth-device when a cellphone call is started
* Tue Jun  9 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.15
- Fixed #3227: autoload module-mrst-specific in pulseaudio
* Wed Jun  3 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.15
- Added patch to change pa_volume_t mapping to cubic which is more natural, fixed #2336
* Sun May 31 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.15
- Added audiomanager module in default.pa to launch it by default
* Tue May 12 2009 zhang qiang <qiang.z.zhang@intel.com> 0.9.15
- Refine error info and fix other three assert bugs at 'proximity-helper.c'
* Fri May  8 2009 Arjan van de Ven <arjan@linux.intel.com> 0.9.15
- don't set LD_AS_NEEDED, pulseaudio has circular library dependencies
  and LD_AS_NEEDED cannot cope with that.
* Thu May  7 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.15
- Do not start pulseaudio daemon if PULSE_SERVER directs pulse elsewhere(redhat #497214)
- Added patch to export more headers and enable this feature by --enable-install-modules-headers for building audiomanager, this patch has been submitted to upstream
* Thu Apr 23 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.15
- Load saving/restoring settings modules by defult to fix #1720, #1642
* Tue Apr 14 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.15
- Update to 0.9.15
* Tue Apr  7 2009 zhang qiang <qiang.z.zhang@intel.com> 0.9.14
- Fix assert bug at 'proximity-helper.c'
* Mon Mar 30 2009 Vivian Zhang <vivian.zhang@intel.com> 0.9.14
- Added patch to fix RTP segfault/uninitialized resampler
* Tue Jan 13 2009 Rusty Lynch <rusty.lynch@intel.com> 0.9.14
- Updating to release 0.9.14
* Fri Jan  9 2009 Anas Nashif <anas.nashif@intel.com> 0.9.13
- Make it build with new libtool
* Tue Jan  6 2009 Rusty Lynch <rusty.lynch@intel.com> 0.9.13
- Adding policykit support
* Sat Jan  3 2009 Rusty Lynch <rusty.lynch@intel.com> 0.9.13
- Disabling openssl
- Adding moblin specific configuration (default.pa)
* Mon Dec 29 2008 Rusty Lynch <rusty.lynch@intel.com> 0.9.13
- Splitting out the X11 related files back out to pulseaudio-module-x11 subpackage
* Mon Dec 29 2008 Rusty Lynch <rusty.lynch@intel.com> 0.9.13
- Revamping package using spec-builder v0.12
* Thu Dec 18 2008 Arjan van de Ven <arjan@linux.intel.com> 0.9.13
- Don't require xorg-x11-proto-devel; pkgconfig takes care of this
* Tue Dec 16 2008 Anas Nashif <anas.nashif@intel.com> 0.9.13
- Fixed rpmlint errors in Summary tag
* Wed Nov 26 2008 Vivian zhang <vivian.zhang@intel.com> 0.9.13
- Enable package module-gconf to fix packaging failure
* Thu Nov 20 2008 Vivian zhang <vivian.zhang@intel.com> 0.9.13
- Update to 0.9.13
* Sat Sep 20 2008 Anas Nashif <anas.nashif@intel.com> 0.9.12
- initial import into moblin
* Thu Sep 11 2008 Bastien Nocera <bnocera@redhat.com> 0.9.12-5
- Rebuild
* Tue Sep  9 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.12-4
- Ship /var/lib/pulse in the RPM
* Tue Sep  9 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.12-3
- Don't remove pulse users/groups on package removal
* Tue Sep  9 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.12-2
- Add intltool to deps
* Tue Sep  9 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.12-1
- Release 0.9.12
* Thu Jul 24 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.11-1
- Final release 0.9.11
* Tue Jul 22 2008 Jon McCann <jmccann@redhat.com> 0.9.11-0.7.git20080626
- Fix for CK API changes
* Thu Jun 26 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.11-0.6.git20080626
- New GIT snapshot
* Sun Jun 22 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.11-0.5.svn20080622
- New GIT snapshot
* Wed Jun 18 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.11-0.4.svn20080618
- New SVN snapshot
* Fri May 30 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.11-0.3.svn20080529
- Fix snapshot versioning
* Thu May 29 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.11-0.0.svn20080529
- New SVN snapshot
* Tue May 20 2008 Matthias Clasen <mclasen@redhat.com> 0.9.11-0.2.svn20080516
- Actually apply the patch
* Sat May 17 2008 Matthias Clasen <mclasen@redhat.com> 0.9.11-0.1.svn20080516
- Fix a wrong assertion in module-default-device-restore
* Fri May 16 2008 Matthias Clasen <mclasen@redhat.com> 0.9.11-0.0.svn20080516
- Update to an svn snapshot of the 'glitch-free' rewrite of pulseaudio
* Sun Mar 30 2008 Lennart Poettering <lpoetter@redhat.com> 0.9.10-1
- Update to PulseAudio 0.9.10
- drop all patches, since they have been integrated upstream
* Thu Mar 27 2008 Lubomir Kundrak <lkundrak@redhat.com> 0.9.8-13
- Abort on CPU time comsumption, so we can get core
* Thu Mar 13 2008 Lubomir Kundrak <lkundrak@redhat.com> 0.9.8-12
- Own /usr/libexec/pulse (#437228)
* Wed Mar 12 2008 Adam Jackson <ajax@redhat.com> 0.9.8-11
- pulseaudio-0.9.8-disable-realtime.patch: Don't ask PolicyKit for increased
  scheduling mojo for now.  It's not clear that it's a win; and if it is,
  the policy should just be fixed to always allow it.
* Wed Mar 12 2008 Lubomir Kundrak <lkundrak@redhat.com> 0.9.8-10
- Build the manual pages with xmltoman
* Fri Feb 29 2008 Lubomir Kundrak <lkundrak@redhat.com> 0.9.8-9
- Fix the fix.
* Fri Feb 29 2008 Lubomir Kundrak <lkundrak@redhat.com> 0.9.8-8
- Fix multilib issue (#228383)
- Prevent dumping core if exiting sooner that ltdl initializaion (#427962)
  * Thu Feb 21 2008 Adam Tkac <atkac redhat com> 0.9.8-7
- really rebuild against new libcap
  * Sun Feb 17 2008 Adam Tkac <atkac redhat com> 0.9.8-6
- rebuild against new libcap
* Wed Jan 23 2008 Lubomir Kundrak <lkundrak@redhat.com> 0.9.8-5
- Fix CVE-2008-0008 security issue (#425481)
* Sun Jan 13 2008 Lubomir Kundrak <lkundrak@redhat.com> 0.9.8-4.1
- Actually add content to pulseaudio-0.9.8-create-dot-pulse.patch
- Make the Source0 tag point to URL instead of a local file
- Drop the nochown patch; it's not applied at all and no longer needed
* Thu Nov 29 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.8-4
- add missing dependency on pulseaudio-utils for pulseaudio-module-x11
* Thu Nov 29 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.8-3
- Create ~/.pulse/ if not existant
* Thu Nov 29 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.8-2
- Add missing dependency on jack-audio-connection-kit-devel
* Wed Nov 28 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.8-1
- Upgrade to current upstream
* Wed Oct 17 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.16.svn20071017
- Another SVN snapshot, fixing another round of bugs (#330541)
- Split libpulscore into a seperate package to work around multilib limitation (#335011)
* Mon Oct  1 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.15.svn20071001
- Another SVN snapshot, fixing another round of bugs
* Sat Sep 29 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.14.svn20070929
- Another SVN snapshot, fixing a couple of subtle bugs
* Tue Sep 25 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.13.svn20070925
- Remove libpulsecore.so symlink from pulseaudio-libs-devel to avoid multilib issues
* Tue Sep 25 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.12.svn20070925
- New SVN snapshot
- Split off libflashsupport again
- Rename "-lib" packages to "-libs", like all other packages do it.
- Provide esound
* Fri Sep  7 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.11.svn20070907
- Update SVN snapshot, don't link libpulsecore.so statically anymore
* Wed Sep  5 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.10.svn20070905
- Update SVN snapshot
* Tue Sep  4 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.9.svn20070904
- Update SVN snapshot
- ship libflashsupport in our package
- drop pulseaudio-devel since libpulsecore is not linked statically
* Thu Aug 23 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.8.svn20070823
- Update SVN snapshot
* Thu Aug 16 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.7.svn20070816
- Update SVN snapshot
* Thu Aug 16 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.6.svn20070816
- Update SVN snapshot
* Tue Aug 14 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.5.svn20070814
- Forgot to upload tarball
* Tue Aug 14 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.4.svn20070814
- Update snapshot. Install file into /etc/xdg/autostart/ to load module-x11-smp
  only after login
* Sun Aug 12 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.3.svn20070812
- Depend on tcp_wrappers-devel instead of tcp_wrappers, to make sure we
  actually get the headers installed.
* Sun Aug 12 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.2.svn20070812
- Update snapshot, contains 64 bit build fixes, and disables module-x11-xsmp by
  default to avoid deadlock when PA is started from gnome-session
* Sun Aug 12 2007 Lennart Poettering <lpoetter@redhat.com> 0.9.7-0.1.svn20070812
- Take snapshot from SVN
* Tue May 29 2007 Pierre Ossman <drzeus@drzeus.cx> 0.9.6-2
- Add libatomic_ops-devel as a build requirement.
* Tue May 29 2007 Pierre Ossman <drzeus@drzeus.cx> 0.9.6-1
- Upgrade to 0.9.6.
* Fri Mar  2 2007 Pierre Ossman <drzeus@drzeus.cx> 0.9.5-5
- Fix merge problems with patch.
* Fri Mar  2 2007 Pierre Ossman <drzeus@drzeus.cx> 0.9.5-4
- Add patch to handle ALSA changing the frame size (bug 230211).
- Add patch for suspended ALSA devices (bug 228205).
* Mon Feb  5 2007 Pierre Ossman <drzeus@drzeus.cx> 0.9.5-3
- Add esound-compat subpackage that allows PulseAudio to be a drop-in
  replacement for esd (based on patch by Matthias Clasen).
- Backport patch allows startup to continue even when the users'
  config cannot be read.
* Mon Oct 23 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.5-2
- Create user and groups for daemon.
* Mon Aug 28 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.5-1
- Upgrade to 0.9.5.
* Wed Aug 23 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.4-3
- Make sure JACK modules are built and packaged.
* Tue Aug 22 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.4-2
- Merge the ALSA modules into the main package as ALSA is the
  standard API.
* Sun Aug 20 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.4-1
- Update to 0.9.4.
- Remove fix for rpath as it is merged upstream.
* Fri Jul 21 2006 Toshio Kuratomi <toshio@tiki-lounge.com> 0.9.3-2
- Remove static libraries.
- Fix for rpath issues.
* Fri Jul 21 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.3-1
- Update to 0.9.3
- GLib 1.2 bindings dropped.
- Howl compat dropped as Avahi is supported natively.
- Added fix for pc files on x86_64.
* Sat Jul  8 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.2-1
- Update to 0.9.2.
- Added Avahi HOWL compat dependencies.
* Thu Jun  8 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.1-1
- Update to 0.9.1.
* Mon May 29 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.0-2
- Build and package doxygen docs
- Call ldconfig for relevant subpackages.
* Mon May 29 2006 Pierre Ossman <drzeus@drzeus.cx> 0.9.0-1
- Update to 0.9.0
* Tue May  9 2006 Pierre Ossman <drzeus@drzeus.cx> 0.8.1-1
- Update to 0.8.1
- Split into more packages
- Remove the modules' static libs as those shouldn't be used (they shouldn't
  even be installed)
* Fri Feb 24 2006 Tom "spot" Callaway <tcallawa@redhat.com> 0.7-2
- dance around with perms so we don't strip the binary
- add missing BR
* Mon Nov 28 2005 Tom "spot" Callaway <tcallawa@redhat.com> 0.7-1
- Initial package for Fedora Extras
