
Summary: System logging and kernel message trapping daemons
Name: sysklogd
Version: 1.5
Release: 14.7
License: GPLv2
Group: System/Daemons
URL: http://www.infodrom.org/projects/sysklogd/
Source0: http://www.infodrom.org/projects/sysklogd/download/sysklogd-%{version}.tar.gz
Source1: sysklogd-%{version}.conf
Source2: sysklogd-%{version}.init
Source3: sysklogd-%{version}.logrotate
Source4: sysklogd-%{version}.sysconfig
Patch1: sysklogd-1.5-empty-debuginfo.patch
Conflicts: logrotate < 3.5.2
Conflicts: rsyslog, syslog-ng
Requires: logrotate
Requires: bash >= 2.0
Requires(post): coreutils
Requires(postun): /sbin/service
Provides: syslog
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%define _bindir /bin
%define _sbindir /sbin

%description
The sysklogd package contains two system utilities (syslogd and klogd)
which provide support for system logging.  Syslogd and klogd run as
daemons (background processes) and log system messages to different
places, like sendmail logs, security logs, error logs, etc.

#%package devel
#Group: Development/Libraries
#Summary: Development tools for the sysklogd daemon
#
#%description devel
#The sysklogd-devel package contains the header file, which provides 
#interface for dispatcher extension.

%prep
%setup -q
%patch1 -p1

%build
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT/%{_sysconfdir}
mkdir -p $RPM_BUILD_ROOT/%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man{5,8}
mkdir -p $RPM_BUILD_ROOT/%{_sbindir}
mkdir -p $RPM_BUILD_ROOT/%{_includedir}/sysklogd
mkdir -p $RPM_BUILD_ROOT/sbin

make install prefix=$RPM_BUILD_ROOT TOPDIR=$RPM_BUILD_ROOT MANDIR=$RPM_BUILD_ROOT%{_mandir} \
	BINDIR=$RPM_BUILD_ROOT%{_sbindir} MAN_USER=`id -nu` MAN_GROUP=`id -ng`

mkdir -p $RPM_BUILD_ROOT/etc/{rc.d/init.d,logrotate.d,sysconfig}

install -p -m644 %SOURCE1 $RPM_BUILD_ROOT/%{_sysconfdir}/syslog.conf
install -p -m755 %SOURCE2 $RPM_BUILD_ROOT/etc/rc.d/init.d/sysklogd
install -p -m644 %SOURCE3 $RPM_BUILD_ROOT/etc/logrotate.d/sysklogd
install -p -m644 %SOURCE4 $RPM_BUILD_ROOT/etc/sysconfig/sysklogd

# Fix ownership of the executables

chmod 755 $RPM_BUILD_ROOT/%{_sbindir}/syslogd
chmod 755 $RPM_BUILD_ROOT/%{_sbindir}/klogd

# Convert CHANGES to UTF-8
iconv -c -s -f ISO8859-1 -t UTF-8 CHANGES -o CHANGES.new
mv -f CHANGES.new CHANGES

%clean
rm -rf $RPM_BUILD_ROOT

%post
for n in /var/log/{messages,secure,maillog,spooler}
do
	[ -f $n ] && continue
	umask 066 && touch $n
done
exit 0

%preun
if [ $1 = 0 ]; then
	[ -f /var/lock/subsys/syslog ] && 
		/sbin/service syslog stop >/dev/null 2>&1 || :
fi
exit 0

%postun
if [ "$1" -ge "1" ]; then
	/sbin/service syslog condrestart > /dev/null 2>&1 || :
fi
exit 0


%files
%defattr(-,root,root)
%doc ANNOUNCE README*  COPYING
%config(noreplace) %{_sysconfdir}/syslog.conf
%config(noreplace) %{_sysconfdir}/sysconfig/sysklogd
%config(noreplace) %{_sysconfdir}/logrotate.d/sysklogd
%{_sysconfdir}/rc.d/init.d/sysklogd
%{_sbindir}/*
%{_mandir}/*/*

#%files devel
#%defattr(-,root,root)
#%dir %{_includedir}/sysklogd
#%{_includedir}/sysklogd/*

%changelog
* Wed Aug  4 2010 Austin Zhang <austin.zhang@intel.com> - 1.5
- Do not sync log into file so frequently, decrease disk IO
  for booting stage; BMC#3810
* Tue Jan 12 2010 Anas Nashif <anas.nashif@intel.com> - 1.5
- Do not start by default, done in rc.system
* Thu Oct  1 2009 Anas Nashif <anas.nashif@intel.com> - 1.5
- Initial import into Moblin
* Sun Jul 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.5-9
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild
* Wed Feb 25 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.5-8
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild
* Wed Jan 14 2009 Jeroen van Meeuwen <kanarip@kanarip.com> - 1.5-7
  Fix chkconfig line (#478794)
* Thu Dec 25 2008 Jeroen van Meeuwen <kanarip@fedoraproject.org> - 1.5-6
- XMas build
- Fix chkconfig service syslog -> chkconfig service sysklogd
* Sat Dec 13 2008 Jeroen van Meeuwen <kanarip@fedoraproject.org> 1.5-5
- Put binaries in the correct path (#471701)
* Fri Oct 17 2008 Jeroen van Meeuwen <kanarip@fedoraproject.org> 1.5-3
- Don't strip binaries (results in empty debuginfo package), #465139
* Fri Aug  8 2008 Jeroen van Meeuwen <kanarip@fedoraproject.org> 1.5-2
- Remove more -devel (#313090)
* Fri Jun  6 2008 Jeroen van Meeuwen <kanarip@fedoraproject.org> 1.5-1
- New upstream version
* Mon Apr 16 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.2-5
- sysklogd provides new realtime interface (#236356)
* Wed Apr 11 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.2-4
- some fixes of previous release (#223573)
* Mon Mar 26 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.2-3
- include priority/facility in message (#223573)
* Mon Mar 12 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.2-2
- log in syslog own timezone (#231326)
* Mon Feb 26 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.2-1
- new upstream(RH) release.
* Tue Feb 20 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.1-48
- fixing another issues from (#226448)
* Tue Feb 20 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.1-47
- fix spec file to meet Fedora standards (#226448)
* Wed Feb  7 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.1-46
- do not stop running syslog-ng during sysklogd uninstall (#182605)
* Wed Jan 31 2007 Nils Philippsen <nphilipp@redhat.com> 1.4.1-45
- fix typo in %%%%post scriptlet
* Mon Jan 29 2007 Peter Vrabec <pvrabec@redhat.com> 1.4.1-44
- fix scriptlets
* Wed Dec 13 2006 Peter Vrabec <pvrabec@redhat.com> 1.4.1-43
- fix some rpmlint issues
* Sat Dec  9 2006 Peter Vrabec <pvrabec@redhat.com> 1.4.1-42
- fix IPv6 patch
* Thu Nov 23 2006 Peter Vrabec <pvrabec@redhat.com> 1.4.1-41
- improve IPv6 patch
* Wed Nov 22 2006 Peter Vrabec <pvrabec@redhat.com> 1.4.1-40
- add IPv6 support
* Wed Sep 13 2006 Florian La Roche <laroche@redhat.com> - 1.4.1-39.2
- make sure scripts don't return an error
* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 1.4.1-39.1
- rebuild
* Wed Jun 14 2006 Jesse Keating <jkeating@redhat.com> - 1.4.1-39
- Add Requires(post) and (postun) on /sbin/service (fixes scriptlet errors)
* Wed Jun 14 2006 Jason Vas Dias <jvdias@redhat.com> - 1.4.1-38
- fix bug 194494 - move logfile touching back to %%%%postun
* Thu Feb 23 2006 Jason Vas Dias <jvdias@redhat.com> - 1.4.1-36
- fix bug 182605: only chkconfig --add in %%%%post if $1 -eq 1
* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1.4.1-34.2
- bump again for double-long bug on ppc(64)
* Tue Feb  7 2006 Jesse Keating <jkeating@redhat.com> - 1.4.1-34.1
- rebuilt for new gcc4.1 snapshot and glibc changes
* Thu Dec 15 2005 Jason Vas Dias<jvdias@redhat.com> 1.4.1rh-34
- Add 'Provides: syslog' for bug 172885
* Fri Dec  9 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt
* Wed Aug 24 2005 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-33
- fix bug 166643: klogd needs to use internal syslog functions in syslog.c,
  because only they allow logging with facility==kernel.
- fix prototypes to allow use of internal syslog functions.
* Mon Aug 15 2005 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-32
- fix bug 165972: remove unused syslog.o from klogd; do not compile syslog.c
* Tue Jun  7 2005 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-31
- fix bug 62679:  give initscript a reload option
- fix bug 78371:  make syslogd's umask configurable in sysconfig/syslog
  with initscript SYSLOG_UMASK option
* Thu May 19 2005 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-30
- fix bug 158205: fix MARK message generation. Patch contributed
  by Ray Van Tassle of Motorola
* Mon Mar 28 2005 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-28
- Fix bug 152319: potential ctime() deadlock in domark() when called
  from signal handler
* Fri Jan 14 2005 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-26
- Final fixup of '@host' name checking code: remove possible
- duplicates properly
* Tue Jan  4 2005 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-25
- Fix bug 144084 - bad version of '@host' name checking code
- used by mistake + memory corruption caused by free of
- addrinfo node returned by getaddrinfo().
* Thu Dec  2 2004 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-24
- Allow kernel printk's to emit an odd number of continuous '%%'s .
- (#141545)
* Thu Dec  2 2004 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-24
- Do not allow hostnames that resolve to the address of a local
- interface to be used for forwarding, else syslogd gets into
- an infinite loop sending messages to itself (as reported by
- Chuck Mead <csm@redhat.com>).
* Wed Dec  1 2004 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-23
- Allow SIGALRM to interrupt system calls, as syslogd expects.
- In Fedora Core, signal(SIGALRM,...) uses SA_RESTART; one is
- required to use siginterrupt() to get interruptable system calls.
- (#140983)
* Wed Aug 25 2004 Jason Vas Dias <jvdias@redhat.com> 1.4.1rh-22
- Fix race condition where child sends SIGTERM before parent handles it
- (#126223, #123906)
* Mon Jun 28 2004 Bill Nottingham <notting@redhat.com> 1.4.1rh-21
- async logging for mail (#73306)
* Sun Jun 20 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- do not set bsd compat on sockets #123912
- fix empty log lines #125679
* Fri Jun 11 2004 Florian La Roche <laroche@redhat.com> 1.4.1rh-18
- make the race for -HUP a little bit smaller
* Wed Jun  9 2004 Bill Nottingham <notting@redhat.com> 1.4.1rh-17
- don't escape UTF-8 (#89292, #71170, #112519)
* Mon May  3 2004 Bill Nottingham <notting@redhat.com> 1.4.1rh-16
- add Owl patch for crunch_list function, fixes potential crashes (#120453)
* Wed Apr  7 2004 Bill Nottingham <notting@redhat.com> 1.4.1rh-15
- fix recvfrom() on 64-bit big-endian platforms (#120201)
* Mon Mar  8 2004 Bill Nottingham <notting@redhat.com> 1.4.1rh-14
- rebuild (#117696)
* Thu Feb 12 2004 Thomas Woerner <twoerner@redhat.com> 1.4.1rh-13
- make sysklogd pie
* Fri Feb  7 2003 Tim Powers <timp@redhat.com> 1.4.1rh-12
- rebuild
* Wed Jan  8 2003 Tim Powers <timp@redhat.com> 1.4.1rh-11
- bump release number
* Fri Dec 20 2002 Elliot Lee <sopwith@redhat.com> 1.4.1rh-10
- _smp_mflags
* Mon Jun 17 2002 Bill Nottingham <notting@redhat.com> 1.4.1rh-9
- don't forcibly strip binaries
* Wed Apr 17 2002 Bill Nottingham <notting@redhat.com> 1.4.1rh-8
- revert loglevel setting to previous behavior (#63664)
* Tue Mar 12 2002 Bill Nottingham <notting@redhat.com> 1.4.1rh-7
- don't *require* logrotate, but conflict with older versions
- fix fd leak of System.map (#52901)
- switch to -x for klogd by default; we have kksymoops
- provide LSB facility
* Wed Aug 15 2001 Bill Nottingham <notting@redhat.com>
- enable LFS for log files
* Tue Aug 14 2001 Bill Nottingham <notting@redhat.com>
- fix comments in config file (#51678)
* Fri Aug  3 2001 Bill Nottingham <notting@redhat.com>
- require a specific version of logrotate (#50794)
- fix %%%%preun for the case when it's not running (#50123)
* Sun Jul  8 2001 Bill Nottingham <notting@redhat.com>
- merge with 1.4.1
* Wed Feb  7 2001 Bill Nottingham <notting@redhat.com>
- i18n tweaks
* Tue Jan 23 2001 Bill Nottingham <notting@redhat.com>
- new translation stuff
* Fri Jan 19 2001 Bill Nottingham <notting@redhat.com>
- adapt /etc/sysconfig/syslog for specification of arbitrary options (#23171)
- fix translation string slightly (#24088)
* Mon Dec 18 2000 Bill Nottingham <notting@redhat.com>
- don't set owner/group on manpages on install
- read /etc/sysconfig/syslog if present for some configuration paramters
- fix build with new kernel headers
* Tue Dec 12 2000 Bill Nottingham <notting@redhat.com>
- start klogd with '-2'
* Mon Dec 11 2000 Bill Nottingham <notting@redhat.com>
- update to 1.4
* Fri Dec  1 2000 Bill Nottingham <notting@redhat.com>
- rebuild because of broken fileutils
* Fri Oct 13 2000 Bill Nottingham <notting@redhat.com>
- don't log cron in two separate places (#18122)
* Thu Sep 14 2000 Bill Nottingham <notting@redhat.com>
- more fixes from solar@false.com, dan@debian.org; fix the security fix
* Tue Sep 12 2000 Jakub Jelinek <jakub@redhat.com>
- never ever call syslog with a user supplied string as second argument
* Mon Aug  7 2000 Bill Nottingham <notting@redhat.com>
- put cron logs in /var/log/cron; rotate them
* Wed Aug  2 2000 Bill Nottingham <notting@redhat.com>
- start at position 12, not 30 (we *need* to be before nfslock now)
* Fri Jul 28 2000 Bill Nottingham <notting@redhat.com>
- um, how did %%%%preun get tacked onto %%%%post?
- fix condrestart stuff
* Fri Jul 21 2000 Bill Nottingham <notting@redhat.com>
- add a umask call to the initscript
* Fri Jul 14 2000 Bill Nottingham <notting@redhat.com>
- move initscript back
* Fri Jul 14 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- update to 1.3.33
* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild
* Tue Jul 11 2000 Bill Nottingham <notting@redhat.com>
- fix logrotate script (#13698)
* Thu Jul  6 2000 Bill Nottingham <notting@redhat.com>
- prereq /etc/init.d
* Thu Jun 29 2000 Bill Nottingham <notting@redhat.com>
- fix init script
* Tue Jun 27 2000 Bill Nottingham <notting@redhat.com>
- require, not prereq new initscripts
* Mon Jun 26 2000 Bill Nottingham <notting@redhat.com>
- initscript munging
* Wed Jun 14 2000 Nalin Dahyabhai <nalin@redhat.com>
- modify logrotate configuration to use the PID file
* Sun Jun 11 2000 Bill Nottingham <notting@redhat.com>
- rebuild in new environment, FHS fixes
* Mon Mar 27 2000 Bill Nottingham <notting@redhat.com>
- handle bad directories passed to '-a' without behaving strangely (#10363)
- remove compatibility chkconfig links
* Thu Feb  3 2000 Bill Nottingham <notting@redhat.com>
- handle compressed man pages
* Wed Dec  1 1999 Bill Nottingham <notting@redhat.com>
- add patch to fix segfaults in ksym-less cases from HP
* Mon Nov 15 1999 Bill Nottingham <notting@redhat.com>
- fix ECONNRESETs from security patch (olaf)
* Sat Sep 25 1999 Bill Nottingham <notting@redhat.com>
- eek. The security patch broke *two* things...
* Wed Sep 22 1999 Bill Nottingham <notting@redhat.com>
- make klogd actually work.
* Wed Sep  8 1999 Bill Nottingham <notting@redhat.com>
- rotate boot.log
* Tue Sep  7 1999 Cristian Gafton <gafton@redhat.com>
- add patch to fix a possible DoS (thanks Olaf Kirch)
* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- initscript munging
* Mon Aug  9 1999 Bill Nottingham <notting@redhat.com>
- patch to fix non-null terminated stuff in klogd
* Mon Jun 21 1999 Bill Nottingham <notting@redhat.com>
- move (sys|k)logd to /sbin
* Tue Apr 13 1999 Bill Nottingham <notting@redhat.com>
- log boot messages to boot.log
- actually put the sysklogd links in the new place
* Mon Apr  5 1999 Cristian Gafton <gafton@redhat.com>
- disable mark ticks by default
* Thu Apr  1 1999 Bill Nottingham <notting@redhat.com>
- stop klogd/syslogd as late as possible.
* Fri Mar 26 1999 Bill Nottingham <notting@redhat.com>
- twiddle initscript to avoid confusion
* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 2)
* Wed Feb 24 1999 Bill Nottingham <notting@redhat.com>
- update to sysklogd-1.3-31
- stop klogd *before* syslogd
* Tue Feb  9 1999 Jeff Johnson <jbj@redhat.com>
- escape naked percent chars in kernel messages (#1088).
* Thu Dec 17 1998 Jeff Johnson <jbj@redhat.com>
- rework last-gasp address-in-module oops trace for both 2.0.x/2.1.x modules.
* Mon Dec  7 1998 Jakub Jelinek <jj@ultra.linux.cz>
- make klogd translate SPARC register dumps and oopses.
* Tue Aug 11 1998 Jeff Johnson <jbj@redhat.com>
- add %%%%clean
* Tue Aug  4 1998 Chris Adams <cadams@ro.com>
- only log to entries that are USER_PROCESS (fix #822)
* Mon Jul 27 1998 Jeff Johnson <jbj@redhat.com>
- remove RPM_BUILD_ROOT from %%%%post
* Wed Apr 29 1998 Cristian Gafton <gafton@redhat.com>
- patch to support Buildroot
- package is now buildrooted
* Wed Apr 29 1998 Michael K. Johnson <johnsonm@redhat.com>
- Added exit patch so that a normal daemon exit is not flagged as an error.
* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr
* Wed Oct 29 1997 Donnie Barnes <djb@redhat.com>
- added (missingok) to init symlinks
* Thu Oct 23 1997 Donnie Barnes <djb@redhat.com>
- added status|restart support to syslog.init
- added chkconfig support
- various spec file cleanups
* Tue Jun 17 1997 Erik Troan <ewt@redhat.com>
- built against glibc
