%define aclocaldir /usr/share/aclocal
%define _sbindir /sbin

Summary: The GNU disk partition manipulation program
Name:    parted
Version: 1.8.6
Release: 10.2
License: GPLv2+
Group:   Applications/System
URL:     http://www.gnu.org/software/parted

Source:  ftp://ftp.gnu.org/gnu/%{name}/%{name}-%{version}.tar.bz2
Patch0: %{name}-1.8.6-warnings.patch
Patch1: %{name}-1.8.6-notransname.patch
Patch2: %{name}-1.8.6-off-by-one.patch
Patch3: %{name}-1.8.6-primary-boundary.patch
Patch4: %{name}-1.8.6-xvd.patch
Patch5: %{name}-1.8.6-devmapper-header.patch
Patch6: %{name}-1.8.6-ped_div_round.patch
Patch7: %{name}-1.8.6-gcc-warning-gen_new_serial_number.patch
Patch8: %{name}-1.8.6-gcc-warning-fat_dir_entry.patch
Patch9: %{name}-1.8.6-gcc-warning-s_sigint_handler.patch

Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: e2fsprogs-devel readline-devel ncurses-devel libuuid-devel
BuildRequires: libtool gettext-devel texinfo
BuildRequires: device-mapper-devel

Requires(post): /sbin/ldconfig
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Requires(postun): /sbin/ldconfig

%description
The GNU Parted program allows you to create, destroy, resize, move,
and copy hard disk partitions. Parted can be used for creating space
for new operating systems, reorganizing disk usage, and copying data
to new hard disks.

%package devel
Summary:  Files for developing apps which will manipulate disk partitions
Group:    Development/Libraries
Requires: %{name} = %{version}-%{release} pkgconfig
%description devel
The GNU Parted library is a set of routines for hard disk partition
manipulation. If you want to develop programs that manipulate disk
partitions and filesystems using the routines provided by the GNU
Parted library, you need to install this package.

%prep
%setup -q
%patch0 -p1 -b .warnings
%patch1 -p1 -b .notransname
%patch2 -p1 -b .offbyone
%patch3 -p1 -b .boundary
%patch4 -p1 -b .xvd
%patch5 -p1 -b .devmapper
%patch6 -p1 -b .ped_div_round
%patch7 -p1 -b .gcc-warning-gen_new_serial_number
%patch8 -p1 -b .gcc-warning-fat_dir_entry
%patch9 -p1 -b .gcc-warning-s_sigint_handler

%build
#export CFLAGS="-O2 -g -pipe -Wall -Wp,-D_FORTIFY_SOURCE=2 -fexceptions -fstack-protector --param=ssp-buffer-size=4 -Wformat -Wformat-security -m32 -march=core2 -mssse3  -mtune=atom -mfpmath=sse -fasynchronous-unwind-tables -fno-omit-frame-pointer"
%configure --disable-static --disable-device-mapper --disable-selinux
%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%{__make} install DESTDIR=%{buildroot}
%{__rm} -rf %{buildroot}%{_libdir}/*.la
%{__rm} -rf %{buildroot}%{_infodir}/dir
%{__rm} -f %{buildroot}%{_bindir}/label

%find_lang %{name}

%clean
%{__rm} -rf %{buildroot}

%post
/sbin/ldconfig
/sbin/install-info %{_infodir}/parted.info.gz %{_infodir}/dir || :

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/parted.info.gz %{_infodir}/dir >/dev/null 2>&1 || :
fi

%postun -p /sbin/ldconfig

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc AUTHORS BUGS COPYING ChangeLog NEWS README THANKS TODO doc/API doc/FAT
%{_sbindir}/parted
%{_sbindir}/partprobe
%{_mandir}/man8/parted.8.gz
%{_mandir}/man8/partprobe.8.gz
%{_libdir}/libparted-*.so.*
%{_infodir}/parted.info.gz

%files devel
%defattr(-,root,root,-)
%{_includedir}/parted
%{_libdir}/libparted.so
%{_libdir}/pkgconfig/libparted.pc

%changelog
* Fri Nov 16 2012 Dragos Stoica <dragos.stoica@windriver.com> - 1.8.6-10
- Fix gcc(4.5.1) warnings 

* Thu Oct 04 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-10
- Do not install the testsuite tools

* Thu Oct 04 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-9
- Always define PED_DEVICE_DM regardless of compile time options

* Tue Aug 21 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-8
- Rebuild

* Wed Aug 08 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-7
- Update License tag to GPLv2+

* Tue Aug 07 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-6
- Detect Xen virtual block devices and set model name appropriately

* Thu Apr 19 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-5
- Spec file cleanups for merge review (#226230)

* Fri Apr 13 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-4
- Fix primary partition cylinder alignment error for DOS disk labels (#229745)
- Do not build and package up libparted.a, only the shared library

* Wed Apr 11 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-3
- Fix off-by-one bug in parted(8) when displaying disk label (#235901)

* Wed Mar 21 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-2
- Do not translate partition name from disk label (#224182)

* Tue Mar 20 2007 David Cantrell <dcantrell@redhat.com> - 1.8.6-1
- Upgrade to GNU parted-1.8.6, summary of major change(s):
     a) Revert linux-swap(new) and linux-swap(old) fs types, it's
        linux-swap for all swap types (#233085)

* Tue Mar 20 2007 David Cantrell <dcantrell@redhat.com> - 1.8.5-1
- Upgrade to GNU parted-1.8.5 (added missing po files)

* Fri Mar 16 2007 David Cantrell <dcantrell@redhat.com> - 1.8.4-1
- Upgrade to GNU parted-1.8.4, summary of major changes:
     a) Update to use newest GNU developer tools
     b) Use gnulib, the GNU portability library
     c) HFS+ resize support
     d) Windows Vista fixes
     e) AIX disk label fixes
     f) >512 byte logical sector read support on Linux
- Spec file cleanups per Fedora packaging guidelines

* Thu Feb 08 2007 David Cantrell <dcantrell@redhat.com> - 1.8.2-5
- Remove period from end of summary line (package review)
- Use preferred BuildRoot (package review)
- BR device-mapper-devel

* Tue Jan 30 2007 David Cantrell <dcantrell@redhat.com> - 1.8.2-4
- Patched parted.8 man page to show partition names apply to GPT disklabels
  as well as Mac and PC98 disklabels (#221600)

* Mon Jan 22 2007 David Cantrell <dcantrell@redhat.com> - 1.8.2-3
- Remove BR for libtermcap-devel
- Specifically preserve starting alignment of 0x800 on Windows Vista
  (see http://support.microsoft.com/kb/923332 for details)
- Fix incorrect sector parameter used to initialize a new PedAlignment

* Thu Jan 18 2007 David Cantrell <dcantrell@redhat.com> - 1.8.2-2
- Preserve starting sector for primary NTFS 3.1 partitions (Windows
  Vista) when modifying the DOS disk label.  NTFS 3.1 partitions do
  not start on the 2nd head of the 1st cylinder at the beginning of
  the drive.

* Fri Jan 12 2007 David Cantrell <dcantrell@redhat.com> - 1.8.2-1
- Upgrade to GNU parted-1.8.2

* Fri Dec 15 2006 David Cantrell <dcantrell@redhat.com> - 1.8.1-2
- Fix a segfault when initializing new volumes (pjones)

* Mon Dec 04 2006 David Cantrell <dcantrell@redhat.com> - 1.8.1-1
- Upgrade to GNU parted-1.8.1

* Fri Nov 17 2006 David Cantrell <dcantrell@redhat.com> - 1.8.0-1
- Upgrade to GNU parted-1.8.0

* Thu Nov 02 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-18
- Detect Apple_Boot partition types correctly (#204714)

* Thu Oct 26 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-17
- For init_generic() failures on user-mode Linux block devices, goto
  error_free_arch_specific instead of error_free_dev.

* Wed Oct 04 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-16
- Don't throw PED_EXCEPTION_ERROR in ped_geometry_read() if accessing
  sectors outside of partition boundary, since returning false will
  shift ped_geometry_check() to the correct sectors.

* Wed Aug 23 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-15
- Fixed gpt patch (*asked_already -> asked_already, whoops)

* Tue Aug 22 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-14
- Improve error message returned by _parse_header() on GPT-labeled disks
  so users actually have an idea of how to correct the problem
- Fix off-by-one error with LastUsableLBA and PartitionEntryLBA overlap
  to prevent possible data corruption when using non-parted GPT editing
  tools

* Mon Aug 21 2006 Peter Jones <pjones@redhat.com> - 1.7.1-13
- Don't use the "volume name" as the device node name on dm device
  partitions, it isn't really what we want at all.

* Thu Aug 17 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-12
- Updated O_DIRECT patch to work around s390 problems
- Update LastUsableLBA on GPT-labeled disks after LUN resize (#194238)
- Fix exception when backup GPT table is not in the correction location
  and parted tries to move it (#194238)

* Tue Aug 15 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-11
- Expand error buffer to 8192 bytes in vtoc_error()
- Do not apply O_DIRECT patch on S/390 or S/390x platforms

* Mon Aug 14 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-10
- Removed bad header file patch (#200577)

* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 1.7.1-9.1
- rebuild

* Wed Jul  5 2006 Peter Jones <pjones@redhat.com> - 1.7.1-9
- add ped_exception_get_handler()

* Mon Jun 26 2006 Florian La Roche <laroche@redhat.com> - 1.7.1-8
- remove info files in preun

* Thu Jun 22 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-7
- PED_SECTOR_SIZE -> PED_SECTOR_SIZE_DEFAULT

* Thu Jun 22 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-6
- Roll dasd patches together
- Use O_DIRECT to prevent first partition corruption on GPT disks

* Thu Jun 15 2006 Jeremy Katz <katzj@redhat.com> - 1.7.1-5
- fix segfaults with dasd devices

* Wed Jun  7 2006 Jeremy Katz <katzj@redhat.com> - 1.7.1-4
- move .so symlink to -devel subpackage

* Sun May 28 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-3
- Rebuild

* Sun May 28 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-2
- Removed mac-swraid patch (added upstream)
- Updated device-mapper patch for parted-1.7.1

* Sat May 27 2006 David Cantrell <dcantrell@redhat.com> - 1.7.1-1
- Upgraded to parted-1.7.1

* Fri May 19 2006 David Cantrell <dcantrell@redhat.com> - 1.7.0-1
- Upgraded to parted-1.7.0

* Thu Apr 13 2006 David Cantrell <dcantrell@redhat.com> - 1.6.25.1-1
- Upgraded to parted-1.6.25.1
- BuildRequires libtool

* Tue Mar 14 2006 Jeremy Katz <katzj@redhat.com> - 1.6.25-8
- fix ppc swraid
- BR gettext-devel

* Wed Feb 22 2006 Peter Jones <pjones@redhat.com> - 1.6.25-7
- close /proc/devices correctly

* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1.6.25-6.1
- bump again for double-long bug on ppc(64)

* Tue Feb  7 2006 Peter Jones <pjones@redhat.com> 1.6.25-6
- Fix dm partition naming.

* Tue Feb  7 2006 Jesse Keating <jkeating@redhat.com> 1.6.25-5.2
- rebuilt for new gcc4.1 snapshot and glibc changes

* Fri Dec  9 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt

* Fri Dec  2 2005 Peter Jones <pjones@redhat.com> 1.6.25-5
- rebuild for new device-mapper

* Thu Dec  1 2005 Peter Jones <pjones@redhat.com> 1.6.25-4
- change device-mapper code to call dm_task_update_nodes() after
  tasks which change device nodes.

* Wed Nov 16 2005 Peter Jones <pjones@redhat.com> 1.6.25-3
- fix /proc/devices parser bug

* Tue Nov 15 2005 Peter Jones <pjones@redhat.com> 1.6.25-2
- add support for partitions on dm devices

* Wed Nov 09 2005 Chris Lumens <clumens@redhat.com> 1.6.25-1
- Updated to 1.6.25.
- Update DASD, iseries, and SX8 patches.

* Tue Aug 30 2005 Chris Lumens <clumens@redhat.com> 1.6.24-1
- Updated to 1.6.24.

* Mon Jul 18 2005 Chris Lumens <clumens@redhat.com> 1.6.23-2
- Add buildreq for texinfo.

* Fri Jul 08 2005 Chris Lumens <clumens@redhat.com> 1.6.23-1
- Updated to 1.6.23.
- Get rid of separate Mac patches that are now included in upstream.
- Update DASD and AIX patches.

* Tue Jun 07 2005 Chris Lumens <clumens@redhat.com> 1.6.22-3
- Modified Apple_Free patch to take care of the case where the partitions
  are unnamed, causing many errors to be printed (#159047).

* Thu May 05 2005 Chris Lumens <clumens@redhat.com> 1.6.22-2
- Added upstream patch to display certain Apple_Free partitions (#154479).

* Wed Mar 23 2005 Chris Lumens <clumens@redhat.com> 1.6.22-1
- Updated to 1.6.22.
- Get rid of separate gc4 patch that's now included upstream.
- Take Mac LVM patch from parted CVS.

* Mon Mar 14 2005 Chris Lumens <clumens@redhat.com> 1.6.21-3
- Include patches from parted CVS for new gcc4 warnings.

* Sun Feb 20 2005 Paul Nasrat <pnasrat@redhat.com> 1.6.21-2
- Support lvm flags on mac partitions (#121266)

* Fri Jan 21 2005 Chris Lumens <clumens@redhat.com> 1.6.21-1 
- Updated to 1.6.21

* Wed Jan 12 2005 Tim Waugh <twaugh@redhat.com> 1.6.20-2
- Rebuilt for new readline.

* Fri Jan 07 2005 Chris Lumens <clumens@redhat.com> 1.6.20-1 
- Updated to 1.6.20 (#139257, #142100).
- Updated DASD and AIX patches for 1.6.20.

* Tue Dec 14 2004 Jeremy Katz <katzj@redhat.com> - 1.6.19-2
- add support for Promise SX8 devices

* Sun Nov 28 2004 Jeremy Katz <katzj@redhat.com> - 1.6.19-1
- update to 1.6.19 (#138419)

* Sun Nov 21 2004 Jeremy Katz <katzj@redhat.com> - 1.6.18-1
- update to 1.6.18

* Sat Nov 20 2004 Miloslav Trmac <mitr@redhat.com> - 1.6.16-3
- Convert pt_BR-parted.8 to UTF-8

* Thu Nov 11 2004 Jeremy Katz <katzj@redhat.com> - 1.6.16-2
- add patch from Matt Domsch to fix consistency of GPT disk labels 
  with the EFI specification for disks > 2TB (#138480)
- understand the new Sun UFS partition ID
- merge the new geometry probing from CVS to see if that helps the 
  assertions people are seeing (#138419)

* Mon Nov  8 2004 Jeremy Katz <katzj@redhat.com> - 1.6.16-1
- update to 1.6.16
- rebuild for python 2.4

* Mon Oct 18 2004 Jeremy Katz <katzj@redhat.com> - 1.6.15-5
- add patch from Matt Domsch to add a unique signature to new DOS labels 
  so that we can later determine which BIOS disk is which (#106674)

* Fri Oct 15 2004 Phil Knirsch <pknirsch@redhat.com> 1.6.15-4
- Fixed dasd patch (had some duplicate file patches in it)
- Fixed problem with parted segfaulting on SCSI discs on s390 (#133997)

* Tue Oct 12 2004 Jeremy Katz <katzj@redhat.com> - 1.6.15-3
- add patch from peterm to fix printing of the size of large devices (#135468)

* Thu Oct 07 2004 Phil Knirsch <pknirsch@redhat.com> 1.6.15-2
- Fixed geometry calculation for bios_geo in dasd_init()

* Mon Sep 20 2004 Jeremy Katz <katzj@redhat.com> - 1.6.15-1
- 1.6.15

* Fri Sep 10 2004 Jeremy Katz <katzj@redhat.com> - 1.6.14-1
- update to 1.6.14

* Tue Aug 24 2004 Jeremy Katz <katzj@redhat.com> - 1.6.12-2
- fix assertion error when checking flags on non-active partition (#130692)
- buildrequires: gettext-devel

* Mon Aug 16 2004 Jeremy Katz <katzj@redhat.com> - 1.6.12-1
- update to 1.6.12 with major changes to CHS handling to hopefully fix #115980
- adjust dasd patch accordingly, drop some included patches

* Mon Jul 19 2004 Karsten Hopp <karsten@redhat.de> 1.6.11-4 
- update dasd patch for dos-type partitions on mainframes (scsi disks)

* Fri Jun 25 2004 Jeremy Katz <katzj@redhat.com> - 1.6.11-3
- install-info (#77687)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com> - 1.6.11-2
- rebuilt

* Tue Jun  1 2004 Jeremy Katz <katzj@redhat.com>
- -devel requires main package (#124938)

* Thu May 13 2004 Jeremy Katz <katzj@redhat.com> - 1.6.11-1
- update to 1.6.11

* Tue May 11 2004 Jeremy Katz <katzj@redhat.com> - 1.6.9-4
- add patch from Matt Domsch to not use the get/set last sector ioctls 
  with a 2.6 kernel (#121455)

* Thu Apr 15 2004 David Woodhouse <dwmw2@redhat.com> - 1.6.9-3
- Fix Mac partition detection to close #112937

* Tue Apr 13 2004 Jeremy Katz <katzj@redhat.com> - 1.6.9-2
- another minor tweak for 2.6's lack of sane geometry handling

* Mon Apr 12 2004 Jeremy Katz <katzj@redhat.com> - 1.6.9-1
- update to 1.6.9
- need automake17
- python-devel is superfluous with pyparted as a separate package
- lose the fake-libtool stuff, 1.6.9 was disted with newer auto*

* Mon Mar 15 2004 Elliot Lee <sopwith@redhat.com> 1.6.6-2
- Fix parted's "part-static" option to close #118183. Woohoo, a fake-libtool.sh :)

* Fri Mar 12 2004 Jeremy Katz <katzj@redhat.com> - 1.6.6-1
- update to 1.6.6 
- split dasd into a patch instead of included in the tarball
- python module is now in the pyparted package (separate src.rpm)
- ExcludeArch: ppc64 (#118183)

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb  6 2004 Jeremy Katz <katzj@redhat.com>
- add automake buildrequires (#115063)

* Thu Jan 22 2004 Jeremy Katz <katzj@redhat.com> 1.6.3-33
- 2.6 removes the geometry fixups that used to be present for IDE disks.  
  According to Andries, just follow what's in the partition table and don't 
  worry about what Linux "detects"

* Thu Nov  6 2003 Jeremy Katz <katzj@redhat.com> 1.6.3-32
- rebuild for python 2.3

* Mon Oct 27 2003 Jeremy Katz <katzj@redhat.com> 1.6.3-31
- add patch from Michael Schwendt <mschwendt@users.sf.net> for segfault

* Wed Sep 17 2003 Jeremy Katz <katzj@redhat.com> 1.6.3-30
- rebuild

* Wed Sep 17 2003 Jeremy Katz <katzj@redhat.com> 1.6.3-29
- and don't barf on the old (broken) 1.02 gpt rev

* Tue Sep 16 2003 Jeremy Katz <katzj@redhat.com> 1.6.3-28
- rebuild

* Tue Sep 16 2003 Jeremy Katz <katzj@redhat.com> 1.6.3-27
- write out the correct gpt revision (#103664)
- add buildrequires on ncurses-devel

* Thu Sep  4 2003 Bill Nottingham <notting@redhat.com> 1.6.3-26
- rebuild 

* Thu Sep  4 2003 Bill Nottingham <notting@redhat.com> 1.6.3-25
- don't buildreq libunicode-devel

* Thu Aug 07 2003 Elliot Lee <sopwith@redhat.com> 1.6.3-24
- Fix libtool

* Wed Jul 09 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-23
- Fixed dasd_write and dasd_read to support lvm and raid partitions.

* Wed Jun 18 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-22
- Fixed a small bug in VTOC fdasd_check_volume() (#97300).

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com> 1.6.3-21
- rebuilt

* Wed Jun  4 2003 Matt Wilson <msw@redhat.com> 1.6.3-20
- don't detect AIX physical volumes as msdos partition tables (#91748)
- added stubbed code for manipulating AIX PVs, enough to clobber the
  signature. (#91748)

* Wed Jun 04 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-19
- Added LDL disk layout support for s390(x).

* Sun May 18 2003 Matt Wilson <msw@redhat.com> 1.6.3-18
- use metadata partitions to protect DASD VTOC
- stash DASD specific data in disk specific areas, not arch specific
  areas.

* Fri May 16 2003 Matt Wilson <msw@redhat.com> 1.6.3-18
- recongnize iseries viodasd (#90449)

* Thu May 08 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-17
- Fixed problem with probing partitions on s390(x) with new partition code.

* Mon May 05 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-16
- Fixed partiton reread code for s390(x).

* Fri May 02 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-15
- Rewrote partition handling for s390(x) dasd devices. No more empty partitions.

* Wed Mar 12 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-13
- Finished updating vtoc and fdasd code to latest s390-utils version.

* Thu Mar 06 2003 Phil Knirsch <pknirsch@redhat.com> 1.6.3-12
- Fixed vtoc handling on s390(x) dasd devices.

* Thu Feb 06 2003 Karsten Hopp <karsten@redhat.de> 1.6.3-11
- use different define to enable DASD debugging
  Otherwise we'll get a lot of dasd debug output because DEBUG is
  always defined

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Jan 22 2003 Karsten Hopp <karsten@redhat.de> 1.6.3-9
- missed one debug message

* Tue Jan 21 2003 Karsten Hopp <karsten@redhat.de> 1.6.3-8
- add patch from CVS to disable debug messages on s390

* Tue Jan 14 2003 Matt Wilson <msw@redhat.com> 1.6.3-7
- updated to a new tarball of parted that includes a fs.probe_specific binding

* Sun Dec  1 2002 Matt Wilson <msw@redhat.com> 1.6.3-6
- hack in partition.native_type (#78118)

* Thu Nov  7 2002 Matt Wilson <msw@redhat.com>
- added a patch to avoid SIGFPE when fat sector size is 0

* Tue Nov  5 2002 Matt Wilson <msw@redhat.com>
- use --disable-dynamic-loading

* Mon Nov  4 2002 Matt Wilson <msw@redhat.com>
- add device.disk_new_fresh()

* Fri Nov  1 2002 Matt Wilson <msw@redhat.com>
- 1.6.3

* Fri Oct  4 2002 Jeremy Katz <katzj@redhat.com> 1.4.24-7
- use make LIBTOOL=/usr/bin/libtool instead of recreating everything
- add patch from Jack Howarth <howarth@bromo.med.uc.edu> to self host properly
- add patch to treat GPT structs as little-endian always and treat GUIDS 
  as little-endian blobs
- add patch to recognize hp service partitions

* Wed Sep 25 2002 Jeremy Katz <katzj@redhat.com> 1.4.24-6hammer
- libtoolize, etc for x86_64
- hack to get the python module in the right place until python.m4 
  from automake is fixed

* Fri Jun 21 2002 Tim Powers <timp@redhat.com> 1.4.24-6
- automated rebuild

* Sun May 26 2002 Tim Powers <timp@redhat.com> 1.4.24-5
- automated rebuild

* Wed May 22 2002 Jeremy Katz <katzj@redhat.com> 1.4.24-4
- rebuild in new environment

* Fri Mar 22 2002 Matt Wilson <msw@redhat.com> 1.4.24-3
- fixed the probe-with-open behavior (again)

* Fri Feb 22 2002 Matt Wilson <msw@redhat.com> 1.4.24-1
- rebuild

* Tue Feb 12 2002 Matt Wilson <msw@redhat.com> 1.4.24-1
- 1.4.24

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Jan  7 2002 Jeremy Katz <katzj@redhat.com> 1.4.20-4
- build with final python 2.2

* Wed Dec 12 2001 Jeremy Katz <katzj@redhat.com> 1.4.20-3
- update from CVS and rebuild in new environment

* Thu Oct 25 2001 Jeremy Katz <katzj@redhat.com> 1.4.20-2
- build both python1.5 and python2 modules

* Fri Oct 19 2001 Matt Wilson <msw@redhat.com> 1.4.20-1	
- 1.4.20 final

* Thu Oct 11 2001 Matt Wilson <msw@redhat.com> 1.4.20-0.1pre3
- new dist from CVS with new autoconf and automake
- gpt is in 1.4.20, removed patch1 (gpt support)
- partstatic is in 1.4.20, removed patch2 (partstatic patch)

* Tue Aug 28 2001 Matt Wilson <msw@redhat.com> 1.4.16-8
- new dist from cvs with changes to the python binding: register
  DEVICE_I20 and DEVICE_ATARAID, check to make sure that a partition
  exists in the PedDisk when using it to find ped_disk_next_partition

* Tue Aug 21 2001 Matt Wilson <msw@redhat.com> 1.4.16-7
- really disable pc98 support (SF #51632)

* Fri Aug 17 2001 Matt Wilson <msw@redhat.com> 1.4.16-6
- added a patch (Patch1) to link the c library in dynamically, the
  rest of the libs statically for the parted binary (MF #49358)

* Tue Aug  7 2001 Matt Wilson <msw@redhat.com>
- made a new dist from CVS that includes binding for
  disk.get_partition_by_sector and accessing the name of a disk type

* Mon Aug  6 2001 Matt Wilson <msw@redhat.com> 1.4.16-4
- created a new dist from CVS that fixes ext3 detection when
  _probe_with_open is needed (#50292)

* Fri Jul 20 2001 Matt Wilson <msw@redhat.com>
- rewrite scsi id code (#49533)

* Fri Jul 20 2001 Matt Wilson <msw@redhat.com>
- added build requires (#49549)

* Tue Jul 17 2001 Matt Wilson <msw@redhat.com>
- 1.4.16
- regenerated gpt patch against 1.4.16, incorporated
  parted-1.4.15-pre1-gpt-printf.patch into the same patch, removed Patch1

* Tue Jul 10 2001 Matt Wilson <msw@redhat.com>
- added a new dist tarball that contains python wrappers to get disk types

* Tue Jul 10 2001 Tim Powers <timp@redhat.com>
- run ldconfig on un/install

* Tue Jul 10 2001 Matt Wilson <msw@redhat.com>
- added a fix from clausen for border case when there is an extended
  on the last cyl

* Mon Jul  9 2001 Matt Wilson <msw@redhat.com>
- 1.4.15

* Thu Jul  5 2001 Matt Wilson <msw@redhat.com>
- added patch from Arjan to enable ataraid support

* Wed Jul  4 2001 Matt Wilson <msw@redhat.com>
- imported 1.4.15-pre2 into CVS and made a new dist tarball

* Tue Jun 26 2001 Matt Wilson <msw@redhat.com>
- added a new dist tarball that contains a check in python code to
  make sure that a partition exists within a disk before trying to
  remove it from the disk
- also changed _probe_with_open to make the first probed filesystem win

* Tue Jun 26 2001 Bill Nottingham <notting@redhat.com>
- fix filesystem type reading on GPT disks

* Tue Jun 26 2001 Matt Wilson <msw@redhat.com>
- added another fix for ext2/ext3
- added Patch4 to move the crc32 function into its own namespace so
  we don't colide with zlib when both are in the same executable space

* Mon Jun 25 2001 Matt Wilson <msw@redhat.com>
- added a new dist tarball from CVS that includes
  ext3 probing

* Wed Jun  6 2001 Matt Wilson <msw@redhat.com>
- updated dist with binding for partition.geom.disk

* Tue Jun  5 2001 Matt Wilson <msw@redhat.com>
- make a new dist tarball that has new python binding changes

* Tue May 29 2001 Bill Nottingham <notting@redhat.com>
- add major numbers for cciss 
- add libunicode-devel buildprereq

* Sun May 27 2001 Matthew Wilson <msw@redhat.com>
- added type, heads, and sectors to the python binding for PedDevice

* Fri May  4 2001 Matt Wilson <msw@redhat.com>
- added parted-1.4.11-gpt-pmbralign.patch from Matt Domsch

* Wed May  2 2001 Matt Wilson <msw@redhat.com>
- include python binding
- enable shared library (for python binding, we want fpic code)
  with --enable-shared
- build parted binary static with --enable-all-static
- don't run libtoolize on this.

* Wed May 02 2001 Bill Nottingham <notting@redhat.com>
- update to 1.4.11
- add EFI GPT patch from Matt Domsch (<Matt_Domsch@dell.com>)
- don't run autoconf, it relies on a newer non-released version
  of autoconf...

* Fri Feb 23 2001 Trond Eivind Glomsrød <teg@redhat.com>
- langify

* Wed Jan 17 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.4.7

* Thu Dec 14 2000 Bill Nottingham <notting@redhat.com>
- rebuild because of broken fileutils

* Fri Nov 03 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.2.12

* Wed Nov 01 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.2.11

* Tue Oct 17 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.2.10

* Sun Sep 10 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.2.9

* Tue Aug 29 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- fix bug when just hitting "return" with no user input

* Sun Aug 20 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- 1.2.8
- blksize patch not needed anymore
- move changelog to the end of the spec file

* Wed Aug 16 2000 Matt Wilson <msw@redhat.com>
- 1.2.7
- patched configure script to ignore the 2.4 blkpg.h header (fixes #15835).

* Fri Aug  4 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.2.6

* Sat Jul 22 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.2.5
- add more docu

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jun 12 2000 Matt Wilson <msw@redhat.com>
- initialization of spec file.
