
%define polkit_uid              87

Summary: PolicyKit Authorization Framework
Name: polkit
Version: 0.101
Release: 2.1
License: LGPLv2+
URL: http://www.freedesktop.org/wiki/Software/PolicyKit
Source0: http://hal.freedesktop.org/releases/%{name}-%{version}.tar.gz
Group: System/Libraries
BuildRequires: glib2-devel
BuildRequires: expat-devel
BuildRequires: pam-devel
BuildRequires: intltool
##BuildRequires: pkgconfig(gobject-introspection-1.0)

Requires: ConsoleKit
Requires: dbus

%description
PolicyKit is a toolkit for defining and handling authorizations.
It is used for allowing unprivileged processes to speak to privileged
processes.

%package devel
Summary: Development files for PolicyKit
Group: Development/Libraries
Requires: %name = %{version}-%{release}
Requires: %name-docs = %{version}-%{release}
Requires: pkgconfig
Requires: glib2-devel

%description devel
Development files for PolicyKit.

%package docs
Summary: Development documentation for PolicyKit
Group: Development/Libraries

%description docs
Development documentation for PolicyKit.

%package desktop-policy
Summary: Roles and default policy for desktop usage
Group: Development/Libraries
Requires(pre): /usr/sbin/groupadd
Requires(preun): /usr/sbin/groupdel
BuildArch: noarch

%description desktop-policy
Roles and default policy for desktop usage.

%prep
%setup -q -n %{name}-%{version}

%build
%configure --disable-gtk-doc \
        --disable-static \
        --libexecdir=%{_libexecdir}/polkit-1
make %{?jobs:-j%jobs}

%install
rm -rf $RPM_BUILD_ROOT
%make_install

%find_lang polkit-1
mv polkit-1.lang polkit.lang

###
### BEGIN DESKTOP POLICY CONFIGURATION ###
###

cat > $RPM_BUILD_ROOT%{_sysconfdir}/polkit-1/localauthority.conf.d/60-desktop-policy.conf << EOF
# This allows users in the wheel group to authenticate as the
# administrator.
#
# DO NOT EDIT THIS FILE, it will be overwritten on update.

[Configuration]
AdminIdentities=unix-group:wheel
EOF

cat > $RPM_BUILD_ROOT%{_localstatedir}/lib/polkit-1/localauthority/10-vendor.d/10-desktop-policy.pkla << EOF
# Authorizations/policy for the wheel group.
#
# DO NOT EDIT THIS FILE, it will be overwritten on update.
#
# Allow users in the wheel group to do certain actions without being
# interrupted by password dialogs
#
[Wheel Group Permissions]
Identity=unix-group:wheel
Action=org.gnome.clockapplet.mechanism.*;org.kde.kcontrol.kcmclock.save;org.freedesktop.RealtimeKit1.*;org.freedesktop.udisks.filesystem-mount-system-internal
ResultAny=auth_admin
ResultInactive=auth_admin
ResultActive=yes
EOF

###
### END DESKTOP POLICY CONFIGURATION
###
rm -rf $RPM_BUILD_ROOT%{_datadir}/locale

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%pre
/usr/sbin/useradd -c 'PolicyKit' -u %{polkit_uid} \
    -s /sbin/nologin -r -d '/' polkituser 2> /dev/null || :


%pre desktop-policy
/usr/sbin/groupadd -r desktop_admin_r 2> /dev/null || :
/usr/sbin/groupadd -r desktop_user_r 2> /dev/null || :


%lang_package

%files desktop-policy
%defattr(-,root,root,-)
%config %{_sysconfdir}/polkit-1/localauthority.conf.d/60-desktop-policy.conf
%{_localstatedir}/lib/polkit-1/localauthority/10-vendor.d/10-desktop-policy.pkla

%files 
%defattr(-,root,root,-)
%doc COPYING
%{_libdir}/lib*.so.*
%dir %{_libdir}/polkit-1
%dir %{_libdir}/polkit-1/extensions
%{_libdir}/polkit-1/extensions/*.so
%{_datadir}/dbus-1/system-services/*
%dir %{_datadir}/polkit-1/
%dir %{_datadir}/polkit-1/actions
%{_datadir}/polkit-1/actions/org.freedesktop.policykit.policy
%config %{_sysconfdir}/dbus-1/system.d/org.freedesktop.PolicyKit1.conf
%config %{_sysconfdir}/pam.d/polkit-1
%config %{_sysconfdir}/polkit-1
%{_bindir}/*
%{_libexecdir}/polkit-1/polkitd

# see upstream docs for why these permissions are necessary
%attr(4755,root,root) %{_bindir}/pkexec
%attr(4755,root,root) %{_libexecdir}/polkit-1/polkit-agent-helper-1

%attr(0700,root,root) %dir %{_localstatedir}/lib/polkit-1/
%dir %{_localstatedir}/lib/polkit-1/localauthority
%dir %{_localstatedir}/lib/polkit-1/localauthority/10-vendor.d
%dir %{_localstatedir}/lib/polkit-1/localauthority/20-org.d
%dir %{_localstatedir}/lib/polkit-1/localauthority/30-site.d
%dir %{_localstatedir}/lib/polkit-1/localauthority/50-local.d
%dir %{_localstatedir}/lib/polkit-1/localauthority/90-mandatory.d
#/usr/lib/girepository-1.0/PolkitAgent-1.0.typelib
#/usr/lib/girepository-1.0/Polkit-1.0.typelib

%files devel
%defattr(-,root,root,-)
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/*.pc
%{_includedir}/*
%{_bindir}/pk-example-frobnicate
%{_datadir}/polkit-1/actions/org.freedesktop.policykit.examples.pkexec.policy
#/usr/share/gir-1.0/Polkit-1.0.gir
#/usr/share/gir-1.0/PolkitAgent-1.0.gir

%files docs
%defattr(-,root,root,-)
#%{_datadir}/gtk-doc/html/*

%changelog
* Thu Sep 20 2011 George Cristea <george.cristea@windriver.com> 
- removing gobject-introspection depedency and fixing integration
* Tue Jun 28 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 0.101
- PACKAGE CLEANUP - Removed unnecessary Obsoletes for PolicyKit as there is no other packages that Requires it, there is no need to add and maintain special version of package.
* Sun Jun  5 2011 Anas Nashif <anas.nashif@intel.com> - 0.101
- Update to 0.101
* Wed Oct 27 2010 Anas Nashif <anas.nashif@intel.com> - 0.96
- Remove dependency on gobject-introspection
* Tue Aug 24 2010 Yan Yin <yan.yin@intel.com> - 0.96
- Fix build failure due to wrong dependency of polkit-devel in spec file
* Mon Aug 23 2010 Auke Kok <auke-jan.h.kok@intel.com> - 0.96
- add performance tune to reduce db reloads at boot time
- spec file cleanups
* Fri May 21 2010 Yan Yin <yan.yin@intel.com> - 0.96
- Fix spec file to package all bin files
* Fri May 21 2010 Yan Yin <yan.yin@intel.com> - 0.96
- Import 0001-Fix-Bug-26982-pkexec-information-disclosure-vulnerability.patch
* Fri May 21 2010 Yan Yin <yan.yin@intel.com> - 0.96
- Update to version 0.96
* Mon Dec  7 2009 Yan Li <yan.i.li@intel.com> - 0.95_git20090913
- Correct package version, use '_' instead of '.'.
* Mon Oct  5 2009 Anas Nashif <anas.nashif@intel.com> - 0.95
- Define polkituser uid for usage in %%pre section
* Mon Oct  5 2009 Anas Nashif <anas.nashif@intel.com> - 0.95
- Update to 0.95.git20090913
* Thu Sep 24 2009 Zhang Qiang <qiang.z.zhang@intel.com> 0.94
- Update to 0.94
* Sun Aug 16 2009 Anas Nashif <anas.nashif@intel.com> - 0.93
- Initial import into Moblin
