#! /bin/bash

# Mount the Android source partition
android_root=`cat /proc/cmdline | awk -F"androidroot=" '{print $2}' | cut -d' ' -f1`
[ -z $android_root ] && ( echo "Failed to find the android root in the boot command line"; exit 1 )
mount $android_root /mnt/android || ( echo "Failed to mount $android_root in /mnt/android"; exit 1 )

if [ ! -f /mnt/android/ramdisk.img ]; then
    echo "WARNING: Failed to find the Android ramdisk.img. Will not start Android."
    exit 1
fi

if [ ! -d /mnt/android/system ]; then
    echo "WARNING: Failed to find the Android system partition. Will not start Android."
    exit 1
fi

# Mount the Android live partition - tmpfs
mount -t tmpfs tmpfs /android

pushd /android >/dev/null
    # Extract the ramdisk image in the tmpfs
    zcat /mnt/android/ramdisk.img | cpio -id > /dev/null
    # Bind the Android system partition to the tmpfs
    mount --bind /mnt/android/system system
    # Create needed directories
    mkdir -p cache mnt mnt/sdcard
    # Mount a tmpfs in the cache directory
    mount -t tmpfs tmpfs cache
    # Bind the kernel modules directory from the host system
    mkdir -p system/lib/modules
    mount --bind /lib/modules system/lib/modules
    # Bind the data directory from host to the tmpfs
    mount --bind /mnt/android/data data
    # Mount SDcard
    mount -o mode=2777,uid=1000,gid=1015 -t tmpfs tmpfs mnt/sdcard
popd >/dev/null

exit 0
