#! /bin/bash

find_network_dev_name()
{
    DHCPCD="/system/bin/dhcpcd -o domain_name_servers"
    rmline=`grep -n "#REMOVE FROM HERE" init.rc|cut -d':' -f1`
    rmline=`expr $rmline + 1`
    sed -i -e "$rmline,\$d" init.rc
    for netdev in `ls /sys/class/net`; do
	if [ "$netdev" != "lo" -a "$netdev" != "wmaster0" ]; then
	    echo -e "service dhcpcd_$netdev $DHCPCD -ABKL\n   disabled\n   oneshot\n" >> init.rc
	    echo -e "service iprenew_$netdev $DHCPCD -n\n   disabled\n   oneshot\n" >> init.rc
	fi
    done
}

[ -c /dev/card0 ] || export HWACCEL=0

find_network_dev_name

echo "dev_mount sdcard /mnt/sdcard auto /sys/class/mmc_host/mmc2/" > system/etc/vold.fstab

echo "ro.sf.lcd_density=240" >> default.prop

# We must disable mdev before switching to Android
# since it conflicts with Android's init
echo > /proc/sys/kernel/hotplug

chroot /android /init

# avoid kernel panic
while :; do
	echo
	echo '	Android-x86 console shell. Use only in emergencies.'
	echo
done
