%define udev_libdir	/lib/udev
%define systemd_dir	/lib/systemd/system
%define dnb_systemd_dir	/lib/systemd/system.dnb

%define uversion R11p5

Name:       systemd
Summary:    System and Session Manager
Version:    35
Release:    86.1
Group:      System/System Control
License:    GPLv2
URL:        http://www.freedesktop.org/wiki/Software/systemd
Source0:    http://www.freedesktop.org/software/systemd/%{name}-%{version}.tar.bz2
Source1:    pamconsole-tmp.conf
Source2:    readahead
Source3:    android.sh
Source4:    android-mount.sh
Source6:    legacy-modules.conf
Source7:    systemd.conf
Source8:    tmp.conf
Source9:    systemd-fastboot-units-CV-%{uversion}.tar.bz2
Source10:   systemd-fastboot-units-DNB-%{uversion}.tar.bz2
Source11:   dnb-modules.conf

Patch1:     %{name}-24-fsck-disable-l-util-linux.patch
Patch2:     systemd-35-execstart-line-rescue-service.patch

BuildRequires:  pkgconfig(dbus-1) >= 1.3.2
BuildRequires:  pkgconfig(dbus-glib-1)
BuildRequires:  pkgconfig(gio-unix-2.0)
BuildRequires:  pkgconfig(libudev) >= 172
BuildRequires:  libcap-devel
BuildRequires:  libxslt
BuildRequires:  pam-devel
BuildRequires:  intltool >= 0.40.0
BuildRequires:  libacl-devel
BuildRequires:  fdupes
BuildRequires:  gperf
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

Patch100:       systemd-35-meego_fastboot-core.patch
Patch101:       systemd-35-meego_fastboot-optimize.patch
Patch103:       systemd-35-MS_REC-fix.patch
Patch106:       systemd-35-fastboot-no-early-dbus.patch
Patch107:       systemd-35-meego_fastboot-aufs.patch
Patch108:       systemd-analyze-cosmetic-exit.patch
Patch109:       systemd-35-navi-sig2.patch

%description
system and session manager for Linux, compatible with SysV and
LSB init scripts. systemd provides aggressive parallelization
capabilities, uses socket and D-Bus activation for starting
services, offers on-demand starting of daemons, keeps track of
processes using Linux cgroups, supports snapshotting and restoring
of the system state, maintains mount and automount points and
implements an elaborate transactional dependency-based service
control logic. It can work as a drop-in replacement for sysvinit.

%package tools
Summary:    Analyze systemd startup timing
Group:      Development/Tools
Requires:   pycairo
Requires:   %{name} = %{version}-%{release}

%description tools
This package installs the systemd-analyze tool, which allows one to
inspect and graph service startup timing in table or graph format.

%package units-cv
Summary:    Systemd units RPM for Crossville Lapis support
Group:      System/System control
Requires:   %{name} = %{version}-%{release}
Conflicts:  systemd-units-dnb

%description units-cv
This package installs the systemd units files needed on the Intel
Crossville Lapis board

%package units-dnb
Summary:    Systemd units RPM for DNB support
Group:      System/System control
Requires:   %{name} = %{version}-%{release}
Conflicts:  systemd-units-cv

%description units-dnb
This package installs the systemd units files needed on the Denso
DNB board

%package units-debug
Summary:    Systemd debug units
Group:      System/System control
Requires:   %{name} = %{version}-%{release}

%description units-debug
This package installs the systemd units files needed to startup services
needed for debugging, like ssh server, setup serial lines, etc.

%package android-cv
Summary:    Android start-up and intialization files for Crossville Lapis
Group:      System/System control
Requires:   %{name} = %{version}-%{release}
Requires:   systemd-units-cv = %{version}-%{release}
Conflicts:  systemd-units-dnb

%description android-cv
Android start-up and intialization files for Crossville Lapis.
The ones used for DNB are part of the units-dnb RPM.

%package devel
Summary:    Development tools for systemd
Group:      Development/Libraries
Requires:   %{name} = %{version}-%{release}

%description devel
This package includes the libraries and header files you will need
to compile applications for systemd.

%package console-ttyS0
Summary:    Systemd console ttyS0
Group:      System/System Control
Requires:   %{name}

%description console-ttyS0
This package will setup a serial getty for ttyS0 is desired.


%package console-ttyS1
Summary:    Systemd console ttyS1
Group:      System/System Control
Requires:   %{name}

%description console-ttyS1
This package will setup a serial getty for ttyS1 is desired.


%package console-tty01
Summary:    Systemd console tty01
Group:      System/System Control
Requires:   %{name}

%description console-tty01
This package will setup a serial getty for tty01 is desired.


%package console-ttyO2
Summary:    Systemd console ttyO2
Group:      System/System Control
Requires:   %{name}

%description console-ttyO2
This package will setup a serial getty for ttyO2 is desired.

%package console-ttyMFD2
Summary:    Systemd console ttyMFD2
Group:      System/System Control
Requires:   %{name}

%description console-ttyMFD2
This package will setup a serial getty for ttyMFD2 is desired.


%package docs
Summary:   System and session manager man pages
Group:     Development/Libraries
Requires:  %{name} = %{version}-%{release}

%description docs
This package includes the man pages for systemd.


%package sysv-docs
Summary:   System and session manager man pages - SysV links
Group:     Development/Libraries
Requires:  %{name} = %{version}-%{release}

%description sysv-docs
This package provides the manual pages needed for systemd
to replace sysvinit.

%package sysv
Summary:   System and session manager - SysV links
Group:     System/Startup Services
Requires:  %{name} = %{version}-%{release}
Provides:       SysVinit = 2.85-38


%description sysv
Systemd is a replacement for sysvinit.  It is dependency-based and
able to read the LSB init script headers in addition to parsing rcN.d
links as hints.

It also provides process supervision using cgroups and the ability to
not only depend on other init script being started, but also
availability of a given mount point or dbus service.

This package provides the links needed for systemd
to replace sysvinit.

%prep
%setup -q -n %{name}-%{version}

%patch1 -p1 
%patch2 -p1 
%patch100 -p1 
%patch101 -p1 
%patch103 -p1 
%patch106 -p1 
%patch107 -p1 
%patch108 -p1 
%patch109 -p1 

%build
autoreconf -f
%configure --disable-static \
    --with-rootdir=/ \
    --with-distro=meego_fastboot \
    --disable-gtk \
    --disable-selinux \
    --disable-tcpwrap \
    --with-udevrulesdir=/lib/udev/rules.d/

make %{?_smp_mflags}

%install
%make_install

# Create SysV compatibility symlinks. systemctl/systemd are smart
# enough to detect in which way they are called.
install -d %{buildroot}/sbin/
ln -s ../bin/systemd %{buildroot}/sbin/init
ln -s ../bin/systemctl %{buildroot}/sbin/halt
ln -s ../bin/systemctl %{buildroot}/sbin/poweroff
ln -s ../bin/systemctl %{buildroot}/sbin/reboot
ln -s ../bin/systemctl %{buildroot}/sbin/runlevel
ln -s ../bin/systemctl %{buildroot}/sbin/shutdown
ln -s ../bin/systemctl %{buildroot}/sbin/telinit

mkdir %{buildroot}/run

# Make sure these directories are properly owned
mkdir -p %{buildroot}/lib/systemd/system/basic.target.wants
mkdir -p %{buildroot}/lib/systemd/system/dbus.target.wants
mkdir -p %{buildroot}/lib/systemd/system/late-services.target.wants

# enable readahead by default
#ln -s ../systemd-readahead-collect.service %{buildroot}/lib/systemd/system/sysinit.target.wants/systemd-readahead-collect.service
#ln -s ../systemd-readahead-replay.service %{buildroot}/lib/systemd/system/sysinit.target.wants/systemd-readahead-replay.service

# Don't ship documentation in the wrong place
rm %{buildroot}/%{_docdir}/systemd/*

install -m 0644 %{SOURCE1} %{buildroot}/etc/tmpfiles.d/pamconsole-tmp.conf

# Disable this for now. It slows down the legacy mode. To be re-created when the two modes will be merged
#install -m 0644 %{SOURCE2} %{buildroot}/.readahead

install -m 0755 %{SOURCE3} %{buildroot}/sbin/android.sh
install -m 0755 %{SOURCE4} %{buildroot}/sbin/android-mount.sh

mkdir -p %{buildroot}/etc/modules-load.d/
install -m 0644 %{SOURCE6}  %{buildroot}/etc/modules-load.d/modules.conf
install -m 0644 %{SOURCE11} %{buildroot}/etc/modules-load.d/dnb-modules.conf

mkdir -p %{buildroot}/etc/tmpfiles.d
install -m 0644 %{SOURCE7} %{buildroot}/etc/tmpfiles.d/modules.conf
install -m 0644 %{SOURCE8} %{buildroot}/etc/tmpfiles.d/tmp.conf

# install fastboot units
rm -rf %{buildroot}/lib/systemd/system
tar xjf %{SOURCE9} -C %{buildroot}/lib/systemd
tar xjf %{SOURCE10} -C %{buildroot}/lib/systemd

# needed for android
mkdir -p %{buildroot}/android

# >> install post
# << install post

%fdupes  %{buildroot}/%{_datadir}/man/

%post
if [ "`readlink /etc/mtab`" != "/proc/self/mounts" ]; then
	rm -f /etc/mtab
	ln -s /proc/self/mounts /etc/mtab
fi
/bin/systemd-machine-id-setup >/dev/null 2>&1 || :

/sbin/ldconfig
ln -s /bin/systemd/ /sbin/init

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
#/.readahead
/bin/*
/usr/bin/systemd-cgls
/usr/bin/systemd-nspawn
/usr/bin/systemd-stdio-bridge
/run
%config %{_sysconfdir}/dbus-1/system.d/org.freedesktop.systemd1.conf
%config %{_sysconfdir}/dbus-1/system.d/org.freedesktop.hostname1.conf
%config %{_sysconfdir}/dbus-1/system.d/org.freedesktop.locale1.conf
%config %{_sysconfdir}/dbus-1/system.d/org.freedesktop.login1.conf
%config %{_sysconfdir}/dbus-1/system.d/org.freedesktop.timedate1.conf
%attr(0644,root,root) %{udev_libdir}/rules.d/70-uaccess.rules
%attr(0644,root,root) %{udev_libdir}/rules.d/71-seat.rules
%attr(0644,root,root) %{udev_libdir}/rules.d/73-seat-late.rules
%config %{_sysconfdir}/systemd
%config %{_sysconfdir}/tmpfiles.d/*
%config %{_sysconfdir}/xdg/systemd/user
%config %{_sysconfdir}/bash_completion.d/systemctl-bash-completion.sh
%{_prefix}/%{_lib}/tmpfiles.d/*
%{_prefix}/%{_lib}/systemd/user/*
/%{_lib}/systemd
/%{_lib}/security/pam_systemd.so
/%{_lib}/udev/rules.d/99-systemd.rules
/%{_libdir}/libsystemd-daemon.so.*
/%{_libdir}/libsystemd-login.so.*
%{_datadir}/dbus-1/*/org.freedesktop.systemd1.*
%{_defaultdocdir}/systemd
%{_datadir}/polkit-1/actions/org.freedesktop.systemd1.policy
%{_datadir}/polkit-1/actions/org.freedesktop.locale1.policy
%{_datadir}/polkit-1/actions/org.freedesktop.login1.policy
%{_datadir}/polkit-1/actions/org.freedesktop.timedate1.policy
%{_datadir}/polkit-1/actions/org.freedesktop.hostname1.policy
%{_datadir}/dbus-1/system-services/org.freedesktop.hostname1.service
%{_datadir}/dbus-1/system-services/org.freedesktop.locale1.service
%{_datadir}/dbus-1/system-services/org.freedesktop.login1.service
%{_datadir}/dbus-1/system-services/org.freedesktop.timedate1.service
%{_datadir}/dbus-1/interfaces/org.freedesktop.hostname1.xml
%{_datadir}/dbus-1/interfaces/org.freedesktop.locale1.xml
%{_datadir}/dbus-1/interfaces/org.freedesktop.timedate1.xml
%exclude %{systemd_dir}
%exclude %{dnb_systemd_dir}

%files units-cv
%{systemd_dir}
%config %{_sysconfdir}/modules-load.d/modules.conf
%exclude %{systemd_dir}/android.target.wants/android-start.service
%exclude %{systemd_dir}/android.target.wants
%exclude %{systemd_dir}/graphical.target.wants/android.timer
%exclude %{systemd_dir}/android.target
%exclude %{systemd_dir}/android.timer
%exclude %{systemd_dir}/android-start.service
%exclude %{systemd_dir}/shutdown.target.wants/android-stop.service
%exclude %{systemd_dir}/android.target.wants/android-start.service
%exclude %{systemd_dir}/graphical.target.wants/android.timer
%exclude %{systemd_dir}/android-stop.service
%exclude %{systemd_dir}/android.target.wants/android-mount.service
%exclude %{systemd_dir}/android-mount.service
%exclude %{systemd_dir}/android-modules-load.service
%exclude %{systemd_dir}/debug.target.wants/*
%exclude %{systemd_dir}/graphical.target.wants/debug.timer
%exclude %{systemd_dir}/debug.timer
%exclude %{systemd_dir}/debug.target
%exclude %{systemd_dir}/load-serial-driver.service

%files units-dnb
%{dnb_systemd_dir}
%config %{_sysconfdir}/modules-load.d/dnb-modules.conf
%exclude %{systemd_dir}/debug.target.wants/*
%exclude %{systemd_dir}/graphical.target.wants/debug.timer
%exclude %{systemd_dir}/debug.timer
%exclude %{systemd_dir}/debug.target
%exclude %{systemd_dir}/load-serial-driver.service

%files units-debug
%{systemd_dir}/debug.target.wants/*
%{systemd_dir}/graphical.target.wants/debug.timer
%{systemd_dir}/debug.timer
%{systemd_dir}/debug.target
%{systemd_dir}/load-serial-driver.service

%files android-cv
%defattr(-,root,root,-)
%{systemd_dir}/android.target.wants/android-start.service
%{systemd_dir}/graphical.target.wants/android.timer
%{systemd_dir}/android.target
%{systemd_dir}/android.timer
%{systemd_dir}/android-start.service
%{systemd_dir}/shutdown.target.wants/android-stop.service
%{systemd_dir}/android-stop.service
%{systemd_dir}/android.target.wants/android-mount.service
%{systemd_dir}/android-mount.service
%{systemd_dir}/android.target.wants/android-modules-load.service
%{systemd_dir}/android-modules-load.service
/android
/sbin/android.sh
/sbin/android-mount.sh

%files docs
%defattr(-,root,root,-)
%doc %{_mandir}/man?/*

# disable SElinux automount
#%exclude %{systemd_dir}/sysinit.target.wants/sys-kernel-security.automount

%files console-ttyMFD2
%defattr(-,root,root,-)
%{systemd_dir}/debug.target.wants/serial-getty@ttyMFD2.path
%{systemd_dir}/serial-getty@ttyMFD2.path

%files console-ttyS0
%defattr(-,root,root,-)
%{systemd_dir}/debug.target.wants/serial-getty@ttyS0.path
%{systemd_dir}/serial-getty@ttyS0.path

%files console-ttyS1
%defattr(-,root,root,-)
%{systemd_dir}/debug.target.wants/serial-getty@ttyS1.path
%{systemd_dir}/serial-getty@ttyS1.path

%files console-tty01
%defattr(-,root,root,-)
%{systemd_dir}/debug.target.wants/serial-getty@tty01.path
%{systemd_dir}/serial-getty@tty01.path

%files console-ttyO2
%defattr(-,root,root,-)
%{systemd_dir}/debug.target.wants/serial-getty@ttyO2.path
%{systemd_dir}/serial-getty@ttyO2.path

# >> files
# << files

%files tools
%defattr(-,root,root,-)
/usr/bin/systemd-analyze

%files devel
%defattr(-,root,root,-)
%{_includedir}/systemd/sd-daemon.h
%{_includedir}/systemd/sd-login.h
%{_libdir}/libsystemd-login.so
%{_libdir}/libsystemd-daemon.so
%{_libdir}/pkgconfig/libsystemd-daemon.pc
%{_libdir}/pkgconfig/libsystemd-login.pc
%{_datadir}/pkgconfig/systemd.pc

%files sysv
%defattr(-,root,root,-)
%doc LICENSE
/sbin/halt
/sbin/init
/sbin/poweroff
/sbin/reboot
/sbin/runlevel
/sbin/shutdown
/sbin/telinit

%files sysv-docs
%defattr(-,root,root,-)
%doc %{_mandir}/man?/*

%post units-dnb
if [ -d %{systemd_dir} ]; then
  /bin/mv %{systemd_dir} %{systemd_dir}.cv
fi
/bin/mv %{dnb_systemd_dir} %{systemd_dir}

if [ -f %{_sysconfdir}/modules-load.d/modules.conf ]; then
  /bin/mv %{_sysconfdir}/modules-load.d/modules.conf \
          %{_sysconfdir}/modules-load.d/cv-modules.conf
fi
/bin/mv %{_sysconfdir}/modules-load.d/dnb-modules.conf \
        %{_sysconfdir}/modules-load.d/modules.conf


%preun units-dnb
/bin/mv %{systemd_dir} %{dnb_systemd_dir}
/bin/mv %{_sysconfdir}/modules-load.d/modules.conf \
        %{_sysconfdir}/modules-load.d/dnb-modules.conf


%postun units-dnb
/bin/mv %{systemd_dir}.cv %{systemd_dir}
/bin/mv %{_sysconfdir}/modules-load.d/cv-modules.conf \
        %{_sysconfdir}/modules-load.d/modules.conf


%changelog
* Mon Feb 04 2013 Dragos Stoica <dragos.stoica@windriver.com> - 35
- D0182 - systemctl taking more time than before during boot process:
- add systemd-35-navi-sig2.patch to start nav_pre.target & nav_swap.service
* Thu Nov 26 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- update service archives versioning
- integrate pulseaudio fix for DNB - D0174
* Fri Nov 23 2012 George Cristea <george.cristea@windriver.com> - 35
- Removed /var partition sync from reboot & poweroff & halt services
* Fri Nov 2 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Split the units into different RPM's for CV and DNB support
- Create a debug units RPM
- Rename the android RPM to android-cv
* Tue Aug 21 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Add systemd-analyze cosmetic exit patch
- Change emgdhmi-test type to simple
* Tue Aug 21 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Chown /dev/snd/timer before pulseaudio starts
* Tue Aug 7 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Do not load i2c_eg20t in udev-trigger as it is already loaded by systemd-load-modules
- Re-enable the udev-settle service as it is needed for the mapper driver
- Crossville Optimisation: decrease timer values for the android and late-services targets
* Thu Jul 26 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Change the android start service's type to simple
* Wed May 30 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Update the syslogd service to use a different socket than logger
* Mon May 28 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- disable syslogd if Android is present - currently freezes Android
* Mon May 21 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- "A0103 syslogd not working" - add syslogd.service and link
* Mon Apr 30 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- Update emgdhmid.service to load emgd (EMGD is a module in A10.1)
* Wed Apr 19 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Remove the v86d services - not needed anymore (B0004 / A0100)
* Wed Apr 18 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Updated Udev sockets to conflict and close before shutdown.target
* Thu Apr 12 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Update the units archive: do not load fbcon for android any-more
* Wed Apr 11 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- package the android-mount service in the android RPM
* Tue Mar 20 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- added serial services for additional serial lines
- start Android on top of EMGD; disable uvesafb load
- add android-mount.sh and respective service to mount the Android partition
- move android scripts to /sbin
* Wed Mar 16 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- change halt, reboot and powroff services to all aubrsync (persistent /var changes)
- update copyright notices (including for .path (serial devices) files
* Wed Feb 15 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Fix the android modules load issue
* Mon Feb 13 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Update the pre-built services archive:
-  Add path-based activation for the serial services
-  Fixed a dependency issue for UDev
-  Update late modules load list
* Fri Feb 10 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Package ALL the Android files in the android rpm
* Fri Jan 27 2012 Andrei Zlate <andrei.zlate@windriver.com> - 35
- moved uvesafb.conf to the crossville_laspis-configs package
- added the pulseaudio service
* Thu Jan 20 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- add late-services.wants/late-modules.service
* Thu Jan 20 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- update sources and services to include copyright notice
* Thu Jan 19 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- change "After=sysinit.target" to "Before=basic.target" for udev.service (reboot issue)
- late-services.timer=6s, udev-trigger if !/mnt/android/ramdisk.img
* Fri Jan 16 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- add /android
* Fri Jan 16 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- update services (add sepparate tarball with the fastboot units)
* Fri Jan 13 2012 Dragos Stoica <dragos.stoica@windriver.com> - 35
- mount /var (readonly) with AUFS2 (union between shm & ext2-ro)
* Tue Dec 13 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Add the android v86d service
- Add the android modules service
- Add the module parameters for the uvesafb module
* Mon Dec 12 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Split the modules load service into legacy/android
* Fri Dec 09 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Renamed the android service to android-start
- Added the android-stop service
* Tue Dec 06 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Remove the libnotify build dependency - only needed for GTK support
- Created android sub-package
* Fri Nov 25 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Added sshd and sshd-keygen services
- Added the Android init service
- Added the getty@tty2 service for the Android console
- Removed the xorg.service - not needed anymore, we are not using X
- Replace the xorg timer with a new timer
- Disabled the emgdhmid service for now - no EMGD support yet
- Added the connmand service
- Added the android.sh init script
* Fri Oct 21 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- Removed ttyPCH1 patch - was added in the meego_fastboot-more patch
* Fri Oct 21 2011 Dragos Stoica <dragos.stoica@windriver.com> - 35
- delay connection to dbus
- optimize services
- add .readahead
* Mon Sep 26 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- install the force mtab service
* Fri Sep 23 2011 Andrei Zlate <andrei.zlate@windriver.com> - 35
- install the ttyPCH1 serial service
* Tue Sep 20 2011 Dragos Stoica <dragos.stoica@windriver.com> - 35
- add meego_fastboot optimizations
- add connman.service to late-services
* Mon Sep  5 2011 Marko Saukko <marko.saukko@cybercom.com> - 35
- Added systemd-35-execstart-line-rescue-service.patch to
  fix multiple ExecStart lines in rescue.service.
* Fri Sep  2 2011 Marko Saukko <marko.saukko@cybercom.com> - 35
- Update to version 35
- Removed hwclock-load.service link creation as destination does not exist anymore.
- Moved %%fdupes under %%install to fix BMC#22706
* Wed Jul 20 2011 Auke Kok <auke-jan.h.kok@intel.com> - 30
- Cosmetic cleanups
- Disabling internal logger as it's nonfunctional - we'll fall
  back to dmesg logging only for now.
- With systemd-loginctl we no longer need to pre-activate tty2
- Vala isn't needed to build because we disable building the gtk UI app.
- Fix several rpmlint warnings (perms, %%config out of place).
- Fix rpm group names.
- Rename -analyze subpackage to -tools. There will likely be more dev tools coming.
- Enable ACL dependency, we really want to use it going forward.
- Run %%fdupes.
- Disable tcp_wrappers dependency as we don't use it in MeeGo.
* Thu Jul 14 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 30
- updated to version 30, and udpate patch set in MeeGo.
* Fri Jul  1 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 29
- added install alias to serial-getty unit file
* Thu Jun 30 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 29
- BMC#18652 - Separate packages for hardware adaptation serials
* Wed Jun 22 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 29
- removed provides and obsolete of removed packages as they are not needed
* Thu Jun 16 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 29
- updated to 29
* Tue Jun 14 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 28
- udpate to 28
* Mon Jun  6 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 26
- split out the systemd man pages into separate subpackages
* Sun May 22 2011 Auke Kok <auke-jan.h.kok@intel.com> - 26
- split out the systemd-analyze tool into a separate subpackage, as it
  requires python/pycairo to run
* Fri May 13 2011 William Douglas <william.douglas@linux.intel.com> - 25
- Update to 26
- add a syslog daemon inside systemd
* Wed May 11 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 25
- sysvinit hack until sysvinit get removed
* Wed May  4 2011 Chris Ferron <chris.e.ferron@linux.intel.com> - 25
- Update to -25
* Thu Apr  7 2011 Chris Ferron <chris.e.ferron@linux.intel.com> -24
- Update to -24
* Fri Apr  1 2011 Chris Ferron <chris.e.ferron@linux.intel.com> -22
- Update to -22
- Initial Port work for MeeGo
* Mon Mar 28 2011 Auke Kok <auke-jan.h.kok@intel.com> - 20
- Updated to -20
* Mon Nov  8 2010 Autospectacle <autospectacle@meego.com> - 11
- Initial automated packaging
