%define release_name MeeGo
%define dist_version 1.2.0

Summary:	MeeGo release files
Name:		meego-release
Version:	1.2.0
Release:	2.1
License:	GPLv2
Group:		System/Base
URL:		http://www.meego.com
Provides:	system-release = %{version}-%{release}
Provides:   moblin-release = 2.2
Obsoletes:  moblin-release <= 2.1.92-4.6
BuildArch:	noarch
Source0:    RPM-GPG-KEY-meego02

%description
MeeGo release files such as various /etc/ files that define the release.

%prep

%build

%install
rm -rf $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT/etc
echo "MeeGo release %{dist_version} (%{release_name})" > $RPM_BUILD_ROOT/etc/meego-release
cp -p $RPM_BUILD_ROOT/etc/meego-release $RPM_BUILD_ROOT/etc/issue

echo "Kernel \r on an \m" >> $RPM_BUILD_ROOT/etc/issue
cp -p $RPM_BUILD_ROOT/etc/issue $RPM_BUILD_ROOT/etc/issue.net
echo >> $RPM_BUILD_ROOT/etc/issue

ln -s meego-release $RPM_BUILD_ROOT/etc/system-release
ln -s meego-release $RPM_BUILD_ROOT/etc/moblin-release

# Install the MeeGo GPG RPM pubkey
mkdir -p $RPM_BUILD_ROOT/etc/pki/rpm-gpg
cp %{SOURCE0} $RPM_BUILD_ROOT/etc/pki/rpm-gpg
pushd $RPM_BUILD_ROOT/etc/pki/rpm-gpg
ln -sf RPM-GPG-KEY-meego02 RPM-GPG-KEY-meego-2-primary
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%config %attr(0644,root,root) /etc/meego-release
/etc/system-release
/etc/moblin-release
%config(noreplace) %attr(0644,root,root) /etc/issue
%config(noreplace) %attr(0644,root,root) /etc/issue.net
/etc/pki/rpm-gpg
%changelog
* Wed May 18 2011 Peter J Zhu <peter.j.zhu@intel.com> - 1.2.0
- fix to dist_version
* Tue May 17 2011 Peter J Zhu <peter.j.zhu@intel.com> - 1.2.0
- Version is 1.2.0 now
* Tue May 17 2011 Ryan Ware <ryan.r.ware@intel.com> - 1.1.99
- Removed development key and added the MeeGo 1.2 release key.
* Wed Apr 13 2011 Anas Nashif <nashif@linux.intel.com> - 1.1.99
- Update version to 1.1.99
* Mon Jan 24 2011 Rolla Selbak <rolla.n.selbak@intel.com> - 1.1.80
- Update version to 1.1.90
* Fri Oct  1 2010 Anas Nashif <nashif@linux.intel.com> - 1.1.80
- Remove dist macros completely, we do not use them
* Fri Oct  1 2010 Anas Nashif <nashif@linux.intel.com> - 1.1.80
- Update version to 1.1.80 (bmc #7815)
* Tue Aug 31 2010 Chris E Ferron <chris.e.ferron@intel.com> - 1.0.90
- update release version to 1.0.90
* Thu Jul  8 2010 Anas Nashif <anas.nashif@intel.com> - 1.0.80
- Move key here, since we do not always install repo packages
* Tue May 18 2010 Anas Nashif <anas.nashif@intel.com> - 1.0.80
- post 1.0 release
* Wed Apr 14 2010 Aaron Bockover <abockover@novell.com> - 0.90
- Split repo files out into a new meego-repos package (bmc#765)
* Wed Mar 31 2010 Anas Nashif <anas.nashif@intel.com> - 0.90
- Reset to 0.90
* Mon Mar 29 2010 Anas Nashif <anas.nashif@intel.com> - 1.0
- Fixed bug (MB#233): inconsistent usage of file uri
- Fixed typo in release url
* Mon Mar 22 2010 Anas Nashif <anas.nashif@intel.com> - 1.0
- Add extra repo
* Mon Mar 22 2010 Chris Ferron <chris.e.ferron@intel.com> 1.0
- Fixed Typeo in base urls in meego-netbook-devel.repo.
* Sun Mar  7 2010 Anas Nashif <anas.nashif@intel.com> - 1.0
- Install zypp repos in right location
* Sun Mar  7 2010 Anas Nashif <anas.nashif@intel.com> - 1.0
- Also provide moblin-release for the transition
* Sat Mar  6 2010 Anas Nashif <anas.nashif@intel.com> - 1.0
- Initial Release
