%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)[1:]")}

Summary: Creates an initial ramdisk image for preloading modules
Name: mkinitrd
Version: 7.0.17
Release: 6.4
License: GPLv2+
Group: System/Base
Source0: mkinitrd-%{version}.tar.bz2
Patch0:  fix-a-weird-btrfs-root-issue.patch
Patch1:  timeout-fix.patch
Patch2:  mkmrstinitrd.patch 
ExclusiveOs: Linux
Requires(pre): udev
Requires: /bin/sh, /sbin/insmod.static, /sbin/losetup
Requires: fileutils,  mktemp >= 1.5-5
Requires: /bin/tar
Requires: /bin/find
Requires: /bin/grep
Requires: /bin/gzip
Requires: /bin/cpio
Requires: filesystem >= 2.1.0
Requires: e2fsprogs >= 1.38-12,   coreutils
Requires: elfutils-libelf
Requires:  device-mapper
Requires: util-linux-ng
Requires: grubby

%description
mkinitrd creates filesystem images for use as initial ram filesystem
(initramfs) images.  These images are used to find and mount the root
filesystem.

%prep
%setup -q 
%patch0 -p1
%patch2 -p1

#
# 2x30 seconds is waay too long a timeout to wait for udev
#
%patch1 -p1
find . -name "Makefile*" -exec sed -i 's|-Werror||g' {} \;

%build
make LIB=%{_lib}

%install
rm -rf $RPM_BUILD_ROOT
make LIB=%{_lib} DESTDIR=$RPM_BUILD_ROOT mandir=%{_mandir} install


%files
%defattr(-,root,root,-)
%attr(755,root,root) /sbin/mkinitrd
%attr(644,root,root) %{_mandir}/man8/mkinitrd.8*
%attr(755,root,root) /usr/libexec/mkliveinitrd
%attr(755,root,root) /usr/libexec/mkmrstinitrd
%attr(755,root,root) /sbin/lsinitrd

%changelog
* Mon Aug 16 2010 Chris E Ferron <chris.e.ferron@intel.com> - 7.0.17
- Fixed BMC#4282 so MFLD will boot by applying a patch from UMG.
* Sat Jun 12 2010 Arjan van de Ven <arjan@linux.intel.com> - 7.0.17
- reduce udev settle time in mkmrstinitrd
* Fri May 28 2010 Yi Yang <yi.y.yang@intel.com> - 7.0.17
- fix an weird btrfs root issue
* Mon Apr 12 2010 Anas Nashif <anas.nashif@intel.com> - 7.0.17
- dmsetup back in /sbin/, was an rpm bug
* Sun Mar  7 2010 Anas Nashif <anas.nashif@intel.com> - 7.0.16
- dmsetup is now in /usr/sbin
* Mon Feb  8 2010 Anas Nashif <anas.nashif@intel.com> - 7.0.15
- Fixed warnings during image creation
* Tue Jan 12 2010 Peter Zhu <peter.j.zhu@intel.com> 7.0.13
- Fix the annoying startup warning by new udev
* Mon Nov 23 2009 Yi Yang <yi.y.yang@intel.com> 7.0.13
- Split grubby as a seperate package
* Mon Oct  5 2009 Anas Nashif <anas.nashif@intel.com> - 7.0.13
- Fixed and sanitized Requires
* Thu Oct  1 2009 Anas Nashif <anas.nashif@intel.com> - 7.0.13
- replace vol_id with blkid
* Thu Oct  1 2009 Anas Nashif <anas.nashif@intel.com> - 7.0.12
- Update to 7.0.12
* Thu Oct  1 2009 Anas Nashif <anas.nashif@intel.com> - 7.0.11
- Update to 7.0.11: sync with git tree
* Thu Oct  1 2009 Anas Nashif <anas.nashif@intel.com> - 7.0.6
- remove annoying message about persistent overlay
* Tue Sep 29 2009 Anas Nashif <anas.nashif@intel.com> - 7.0.5
- Fixed parsing of name and version from moblin-release
- 7.0.5
* Sat Sep 26 2009 Anas Nashif <anas.nashif@intel.com> - 7.0.4
- Integrate patches
- Only substitute  first line release when updating kernel
* Thu Jul  9 2009 Austin Zhang <austin.zhang@intel.com> 7.0.3
- Replace vol_id with blkid, vol_id was gone with the udev update.
* Wed Jun 17 2009 Prajwal Mohan <prajwal.karur.mohan@intel.com> 7.0.3
- Modified mkmrstinitrd to fix USB search problem
* Thu May 14 2009 Prajwal Mohan <prajwal.karur.mohan@intel.com> 
- Added support to boot from Nand for Mrst
* Wed Apr  8 2009 Anas Nashif <anas.nashif@intel.com> 7.0.1
- Create semi-live initrds for moorestown
- New released, now from our git tree
* Tue Apr  7 2009 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Remove confusing message about mkinitrd
* Wed Apr  1 2009 Andrzej Zaborowski <andrew.zaborowski@intel.com> 6.0.52
- Fix init= handling
* Wed Mar 18 2009 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Do not exit with 1
* Mon Mar 16 2009 Yan Li <yan.i.li@intel.com> 6.0.52
- Display a proper error message when not invoked to make a LiveCD
  initrd
* Wed Feb  4 2009 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Pass kernel paramters to init
* Wed Feb  4 2009 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Pass kernel paramters to init
* Fri Jan 16 2009 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Create lib/udev/rules.d later avoiding warning
* Sat Jan 10 2009 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Handle new udev calls
- Support hybrid iso
* Tue Dec 16 2008 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Fixed rpmlint errors in Summary tag
* Thu Dec 11 2008 Anas Nashif <anas.nashif@intel.com> 6.0.52
- fastinit replaces initscripts
* Tue Dec  2 2008 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Exit if not generating a LiveOS initrd
* Sun Nov 30 2008 Anas Nashif <anas.nashif@intel.com> 6.0.52
- Do not use nash, fixed dependencies
* Fri Nov 28 2008 Anas Nashif <anas.nashif@intel.com> 6.0.52
- fixed rpmlint warning: explicit-lib-dependency
* Sat Oct  4 2008 Anas Nashif <anas.nashif@intel.com> 6.0.52
- remove requirement on isomd5sum
* Tue May  6 2008 Jeremy Katz <katzj@redhat.com> - 6.0.52-2
- Require isomd5sum so that live images can be verified (#445284)
* Fri Apr 25 2008 Jeremy Katz <katzj@redhat.com> - 6.0.52-1
- Handle kvm virtio devices (markmc, #444155)
- Output value from fstab into as arg to mkrootdev (pjones, #209473)
- Don't depend on system.map (markmc, #430718)
* Fri Apr 18 2008 Peter Jones <pjones@redhat.com> - 6.0.51-1
- Handle bangpath translation in sysfs slightly differently.  (#442811)
* Thu Apr 17 2008 Peter Jones <pjones@redhat.com> - 6.0.50-1
- Handle bangpath translation in sysfs at one more place.  (#442811)
* Thu Apr 17 2008 Peter Jones <pjones@redhat.com> - 6.0.49-1
- The kernel uevent/sysfs API for firmware loading changed underneath us again.
* Thu Apr 17 2008 Peter Jones <pjones@redhat.com> - 6.0.48-1
- Add lsinitrd for cebbert.
* Mon Apr 14 2008 Jeremy Katz <katzj@redhat.com> - 6.0.47-1
- Fix merge fun
* Mon Apr 14 2008 Peter Jones <pjones@redhat.com> - 6.0.46-1
- Fix ps3 disk handling in /proc/devices (#389331)
* Fri Apr 11 2008 Jeremy Katz <katzj@redhat.com> - 6.0.45-1
- Fix final bit of resume for hibernate
* Fri Apr 11 2008 Jeremy Katz <katzj@redhat.com> - 6.0.44-1
- Fix up finding the resume device for hibernate (#438951)
* Mon Apr  7 2008 Peter Jones <pjones@redhat.com> - 6.0.43-1
- Require diffutils for /usr/bin/cmp (#438568)
- Chase deps in /sys/block/dm-0/slaves/ and similar (#440485)
* Mon Apr  7 2008 Peter Jones <pjones@redhat.com> - 6.0.42-1
- Use libelf to find elf interpreter, so we don't have to iterate several
  ld.so's looking for our linker. (#440091)
- Try harder to make sure we can read device labels (#437534)
- Support encrypted RAID member devices (#429600)
- Fix postinst.d and perm.d usage, and own those directories (#441111)
* Wed Apr  2 2008 Peter Jones <pjones@redhat.com> - 6.0.41-1
- Fix a warning message when you run with no swap
- Fix kernel's "make install"
* Thu Mar 20 2008 Peter Jones <pjones@redhat.com> - 6.0.40-1
- Use /etc/grub.conf rather than pointing at /boot/grub/grub.conf directly.
* Tue Mar 18 2008 Peter Jones <pjones@redhat.com> - 6.0.39-1
- Fix parsing of /proc/mdstat so we look for sda1 not sda (#437231)
  (gawk, bash, I hate you both.)
* Tue Mar 18 2008 Peter Jones <pjones@redhat.com> - 6.0.38-1
- Add --posttrans support in new-kernel-package and installkernel.
* Sun Mar 16 2008 Jeremy Katz <katzj@redhat.com> - 6.0.37-1
- Fix syntax error with encrypted root
* Fri Mar 14 2008 Peter Jones <pjones@redhat.com> - 6.0.36-1
- Handle "mapper/" names at more places (hopefully fix #435173 and others)
* Wed Mar 12 2008 Peter Jones <pjones@redhat.com> - 6.0.35-1
- Resolve label/uuid to a device earlier (#435228)
* Thu Mar  6 2008 Jeremy Katz <katzj@redhat.com> - 6.0.34-1
- Fix scsi_wait_scan stuff up (#429937)
- Add support for --without (wtogami, #436248)
* Wed Mar  5 2008 Jeremy Katz <katzj@redhat.com> - 6.0.33-1
- Fix the non-persistent overlay case
* Tue Mar  4 2008 Jeremy Katz <katzj@redhat.com> - 6.0.32-1
- Support keymaps for encrypted root devices (dlehman)
- Add persistence bits to mkliveinitrd (based on changes by Douglas McClendon)
* Tue Feb 26 2008 Jeremy Katz <katzj@redhat.com> - 6.0.31-1
- Add mkliveinitrd
* Thu Feb 21 2008 Peter Jones <pjones@redhat.com>
- Require newer lvm2 version.
* Wed Feb 20 2008 Peter Jones <pjones@redhat.com> - 6.0.30-1
- Load selinux policy during boot.
* Fri Feb 15 2008 Peter Jones <pjones@redhat.com> - 6.0.29-1
- Work around sysfs path changes
- Remove debugging echos from dm-crypt work.
* Fri Feb  1 2008 Jeremy Katz <katzj@redhat.com> - 6.0.28-4
- Don't create the rtc nodes in the initrd anymore (#431274)
* Sat Jan 19 2008 Jeremy Katz <katzj@redhat.com> - 6.0.28-3
- Don't call lvm.static -- it no longer exists
* Mon Jan 14 2008 David Cantrell <dcantrell@redhat.com> - 6.0.28-2
- Rebuild for new libdhcp
* Wed Jan  9 2008 Peter Jones <pjones@redhat.com> - 6.0.28-1
- Fix device detection with labels and no lvm (#427439, #426722)
- Fix ppoll wrapper for older kernels
* Thu Jan  3 2008 Jesse Keating <jkeating@redhat.com> - 6.0.27-2
- Rebuild for libparted soname bump.
* Wed Jan  2 2008 Peter Jones <pjones@redhat.com> - 6.0.27-1
- Fix merge error that caused 6.0.25-1's change to be reverted.
* Wed Jan  2 2008 Peter Jones <pjones@redhat.com> - 6.0.26-1
- Update copyright and license info
- Add support for loading all available drivers.
* Fri Dec 21 2007 Peter Jones <pjones@redhat.com> - 6.0.25-2
- Add BuildReq for util-linux-ng
* Fri Dec 21 2007 Peter Jones <pjones@redhat.com> - 6.0.25-1
- Don't remove two things from a GHashTable at the same time;
  it doesn't work with newer glib2.
* Sat Dec 15 2007 Jeremy Katz <katzj@redhat.com> - 6.0-24-1
- And fix other stupid error for root on LVM on encrypted PV
* Fri Dec 14 2007 Peter Jones <pjones@redhat.com> - 6.0.23-1
- Fix syntax error from 6.0.22-1
* Thu Dec 13 2007 Jeremy Katz <katzj@redhat.com> - 6.0-22-1
- Fix root on LVM with an encrypted PV
* Wed Dec 12 2007 Peter Jones <pjones@redhat.com> - 6.0.21-1
- Fix missing mkdir for /lib
* Tue Dec 11 2007 Peter Jones <pjones@redhat.com> - 6.0.20-1
- Add encrypted root filesystem support (Patch from dlehman)
* Fri Nov 30 2007 Jeremy Katz <katzj@redhat.com> - 6.0.19-6
- rebuild for libdhcp6client bump
* Sun Nov 11 2007 Jeremy Katz <katzj@redhat.com> - 6.0.19-5
- and another rebuild
* Fri Nov  9 2007 Jeremy Katz <katzj@redhat.com> - 6.0.19-4
- rebuild for new libdhcp4client
* Sat Oct 20 2007 Bill Nottingham <notting@redhat.com> - 6.0.19-3
- pull the right dynamic linker when multiple ones are present (#336161)
* Thu Sep 27 2007 Peter Jones <pjones@redhat.com> - 6.0.19-1
- Fix nosegneg library discovery in get_dso_deps() harder (#244730)
* Tue Sep 25 2007 Peter Jones <pjones@redhat.com> - 6.0.18-1
- Fix segfault on x86_64 paravirt (#304731, patch from Harald Hoyer)
* Wed Sep 19 2007 Peter Jones <pjones@redhat.com> - 6.0.17-1
- Fix missing quotes causing failure to detect erroneous "--with" command line
  arguments (#249163)
- Use open64 in losetup so large files work (#220687)
- Fix sysfs paths for fw-sbp2 (#231708)
- Handle spaces in kernel command line better (#240785)
- Fix handling of --omit-lvm-modules and --omit-dmraid
* Tue Sep 11 2007 Peter Jones <pjones@redhat.com> - 6.0.16-1
- Fix handling of CCISS one more time (bz#274201)
* Fri Sep  7 2007 Peter Jones <pjones@redhat.com> - 6.0.15-1
- Fix dmraid on x86_64.
* Fri Aug 31 2007 Peter Jones <pjones@redhat.com> - 6.0.14-1
- Don't probe loop devices as boot disks or in mkblkdevs
- Minor performance improvements.
* Thu Aug 30 2007 Peter Jones <pjones@redhat.com> - 6.0.13-1
- More fixes to mkblkdevs and other related code.
* Mon Aug 27 2007 Peter Jones <pjones@redhat.com> - 6.0.12-3
- Fix mkblkdevs patch to actually apply ;)
* Mon Aug 27 2007 Peter Jones <pjones@redhat.com> - 6.0.12-2
- Fix segfault in scsi vpd probe code
- Fix block device creation
* Mon Aug 27 2007 Peter Jones <pjones@redhat.com> - 6.0.12-1
- Unmerge one of the 'bash' branch changes; it's not ready yet.
* Mon Aug 27 2007 Peter Jones <pjones@redhat.com> - 6.0.11-2
- Fix minor build problem on x86_64.
- Add BR: popt-devel
* Mon Aug 27 2007 Peter Jones <pjones@redhat.com> - 6.0.11-1
- Temporarily add a requires on mdadm to avoid #249587
- Backport changes from 'bash' branch.
* Wed Aug  1 2007 Peter Jones <pjones@redhat.com> - 6.0.10-3
- rebuild to fix merge error.
* Tue Jul 31 2007 Peter Jones <pjones@redhat.com> - 6.0.10-2
- rebuild to fix merge error.
* Tue Jul 31 2007 Peter Jones <pjones@redhat.com> - 6.0.10-1
- Fix nosegneg library discovery in get_dso_deps() (#244730)
- Only do ld.so discovery once in get_dso_deps()
- Optionally use dhcp to discover nfsroot target (#248575)
* Mon Jun 25 2007 Peter Jones <pjones@redhat.com>
- Fix symlink paths in installkernel on ia64
  Resolves #227711
* Mon Apr 16 2007 Peter Jones <pjones@redhat.com> - 6.0.9-1
- Use scsi_wait_scan.ko with scsi storage modules (#220470)
- Fix handling of config files with no 'default' line in grubby
* Wed Mar 28 2007 Peter Jones <pjones@redhat.com>
- Fix perms on libbdevid
* Fri Mar 23 2007 Jeremy Katz <katzj@redhat.com>
- handle new firewire stack (#231708)
* Wed Feb 28 2007 Peter Jones <pjones@redhat.com>
- Fix linking error on bdevid probe modules
* Tue Feb 27 2007 Peter Jones <pjones@redhat.com> - 6.0.8-1
- nash and mkinitrd shouldn't both provide libbdevid.so.*
* Tue Feb 13 2007 Peter Jones <pjones@redhat.com>
- Query modules for firmware and try to copy it into the image.
* Thu Feb  1 2007 Peter Jones <pjones@redhat.com>
- Add support for ">>" in nash for better debugging of thaw from hibernate.
* Mon Jan 22 2007 Peter Jones <pjones@redhat.com> - 6.0.7-1
- Fix UUID handling on resume devices.
- Don't require that a driver be modular when looking up its name in sysfs.
- Make removable devices conditionally considered when scanning labels.
- Fix handling of dm devices without device tables.
* Thu Jan  4 2007 Jeremy Katz <katzj@redhat.com>
- handle multiline options (#209447)
- iscsi tools changed their syntax (#221088)
* Wed Jan  3 2007 Jeremy Katz <katzj@redhat.com>
- don't create /dev/tty* on s390 (#209204)
* Tue Dec 19 2006 Peter Jones <pjones@redhat.com> - 6.0.6-1
- Fix LABEL handling
* Thu Dec 14 2006 Jeremy Katz <katzj@redhat.com> - 6.0.5-1
- use "stabilized" with ahci and sata_* as well
* Thu Dec 14 2006 Peter Jones <pjones@redhat.com> - 6.0.4-1
- use "stabilized" with the new pata drivers so we don't race.
* Thu Dec  7 2006 Jeremy Katz <katzj@redhat.com> - 6.0.3-1
- build against arbitrary pythons and rebuild for python 2.5
* Tue Dec  5 2006 Peter Jones <pjones@redhat.com> - 6.0.2-1
- Fix typo introduced in merge (patch from notting)
* Mon Dec  4 2006 Peter Jones <pjones@redhat.com> - 6.0.1-1
- Fix library soname and link error.
* Mon Dec  4 2006 Peter Jones <pjones@redhat.com> - 6.0-1
- Merge in close() fix in bdevid probe code from rhel5 branch
- Try to load raid456 module as well as individual level-based modules
- more sophisticated modalias probing, so we get new storage drivers better
  (patch from notting)
- Handle dynamic executables and libraries
- Don't clobber the kernel command line when handling resume (#215084).
- Fix test for "withusb" (#215314).
- Link dynamically
* Thu Oct 26 2006 Peter Jones <pjones@redhat.com>
- Don't reference "netdev" in addnetdev()
- Only use one IP address for "remoteip" in handlenfs()
- Abort much earlier if not invoked as UID 0
* Thu Sep 28 2006 Peter Jones <pjones@redhat.com> - 5.1.19-1
- Fix booting on non-LVM devices where sysfs uses a '!' in the device path,
  such as cciss.  (#201875, #196360)
* Wed Sep 27 2006 Peter Jones <pjones@redhat.com> - 5.1.18-1
- Split nash into its own package to work around dep sorting issue on install.
* Thu Sep 21 2006 Peter Jones <pjones@redhat.com> - 5.1.17-1
- Fix module dependency probing when there's no modalias
* Wed Sep 20 2006 Peter Jones <pjones@redhat.com> - 5.1.16-1
- Don't require non-tmpfs tmpdir unless we're using loopback
- Fix symlink chasing for yaboot.conf in grubby (#207302)
* Wed Sep 20 2006 Jeremy Katz <katzj@redhat.com> 
- Hack for moduledeps of gfs2/nfs
* Tue Sep 19 2006 Jeremy Katz <katzj@redhat.com>
- Handle zfcp.conf not specifying scsiid and scsilun (#198803)
* Tue Sep 12 2006 Peter Jones <pjones@redhat.com>
- Fix escaping error in md-handler's awk script
* Fri Sep  8 2006 Jesse Keating <jkeating@redhat.com> - 5.1.15-1
- more typos to fix related to (#205194)
* Fri Sep  8 2006 Peter Jones <pjones@redhat.com> - 5.1.14-1
- Fix another typo in the same one-line shell wrapper (#205194)
* Fri Sep  8 2006 Peter Jones <pjones@redhat.com> - 5.1.13-1
- Fix missing coreutils dep and typo in shell wrapper (#205194)
- Fix bad mpath test (#204758)
* Thu Sep  7 2006 Peter Jones <pjones@redhat.com> - 5.1.12-1
- Fix bug in dm dependency scanning (#205635)
* Wed Sep  6 2006 Peter Jones <pjones@redhat.com> - 5.1.11-1
- Pull in bdevid properly (not two sources any more)
- Lots of minor bugfixes, leak fixups, etc.
- Updates for new iScsi userland (katzj)
- ata and usb device id probes in bdevid
- preliminary work for boot-time device identification.
- Fixes for network driver selection (katzj)
* Fri Sep  1 2006 Peter Jones <pjones@redhat.com> - 5.1.10-1
- Fix %%%%setup args
- Work around lvm locking problems when clvm is installed (#203904)
- Work around lvm segfault by always using lvm.static
- Fix label scanning on dm devices (based on a patch from Hans de Goede)
  (#204763)
- handle the /proc/bus/usb mounting with a state machine in the module
  loading emission, not with a sentinal value
- do forced finding of devices *after* auto-detection of the root fs, so
  we're not blindsided by bogus scsi_hostadapter aliases and the like.
- move nashDm* functions to libnash so stuff in block.c can call them.
* Tue Aug 29 2006 David Cantrell <dcantrell@redhat.com> - 5.1.9-2
- BuildRequires parted-devel >= 1.7.1-15
* Thu Aug 17 2006 Peter Jones <pjones@redhat.com> - 5.1.9-1
- Fix "MOUNT_PROC_USB" warning
* Wed Aug 16 2006 Peter Jones <pjones@redhat.com> - 5.1.8-1
- Use modprobe to find module deps (#202559, #202596)
- Fix typo for /dev/efirtc (#202110)
* Wed Aug 16 2006 Peter Jones <pjones@redhat.com> - 5.1.7-1
- Make "stabilized" work better (patch from Alexandre Oliva)
- Rewrite usb handling (notting and pjones)
- Fix libbdevid provides/obsoletes.
- Include usb hcd drivers by default
* Mon Aug 14 2006 Bill Nottingham <notting@redhat.com> - 5.1.6-1
- don't make every root device /dev/loop0. Eep.
* Mon Aug 14 2006 Peter Jones <pjones@redhat.com> - 5.1.5-1
- Provide libbdevid.
* Mon Aug 14 2006 Peter Jones <pjones@redhat.com> - 5.1.4-1
- Fix requires for libbdevid
- Make it safe to call nashLogger and nashLoggerV with no context.
* Mon Aug 14 2006 Mark McLoughlin <markmc@redhat.com> - 5.1.3-2
- Fix compile error
* Fri Aug 11 2006 Bill Nottingham <notting@redhat.com> - 5.1.3-1
- replace various sed/grep/cut/head calls with bash & awk equivalents
- fix a typo
- nfs loop fixes
- silence xen errors when sysfs layout is different
* Wed Jul 26 2006 Peter Jones <pjones@redhat.com> - 5.1.2-1
- pull in new libbdevid for scsi probing fix
- restructure package so things can include libbdevid (and its modules)
  without depending on python
* Wed Jul 19 2006 Bill Nottingham <notting@redhat.com>
- support for loopback root (including loop-over-NFS)
* Tue Jul 18 2006 Jeremy Katz <katzj@redhat.com> - 5.1.1-1
- build with -fPIC
- pull in new libbdevid for linking fix
* Mon Jul 17 2006 Jeremy Katz <katzj@redhat.com> - 5.1.0-1
- allow rootdev/rootfs/rootopts parsing on the mkinitrd command line (notting)
- fix case where we'd spin forever resolving a device (#199046)
* Thu Jul 13 2006 Peter Jones <pjones@redhat.com> - 5.0.47-1
- add libbdevid
- fix mode handling on open syscall wrapper (patch from Mark McLoughlin)
- save dhcp lease file after network initialization (patch from markmc)
* Thu Jul  6 2006 Bill Nottingham <notting@redhat.com>
- if NFS host doesn't resolve, assume it's an IP
- make sure IP check doesn't get extraneous info
* Wed Jul  5 2006 Peter Jones <pjones@redhat.com>
- make libnash.a and the nash-devel package
- use libdhcp instead of pump (patch from Mark McLoughlin)
* Fri Jun 30 2006 Jeremy Katz <katzj@redhat.com> - 5.0.46-1
- if we don't get a modalias for a net driver, try via
  ethtool (notting, #196104)
- add patches from Aron Griffis (aron AT hp DOT com) for multiboot
  support on ia64
* Thu Jun 22 2006 Jeremy Katz <katzj@redhat.com> - 5.0.45-1
- don't emit <empty> for iscsi username/password stuff
- handle _netdev option for filesystems
* Thu Jun 22 2006 Jeremy Katz <katzj@redhat.com> - 5.0.44-1
- fix so we only use iscsistart if we're doing root on iscsi
- fix spurious shell error (noticed by karsten)
* Wed Jun 21 2006 Jeremy Katz <katzj@redhat.com> - 5.0.43-1
- Add back patches from pjones which had just been in the package for
  * fix bad shell code to detect DMs in use
  * fix "stabilized" to stat where appropriate
  * use stabilized for sbp2
* Wed Jun 21 2006 Jeremy Katz <katzj@redhat.com> - 5.0.42-1
- add a hack to handle xennet devices not having a modalias (#196104)
- initial pass at support for root on iscsi (patch from Patrick
  Mansfield <patmans@us.ibm.com>)
* Mon Jun 12 2006 Peter Jones <pjones@redhat.com> 
- Fixes for stateless/diskless configurations (patch from Jeff Law,
  <law@redhat.com>)
* Wed May 24 2006 Peter Jones <pjones@redhat.com> - 5.0.41-1
- (very) basic multipath support
- minor fixes for usb
* Thu May 18 2006 Jeremy Katz <katzj@redhat.com> - 5.0.40-1
- fix multiple netdev handling (#192321)
* Wed May 10 2006 Peter Jones <pjones@redhat.com> - 5.0.39-1
- handle [eou]hci_hcd even _more_ correctly ;)
* Tue May  9 2006 Peter Jones <pjones@redhat.com> - 5.0.38-1
- handle bringing up multiple network devices (katzj)
- make "withusb=yes" default
- add --without-usb
- make usb load [euo]hci_hcd correctly
* Mon May  1 2006 Jeremy Katz <katzj@redhat.com>  - 5.0.37-1
- munge rootopts on all non-nfs cases
* Wed Apr 26 2006 Bill Nottingham <notting@redhat.com> - 5.0.36-1
- NFS root fixes
- fix typo
* Mon Apr 10 2006 Peter Jones <pjones@redhat.com> - 5.0.34-1
- fix "!" handling for sysfs paths in mkblkdevs
- fix argument checking for mknodCommand
* Thu Mar 30 2006 Peter Jones <pjones@redhat.com> - 5.0.33-1
- fix unbalanced pushd in mkinitrd (patch from Pete Zaitcev, bz# 185822)
- add "cond" command for simple conditionals (bz# 182938)
- add "status" command to see/set the exit status for testing
- add "--remove-args" and "--update" args for new-kernel-pkg (patch from
  Don Zickus, bz# 183917)
* Mon Mar 13 2006 Peter Jones <pjones@redhat.com> - 5.0.32-1
- handle sd_mod on scsi_mod in findmodule, not in the scsi setup.  This
  fixes the "no scsi_hostadapter" alias problem better (#182008).
* Fri Mar 10 2006 Peter Jones <pjones@redhat.com> - 5.0.31-1
- add segv handler for nash
* Wed Mar  8 2006 Peter Jones <pjones@redhat.com> - 5.0.30-1
- move blkid.tab* references to /etc/blkid/blkid.tab*
- don't do the selinux context stuff on blkid.tab*, as it now inherits from
  the directory.
* Mon Feb 27 2006 Peter Jones <pjones@redhat.com> - 5.0.29-1
- Fix pump-devel buildrequires
- Fix grubby's getpathbyspec() usage (#183010)
- Fix grubby's makefile
- Make readlink command work with super scary huge sysfs paths (#183091)
- Make readlink handle directories better (#166666)
- Don't create ramdisk blockdevs, mkblkdevs does it (#181873)
- Don't use showlabels to resolve labels, use resolveDevice so we don't
  need messy awk (#180372)
* Fri Feb 24 2006 Peter Jones <pjones@redhat.com> - 5.0.28-1
- Make /dev/efirtc on ia64 boxes (#182598)
- Handle selinux contexts on /etc/blkid.tab* since we can't do it in
  libblkid.
- Make building from the "nash" subdir work again
- Make getpathbyspec() allocate on the caller's stack, eliminating
  several memory leaks in callers.
- Don't strip nash
* Wed Feb 22 2006 Peter Jones <pjones@redhat.com> - 5.0.27-1
- Fix multiboot argument quoting in new-kernel-package (#182243)
- Fix "netlink" fd error in hotplug initialization.
- Fix directory creation in smartmknod()
- Fix find command when it's not run alone (#181874, patch from Mark
  McLoughlin)
- Don't use 0-length uuids
- Update /dev/mapper nodes more often
- Allow dm partadd not to include the /dev/mapper path
- Use /etc/fstab, not /fstab, so if you've got /sbin/mount it'll work
- Bring in sd_mod if libata or scsi_mod is selected (#181983)
- use -Wl,--wrap,open and __wrap_open() instead of coeOpen()
* Wed Feb 15 2006 Peter Jones <pjones@redhat.com> - 5.0.26-1
- fix detection of floppy devices, don't probe them for labels
- fix grubby to use the same label scanning code as nash
- senseless rewriting of makefiles so that grubby can use nash's .o's, uh,
  "more easily".
* Tue Feb 14 2006 Peter Jones <pjones@redhat.com> - 5.0.25-1
- rework hotplug control fds (#181515)
* Tue Feb 14 2006 Peter Jones <pjones@redhat.com> - 5.0.24-1
- use the right nash-dm command to get the device list
- check if a subdevice has the same partition table, not if it starts
  at the right place (fixes partition comparison on !mirror devices)
* Mon Feb 13 2006 Peter Jones <pjones@redhat.com> - 5.0.23-1
- add basic hotplug handler and firmware loader
* Mon Feb 13 2006 Jesse Keating <jkeating@redhat.com> - 5.0.22-1.1
- rebump for build order issues during double-long bump
* Sat Feb 11 2006 Peter Jones <pjones@redhat.com> - 5.0.22-1
- formatting cleanups
- prefix partition number with "p" for partitions on dmraid
- add support for disabling partitions which overlap with partitions on
  dm devices.
- add multipath support
- fix dm creation ordering and partition detection
- add "network" command (katzj)
- add nfsroot support (katzj)
- put "showlabels" back into nash
* Fri Feb  3 2006 Peter Jones <pjones@redhat.com> - 5.0.21-1
- add "mount -o bind" support and "mount --move" support (#109366, patch
  from Kasper Dupont)
- add resolveDevice command, which cases down device labels.
- remove "findlodev" from the documentation (#178587)
- fix nash command name parsing bug (#178587)
- fix "find" argument parsing (#178587)
- add "find" handling for "-type d"
* Thu Feb  2 2006 Peter Jones <pjones@redhat.com> - 5.0.20-1
- fix really dumb spec file mistake
- fix devno detection for /dev/root
- fix testdm check
* Thu Feb  2 2006 Peter Jones <pjones@redhat.com> - 5.0.19-1
- mkinitrd: get resolve_dm_name() and get_numeric_dev() from initscripts
  instead of a private copy
- add block.[ch]:
  - move parse_sysfs_devnum(), sysfs_blkdev_probe(), and
    mkpathbyspec() from nash.c
  - add label/uuid/name lookups for block devices using libblkid
- add lib.[ch]:
  - move makeFdCoe(), coeOpen(), coeFopen(), coeOpendir(), readFD(),
    nashLoggerV(), nashLogger(), qprintf(), eprintf(), smartmknod(),
    testing, quiet, reallyquiet from nash.c
  - move nashDefaultLogger(), from dm.c
  - move log enums and declarations from dm.h
- dm.c: add dm_finish(), which does dm_task_destroy() and then library cleanup
  (solves an fd leak)
- remove linux_fs.h, mount_by_label.[ch], name_to_dev_t.[ch]
* Tue Jan 31 2006 Peter Jones <pjones@redhat.com> - 5.0.18-1
- make mkinitrd discover dm uuids
- add uuid support to nash's "dm create" and "dm partadd"
- add nash command "dm get_uuid $NAME"
- add support for renamed dm raids
* Tue Jan  3 2006 Peter Jones <pjones@redhat.com> - 5.0.17-1
- fix dm operations to create/remove device nodes during each change.
* Tue Jan  3 2006 Peter Jones <pjones@redhat.com> - 5.0.16-1
- Hopefully fix raid autorun with a patch from Paul Flinders.
* Mon Dec 19 2005 Peter Jones <pjones@redhat.com> - 5.0.15-1
- Don't open init's console with close-on-exec
* Sun Dec 18 2005 Peter Jones <pjones@redhat.com> - 5.0.14-1
- Remove vestigial loopback support.
- Remove email addresses from man pages (which still need some work)
* Fri Dec 16 2005 Jesse Keating <jkeating@redhat.com> - 5.0.13-1.1
- bump for gcc
* Mon Dec  5 2005 Peter Jones <pjones@redhat.com> - 5.0.13-1
- Updates for gcc 4.1
* Sat Nov 26 2005 Peter Jones <pjones@redhat.com> - 5.0.12-1
- Fix buildreq/req for dmraid on s390
- Typo fix from Alexandre Oliva
* Mon Nov 21 2005 Peter Jones <pjones@redhat.com> - 5.0.11-1
- audit for open()s without appropriate closes()
- make new functions coeOpen(), coeFopen(), and coeOpendir().  These behave
  like open(), fopen(), and opendir() except that they set any associated
  file descriptors to close on exec().
- use them everywhere except where we open a console.
* Thu Nov 17 2005 Peter Jones <pjones@redhat.com> - 5.0.10-1
- don't set up dmraids that aren't active in the initrd
* Wed Nov 16 2005 Peter Jones <pjones@redhat.com> - 5.0.9-1
- dmraid support
* Fri Oct 21 2005 Peter Jones <pjones@redhat.com> - 5.0.8-1
- don't clobber cmdline in mkrootdev (fixes runlevel selection)
* Fri Oct 21 2005 Jeremy Katz <katzj@redhat.com> - 5.0.7-1
- fix new-kernel-pkg --multiboot=
* Tue Oct 18 2005 <pjones@redhat.com> - 5.0.6-1
- make lvm work again
* Mon Oct 17 2005 Peter Jones <pjones@redhat.com> - 5.0.5-1
- make PROBE, MODULES, and PREMODS load defaults from a config file
- get rid of support for not using a dynamic /dev
- add options to force device probes (for when PROBE is "no")
- consolidate some duplicate code paths
- make nash's otherCommand check PATH first and use what it finds there for
  any commands it needs to run, unless the command starts with "nash-",
  in which case the internal version is used unconditionally
- remove the symlink hack for setuproot/preswitchroot/switchroot
- wrap all the nash commands in mkinitrd with shell functions and use the
  "nash-" varient.
- rework root fs creation so Jeremy can use the otherCommand feature
* Fri Oct  7 2005 Peter Jones <pjones@redhat.com> - 5.0.4-1
- split switchroot into setuproot and switchroot, with presetuproot in
  between
- make preswitchroot and setuproot execute through symlinks, so they may
  be replaced by a second initramfs image
- add logic to mount filesystems specified in /etc/fstab.sys during setuproot
- general code cleanups
* Fri Sep 30 2005 Peter Jones <pjones@redhat.com> - 5.0.3-1
- fix root dev discovery to give us "hda3" and such again, rather than
  a full sysfs path
* Thu Sep 29 2005 Peter Jones <pjones@redhat.com> - 5.0.2-1
- add error and quiet printf functions
- use them instead of testing quiet and typing stderr everywhere
- actually make _all_ errors use eprintf (and thus stderr)
- print strerror in errors instead of raw errno
- make "getKernelCmdLine use readFD
- make "getKernelArg" picky about if you've got the right command vs
  just one that starts with the same string
- make "getKernelArg" handle "=" for you, so it either gives you the value
  when there is one, '\0' when there's not and it's EOL, or whitespace.
- reformat some two-space-indent spots
- check for short reads in catCommand
- kill pivotroot
- cleaned up resume messages
- make mkrootdev use readFD
- combine mkdevies and makedevs into mkblkdevs, no longer
  using /proc/partitions
- don't use callocs+memcpy/strcpy+strcat when we can use asprintf
- make setQuietCommand use getKenrelArg
- make runStartup use readFD
- patch from Alexandre Oliva to fix LVM-on-RAID1 /root and swap-on-LVM
  (bz #169059)
- reorder device creation for easier maintenance create /dev/rtc
- change fixme comment about lvm vgs
- use cemit at some places we used a lot of emits before
- reorder device node creation for clarity
- use mkblkdevs instead of makedevs and mkdevices
- decouple loopback root and lvm
* Wed Sep 28 2005 Peter Jones <pjones@redhat.com> - 5.0.1-1
- create /dev/rtc
- create /dev/tty, /dev/tty{0..11}, and /dev/ttyS{0..4}
- tweak the messages output in loud mode during device node creation
* Tue Sep 27 2005 Peter Jones <pjones@redhat.com> - 5.0.0-1
- remove support for pivotroot
- remove support for non-initramfs initrds
- remove support for 2.4 kernels
- don't force scsi_mod before scsi modules; deps should bring it in.
  same for "unknown"; it's not needed any more.
- lots of whitespace adjustment
- minor messaging changes
- no manual redirection to stderr or RCFILE, nor manual verbose checking
- in light of these changes and other planned changes, this is 5.0.0
* Mon Sep 26 2005 Peter Jones <pjones@redhat.com> - 4.2.24-1
- Fix module discovery for raid (eleminates "find" warning as well)
* Sun Sep 25 2005 Peter Jones <pjones@redhat.com> - 4.2.23-2
- Fix module discovery to not always use the modules /dev/hda1 requires
  when using root-on-label.
- Put the lvm check after the raid check, so the raid check atually gets run.
* Wed Sep 21 2005 Peter Jones <pjones@redhat.com> - 4.2.22-1
- Only scan appended kernel command line args for duplicates once.
- handle short reads correctly in nash's readFD
- use calloc for things instead of malloc, since we usually need zeroed memory
  and we never memset
- use canonicalize_file_name instead of malloc+realpath
- honor quiet flag on suspend/resume
- autodetect storage drivers in mkinitrd
* Mon Aug 15 2005 Peter Jones <pjones@redhat.com> - 4.2.21-1
- Fix a bug in switchroot's command line parsing (patch from mkj)
* Fri Aug 12 2005 Jeremy Katz <katzj@redhat.com> - 4.2.20-1
- fix a buglet in root vg finding
- support resume with swsusp
* Fri Aug  5 2005 Peter Jones <pjones@redhat.com> - 4.2.19-1
- Fix yaboot stanza placement with a patch from dwmw2 (#142346)
* Wed Jul 20 2005 Bill Nottingham <notting@redhat.com> - 4.2.18-1
- since udev is not in use, don't require it or claim to be starting it
* Fri Jun 24 2005 Peter Jones <pjones@redhat.com> - 4.2.17-1
- Don't use udev or udevstart in the initrd; it's trivial to do
  all that work by looking for directories with "dev" nodes in sysfs
  and making the device from the dirname using major/minor from "dev"
* Mon Jun  6 2005 Peter Jones <pjones@redhat.com> - 4.2.16-1
- Add a patch from Jeff Layton to remove files from the initramfs
  before executing the new init.  (slightly modified, #153069)
* Tue May 17 2005 Peter Jones <pjones@redhat.com> - 4.2.15-1
- Better init argument handling (don't mess up with serial console)
* Tue May 10 2005 Peter Jones <pjones@redhat.com> - 4.2.14-1
- Better init argument handling (no uninitialized args)
* Fri May  6 2005 Peter Jones <pjones@redhat.com> - 4.2.13-1
- allow for lvm VGs to be in the /dev/mapper/$VG-$LV format (#154767)
* Wed May  4 2005 Peter Jones <pjones@redhat.com> - 4.2.12-1
- Don't copy "console=" arguments from /proc/cmdline to init
* Wed May  4 2005 Peter Jones <pjones@redhat.com> - 4.2.11-1
- don't copy "rw" option into the initrd; use "ro" instead if it's
  the only option.
- Don't print "unmounting old ..." messages in nash if we're set to quiet
* Tue May  3 2005 Peter Jones <pjones@redhat.com> - 4.2.10-1
- set umask explicitly
* Tue Apr 26 2005 Peter Jones <pjones@redhat.com> - 4.2.9-1
- invoke bash with "--norc" (#155986)
- use binary udevstart.static, not a symlink
- print exit status in nash when programs return an error
* Tue Apr  5 2005 Peter Jones <pjones@redhat.com> - 4.2.8-1
- Don't consolidate duplicates in "--args" (#147222)
* Wed Mar 30 2005 Peter Jones <pjones@redhat.com> - 4.2.7-1
- unmount what filesystems we can from the initramfs
- close appropriate files before spawning init
* Wed Mar 23 2005 Peter Jones <pjones@redhat.com> - 4.2.6-1
- work correctly with "set -o noclobber"
- wait longer after modprobe of usb-storage
- fix a wrong error output file
* Tue Mar 22 2005 Peter Jones <pjones@redhat.com> - 4.2.5-1
- handle mount-by-uuid for root correctly (##148756)
* Thu Mar 17 2005 Peter Jones <pjones@redhat.com> - 4.2.4-1
- don't do vgmknodes at all for lvm
* Tue Mar 15 2005 Peter Jones <pjones@redhat.com> - 4.2.3-1
- use --ignorelockingfailure with lvm commands in the initrd, and only
  activate the volume / is on.  (#151172)
* Tue Mar 15 2005 Peter Jones <pjones@redhat.com> - 4.2.2-1
- Fix accidental formatting of data in grub.conf (#151118,
  from proski@gnu.org)
* Tue Mar  1 2005 Peter Jones <pjones@redhat.com> - 4.2.1-1
- typo fixes
- one missed gcc4 fix
* Tue Mar  1 2005 Peter Jones <pjones@redhat.com> - 4.2.0.4-1
- fix gcc4 warnings/errors
- use -D_FORTIFY_SOURCE=2 wherever we don't use RPM_OPT_FLAGS
* Fri Jan 21 2005 Peter Jones <pjones@redhat.com> - 4.2.0.3-1
- Make nash expand environment variables on command lines (#144474)
- Make nash check pids returned from wait*() (#145660)
* Fri Jan 21 2005 Peter Jones <pjones@redhat.com> - 4.2.0.2-1
- Make getArg return NULL on cmd=NULL, fixing #144472 .  Based on a
  patch from Kasper Dupont.
* Tue Jan 18 2005 Jeremy Katz <katzj@redhat.com> - 4.2.0.1-1
- fix grubby tests to run on systems with /boot = /
* Tue Jan 18 2005 Jeremy Katz <katzj@redhat.com> - 4.2.0-1
- grubby: add multiboot support for xen0
- new-kernel-pkg: likewise
* Mon Dec 20 2004 Jeremy Katz <katzj@redhat.com> - 4.1.20-1
- grubby: fix mac yaboot.conf updating if magicboot line is present
* Mon Nov 22 2004 Jeremy Katz <katzj@redhat.com> - 4.1.19-1
- remove use of dietlibc for nash
* Wed Nov  3 2004 Jeremy Katz <katzj@redhat.com>
- handle machines with lots of disks in /proc/partitions (#137816)
* Sun Oct 24 2004 Jeremy Katz <katzj@redhat.com>
- require cpio (#136814)
* Sun Oct 17 2004 Jeremy Katz <katzj@redhat.com> - 4.1.18-1
- fix UPDATEDEFAULT with new-kernel-pkg (#135997)
* Fri Oct 15 2004 Jeremy Katz <katzj@redhat.com> - 4.1.17-1
- run udevstart again instead of sleeping, this will ensure all
  devices are created in all cases after modules have been
  loaded (thanks to notting)
* Fri Oct 15 2004 Jeremy Katz <katzj@redhat.com> - 4.1.16-1
- mkinitrd: Sleep briefly to let udev finish creating devices
* Wed Oct 13 2004 Jeremy Katz <katzj@redhat.com> - 4.1.15-1
- new-kernel-pkg: set new kernels as default (#135161) when
  a) /etc/sysconfig/kernel contains UPDATEDEFAULT=yes
  b) --package foo is passed in and foo matches DEFAULTKERNEL
    in /etc/sysconfig/kernel
* Thu Sep 30 2004 Jeremy Katz <katzj@redhat.com> - 4.1.14-1
- support changing root on the kernel command line with lvm (#133236)
* Wed Sep 22 2004 Jeremy Katz <katzj@redhat.com> - 4.1.12-1
- update to work with udev 032, conflict with old udev
- if udev is present, use it.  trying to avoid the use of udev if it's
  installed is the road to things not working
* Fri Sep 10 2004 Jeremy Katz <katzj@redhat.com> - 4.1.11-1
- more fixing
* Wed Sep  8 2004 Jeremy Katz <katzj@redhat.com> - 4.1.10-1
- mkinitrd: mount tmpfs with the right permissions
* Tue Aug 31 2004 Jeremy Katz <katzj@redhat.com> - 4.1.9-1
- mkinitrd: use tmpfs instead of ramfs for udev stuff
* Fri Aug 27 2004 Jeremy Katz <katzj@redhat.com> - 4.1.8-1
- nash: and the hack to fix ppc broke other arches, conditionalize it (#130928)
* Wed Aug 25 2004 Jeremy Katz <katzj@redhat.com> - 4.1.6-1
- nash: fix another off by one (#130987)
- nash: hack to fix ppc booting (#130928)
* Wed Aug 25 2004 Karsten Hopp <karsten@redhat.com> - 4.1.5-1
- fix zfcp handling
* Tue Aug 24 2004 Jeremy Katz <katzj@redhat.com> - 4.1.4-1
- nash: create raid device if needed (think udev) before calling
  the raidautorun ioctl (#130561)
* Tue Aug 24 2004 Jeremy Katz <katzj@redhat.com> - 4.1.3-1
- nash: make echo behavior consistent with other shells
- more fixes from Steve Grubb (#129673)
* Mon Aug 23 2004 Karsten Hopp <karsten@redhat.de> 4.1.2-1
- mkinitrd: add support for zfcp devices (mainframe)
* Thu Aug 19 2004 Jeremy Katz <katzj@redhat.com> - 4.1.1-1
- don't remove lost+found (#130327)
- don't try to mount/umount /sys on 2.4 (#130298)
* Tue Aug 17 2004 Jeremy Katz <katzj@redhat.com> - 4.1.0-1
- mkinitrd: if using udev for the initrd, set things up appropriately
  (based on patches from Harald Hoyer and Thomas Woerner)
- nash: support for echo -n
- nash: better error message on exec failures
- nash: exec udev if we're called as a hotplug handler
* Mon Aug 16 2004 Jeremy Katz <katzj@redhat.com> - 4.0.6-1
- various fixes from a code review by Steve Grubb which should fix
  some of the lingering problems (#129673)
- nash: warning fix from Michal Jaegermann (#129673)
- grubby: removal with (hd0,0)
* Thu Aug 12 2004 Jeremy Katz <katzj@redhat.com> - 4.0.5-1
- nash: oops, let's try that again
* Wed Aug 11 2004 Jeremy Katz <katzj@redhat.com> - 4.0.4-1
- nash: fix mounting by label in some cases (tracked down by
  Erik Jacobson, #129581, #129673, #129667, #129635)
* Tue Aug 10 2004 Jeremy Katz <katzj@redhat.com>  4.0.3-1
- grubby: more (hd0,0) support (#125156)
- mkinitrd.8: update manpage (#129585)
- nash: fix some warnings
* Wed Aug  4 2004 Jeremy Katz <katzj@redhat.com> 4.0.2-1
- nash: support bind mounting
- grubby: support the (hd0,0)/path syntax for kernels and initrds in
  grub.conf (#114758, #125156, #120906)
* Wed Aug  4 2004 Jeremy Katz <katzj@redhat.com> - 4.0.1-1
- improve handling of arguments to init with initramfs (#129057)
* Mon Aug  2 2004 Jeremy Katz <katzj@redhat.com> - 4.0.0-1
- create an initramfs on 2.6 kernels instead of an initrd
- use new mount magic instead of pivot_root
  on 2.6 kernels
- try to handle the case of modules going away on kernel upgrades a
  little bit more nicely (#123994)
- avoid over-zealous creation of /dev/mapper/control (#127115)
- improve nash(8) manpage (#127413)
* Fri Jun 18 2004 Jeremy Katz <katzj@redhat.com> - 3.5.24-1
- fix usb-storage detection with 2.6 (#126309)
* Tue May 18 2004 Jeremy Katz <katzj@redhat.com> - 3.5.23-1
- add support for RAID6
* Wed May 12 2004 Jeremy Katz <katzj@redhat.com>
- add support for multipath personality from Tom Callaway (#120379)
* Thu May  6 2004 Jeremy Katz <katzj@redhat.com> - 3.5.22-1
- bump initrd size (#122325)
* Wed Apr 14 2004 Jeremy Katz <katzj@redhat.com> - 3.5.21-1
- new-kernel-package: add patch from Ryan Tilder to allow setting new
  kernel as default (#117605)
- mkinitrd: i2o_pci isn't in 2.6 (#120827)
- new-kernel-pkg: conditionalize kernel binary name for 2.6 vs 2.4
  on ppc/ppc64 (as it's vmlinuz in 2.6 instead of the
  vmlinux from 2.4) (#120868)
* Tue Apr 13 2004 Jeremy Katz <katzj@redhat.com> - 3.5.20-1
- mkinitrd: minor regex fix for some kernel names (#120624)
* Mon Feb  9 2004 Jeremy Katz <katzj@redhat.com> - 3.5.19-1
- nash/mkinitrd: quiet mode for nash and necessary mkinitrd changes
  to work with it
- mkinitrd: add lxo's patch for copying lvm.conf (#112099)
- new-kernel-pkg: allow specifying the banner used in the boot loader config
  on the command line (#114809)
* Tue Jan 13 2004 Jeremy Katz <katzj@redhat.com> 
- mkinitrd: add patch from Alex Kiernan for modules with multiple
  deps in 2.6 (#113306)
* Thu Jan  8 2004 Jeremy Katz <katzj@redhat.com> 3.5.18-1
- new-kernel-pkg: add a --kernel-arguments option (#113125)
* Tue Jan  6 2004 Jeremy Katz <katzj@redhat.com> 
- fix ybin path (#112939)
* Sun Jan  4 2004 Jeremy Katz <katzj@redhat.com> 3.5.17-1
- mkinitrd: handle multiple spaces in modules.conf (from Lubomir Bulej)
- nash: rebuild against new dietlibc fixing problems with root=LABEL= (#112623)
- mkinitrd: determine kernel version and adjust modulefile appropriately
  so that we look at /etc/modprobe.conf for 2.6 kernels
- mkinitrd: first pass at getting lvm working on 2.4 -> 2.6 upgrade
* Wed Dec 24 2003 Jeremy Katz <katzj@redhat.com> 
- mkinitrd: quiet strip by default
* Mon Dec 22 2003 Jeremy Katz <katzj@redhat.com> 3.5.16.1-1
- make stripping less aggressive
* Mon Dec 22 2003 Jeremy Katz <katzj@redhat.com> 3.5.16-1
- fixing handling of non-lvm case when /dev/mapper/control isn't present
- add patch from Al Viro to get root dev in numeric form by grokking sysfs
* Tue Dec  9 2003 Jeremy Katz <katzj@redhat.com> 
- strip modules if /usr/bin/strip exists (#111756)
* Fri Dec  5 2003 Jeremy Katz <katzj@redhat.com> 3.5.15-2
- require lvm2 so that it gets installed early enough
* Fri Dec  5 2003 Jeremy Katz <katzj@redhat.com> 3.5.15-1
- mkinitrd: add support for lvm2 (note: will not currently handle being
  on a running 2.4 kernel and installing 2.6 with lvm rootfs)
* Wed Dec  3 2003 Jeremy Katz <katzj@redhat.com> 
- nash: add mkdmnod for creating the device-mapper control node
* Thu Oct  2 2003 Jeremy Katz <katzj@redhat.com> 3.5.14-1
- fix dependency on /usr/bin/tail and /usr/bin/id
* Tue Sep 30 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- remove one more mktemp dir for "all loopback devices in use" case
* Tue Sep 23 2003 Jeremy Katz <katzj@redhat.com> 3.5.13-1
- fix getting modules from /lib/modules/$(uname -r)/updates
* Mon Sep 22 2003 Jeremy Katz <katzj@redhat.com> 3.5.12-1
- argument checking and usage for /sbin/installkernel  (#103109)
* Wed Sep  3 2003 Jeremy Katz <katzj@redhat.com> 3.5.11-1
- really only do grub configs on grub arches
- some usb mkinitrd fixes
* Fri Aug 29 2003 Jeremy Katz <katzj@redhat.com> 3.5.10-1
- clean up bogus warning in installkernel
- only try to do grub configs on arches which support grub (#103261)
* Thu Aug  7 2003 Matt Wilson <msw@redhat.com> 3.5.9-1
- add \n to error messages in grubby
- NUL terminate buffer returned from readlink properly
- symlinks are most likely relative, chdir to / before trying to
  follow them
- yaboot needs boot prefix
- silo needs boot prefix too
* Wed Jul 30 2003 Jeremy Katz <katzj@redhat.com> 
- grubby: don't segfault on label=\n (reported by dburcaw)
* Thu Jul 24 2003 Jeremy Katz <katzj@redhat.com> 
- grubby: patch from zaitcev for uninitialized variable that can get
  hit in the zipl case
* Mon Jul 21 2003 Jeremy Katz <katzj@redhat.com> 3.5.8-1
- bump initrd size (#99525)
* Wed Jul  9 2003 Jeremy Katz <katzj@redhat.com> 3.5.7-1
- pick modules from /lib/modules/$(uname -r)/updates first
- be less confused by more than one module of a name
* Wed Jun 25 2003 Jeremy Katz <katzj@redhat.com> 3.5.6-1
- unbreak reading module options from modules.conf again (#97982)
* Fri Jun 20 2003 Bill Nottingham <notting@redhat.com> 3.5.5-1
- fix modules.dep usage for 2.5/2.6
* Fri Jun 20 2003 Jeremy Katz <katzj@redhat.com> 3.5.4-1
- handle more bizarre modules.conf constructs (notting)
* Thu Jun 12 2003 Jeremy Katz <katzj@redhat.com> 3.5.3-1
- mkinitrd: fix copying of pvs (#97314, #97289)
- mkinitrd: use pvscan instead of lvmdiskscan to find PVs to work
  better on other arches
- mkinitrd: better check for dasd existence
- mkinitrd: make certain lvm-mod is included if root on lvm
* Wed Jun 11 2003 Jeremy Katz <katzj@redhat.com> 3.5.2-1
- mkinitrd: revert use of modprobe -c.  it breaks in the installer when we
  don't have a modules.dep for the BOOT kernel
- nash: return pivot_root call correctly (#97753)
* Wed Jun 11 2003 Jeremy Katz <katzj@redhat.com> 3.5.1-1
- nash: fix syscall bits with gcc 3.3 on s390
- new-kernel-pkg: do depmod before mkinitrd (#97218)
* Tue Jun 10 2003 Jeremy Katz <katzj@redhat.com> 3.5.0-1
- mkinitrd: add patch from gc@mandrakesoft.com to determine module
  deps from modules.dep (#87873)
- tweak patch to not break weird cases where module deps aren't all
  you need :/
- grubby: don't remove the last kernel (#60041)
- mkinitrd: use modprobe -c to find module options (#89794)
* Tue May 20 2003 Matt Wilson <msw@redhat.com> 3.4.52-1
- use addSystemMap to build the image for iSeries (#91187)
* Fri May 16 2003 Jeremy Katz <katzj@redhat.com> 3.4.51-1
- grubby: error out gracefully if we run out of space (#85424)
- mkinitrd: copy parent dirs for pvs (#88962)
- mkinitrd: exit with an exit status if tar fails (#90123)
- new-kernel-pkg: only use the first entry for / (#90155)
- grubby: fix a buffer overflow  (#90444)
* Wed Apr 30 2003 Jeremy Katz <katzj@redhat.com> 3.4.50-1
- fix typo in new-kernel-pkg for iSeries
* Wed Apr 30 2003 Elliot Lee <sopwith@redhat.com>
- BuildRequires: popt
- Change grubby Makefile to static-link popt a bit more cleanly
* Thu Apr 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.49.1-1
- use Arjan's suggestion of vmlinitrd for the kernel + initrd combo file
* Thu Apr 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.49-2
- fix description referencing /etc/conf.modules (#89558)
* Thu Apr 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.49-2
- require ppc64-utils on ppc
* Fri Apr 18 2003 Jeremy Katz <katzj@redhat.com> 3.4.49-1
- new-kernel-pkg: on iSeries, we don't have a boot loader, just make the
  kernel + initrd combo file (/boot/vmlinux-version.img)
* Mon Apr  7 2003 Karsten Hopp <karsten@redhat.com> 3.4.48-1
- Fix segfault on mainframe
* Wed Mar 26 2003 Jeremy Katz <katzj@redhat.com> 3.4.47-1
- mkinitrd: fix using options for loading modules
- mkinitrd: don't use kernel parameters for dasd at mkinitrd time,
  use what's in modules.conf
* Mon Mar 24 2003 Jeremy Katz <katzj@redhat.com> 3.4.46-1
- new-kernel-pkg: add necessary bits for s390, some logic cleanups
- grubby: fix root detection for s390{,x}
* Sun Mar 23 2003 Jeremy Katz <katzj@redhat.com> 3.4.45-1
- grubby: add silo support (sparc)
- grubby: add zipl support (s390{,x})
- add grubby test cases for zipl support
* Wed Mar 19 2003 Jeremy Katz <katzj@redhat.com> 3.4.44.1-1
- fix dasd option reading
* Fri Mar 14 2003 Phil Knirsch <pknirsch@redhat.com> 3.4.44
- Added automatic dasd= parameters for kernel parameter on s390(x).
* Tue Mar  4 2003 Jeremy Katz <katzj@redhat.com> 3.4.43-1
- apply ppc patches for new-kernel-pkg and installkernel from Dan
  Burcaw <dburcaw@terrasoftsolutions.com>
- man page tweak (#85471)
* Tue Feb 18 2003 Jeremy Katz <katzj@redhat.com> 3.4.42-1
- grubby: fix segfault from uninitialized variable (#84128)
* Tue Feb 11 2003 Jeremy Katz <katzj@redhat.com> 3.4.41-1
- nash: add readlink
- use readlink for rootdev to handle symlinks to root devs (#83391)
* Tue Feb  4 2003 Jeremy Katz <katzj@redhat.com> 3.4.40-1
- fix i2o module ordering (#83447)
- ifarch'd build requires of dietlibc now that the build system has a way to
  handle these
* Sat Feb  1 2003 Florian La Roche <Florian.LaRoche@redhat.de>
- change one test from a number to a string test that could otherwise
  fail in not properly setup chroot environments
* Fri Jan 31 2003 <ewt@redhat.com>
- added support for yaboot
- test script runs tests for all platforms
- separated elilo configuration from lilo mode, allowing elilo specific
  tests to be run on any platform
* Sun Jan 26 2003 <ewt@redhat.com>
- grubby now shortens lilo titles to ensure they are less then 16 characters
  long (76236)
- mkinitrd would only turn on /dev/md0 if raid was needed; now it enables
  all raid devices listed in /proc/mdstat (82209)
- use product name from /etc/redhat-release to generate label in grub.conf
  (82352)
* Mon Jan 20 2003 Bill Nottingham <notting@redhat.com> 3.4.36-1
- don't error out running awk on /proc/mdstat if /proc/mdstat isn't
  there
* Tue Jan 14 2003 <ewt@redhat.com>
- all mkdev() actions will create directories as needed (some code in
  mkdevices is now obsolete; I'll remove it later) (#73317)
- added mkdev command to test the above
- support diratime/nodiratime mount options (#78738)
- grubby will follow symlinks when writing new config file (#78713)
- don't depend on raidtab, use /proc/mdstat instead (#80424) this covers
  both mkinitrd and grubby
* Sun Jan  5 2003 Jeremy Katz <katzj@redhat.com> 3.4.34-1
- grubby: fix segfault finding default if default doesn't have a root= (#66000)
- don't include usb modules by default.  pass --with-usb to get usb modules
- make sure kudzu exists before trying to exec it
- handle multiple scsi hosts being present (#77422)
- add /usr/sbin to default path (#79581)
- fix using --builtin= (#80448)
- grubby: preserve the mode on config files (#80776)
* Mon Dec 16 2002 Jeremy Katz <katzj@redhat.com>
- errno fixes
* Tue Dec  3 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- /sbin/new-kernel-pkg: fix a test to have correct ""
* Fri Nov 22 2002 Jeremy Katz <katzj@redhat.com>
- mkinitrd: more gzipped module fixes
* Thu Nov 21 2002 Jeremy Katz <katzj@redhat.com>
- mkinitrd: add support for finding gzipped modules
- mkinitrd: don't be noisy if we don't have lvm-mod loaded
* Wed Nov  6 2002 Jeremy Katz <katzj@redhat.com>
- grubby: don't bail when looking for root in appends of lilo-style configs
- include grubby on x86_64
* Thu Sep 26 2002 Nalin Dahyabhai <nalin@redhat.com>
- fix some syntax errors
- use grep's -q flag to save a redirect in places where we're not redirecting
  stderr
* Thu Sep  5 2002 Jeremy Katz <katzj@redhat.com>
- grubby could segfault by going into its lilo checking if it couldn't find
  a default to copy (default had no root= and --bad-image-okay wasn't
  being used)
* Mon Sep  2 2002 Jeremy Katz <katzj@redhat.com>
- nash: create directories if needed in mkdevices command (#73090)
- grubby: handle lilo case of non-linux default (#72202)
* Sat Aug 31 2002 Jeremy Katz <katzj@redhat.com>
- grubby: fix for case like 'append = " hdc=ide-scsi "' (#68802)
* Fri Aug 30 2002 Bill Nottingham <notting@redhat.com>
- fix firewire stuff (#72916)
* Fri Aug 23 2002 Bill Nottingham <notting@redhat.com>
- fix mpt fusion stuff
* Tue Aug 13 2002 Jeremy Katz <katzj@redhat.com>
- /boot/efi/redhat -> /boot/efi/EFI/redhat on ia64
* Sun Aug 11 2002 Jeremy Katz <katzj@redhat.com>
- fix grubby to work correctly on ia64
* Thu Aug  8 2002 Michael Fulbright <msf@redhat.com>
- added sleep command to nash and fixed creating initrd with / or /boot on usb
* Tue Jul 30 2002 Jeremy Katz <katzj@redhat.com>
- grubby: adding kernels to lilo.conf when not using root=LABEL will work
  now too
* Fri Jul 26 2002 Erik Troan <ewt@redhat.com>
- didn't close /proc/partitions in mkdevices
* Thu Jul 25 2002 Jeremy Katz <katzj@redhat.com>
- grubby: fix adding kernels to lilo when using root=LABEL
* Wed Jul 24 2002 Erik Troan <ewt@redhat.com>
- added and used mkdevices command (68959)
* Wed Jul 17 2002 Erik Troan <ewt@redhat.com>
- do proper probing to check root=LABEL
- --bootloader-probe didn't support /etc/sysconfig/grub
* Fri Jul 12 2002 Erik Troan <ewt@redhat.com>
- don't sanity check root=LABEL right now; probing might make sense?
* Wed Jul 10 2002 Erik Troan <ewt@redhat.com>
- --ifneeded is obsolete; we always need initrds
- grubby lets you specify multiple indexes for --info
- grubby lets you select kernels by title
- added showlabels to nash
- new-kernel-pkg sets the root device from /etc/fstab rather then inheriting it
- new-kernel-pkg removes all entries w/ a duplicate label (67459)
* Mon Jul  8 2002 Erik Troan <ewt@redhat.com>
- usb root device code could fail, causing no initrd to be made
* Thu Jun 27 2002 Erik Troan <ewt@redhat.com>
- grubby didn't add new kernels properly
* Thu Jun 27 2002 Erik Troan <ewt@redhat.com>
- support root on usb devices
* Wed Jun 26 2002 Erik Troan <ewt@redhat.com>
- other= in lilo.conf wasn't being parsed out properly
* Mon Jun 24 2002 Erik Troan <ewt@redhat.com>
- changed --add-kernel implementation so that --args gets handled properly
* Sun Jun 23 2002 Erik Troan <ewt@redhat.com>
- added loadinitrd (used by mkbootdisk) on ia32 and sparc
- modules "off" and "null" should be ignored (67086)
- mkrootdev looks for root=LABEL=/ in /proc/cmdline, so root by label
  works again (fully determined by root= kernel parameter)
- added --update-kernel and --remove-args arguments to grubby
- kernel specification of ALL supported by grubby
- DEFAULT accepted much more consistently
- grubby --info displays info on all kernels specified, not just the first
- ext3 need mbcache now (67354)
- grubby allows config file entry numbers to be used as kernel paths
- support /etc/sysconfig/grub.conf
- display lba info from lilo.conf file in --info
* Thu Jun 13 2002 Jeremy Katz <katzj@redhat.com>
- don't run lilo twice on kernel removal in new-kernel-pkg
- don't run grubby to add/remove kernels from new-kernel-pkg if
  bootloader config doesn't
* Tue Jun 11 2002 Erik Troan <ewt@redhat.com>
- added --bootloader-probe to grubby
- wrote a man page for grubby
- include grubby on ia64
- updated new-kernel-pkg to work with lilo/elilo
- added --info=DEFAULT option
* Mon Jun 10 2002 Jeremy Katz <katzj@redhat.com>
- start raid before lvm so that you can have root on lvm on raid (#66175)
* Tue Jun  4 2002 Erik Troan <ewt@redhat.com>
- failed to initialize a variable in grubby
* Fri May 31 2002 Erik Troan <ewt@redhat.com>
- added --grub option so grub tests could run on ia64
- added some basic tests of lilo default directive handling
* Wed May 29 2002 Jeremy Katz <katzj@redhat.com>
- require lvm
* Tue May 28 2002 Bill Nottingham <notting@redhat.com>
- fix umounting of /initrd when pivoting
* Tue May 28 2002 Erik Troan <ewt@redhat.com>
- marked /sbin/installkernel as %%config (53006)
- run make test during build
* Wed May 22 2002 Erik Troan <ewt@redhat.com>
- added --nopivot (53679)
- honor INSTALL_PATH in installkernel (32833)
- installkernel versions old kernels as well (52756)
- lilo support added to grubby
* Tue May 21 2002 Erik Troan <ewt@redhat.com>
- cleaned up usage message
- added --omit-lvm-modules to man page
- added --builtin option (65250)
- skip comments in fstab (65249)
- added findlodev to nash, use that to pick block device (63421)
- support -o option in nash's mount (59185)
- look for xfs_dmapi (60066)
- added > support for executed commands (61180)
- grubby copies permissions from old config file (59227)
- use options from fstab for root filesystem (56071)
- try and be better about returning nonzero on error (60203)
- make modprobe symlink properly to avoid kernel message (62145)
- support linear raid (12775)
- support fallback option in grub config (54794)
- comments in template entries not handled quite right (65198)
* Sat Apr 20 2002 Erik Troan <ewt@redhat.com>
- grubby does a better job of not adding superfluous default= lines
* Wed Apr 17 2002 Erik Troan <ewt@redhat.com>
- preload works again
* Wed Apr 10 2002 Jeremy Katz <katzj@redhat.com>
- revert to not mounting by label
* Fri Apr  5 2002 Jeremy Katz <katzj@redhat.com>
- include pbrown's changes to load parport_pc when needing ppa.o (#35360)
* Thu Apr  4 2002 Jeremy Katz <katzj@redhat.com>
- fix redirection bug (#62623)
- create proper link of /sbin->/bin in initrd (#62199)
* Thu Mar 28 2002 Jeremy Katz <katzj@redhat.com>
- prereq dev package so that we always have the dev package before we get run
* Fri Mar 22 2002 Jeremy Katz <katzj@redhat.com>
- duh, that won't work.  fix it
- don't require lvm tools right now
* Thu Mar 21 2002 Jeremy Katz <katzj@redhat.com>
- fix nash to create directories for devices like cciss and ida
* Tue Feb  5 2002 Bill Nottingham <notting@redhat.com>
- run mkinitrd with -f in new-kernel-pkg
- don't run lilo in /sbin/installkernel
* Fri Feb  1 2002 Jeremy Katz <katzj@redhat.com>
- require lvm
* Thu Jan 31 2002 Jeremy Katz <katzj@redhat.com>
- clean up warnings for when /proc isn't mounted
* Tue Jan 29 2002 Jeremy Katz <katzj@redhat.com>
- fix probing for LVM usage to require a volume group to exist before adding
  the module
- --omit-lvm-modules will omit LVM modules
- add support for root device being LVM
* Wed Jan 16 2002 Erik Troan <ewt@redhat.com>
- look for a non /tmpfs directory
- added support for xfs
- use with raid md.o if it exists
- fixed bug in echo
- use find form nash rather then /usr (mkinitrd shouldn't need /usr
  mounted)
* Fri Jan 11 2002 Erik Troan <ewt@redhat.com>
- added support for mounting root filesystem by label
- switched to dietlibc from minilibc
- fix so --preload= works [33675,57560,44377]
- added info on --image-version and --nocompress to man page [57560]
- set fileystem check interval to 0 in case the system clock
  is borked [51454]
- give a proper error when run by a user other then root [27218,53159]
- grubby statically linked against popt [55305]
- cleaned up verbose output a bit [21791]
* Tue Dec 18 2001 Trond Eivind Glomsr�d <teg@redhat.com>
- Add LVM module when LVM is used
* Wed Sep  5 2001 Jeremy Katz <katzj@redhat.com>
- grubby shouldn't blow away default=saved lines (#52981)
* Fri Aug 31 2001 Jeremy Katz <katzj@redhat.com>
- fix new-kernel-pkg --mkinitrd for ia64
* Thu Aug 30 2001 Erik Troan <ewt@redhat.com>
- fixed bug handling invalid default (MF #52889)
- in some cases we would set the default to point at a removed image
* Wed Aug 29 2001 Erik Troan <ewt@redhat.com>
- minor grubby fixes
* Tue Aug 28 2001 Jeremy Katz <katzj@redhat.com>
- let new-kernel-pkg be able to do more (initrds, modules.*)
- include grubby only on x86
* Mon Aug 27 2001 Jeremy Katz <katzj@redhat.com>
- more grubby fixups for having a /boot
- added new-kernel-pkg
* Sun Aug 26 2001 Erik Troan <ewt@redhat.com>
- added grubby
- added installkernel
* Fri Aug  3 2001 Matt Wilson <msw@redhat.com>
- make consoles with the correct minor numbers
- applied patch from hjl to fix fstab parsing (#50819)
* Fri Jul 20 2001 Jeremy Katz <katzj@redhat.com>
- skip errors finding jbd as a module if we're skipping them trying to find
  ext3 so that you can build a kernel with ext3 built-in and still use an
  initrd
* Wed Jul 11 2001 Bill Nottingham <notting@redhat.com>
- don't print errors if /etc/raidtab doesn't exist
- or /etc/{modules.conf,conf.modules}, for that matter
* Fri Jul  6 2001 Matt Wilson <msw@redhat.com>
- don't dig through /etc/fstab to find out if we have a filesystem on
  a RAID device, it's usually mounted by label so /dev/mdN isn't there
  at all (#46525)
* Tue Jun 26 2001 Bill Nottingham <notting@redhat.com>
- require filesystem >= 2.1.0, otherwise we don't boot
* Thu Jun 21 2001 Erik Troan <ewt@redhat.com>
- added a bunch of commands to nash
- use pivot_root
- support ext3
* Fri Jun  8 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- delete the exclusivearch line completely
* Fri Mar 23 2001 Matt Wilson <msw@redhat.com>
- reset the state of findmodule after getting the modules we need
* Wed Feb 28 2001 Matt Wilson <msw@redhat.com>
- changed the Requires on mktemp from >= 1.5 to >= 1.5-5 (which included
  - d support) (#30127)
* Fri Feb 23 2001 Erik Troan <ewt@redhat.com>
- let nash be invoked as modprobe to avoid a modprobe failure to exec
- nash will try to run arbitrary commands now (removing insmod as a special
  case)
* Mon Feb 12 2001 Matt Wilson <msw@redhat.com>
- add findutils to Requires line (#27269)
* Thu Feb  8 2001 Matt Wilson <msw@redhat.com>
- added checks to load the modules i2o_block needs
* Wed Feb  7 2001 Bill Nottingham <notting@redhat.com>
- fix utterly broken build
* Wed Jan 31 2001 Helge Deller <hdeller@redhat.com>
- added mandir to nash Makefile (RH 6.x compatibility)
* Tue Jan 30 2001 Erik Troan <ewt@redhat.com>
- added dependency on mktemp
* Thu Jan 25 2001 Erik Troan <ewt@redhat.com>
- we need to insert xor.o before raid5.o
* Wed Jan 24 2001 Matt Wilson <msw@redhat.com>
- code in RAID_AUTORUN ioctl fallback
- fixed raidstart check flag from -z to -n
* Tue Jan 23 2001 Erik Troan <ewt@redhat.com>
- switched to using nash from sash
* Tue Jan 23 2001 Matt Wilson <msw@redhat.com>
- added patch from twaugh to avoid blindly adding scsi_mod
  and sd_mod to initrd if they are not needed (#24114)
* Thu Jan 11 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Enlarge initrds, needed for systems with both IDE and SCSI
  (Bug #23846)
- Version 2.[6789] probably shouldn't identify itself as 2.6
  with --version. ;)
- bzip2 source
* Wed Dec 20 2000 Erik Troan <ewt@redhat.com>
- let the kernel autoload ide-cd
* Fri Dec  8 2000 Erik Troan <ewt@redhat.com>
- added modular ide support
* Wed Aug 30 2000 Nalin Dahyabhai <nalin@redhat.com>
- use mktemp to create temporary files and directories
* Sat Aug  5 2000 Erik Troan <ewt@redhat.com>
- changes from Keith Owens for 2.4
* Tue Jul  4 2000 Matt Wilson <msw@redhat.com>
- build on alpha
* Mon Jun 26 2000 Bill Nottingham <notting@redhat.com>
- ignore 'unknown' aliases (they shouldn't be there anyways)
* Thu Jun  1 2000 Bill Nottingham <notting@redhat.com>
- build on ia64
- bump up initrd size on ia64
- modules.confiscation, /usr/man -> /usr/share/man
* Tue May  2 2000 Nalin Dahyabhai <nalin@redhat.com>
- make RPM pick up man page, regardless of compression
* Tue Feb 29 2000 Matt Wilson <msw@redhat.com>
- add requirement for /sbin/losetup
* Mon Feb  7 2000 Matt Wilson <msw@redhat.com>
- gzip manpage
* Thu Feb  3 2000 Matt Wilson <msw@redhat.com>
- gzip manpage
* Mon Jan 10 2000 Erik Troan <ewt@redhat.com>
- use sash, not ash
* Mon Jan  3 2000 Matt Wilson <msw@redhat.com>
- use ash.static for /bin/sh, not sash
* Sat Jan  1 2000 Erik Troan <ewt@redhat.com>
- configure loopback devices
* Tue Sep 28 1999 Bill Nottingham <notting@redhat.com>
- sparc fixup from jakub
* Wed Sep 22 1999 Michael K. Johnson <johnsonm@redhat.com>
- fix cleanup (blush!)
* Tue Sep 21 1999 Michael K. Johnson <johnsonm@redhat.com>
- now works when /usr is not mounted (do not rely on /usr/bin/install)
- slight cleanups, better usage message
* Thu Jul 29 1999 Michael K. Johnson <johnsonm@redhat.com>
- Now automatically includes necessary raid modules
- --omit-raid-modules now omits raid modules
- tiny doc updates
* Thu Jul 29 1999 Bill Nottingham <notting@redhat.com>
- updates from bugzila (#4243, #4244)
* Sat Mar 27 1999 Matt Wilson <msw@redhat.com>
- --omit-scsi-modules now omits all scsi modules
- updated documentation
- mkinitrd now grabs scsi_hostadapter modules from anywhere -
  some RAID controller modules live in block/
* Thu Feb 25 1999 Matt Wilson <msw@redhat.com>
- updated description
* Mon Jan 11 1999 Matt Wilson <msw@redhat.com>
- Ignore the absence of scsi modules, include them if they are there, but
  don't complain if they are not.
- changed --no-scsi-modules to --omit-scsi-modules (as it should have been)
* Thu Nov  5 1998 Jeff Johnson <jbj@redhat.com>
- import from ultrapenguin 1.1.
* Tue Oct 20 1998 Jakub Jelinek <jj@ultra.linux.cz>
- fix for combined sparc/sparc64 insmod, also pluto module is really
  fc4:soc:pluto and we don't look at deps, so special case it.
* Sat Aug 29 1998 Erik Troan <ewt@redhat.com>
- replaced --needs-scsi-mods (which is now the default) with
  - -omit-scsi-mods
* Fri Aug  7 1998 Jeff Johnson <jbj@redhat.com>
- correct obscure regex/shell interaction (hardwires tabs on line 232)
* Mon Jan 12 1998 Erik Troan <ewt@redhat.com>
- added 'make archive' rule to Makefile
- rewrote install procedure for more robust version handling
- be smarter about grabbing options from /etc/conf.modules
* Mon Oct 20 1997 Erik Troan <ewt@redhat.com>
- made it use /bin/ash.static
* Wed Apr 16 1997 Erik Troan <ewt@redhat.com>
- Only use '-s' to install binaries if /usr/bin/strip is present.
- Use an image size of 2500 if binaries can't be stripped (1500 otherwise)
- Don't use "mount -o loop" anymore -- losetup the proper devices manually
- Requires losetup, e2fsprogs
* Wed Mar 12 1997 Michael K. Johnson <johnsonm@redhat.com>
- Fixed a bug in parsing options.
- Changed to use a build tree, then copy the finished tree into the
  image after it is built.
- Added patches derived from ones written by Christian Hechelmann which
  add an option to put the kernel version number at the end of the module
  name and use install -s to strip binaries on the fly.
