Summary: The GNU versions of grep pattern matching utilities
Name: grep
Version: 2.5.1a
Epoch: 1
Release: 61.9
License: GPLv2+
Group: Applications/Text
Source: ftp://ftp.gnu.org/pub/gnu/grep/grep-%{version}.tar.bz2
Patch0: grep-2.5.1-fgrep.patch
Patch1: grep-2.5.1-bracket.patch
Patch2: grep-2.5-i18n.patch
Patch3: grep-2.5.1-oi.patch
Patch4: grep-2.5.1-manpage.patch
Patch5: grep-2.5.1-color.patch
Patch6: grep-2.5.1-icolor.patch
Patch7: grep-skip.patch
Patch10: grep-2.5.1-egf-speedup.patch
Patch11: grep-2.5.1-dfa-optional.patch
Patch12: grep-2.5.1-tests.patch
Patch13: grep-2.5.1-w.patch
Patch14: grep-P.patch
Patch15: grep-mem-exhausted.patch
Patch16: grep-empty-pattern.patch
Patch17: grep-2.5.1a-pcrewrap.patch
Patch18: grep-2.5.1a-utf8.patch
URL: http://www.gnu.org/software/grep/
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
BuildRoot:	%(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)
BuildRequires: pcre-devel >= 3.9-10, texinfo, gettext

%description
The GNU versions of commonly used grep utilities.  Grep searches
through textual input for lines which contain a match to a specified
pattern and then prints the matching lines.  GNU's grep utilities
include grep, egrep and fgrep.

You should install grep on your system, because it is a very useful
utility for searching through text.

%prep
%setup -q
%patch0 -p1 -b .fgrep
%patch1 -p1 -b .bracket
%patch2 -p1 -b .i18n
%patch3 -p1 -b .oi
%patch4 -p1 -b .manpage
%patch5 -p1 -b .color
%patch6 -p1 -b .icolor
%patch7 -p1 -b .skip
%patch10 -p1 -b .egf-speedup
%patch11 -p1 -b .dfa-optional
%patch12 -p1 -b .tests
%patch13 -p1 -b .w
%patch14 -p1 -b .P
%patch15 -p1 -b .mem-exhausted
%patch16 -p1 -b .empty-pattern
%patch17 -p1 -b .pcrewrap
%patch18 -p1 -b .utf8
chmod a+x tests/fmbtest.sh
chmod a+x tests/pcrewrap.sh

%build
[ ! -e configure ] && ./autogen.sh
%configure --without-included-regex CPPFLAGS="-I%{_includedir}/pcre"
make %{?_smp_mflags}

%install
rm -rf ${RPM_BUILD_ROOT}
make %{?_smp_mflags} DESTDIR=$RPM_BUILD_ROOT install
%ifos Linux
mkdir -p $RPM_BUILD_ROOT/bin
mv -f $RPM_BUILD_ROOT%{_bindir}/* $RPM_BUILD_ROOT/bin
rm -rf $RPM_BUILD_ROOT%{_bindir}
%endif
gzip -9f $RPM_BUILD_ROOT%{_infodir}/grep*
rm -f $RPM_BUILD_ROOT%{_infodir}/dir

# Use symlinks for egrep and fgrep
ln -sf grep $RPM_BUILD_ROOT/bin/egrep
ln -sf grep $RPM_BUILD_ROOT/bin/fgrep

%find_lang %name

%check
make check

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
[ -e %{_infodir}/grep.info.gz ] && /sbin/install-info --quiet --info-dir=%{_infodir} %{_infodir}/grep.info.gz || :

%preun
if [ $1 = 0 ]; then
	[ -e %{_infodir}/grep.info.gz ] && /sbin/install-info --quiet --info-dir=%{_infodir} --delete %{_infodir}/grep.info.gz || :
fi

%files -f %{name}.lang
%defattr(-,root,root)
%doc ABOUT-NLS AUTHORS THANKS TODO NEWS README ChangeLog COPYING

%ifos Linux
/bin/*
%else
%{_bindir}/*
%endif
%{_infodir}/*.info*.gz
%{_mandir}/*/*

%changelog
* Fri Dec 24 2010 Yan Li <yan.i.li@intel.com> - 2.5.1a
- Downgrade to version 2.5.1a (BMC#11589)
* Tue Apr  7 2009 zhang qiang <qiang.z.zhang@intel.com> 2.5.3
- [bug 980] fix LSB4 compliance failure on grep, unapply the
  patch 'grep-2.5.3-egf-speedup.patch'
* Fri Jan 16 2009 Anas Nashif <anas.nashif@intel.com> 2.5.3
- Readd pcre without which tests break
* Sat Dec 13 2008 Anas Nashif <anas.nashif@intel.com> 2.5.3
- update to 2.53
* Sat Dec 13 2008 Anas Nashif <anas.nashif@intel.com> 2.5.3
- Update to version 2.5.3
- do not use pcre, use internal regex instead
* Thu Nov 20 2008 Lubomir Rintel <lkundrak@v3.sk> 2.5.3-1
- Update to latest upstream version
- Drop upstreamed patches
- Add a couple of regression tests
- Temporarily disable tests
- Minor cleanup
* Wed Oct  1 2008 Lubomir Rintel <lkundrak@v3.sk> 2.5.1a-61
- Fix pcre-mode (-P) line wrapping (bug #324781)
- Match the version with upstream
- Recode AUTHORS to utf8
* Fri Jul 25 2008 Tom "spot" Callaway <tcallawa@redhat.com> - 2.5.1-60
- fix license tag
* Tue Feb 19 2008 Fedora Release Engineering <rel-eng@fedoraproject.org> - 2.5.1-59
- Autorebuild for GCC 4.3
* Fri Apr 20 2007 Stepan Kasal <skasal@redhat.com> - 2.5.1-58
- Adhere to packaging guidelines.
- Resolves: #225857
- Use CPPFLAGS= argument to configure to add an -I option.
- Do not set LDFLAGS=-s for "make install".
* Mon Jan 22 2007 Tim Waugh <twaugh@redhat.com> 2.5.1-57
- Make preun scriptlet unconditionally succeed (bug #223697).
* Wed Nov 22 2006 Tim Waugh <twaugh@redhat.com> 2.5.1-56
- Fixed count of patterns when the last is an empty string (bug #204255).
* Wed Nov 22 2006 Tim Waugh <twaugh@redhat.com> 2.5.1-55
- Fix 'memory exhausted' errors by limiting in-memory buffer (bug #198165).
* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 2.5.1-54.1
- rebuild
* Wed May 31 2006 Tim Waugh <twaugh@redhat.com> 2.5.1-54
- Applied upstream patch to fix '-D skip' (bug #189580).
* Mon Feb 20 2006 Tim Waugh <twaugh@redhat.com> 2.5.1-53
- Applied Tim Robbins' patch for 'grep -w' (bug #179698).
* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 2.5.1-52.2
- bump again for double-long bug on ppc(64)
* Tue Feb  7 2006 Jesse Keating <jkeating@redhat.com> - 2.5.1-52.1
- rebuilt for new gcc4.1 snapshot and glibc changes
* Fri Feb  3 2006 Tim Waugh <twaugh@redhat.com> 2.5.1-52
- Prevent 'grep -P' from segfaulting (bug #171379).
* Fri Dec  9 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt
* Thu Sep 29 2005 Tim Waugh <twaugh@redhat.com> 2.5.1-51
- Prevent 'grep -Fw ""' from busy-looping (bug #169524).
* Tue Jun 28 2005 Tim Waugh <twaugh@redhat.com> 2.5.1-50
- Further fixing for bug #161700.
* Mon Jun 27 2005 Tim Waugh <twaugh@redhat.com> 2.5.1-49
- Fix 'grep -Fw' for encodings other than UTF-8 (bug #161700).
* Wed Apr 13 2005 Tim Waugh <twaugh@redhat.com>
- Build requires recent pcre-devel (bug #154626).
* Wed Mar  2 2005 Tim Waugh <twaugh@redhat.com> 2.5.1-48
- Rebuild for new GCC.
* Fri Jan  7 2005 Tim Waugh <twaugh@redhat.com> 2.5.1-47
- Run 'make check'.
- Fixed -w handling for EGexecute.  Now 'make check' passes.
- Cache MB_CUR_MAX value in egf-speedup patch.
- Fixed variable shadowing in egf-speedup patch.
- Removed redundant (and incorrect) code in prline.
* Fri Jan  7 2005 Tim Waugh <twaugh@redhat.com> 2.5.1-46
- More -w tests from Jakub Jelinek.
- Rebased on 2.5.1a.
* Fri Dec 31 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-45
- More tests (Jakub Jelinek).
- Jakub Jelinek's much improved -Fi algorithm.
- Removed bogus part of grep-2.5.1-fgrep patch.
* Tue Dec 21 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-44
- Fixed -Fi for multibyte input (bug #143079).
* Thu Dec 16 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-43
- Bypass kwset matching when ignoring case and processing multibyte input
  (bug #143079).
* Tue Dec 14 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-42
- Further UTF-8 processing avoided since a '\n' byte is always an
  end-of-line character in that encoding.
* Fri Dec  3 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-41
- Fixed a busy loop in the egf-speedup patch (bug #140781).
* Thu Nov 18 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-40
- Fixed a bug in the fgrep patch, exposed by the dfa-optional patch
  (bug #138558).
* Tue Nov 16 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-39
- Fixed last patch.
* Tue Nov 16 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-38
- Applied patch from Karsten Hopp to fix background colour problems with
  - -color output (bug #138913).
* Wed Nov 10 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-37
- Prevent false matches when DFA is disabled (bug #138558).
* Mon Nov  8 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-36
- Automatically disable DFA when processing multibyte input.  GREP_USE_DFA
  environment variable overrides.
* Fri Nov  5 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-35
- Fixes to egf-speedup patch: now it does not change any functionality,
  as intended.
- GREP_NO_DFA now turns off the DFA engine, for performance testing.
* Thu Nov  4 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-34
- More improvements to egf-speedup patch (bug #138076).
* Thu Nov  4 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-33
- Small improvements to egf-speedup patch.
* Wed Nov  3 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-32
- Remove mb-caching hack.
- Better multibyte handling in EGexecute() and Fexecute().
- Don't need regex.c changes in grep-2.5-i18n.patch.
* Wed Oct 13 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-31
- Make 'grep -F' avoid UTF-8 processing if the pattern contains no
  multibyte characters (bug #133932).
* Mon Oct 11 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-30
- Applied patch from Robert Scheck to tidy spec file and add a URL
  tag (bug #135185).
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt
* Fri Jun  4 2004 Tim Waugh <twaugh@redhat.com>
- More build requirements (bug #125323).
* Tue May 18 2004 Jeremy Katz <katzj@redhat.com> 2.5.1-28
- rebuild
* Tue May 18 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-27
- Fix dfa multibyte character class matching when -i is used (bug #123363).
- Use bracket patch before i18n patch to make it clear that the bug exists
  upstream.
* Thu Feb 26 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-26
- Fix fgrep (bug #116909).
* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt
* Mon Jan  5 2004 Tim Waugh <twaugh@redhat.com> 2.5.1-24
- Work around glibc bug #112869 (segfault in re_compile_pattern).
- Avoid patching Makefile.am, to avoid automake/autoconf weirdness.
* Wed Dec 10 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-23
- Another multibyte efficiency bug-fix (bug #111800).
* Mon Dec  8 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-22
- Fixed [:alpha:]-type character classes (bug #108484).
- Fixed -o -i properly (bug #111489).
* Sat Dec  6 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-21
- Fixed 'fgrep -i' (bug #111614).
* Fri Nov 21 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-20
- Another two multibyte efficiency bug-fixes (bug #110524).
* Thu Nov  6 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-19
- Fixed a multibyte efficiency bug.
* Thu Nov  6 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-18
- Turn on multibyte efficiency patch again to shake out bugs.
* Wed Oct  8 2003 Tim Waugh <twaugh@redhat.com>
- Fixed man page bug (bug #106267).
* Thu Sep 18 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-17
- Use symlinks for egrep/fgrep, rather than shell script wrappers.
* Fri Jun 27 2003 Tim Waugh <twaugh@redhat.com>
- Fix debuginfo package.
* Fri Jun 27 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-16.1
- Rebuilt.
* Fri Jun 27 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-16
- Finally give up on making grep go fast. :-(
* Thu Jun 26 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-15.1
- Rebuilt.
* Thu Jun 26 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-15
- Fixed grep -i bug introduced by cache.
* Mon Jun 23 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-14.1
- Rebuilt.
* Mon Jun 23 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-14
- Redo the gofast patch (bug #97785).
* Thu Jun 12 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-13.1
- Rebuilt.
* Thu Jun 12 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-13
- Fixed a bug in the gofast patch (bug #97266).
* Tue Jun 10 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-12.1
- Rebuilt.
* Tue Jun 10 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-12
- Go faster (bug #69900).
- Fix man page.
* Wed Jun  4 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt
* Thu May 29 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-10.1
- Rebuilt.
* Thu May 29 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-10
- Use system regex again.
* Thu May 29 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-9
- Fixed bug in go-fast patch.
* Wed May 28 2003 Tim Waugh <twaugh@redhat.com> 2.5.1-8
- Go fast (bug #69900).
- Run test suite.
* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 2.5.1-7
- rebuilt
* Tue Nov 19 2002 Tim Waugh <twaugh@redhat.com> 2.5.1-6
- i18n patch.
* Mon Oct 21 2002 Tim Waugh <twaugh@redhat.com> 2.5.1-5
- Don't install /usr/share/info/dir.
- Fix -o -i (bug #72641).
* Sat Jul 20 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- install all info files #69204
* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild
* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild
* Tue Mar 26 2002 Bernhard Rosenkraenzer <bero@redhat.com> 2.5.1-1
- 2.5.1
* Wed Mar 13 2002 Bernhard Rosenkraenzer <bero@redhat.com> 2.5-1
- 2.5 final
* Wed Jan 23 2002 Bernhard Rosenkraenzer <bero@redhat.com> 2.5-0.g.1
- 2.5g
* Wed Jan  9 2002 Tim Powers <timp@redhat.com>
- automated rebuild
* Mon Nov 19 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5-0.f.4
- Update CVS to reduce bloat
* Thu Nov  8 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5-0.f.3
- Don't fail %%%%post with --excludedocs
* Wed Sep 26 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5-0.f.2
- Fix up echo A |grep '[A-Z0-9]' in locales other than C
* Tue Sep 25 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5-0.f.1
- 2.5f, fixes #53603
* Wed Jul 18 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.4.2-7
- Fix up the i18n patch - it used to break "grep '[]a]'" (#49003)
- revert to 2.4.2 (latest official release) for now
* Mon May 28 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5e-4
- Fix "echo Linux forever |grep -D skip Linux"
* Mon May 21 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5e-3
- Add new -D, --devices option
- Fix a bug with "directories" being uninitialized
* Sun May 13 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5e-2
- Fix up the --color option to behave like the one from ls (--color=auto)
  Sooner or later, some people will alias grep="grep --color" and wonder why
  their scripts break.
- Update docs accordingly
- Get rid of the annoying blinking in grep --color
* Sun May 13 2001 Bernhard Rosenkraenzer <bero@redhat.com> 2.5e-1
- 2.5e
* Tue Feb 27 2001 Trond Eivind Glomsrød <teg@redhat.com>
- use %%%%{_tmppath}
- langify
* Sun Aug 20 2000 Jakub Jelinek <jakub@redhat.com>
- i18n character ranges patch from Ulrich Drepper
* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild
* Mon Jun 19 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- FHSify
* Tue Mar 21 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- update to 2.4.2
- fix download URL
* Thu Feb  3 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- gzip info pages (Bug #9035)
* Wed Feb  2 2000 Cristian Gafton <gafton@redhat.com>
- fix description
* Wed Dec 22 1999 Jeff Johnson <jbj@redhat.com>
- update to 2.4.
* Wed Oct 20 1999 Bill Nottingham <notting@redhat.com>
- prereq install-info
* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 2)
* Mon Mar  8 1999 Preston Brown <pbrown@redhat.com>
- upgraded to grep 2.3, added install-info %%%%post/%%%%preun for info
* Wed Feb 24 1999 Preston Brown <pbrown@redhat.com>
- Injected new description and group.
* Sat May  9 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr
* Fri May  1 1998 Cristian Gafton <gafton@redhat.com>
- updated to 2.2
* Thu Oct 16 1997 Donnie Barnes <djb@redhat.com>
- updated from 2.0 to 2.1
- spec file cleanups
- added BuildRoot
* Mon Jun  2 1997 Erik Troan <ewt@redhat.com>
- built against glibc
