# 
# Do NOT Edit the Auto-generated Part!
# Generated by: spectacle version 0.22
# 
# >> macros
%define dbus_user_uid 81
# << macros

Name:       dbus
Summary:    D-Bus message bus
Version:    1.4.14
Release:    6.2
Group:      System/Libraries
License:    GPLv2+ or AFL
URL:        http://www.freedesktop.org/software/dbus/
Source0:    http://dbus.freedesktop.org/releases/%{name}/%{name}-%{version}.tar.gz
Source100:  dbus.yaml
Patch0:     start-early.patch
Requires:   %{name}-libs = %{version}
Requires(pre): /usr/sbin/useradd
BuildRequires:  pkgconfig(x11)
BuildRequires:  expat-devel >= 1.95.5
BuildRequires:  gettext
BuildRequires:  libcap-devel
BuildRequires:  libtool


%description
D-Bus is a system for sending messages between applications. It is used both
for the systemwide message bus service, and as a per-user-login-session
messaging facility.



%package libs
Summary:    Libraries for accessing D-Bus
Group:      System/Libraries
Requires:   %{name} = %{version}-%{release}
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

%description libs
Lowlevel libraries for accessing D-Bus.

%package doc
Summary:    Developer documentation for D-Bus
Group:      Documentation
Requires:   %{name} = %{version}-%{release}

%description doc
This package contains DevHelp developer documentation for D-Bus along with
other supporting documentation such as the introspect dtd file.


%package devel
Summary:    Libraries and headers for D-Bus
Group:      Development/Libraries
Requires:   %{name} = %{version}-%{release}
Requires:   pkgconfig

%description devel
Headers and static libraries for D-Bus.

%package x11
Summary:    X11-requiring add-ons for D-Bus
Group:      System/X11
Requires:   %{name} = %{version}-%{release}

%description x11
D-Bus contains some tools that require Xlib to be installed, those are in this
separate package so server systems need not install X.



%prep
%setup -q -n %{name}-%{version}

# start-early.patch
%patch0 -p1
# >> setup
# << setup

%build
# >> build pre
# << build pre

%reconfigure --disable-static \
    --exec-prefix=/ \
    --bindir=/bin \
    --libexecdir=/%{_lib}/dbus-1 \
    --sysconfdir=/etc \
    --libdir=/%{_lib} \
    --disable-tests \
    --disable-asserts \
    --disable-xml-docs \
    --disable-doxygen-docs \
    --disable-selinux \
    --disable-libaudit \
    --with-system-pid-file=%{_localstatedir}/run/messagebus.pid \
    --with-dbus-user=dbus \
    --with-systemdsystemunitdir="/%{_lib}/systemd/system"

make %{?jobs:-j%jobs}

# >> build post
# << build post
%install
rm -rf %{buildroot}
# >> install pre
# << install pre
%make_install

# >> install post
mkdir -p %{buildroot}%{_libdir}/pkgconfig
# Change the arch-deps.h include directory to /usr/lib instead of /lib
sed -e 's@-I${libdir}@-I${prefix}/%{_lib}@' %{buildroot}/%{_lib}/pkgconfig/dbus-1.pc > %{buildroot}%{_libdir}/pkgconfig/dbus-1.pc
rm -f %{buildroot}/%{_lib}/pkgconfig/dbus-1.pc

mkdir -p %{buildroot}%{_bindir}
mv -f %{buildroot}/bin/dbus-launch %{buildroot}%{_bindir}

mkdir -p %{buildroot}%{_libdir}/dbus-1.0/include/
mv -f %{buildroot}/%{_lib}/dbus-1.0/include/* %{buildroot}%{_libdir}/dbus-1.0/include/
rm -rf %{buildroot}/%{_lib}/dbus-1.0

mkdir -p %{buildroot}%{_datadir}/dbus-1/interfaces

# disable systemd files All of them are now part of systemd package
rm -rf %{buildroot}/lib/systemd
# << install post

%pre
# >> pre
# Add the "dbus" user and group
[ -e /usr/sbin/groupadd ] && /usr/sbin/groupadd -r -g %{dbus_user_uid} dbus 2>/dev/null || :
[ -e /usr/sbin/useradd ] && /usr/sbin/useradd -c 'System message bus' -u %{dbus_user_uid} \
-g %{dbus_user_uid} -s /sbin/nologin -r -d '/' dbus 2> /dev/null || :
# << pre






%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig










%files
%defattr(-,root,root,-)
%doc COPYING
/bin/dbus-cleanup-sockets
/bin/dbus-daemon
/bin/dbus-monitor
/bin/dbus-send
/bin/dbus-uuidgen
%dir %{_sysconfdir}/dbus-1
%config(noreplace) %{_sysconfdir}/dbus-1/session.conf
%dir %{_sysconfdir}/dbus-1/session.d
%config(noreplace) %{_sysconfdir}/dbus-1/system.conf
%dir %{_sysconfdir}/dbus-1/system.d
%dir /%{_lib}/dbus-1
# disable systemd files All of them are now part of systemd package
#/%{_lib}/systemd/system/*
%attr(4750,root,dbus) /%{_lib}/dbus-1/dbus-daemon-launch-helper
%dir %{_datadir}/dbus-1
%{_datadir}/dbus-1/interfaces
%{_datadir}/dbus-1/services
%{_datadir}/dbus-1/system-services
%doc %{_mandir}/man1/dbus-cleanup-sockets.1.gz
%doc %{_mandir}/man1/dbus-daemon.1.gz
%doc %{_mandir}/man1/dbus-monitor.1.gz
%doc %{_mandir}/man1/dbus-send.1.gz
%doc %{_mandir}/man1/dbus-uuidgen.1.gz
%dir %{_localstatedir}/run/dbus
%dir %{_localstatedir}/lib/dbus
# >> files
# << files


%files libs
%defattr(-,root,root,-)
/%{_lib}/libdbus-1.so.3*
# >> files libs
# << files libs

%files doc
%defattr(-,root,root,-)
%doc doc/dbus-faq.html
%doc doc/dbus-specification.html
%doc doc/dbus-test-plan.html
%doc doc/dbus-tutorial.html
%doc doc/introspect.dtd
%doc doc/introspect.xsl
%doc doc/system-activation.txt
%doc %{_datadir}/doc/dbus/dbus-faq.html
%doc %{_datadir}/doc/dbus/dbus-specification.html
%doc %{_datadir}/doc/dbus/dbus-test-plan.html
%doc %{_datadir}/doc/dbus/dbus-tutorial.html
%doc %{_datadir}/doc/dbus/diagram.png
%doc %{_datadir}/doc/dbus/diagram.svg
%doc %{_datadir}/doc/dbus/system-activation.txt
#%doc %{_datadir}/doc/dbus/dbus-cleanup-sockets.1.html
#%doc %{_datadir}/doc/dbus/dbus-daemon.1.html
#%doc %{_datadir}/doc/dbus/dbus-launch.1.html
#%doc %{_datadir}/doc/dbus/dbus-monitor.1.html
#%doc %{_datadir}/doc/dbus/dbus-send.1.html
#%doc %{_datadir}/doc/dbus/dbus-uuidgen.1.html
# >> files doc
# << files doc

%files devel
%defattr(-,root,root,-)
/%{_lib}/libdbus-1.so
%{_includedir}/dbus-1.0/dbus/dbus*.h
%dir %{_libdir}/dbus-1.0
%{_libdir}/dbus-1.0/include/dbus/dbus-arch-deps.h
%{_libdir}/pkgconfig/dbus-1.pc
# >> files devel
# << files devel

%files x11
%defattr(-,root,root,-)
%{_bindir}/dbus-launch
%doc %{_mandir}/man1/dbus-launch.1.gz
# >> files x11
# << files x11

%changelog
* Mon Jan 16 2012 Dragos Stoica <dragos.stoica@windriver.com> - 1.4.14
- disabled systemd services. they're now part of systemd package
* Mon Sep  5 2011 Marko Saukko <marko.saukko@cybercom.com> - 1.4.14
- Updating to the latest stable realease 1.4.14.
- Removed merged patch: dbus-1.0.1-generate-xml-docs.patch
* Sun Jun  5 2011 Anas Nashif <anas.nashif@intel.com> - 1.4.1
- Do not built auto-documentation
* Sat Mar 12 2011 Anas Nashif <anas.nashif@intel.com> - 1.4.1
- Remove creds-dbus patch
* Wed Jan 19 2011 Ryan Ware <ryan.r.ware@intel.com> - 1.4.1
- This update adds the creds-dbus patch which enables mandatory access controls for dbus communication.
- FEA#9093
* Fri Dec 31 2010 Fathi Boudra <fathi.boudra@nokia.com> - 1.4.1
- Update to 1.4.1
- Fix CVE 2010-4352: Reject deeply nested variants (BMC#11884)
- Remove 00-start-message-bus.sh from the Source list (unused)
- Fix case, it should be "D-Bus" instead of "D-BUS"
- Add doxygen BuildRequires and enable doxygen documentation
- Remove useless or unused variables
- Convert the spec file to yaml file
* Mon Oct 11 2010 Maitrey Mishra <ext-maitrey.mishra@nokia.com> - 1.4.0
- Update to 1.4.0
* Thu Mar 25 2010 Anas Nashif <anas.nashif@intel.com> - 1.2.24
- Update to 1.2.24
* Tue Mar 16 2010 Ross Burton <ross@linux.intel.com> - 1.2.20
- Apply patch to fix thread blocking from git
* Fri Feb 26 2010 Yi Yang <yi.y.yang@intel.com> - 1.2.20
- Apply fd-passing patch from dbus-1.3.0
* Tue Feb 16 2010 Anas Nashif <anas.nashif@intel.com> - 1.2.20
- Update to 1.2.20
* Fri Sep 11 2009 Anas Nashif <anas.nashif@intel.com> - 1.2.16
- Create user with dbus group
* Sun Sep  6 2009 Peter Zhu <peter.j.zhu@intel.com> 1.2.16
- Upgrade to 1.2.16
* Mon May 25 2009 Anas Nashif <anas.nashif@intel.com> 1.2.12
- Fixed ChangeLog
* Thu Apr 30 2009 Zhang, Qiang Z <qiang.z.zhang@intel.com> 1.2.12
- Fix CVE-2009-1189
* Tue Mar 31 2009 Xu Li <xu.li@intel.com> 1.2.12
- Upgrade to 1.2.12
- Drop deprecated source
* Fri Dec 19 2008 Auke Kok <auke-jan.h.kok@intel.com> 1.2.4
- remove /etc//X11/xinit/xinitrc.d/00-start-message-bus.sh
  since it is not actually doing anything other than chew CPU time
* Tue Dec 16 2008 Anas Nashif <anas.nashif@intel.com> 1.2.4
- enable x11 sub-package
* Wed Dec 10 2008 Anas Nashif <anas.nashif@intel.com> 1.2.4
- Remove of requirement on devhelp
* Wed Nov 19 2008 Vivian zhang <vivian.zhang@intel.com> 1.2.4
- Update dbus to 1.2.4
- Regenerate start-early patch
* Fri Sep 19 2008 Yi Yang <yi.y.yang@intel.com> 1.2.3
- Update dbus to 1.2.3
* Wed Sep  3 2008 Anas Nashif <anas.nashif@intel.com> 
- check for scripts before executing them
* Wed Jul 23 2008 Vivian Zhang <vivian.zhang@intel.com> 
- Add %%doc to man in %%files
