Summary: The GNU versions of find utilities (find and xargs)
Name: findutils
Version: 4.2.31
Release: 2.3
License: GPLv2+
Epoch: 1
Group: Applications/File
URL: http://www.gnu.org/software/findutils/
Source0: ftp://ftp.gnu.org/gnu/findutils/%{name}-%{version}.tar.gz
#Source1: ftp://ftp.gnu.org/gnu/findutils/%{name}-%{version}.tar.gz.sig
Patch1: findutils-4.2.31-no-locate.patch
Patch2: findutils-bmc12931-find-ls-stack-overflow.patch

%define run_tests 0

Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Buildroot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: libtool, automake, autoconf, gzip
BuildRequires: gettext-devel, texinfo
%if %{run_tests}
BuildRequires: dejagnu
%endif

%description
The findutils package contains programs which will help you locate
files on your system.  The find utility searches through a hierarchy
of directories looking for files which match a certain set of criteria
(such as a filename pattern).  The xargs utility builds and executes
command lines from standard input arguments (usually lists of file
names generated by the find command).

You should install findutils because it includes tools that are very
useful for finding things on your system.

%prep
%setup -q
%patch1 -p1 -b .no-locate
%patch2 -p1

%build
export CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE"
export CXXFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE"
%configure --without-selinux

make %{?_smp_mflags}

%check
%if %{run_tests}
make check
%endif

%install
rm -rf %{buildroot}
make install DESTDIR=$RPM_BUILD_ROOT

rm -f $RPM_BUILD_ROOT%{_infodir}/dir

mkdir -p %{buildroot}/bin
pushd %{buildroot}/bin
ln -sf ../usr/bin/find
popd

%find_lang %{name}

%post
/sbin/install-info %{_infodir}/find.info.gz %{_infodir}/dir || :

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/find.info.gz %{_infodir}/dir || :
fi

%clean
rm -rf %{buildroot}

%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README THANKS TODO
%{_bindir}/find
/bin/find
%{_bindir}/xargs
%{_mandir}/man1/find.1*
%{_mandir}/man1/xargs.1*
%{_infodir}/find.info*

%changelog
* Wed Jan 26 2011 Yan Li <yan.i.li@intel.com> - 4.2.31
- Fixed "find -ls" stack overflow (BMC#12931)
* Wed Dec 29 2010 Carsten Munk <carsten@maemo.org> - 4.2.31
- Re-add %%{run_tests} usage in packaging. Without this,
  dejagnu is a BuildRequires and makes MeeGo bootstrap/build cycles
  much harder as it adds Tcl/Tk dependancy. (BMC#11819)
* Wed Dec 29 2010 Yan Li <yan.i.li@intel.com> - 4.2.31
- Reverted to version 4.2.31 (BMC#11589)
* Thu Nov  5 2009 PeterZhu <peter.j.zhu@intel.com> - 4.4.0
- Remove /usr/share/info/dir in %%install
- Remove old tar ball
- Fix summary of locatedb to remove rpmlint error
* Fri Dec  5 2008 Arjan van de Ven <arjan@linux.intel.com> - 4.4.0
- Remove epoch
* Fri Dec  5 2008 Arjan van de Ven <arjan@linux.intel.com> - 4.2.33
- split off a -doc package
* Fri Sep 12 2008 Yi Yang <yi.y.yang@intel.com> 4.2.33
- Remove installation warnings of info files
* Wed Jul 23 2008 Peter J Zhu <peter.j.zhu@intel.com>
- Added %%doc prefix to man/info
* Mon Apr 14 2008 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:1.2.33-3
- Move find to /bin
  Resolves: #438183
* Fri Mar 28 2008 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:4.2.33-2
- Fix xargs ARG_MAX assert
  Resolves: #439168
* Fri Feb 15 2008 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:4.2.33-1
- Update to findutils-4.2.33
- Fix License
* Wed Feb 13 2008 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:4.2.32-1
- Update to findutils-4.2.32
* Mon Feb 11 2008 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:4.2.31-4
- Rebuild
* Fri Jan 18 2008 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:4.2.31-3
- Rebuild
* Thu Aug 23 2007 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:4.2.31-2
- fix license
- rebuild
* Tue Jun 12 2007 Vitezslav Crhonek <vcrhonek@redhat.com> - 1:4.2.31-1
- Update to findutils-4.2.31
  Resolves: #243732
* Fri Jan  5 2007 Miloslav Trmac <mitr@redhat.com> - 1:4.2.29-2
- Ignore install-info errors in scriptlets
* Sun Nov 26 2006 Miloslav Trmac <mitr@redhat.com> - 1:4.2.29-1
- Update to findutils-4.2.29
- Fix some rpmlint warnings
* Wed Jul 12 2006 Jesse Keating <jkeating@redhat.com> - 1:4.2.27-4.1
- rebuild
* Sun Feb 19 2006 Miloslav Trmac <mitr@redhat.com> - 1:4.2.27-4
- Report the correct directory when hard link count is inconsistent (#182001)
* Fri Feb 10 2006 Jesse Keating <jkeating@redhat.com> - 1:4.2.27-3.2
- bump again for double-long bug on ppc(64)
* Tue Feb  7 2006 Jesse Keating <jkeating@redhat.com> - 1:4.2.27-3.1
- rebuilt for new gcc4.1 snapshot and glibc changes
* Mon Jan 30 2006 Miloslav Trmac <mitr@redhat.com> - 1:4.2.27-3
- Updated SELinux patch, --context is no longer valid (use -context)
* Thu Jan 12 2006 Miloslav Trmac <mitr@redhat.com> - 1:4.2.27-2
- Don't use uninitialized memory in -printf %%%%Z (#174485)
- Ship more documentation files
- Clean up the spec file a bit
* Fri Dec  9 2005 Jesse Keating <jkeating@redhat.com>
- rebuilt
* Wed Dec  7 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.27-1
- 4.2.27.
- No longer need arg_max patch.
* Mon Nov 21 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.26-1
- One further arg_max fix for PPC.
- Applied arg_max patch from upstream to fix test suite failures.
- 4.2.26 (fixes bug #173817).
* Tue Oct 11 2005 Dan Walsh <dwalsh@redhat.com> 1:4.2.25-3
- Fix selinux patch
* Mon Sep  5 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.25-2
- 4.2.25.
* Mon Jun 20 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.23-1
- 4.2.23.
* Thu Mar 17 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.20-1
- 4.2.20.
* Mon Mar 14 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.18-3
- Applied patch from Robert Scheck to fix compilation with GCC 4 (bug #151031).
* Wed Mar  2 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.18-2
- Rebuild for new GCC.
* Mon Feb 21 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.18-1
- 4.2.18.
* Mon Feb 14 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.15-2
- Added nofollow patch from upstream.
* Mon Jan 31 2005 Tim Waugh <twaugh@redhat.com> 1:4.2.15-1
- 4.2.15.  Lots of patches removed due to upstream merge.
* Tue Jan  4 2005 Dan Walsh <dwalsh@redhat.com> 1:4.1.20-8
- Change --context to use fnmatch instead of strcmp
* Tue Dec  7 2004 Tim Waugh <twaugh@redhat.com>
- Removed "G" and "M" size qualifiers from man page, since support for
  those is not in the stable branch (bug #141987).
* Tue Oct 19 2004 Tim Waugh <twaugh@redhat.com> 1:4.1.20-7
- Better xargs ARG_SIZE handling (bug #135129).
* Fri Oct 15 2004 Tim Waugh <twaugh@redhat.com>
- Fixed d_type patch for underquoted m4 macro.
* Fri Oct  8 2004 Tim Waugh <twaugh@redhat.com>
- Use upstream patch for find -size man page fix.
* Wed Oct  6 2004 Tim Waugh <twaugh@redhat.com> 1:4.1.20-6
- Fixed bug #126352.
* Tue Oct  5 2004 Tim Waugh <twaugh@redhat.com> 1:4.1.20-5
- Build requires gettext-devel, texinfo (bug #134692).
* Thu Sep 30 2004 Tim Waugh <twaugh@redhat.com> 1:4.1.20-4
- Set re->translate before re_compile_pattern (bug #134190).
* Sun Aug  1 2004 Alan Cox <alan@redhat.com> 1:4.1.20-3
- Fix build with current auto* tools (Steve Grubb)
* Tue Jul  6 2004 Tim Waugh <twaugh@redhat.com> 1:4.1.20-2
- Fix -iregex (bug #127297).
* Fri Jun 25 2004 Tim Waugh <twaugh@redhat.com> 1:4.1.20-1
- Clarify find man page (bug #126098).
- Apply changes by Robert Scheck <redhat@linuxnetz.de> (bug #126352):
  - Upgrade to 4.1.20 and some specfile cleanup
* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt
* Thu May 20 2004 Tim Waugh <twaugh@redhat.com> 4.1.7-26
- Fixed build requirements (bug #123746).
* Sun Mar 14 2004 Tim Waugh <twaugh@redhat.com> 4.1.7-25
- Apply Jakub Jelinek's patch for xargs -E/-I/-L options.
* Thu Mar 11 2004 Tim Waugh <twaugh@redhat.com> 4.1.7-24
- Apply selinux patch last so that it can be turned off (bug #118025).
* Tue Mar  9 2004 Tim Waugh <twaugh@redhat.com>
- Jakub Jelinek's d_type patch improvement.
* Sun Mar  7 2004 Tim Waugh <twaugh@redhat.com> 4.1.7-23
- Run 'make check'.
- Apply Ulrich Drepper's improvement on the d_type patch.
* Fri Mar  5 2004 Tim Waugh <twaugh@redhat.com> 4.1.7-22
- Apply Jakub Jelinek's d_type patch for improved efficiency with
  many common expressions.
* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt
* Tue Jan 27 2004 Dan Walsh <dwalsh@redhat.com> 4.1.7-20
- fix call to is_selinux_enabled
* Thu Oct 30 2003 Dan Walsh <dwalsh@redhat.com> 4.1.7-19
- Turn off SELinux
* Thu Oct 30 2003 Dan Walsh <dwalsh@redhat.com> 4.1.7-18.sel
- Turn on selinux
* Sat Oct 25 2003 Tim Waugh <twaugh@redhat.com> 4.1.7-17
- Rebuilt.
* Fri Oct 10 2003 Dan Walsh <dwalsh@redhat.com> 4.1.7-16
- Turn off selinux
* Fri Oct 10 2003 Dan Walsh <dwalsh@redhat.com> 4.1.7-15.sel
- Turn on selinux
* Fri Sep  5 2003 Dan Walsh <dwalsh@redhat.com> 4.1.7-15
- Turn off selinux
* Thu Aug 28 2003 Dan Walsh <dwalsh@redhat.com> 4.1.7-14.sel
- Turn on selinux
* Fri Jul 18 2003 Dan Walsh <dwalsh@redhat.com> 4.1.7-13
- Add SELinux patch
* Wed Jun  4 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt
* Wed Apr 23 2003 Elliot Lee <sopwith@redhat.com> 4.1.7-11
- Remove config.{sub,guess} to make ppc64 work
* Mon Mar 17 2003 Tim Waugh <twaugh@redhat.com> 4.1.7-10
- Make 'xargs -i -n1' behave as expected (bug #86191).
* Wed Jan 22 2003 Tim Powers <timp@redhat.com> 4.1.7-9
- rebuilt
* Tue Oct 22 2002 Tim Waugh <twaugh@redhat.com> 4.1.7-8
- Ship translations.
- Don't install files not packaged.
* Wed Jul  3 2002 Tim Waugh <twaugh@redhat.com> 4.1.7-7
- Fix usage message (bug #67828).
* Fri Jun 21 2002 Tim Powers <timp@redhat.com> 4.1.7-6
- automated rebuild
* Thu May 23 2002 Tim Powers <timp@redhat.com> 4.1.7-5
- automated rebuild
* Tue Feb 26 2002 Tim Waugh <twaugh@redhat.co,> 4.1.7-4
- Rebuild in new environment.
* Tue Feb 12 2002 Tim Waugh <twaugh@redhat.com> 4.1.7-3
- s/Copyright/License/.
- Fix documentation (bug #53857).
* Wed Jan  9 2002 Tim Powers <timp@redhat.com>
- automated rebuild
* Sun Jun  3 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 4.1.7, no additional patch needed anymore
* Thu Feb  8 2001 Preston Brown <pbrown@redhat.com>
- remove extraneous linking to librt/libpthreads.
* Tue Oct 17 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 4.1.6
* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild
* Wed Jun 28 2000 Preston Brown <pbrown@redhat.com>
- revert to 4.1.5 ( :) ) on the advice of HJ Lu
- patch to fix finding w/ -perm flag
* Tue Jun 27 2000 Preston Brown <pbrown@redhat.com>
- revert to 4.1.4
- reapply numblks patch
- generate new nolocate patch, we don't ship it.
* Mon Jun 12 2000 Preston Brown <pbrown@redhat.com>
- 4.1.5, FHS paths
- remove mktemp,getshort patches (don't ship locate)
- alpha, numblks patch no longer needed
* Mon Apr  3 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 4.1.4
- remove some obsolete patches, adapt others
- fix build on alpha
* Wed Feb  2 2000 Cristian Gafton <gafton@redhat.com>
- fix summary
- ma  pages are compressed
* Wed Jan 12 2000 Preston Brown <pbrown@redhat.com>
- new description.
* Fri Aug 27 1999 Preston Brown <pbrown@redhat.com>
- fixed block count bug (# 2141)
* Mon Mar 29 1999 Preston Brown <pbrown@redhat.com>
- patch to fix xargs out of bounds overflow (bug # 1279)
* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 30)
* Fri Mar 19 1999 Jeff Johnson <jbj@redhat.com>
- strip binaries.
* Mon Feb  8 1999 Jeff Johnson <jbj@redhat.com>
- remove further updatedb remnants (#1072).
* Thu Dec  3 1998 Cristian Gafton <gafton@redhat.com>
- added patch for glibc21
* Mon Nov 16 1998 Erik Troan <ewt@redhat.com>
- removed locate stuff (as we now ship slocate)
* Wed Jun 10 1998 Erik Troan <ewt@redhat.com>
- updated updatedb cron script to not look for $TMPNAME.n (which was
  a relic anyway)
- added -b parameters to all of the patches
* Fri Apr 24 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr
* Mon Mar  9 1998 Michael K. Johnson <johnsonm@redhat.com>
- make updatedb.cron use mktemp correctly
- make updatedb use mktemp
* Sun Nov  9 1997 Michael K. Johnson <johnsonm@redhat.com>
- nobody should own tmpfile
- ignore /net
* Wed Nov  5 1997 Michael K. Johnson <johnsonm@redhat.com>
- made updatedb.cron do a better job of cleaning up after itself.
* Tue Oct 28 1997 Donald Barnes <djb@redhat.com>
- fixed 64 bit-ism in getline.c, patch tacked on to end of glibc one
* Thu Oct 23 1997 Erik Troan <ewt@redhat.com>
- added patch for glibc 2.1
* Fri Oct 17 1997 Donnie Barnes <djb@redhat.com>
- added BuildRoot support
* Tue Oct 14 1997 Michael K. Johnson <johnsonm@redhat.com>
- made updatedb.cron work even if "nobody" can't read /root
- use mktemp in updatedb.cron
* Sun Sep 14 1997 Erik Troan <ewt@redhat.com>
- added missing info pages
- uses install-info
* Mon Jun  2 1997 Erik Troan <ewt@redhat.com>
- built with glibc
* Mon Apr 21 1997 Michael K. Johnson <johnsonm@redhat.com>
- fixed updatedb.cron
