/*
 * pb_serial.h
 *
 * this program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 */
/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2014 KYOCERA Corporation
 * (C) 2015 KYOCERA Corporation
 * (C) 2018 KYOCERA Corporation
 * (C) 2019 KYOCERA Corporation
 */
#ifndef __ARCH_ARM_MACH_MSM_PB_SERIAL_PB_SERIAL_H__
#define __ARCH_ARM_MACH_MSM_PB_SERIAL_PB_SERIAL_H__

#include <linux/fs.h>
#include <linux/tty.h>
#include "pb_command.h"

enum {
	MSG_MSGDUMP,
	MSG_DEBUG,
	MSG_INFO,
	MSG_WARNING,
	MSG_LIGHT,
	MSG_ERROR,
	MSG_NONE,
};

#ifndef DEBUG
#define DEBUG
#endif

#ifdef DEBUG
extern int g_uart_print_level;

static const char strLog[6] = {
	'M', 'D', 'I', 'W', 'L', 'E'
};

#define pb_print(level, fmt, args...) do {				\
	if (level >= g_uart_print_level) {				\
		printk(KERN_INFO "PB_UART<%c>[%s:%d]: " fmt,		\
			strLog[level], __func__, __LINE__, ##args);	\
	}	\
} while (0)
#else
#define pb_print(level, fmt, args...) do { } while (0)
#endif

#define PB_DATA_BUF_SIZE	128
#define SMD_SETTING		0x04

extern void smd_send_data(char *buf, int len, int line);
extern int smd_setup(void);
extern void smd_stop(void);

extern void set_function_up(int id);

#endif /*__ARCH_ARM_MACH_MSM_PB_SERIAL_PB_SERIAL_H__ */
