/*
 * This software is contributed or developed by KYOCERA Corporation.
 * (C) 2018 KYOCERA Corporation
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef _KC_APP_SMEM_DEV_H_
#define _KC_APP_SMEM_DEV_H_
/*===========================================================================*/
#include <linux/ioctl.h>

typedef struct{
	int     smem_id;
	void*   buff;
	size_t  ofst;
	size_t  size;
}smem_id_t;

#define SMEM_CMD_CODE	(0x54)
#define SMEM_CMD_READ	_IOC(_IOC_READ,  SMEM_CMD_CODE, 1, sizeof(smem_id_t*))
#define SMEM_CMD_WRITE	_IOC(_IOC_WRITE, SMEM_CMD_CODE, 2, sizeof(smem_id_t*))
/*===========================================================================*/
#endif /* _KC_APP_SMEM_DEV_H_ */
